var _gaq = _gaq || [];

if (/\.bix\.com$/.test(document.location.hostname)) {
    _gaq.push([ "_setAccount", "UA-51815400-1" ]);
    _gaq.push([ "_setDomainName", "bix.com" ]);
} else {
    _gaq.push([ "_setAccount", "UA-32755516-6" ]);
    _gaq.push([ "_setDomainName", "one.com" ]);
}

_gaq.push([ "_setAllowLinker", true ]);

_gaq.push([ "_trackPageview" ]);

_gaq.push([ "_trackPageLoadTime" ]);

(function() {
    var ga = document.createElement("script");
    ga.type = "text/javascript";
    ga.async = true;
    ga.src = ("https:" === document.location.protocol ? "https://ssl" : "http://www") + ".google-analytics.com/ga.js";
    var s = document.getElementsByTagName("script")[0];
    s.parentNode.insertBefore(ga, s);
})();

(function(w, d, s, l, i) {
    w[l] = w[l] || [];
    w[l].push({
        "gtm.start": new Date().getTime(),
        event: "gtm.js"
    });
    var f = d.getElementsByTagName(s)[0], j = d.createElement(s), dl = l != "dataLayer" ? "&l=" + l : "";
    j.async = true;
    j.src = "//www.googletagmanager.com/gtm.js?id=" + i + dl;
    f.parentNode.insertBefore(j, f);
})(window, document, "script", "dataLayer", "GTM-KQ4H");

function trackLoginViaGoogleTagManager() {
    dataLayer.push({
        eventcategory: "Interaction",
        eventaction: "LogIn",
        eventlabel: "Webmail",
        cdga_login: "Yes",
        event: "eventga"
    });
}

var require = {
    baseUrl: "/",
    waitSeconds: 20,
    paths: {
        mime: "3rdparty/mime",
        knockout: "3rdparty/knockout",
        crossroads: "3rdparty/crossroads",
        eventmatcher: "3rdparty/eventmatcher",
        hasher: "3rdparty/hasher",
        signals: "3rdparty/signals",
        jquery: "3rdparty/jquery",
        mario: "3rdparty/mario",
        ace: "3rdparty/ace",
        createError: "3rdparty/createError",
        css: "3rdparty/css",
        punycode: "3rdparty/punycode",
        "one-validation": "3rdparty/onevalidation/validation",
        tpl: "3rdparty/tpl",
        unicoderegexp: "3rdparty/unicodeRegExp"
    },
    shim: {
        "3rdparty/one-theme/3rdparty/bootstrap/js/bootstrap-alert": {
            deps: [ "jquery" ],
            exports: "$.fn.alert"
        },
        "3rdparty/one-theme/3rdparty/bootstrap/js/bootstrap-dropdown": {
            deps: [ "jquery" ],
            exports: "$.fn.dropdown"
        },
        "3rdparty/one-theme/3rdparty/bootstrap/js/bootstrap-button": {
            deps: [ "jquery" ],
            exports: "$.fn.button"
        },
        "3rdparty/one-theme/3rdparty/bootstrap/js/bootstrap-tooltip": {
            deps: [ "jquery" ],
            exports: "$.fn.tooltip"
        },
        "3rdparty/jquery.elastic": {
            deps: [ "jquery" ],
            exports: "$.elastic"
        },
        "3rdparty/jquery.cookie": {
            deps: [ "jquery" ],
            exports: "$.cookie"
        },
        knockout: [ "jquery" ]
    }
};

/*!
    Copyright (c) 2009, 280 North Inc. http://280north.com/
    MIT License. http://github.com/280north/narwhal/blob/master/README.md
*/
(function(definition) {
    if (typeof define == "function") {
        define(definition);
    } else {
        definition();
    }
})(function() {
    if (!Function.prototype.bind) {
        Function.prototype.bind = function bind(that) {
            var target = this;
            if (typeof target != "function") throw new TypeError();
            var args = slice.call(arguments, 1);
            var bound = function() {
                if (this instanceof bound) {
                    var F = function() {};
                    F.prototype = target.prototype;
                    var self = new F();
                    var result = target.apply(self, args.concat(slice.call(arguments)));
                    if (result !== null && Object(result) === result) return result;
                    return self;
                } else {
                    return target.apply(that, args.concat(slice.call(arguments)));
                }
            };
            return bound;
        };
    }
    var call = Function.prototype.call;
    var prototypeOfArray = Array.prototype;
    var prototypeOfObject = Object.prototype;
    var slice = prototypeOfArray.slice;
    var toString = call.bind(prototypeOfObject.toString);
    var owns = call.bind(prototypeOfObject.hasOwnProperty);
    var defineGetter;
    var defineSetter;
    var lookupGetter;
    var lookupSetter;
    var supportsAccessors;
    if (supportsAccessors = owns(prototypeOfObject, "__defineGetter__")) {
        defineGetter = call.bind(prototypeOfObject.__defineGetter__);
        defineSetter = call.bind(prototypeOfObject.__defineSetter__);
        lookupGetter = call.bind(prototypeOfObject.__lookupGetter__);
        lookupSetter = call.bind(prototypeOfObject.__lookupSetter__);
    }
    if (!Array.isArray) {
        Array.isArray = function isArray(obj) {
            return toString(obj) == "[object Array]";
        };
    }
    if (!Array.prototype.forEach) {
        Array.prototype.forEach = function forEach(fun) {
            var self = toObject(this), thisp = arguments[1], i = 0, length = self.length >>> 0;
            if (toString(fun) != "[object Function]") {
                throw new TypeError();
            }
            while (i < length) {
                if (i in self) {
                    fun.call(thisp, self[i], i, self);
                }
                i++;
            }
        };
    }
    if (!Array.prototype.map) {
        Array.prototype.map = function map(fun) {
            var self = toObject(this), length = self.length >>> 0, result = Array(length), thisp = arguments[1];
            if (toString(fun) != "[object Function]") {
                throw new TypeError();
            }
            for (var i = 0; i < length; i++) {
                if (i in self) result[i] = fun.call(thisp, self[i], i, self);
            }
            return result;
        };
    }
    if (!Array.prototype.filter) {
        Array.prototype.filter = function filter(fun) {
            var self = toObject(this), length = self.length >>> 0, result = [], thisp = arguments[1];
            if (toString(fun) != "[object Function]") {
                throw new TypeError();
            }
            for (var i = 0; i < length; i++) {
                if (i in self && fun.call(thisp, self[i], i, self)) result.push(self[i]);
            }
            return result;
        };
    }
    if (!Array.prototype.every) {
        Array.prototype.every = function every(fun) {
            var self = toObject(this), length = self.length >>> 0, thisp = arguments[1];
            if (toString(fun) != "[object Function]") {
                throw new TypeError();
            }
            for (var i = 0; i < length; i++) {
                if (i in self && !fun.call(thisp, self[i], i, self)) return false;
            }
            return true;
        };
    }
    if (!Array.prototype.some) {
        Array.prototype.some = function some(fun) {
            var self = toObject(this), length = self.length >>> 0, thisp = arguments[1];
            if (toString(fun) != "[object Function]") {
                throw new TypeError();
            }
            for (var i = 0; i < length; i++) {
                if (i in self && fun.call(thisp, self[i], i, self)) return true;
            }
            return false;
        };
    }
    if (!Array.prototype.reduce) {
        Array.prototype.reduce = function reduce(fun) {
            var self = toObject(this), length = self.length >>> 0;
            if (toString(fun) != "[object Function]") {
                throw new TypeError();
            }
            if (!length && arguments.length == 1) throw new TypeError();
            var i = 0;
            var result;
            if (arguments.length >= 2) {
                result = arguments[1];
            } else {
                do {
                    if (i in self) {
                        result = self[i++];
                        break;
                    }
                    if (++i >= length) throw new TypeError();
                } while (true);
            }
            for (;i < length; i++) {
                if (i in self) result = fun.call(void 0, result, self[i], i, self);
            }
            return result;
        };
    }
    if (!Array.prototype.reduceRight) {
        Array.prototype.reduceRight = function reduceRight(fun) {
            var self = toObject(this), length = self.length >>> 0;
            if (toString(fun) != "[object Function]") {
                throw new TypeError();
            }
            if (!length && arguments.length == 1) throw new TypeError();
            var result, i = length - 1;
            if (arguments.length >= 2) {
                result = arguments[1];
            } else {
                do {
                    if (i in self) {
                        result = self[i--];
                        break;
                    }
                    if (--i < 0) throw new TypeError();
                } while (true);
            }
            do {
                if (i in this) result = fun.call(void 0, result, self[i], i, self);
            } while (i--);
            return result;
        };
    }
    if (!Array.prototype.indexOf) {
        Array.prototype.indexOf = function indexOf(sought) {
            var self = toObject(this), length = self.length >>> 0;
            if (!length) return -1;
            var i = 0;
            if (arguments.length > 1) i = toInteger(arguments[1]);
            i = i >= 0 ? i : length - Math.abs(i);
            for (;i < length; i++) {
                if (i in self && self[i] === sought) {
                    return i;
                }
            }
            return -1;
        };
    }
    if (!Array.prototype.lastIndexOf) {
        Array.prototype.lastIndexOf = function lastIndexOf(sought) {
            var self = toObject(this), length = self.length >>> 0;
            if (!length) return -1;
            var i = length - 1;
            if (arguments.length > 1) i = toInteger(arguments[1]);
            i = i >= 0 ? i : length - Math.abs(i);
            for (;i >= 0; i--) {
                if (i in self && sought === self[i]) return i;
            }
            return -1;
        };
    }
    if (!Object.getPrototypeOf) {
        Object.getPrototypeOf = function getPrototypeOf(object) {
            return object.__proto__ || (object.constructor ? object.constructor.prototype : prototypeOfObject);
        };
    }
    if (!Object.getOwnPropertyDescriptor) {
        var ERR_NON_OBJECT = "Object.getOwnPropertyDescriptor called on a " + "non-object: ";
        Object.getOwnPropertyDescriptor = function getOwnPropertyDescriptor(object, property) {
            if (typeof object != "object" && typeof object != "function" || object === null) throw new TypeError(ERR_NON_OBJECT + object);
            if (!owns(object, property)) return;
            var descriptor, getter, setter;
            descriptor = {
                enumerable: true,
                configurable: true
            };
            if (supportsAccessors) {
                var prototype = object.__proto__;
                object.__proto__ = prototypeOfObject;
                var getter = lookupGetter(object, property);
                var setter = lookupSetter(object, property);
                object.__proto__ = prototype;
                if (getter || setter) {
                    if (getter) descriptor.get = getter;
                    if (setter) descriptor.set = setter;
                    return descriptor;
                }
            }
            descriptor.value = object[property];
            return descriptor;
        };
    }
    if (!Object.getOwnPropertyNames) {
        Object.getOwnPropertyNames = function getOwnPropertyNames(object) {
            return Object.keys(object);
        };
    }
    if (!Object.create) {
        Object.create = function create(prototype, properties) {
            var object;
            if (prototype === null) {
                object = {
                    __proto__: null
                };
            } else {
                if (typeof prototype != "object") throw new TypeError("typeof prototype[" + typeof prototype + "] != 'object'");
                var Type = function() {};
                Type.prototype = prototype;
                object = new Type();
                object.__proto__ = prototype;
            }
            if (properties !== void 0) Object.defineProperties(object, properties);
            return object;
        };
    }
    function doesDefinePropertyWork(object) {
        try {
            Object.defineProperty(object, "sentinel", {});
            return "sentinel" in object;
        } catch (exception) {}
    }
    if (Object.defineProperty) {
        var definePropertyWorksOnObject = doesDefinePropertyWork({});
        var definePropertyWorksOnDom = typeof document == "undefined" || doesDefinePropertyWork(document.createElement("div"));
        if (!definePropertyWorksOnObject || !definePropertyWorksOnDom) {
            var definePropertyFallback = Object.defineProperty;
        }
    }
    if (!Object.defineProperty || definePropertyFallback) {
        var ERR_NON_OBJECT_DESCRIPTOR = "Property description must be an object: ";
        var ERR_NON_OBJECT_TARGET = "Object.defineProperty called on non-object: ";
        var ERR_ACCESSORS_NOT_SUPPORTED = "getters & setters can not be defined " + "on this javascript engine";
        Object.defineProperty = function defineProperty(object, property, descriptor) {
            if (typeof object != "object" && typeof object != "function" || object === null) throw new TypeError(ERR_NON_OBJECT_TARGET + object);
            if (typeof descriptor != "object" && typeof descriptor != "function" || descriptor === null) throw new TypeError(ERR_NON_OBJECT_DESCRIPTOR + descriptor);
            if (definePropertyFallback) {
                try {
                    return definePropertyFallback.call(Object, object, property, descriptor);
                } catch (exception) {}
            }
            if (owns(descriptor, "value")) {
                if (supportsAccessors && (lookupGetter(object, property) || lookupSetter(object, property))) {
                    var prototype = object.__proto__;
                    object.__proto__ = prototypeOfObject;
                    delete object[property];
                    object[property] = descriptor.value;
                    object.__proto__ = prototype;
                } else {
                    object[property] = descriptor.value;
                }
            } else {
                if (!supportsAccessors) throw new TypeError(ERR_ACCESSORS_NOT_SUPPORTED);
                if (owns(descriptor, "get")) defineGetter(object, property, descriptor.get);
                if (owns(descriptor, "set")) defineSetter(object, property, descriptor.set);
            }
            return object;
        };
    }
    if (!Object.defineProperties) {
        Object.defineProperties = function defineProperties(object, properties) {
            for (var property in properties) {
                if (owns(properties, property)) Object.defineProperty(object, property, properties[property]);
            }
            return object;
        };
    }
    if (!Object.seal) {
        Object.seal = function seal(object) {
            return object;
        };
    }
    if (!Object.freeze) {
        Object.freeze = function freeze(object) {
            return object;
        };
    }
    try {
        Object.freeze(function() {});
    } catch (exception) {
        Object.freeze = function freeze(freezeObject) {
            return function freeze(object) {
                if (typeof object == "function") {
                    return object;
                } else {
                    return freezeObject(object);
                }
            };
        }(Object.freeze);
    }
    if (!Object.preventExtensions) {
        Object.preventExtensions = function preventExtensions(object) {
            return object;
        };
    }
    if (!Object.isSealed) {
        Object.isSealed = function isSealed(object) {
            return false;
        };
    }
    if (!Object.isFrozen) {
        Object.isFrozen = function isFrozen(object) {
            return false;
        };
    }
    if (!Object.isExtensible) {
        Object.isExtensible = function isExtensible(object) {
            if (Object(object) === object) {
                throw new TypeError();
            }
            var name = "";
            while (owns(object, name)) {
                name += "?";
            }
            object[name] = true;
            var returnValue = owns(object, name);
            delete object[name];
            return returnValue;
        };
    }
    if (!Object.keys) {
        var hasDontEnumBug = true, dontEnums = [ "toString", "toLocaleString", "valueOf", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "constructor" ], dontEnumsLength = dontEnums.length;
        for (var key in {
            toString: null
        }) hasDontEnumBug = false;
        Object.keys = function keys(object) {
            if (typeof object != "object" && typeof object != "function" || object === null) throw new TypeError("Object.keys called on a non-object");
            var keys = [];
            for (var name in object) {
                if (owns(object, name)) {
                    keys.push(name);
                }
            }
            if (hasDontEnumBug) {
                for (var i = 0, ii = dontEnumsLength; i < ii; i++) {
                    var dontEnum = dontEnums[i];
                    if (owns(object, dontEnum)) {
                        keys.push(dontEnum);
                    }
                }
            }
            return keys;
        };
    }
    if (!Date.prototype.toISOString) {
        Date.prototype.toISOString = function toISOString() {
            var result, length, value;
            if (!isFinite(this)) throw new RangeError();
            result = [ this.getUTCFullYear(), this.getUTCMonth() + 1, this.getUTCDate(), this.getUTCHours(), this.getUTCMinutes(), this.getUTCSeconds() ];
            length = result.length;
            while (length--) {
                value = result[length];
                if (value < 10) result[length] = "0" + value;
            }
            return result.slice(0, 3).join("-") + "T" + result.slice(3).join(":") + "." + ("000" + this.getUTCMilliseconds()).slice(-3) + "Z";
        };
    }
    if (!Date.now) {
        Date.now = function now() {
            return new Date().getTime();
        };
    }
    if (!Date.prototype.toJSON) {
        Date.prototype.toJSON = function toJSON(key) {
            if (typeof this.toISOString != "function") throw new TypeError();
            return this.toISOString();
        };
    }
    if (isNaN(Date.parse("2011-06-15T21:40:05+06:00"))) {
        Date = function(NativeDate) {
            var Date = function Date(Y, M, D, h, m, s, ms) {
                var length = arguments.length;
                if (this instanceof NativeDate) {
                    var date = length == 1 && String(Y) === Y ? new NativeDate(Date.parse(Y)) : length >= 7 ? new NativeDate(Y, M, D, h, m, s, ms) : length >= 6 ? new NativeDate(Y, M, D, h, m, s) : length >= 5 ? new NativeDate(Y, M, D, h, m) : length >= 4 ? new NativeDate(Y, M, D, h) : length >= 3 ? new NativeDate(Y, M, D) : length >= 2 ? new NativeDate(Y, M) : length >= 1 ? new NativeDate(Y) : new NativeDate();
                    date.constructor = Date;
                    return date;
                }
                return NativeDate.apply(this, arguments);
            };
            var isoDateExpression = new RegExp("^" + "(\\d{4})" + "(?:-(\\d{2})" + "(?:-(\\d{2})" + "(?:" + "T(\\d{2})" + ":(\\d{2})" + "(?:" + ":(\\d{2})" + "(?:\\.(\\d{3}))?" + ")?" + "(?:" + "Z|" + "(?:" + "([-+])" + "(\\d{2})" + ":(\\d{2})" + ")" + ")?)?)?)?" + "$");
            for (var key in NativeDate) Date[key] = NativeDate[key];
            Date.now = NativeDate.now;
            Date.UTC = NativeDate.UTC;
            Date.prototype = NativeDate.prototype;
            Date.prototype.constructor = Date;
            Date.parse = function parse(string) {
                var match = isoDateExpression.exec(string);
                if (match) {
                    match.shift();
                    for (var i = 1; i < 7; i++) {
                        match[i] = +(match[i] || (i < 3 ? 1 : 0));
                        if (i == 1) match[i]--;
                    }
                    var minuteOffset = +match.pop(), hourOffset = +match.pop(), sign = match.pop();
                    var offset = 0;
                    if (sign) {
                        if (hourOffset > 23 || minuteOffset > 59) return NaN;
                        offset = (hourOffset * 60 + minuteOffset) * 6e4 * (sign == "+" ? -1 : 1);
                    }
                    return NativeDate.UTC.apply(this, match) + offset;
                }
                return NativeDate.parse.apply(this, arguments);
            };
            return Date;
        }(Date);
    }
    var ws = "	\n\f\r   ᠎    " + "         　\u2028" + "\u2029";
    if (!String.prototype.trim || ws.trim()) {
        ws = "[" + ws + "]";
        var trimBeginRegexp = new RegExp("^" + ws + ws + "*"), trimEndRegexp = new RegExp(ws + ws + "*$");
        String.prototype.trim = function trim() {
            return String(this).replace(trimBeginRegexp, "").replace(trimEndRegexp, "");
        };
    }
    var toInteger = function(n) {
        n = +n;
        if (n !== n) n = -1; else if (n !== 0 && n !== 1 / 0 && n !== -(1 / 0)) n = (n > 0 || -1) * Math.floor(Math.abs(n));
        return n;
    };
    var prepareString = "a"[0] != "a", toObject = function(o) {
        if (o == null) {
            throw new TypeError();
        }
        if (prepareString && typeof o == "string" && o) {
            return o.split("");
        }
        return Object(o);
    };
});

(function(root, factory) {
    if (typeof module !== "undefined") {
        module.exports = factory();
    } else if (typeof root.define === "function" && define.amd) {
        define(factory);
    } else {
        root.inter = factory();
    }
})(this, function() {
    var inter = {
        renderers: {},
        trQuantity: function(patternByQuantity, number) {
            return this.getPatternRenderer(patternByQuantity[this.pluralRule(number)]).call(this, Array.prototype.slice.call(arguments, 1));
        },
        tokenizePattern: function(pattern) {
            var tokens = [];
            pattern.replace(/\{(\d+)\}|([^\{]+)/g, function($0, placeHolderNumber, text) {
                if (text) {
                    tokens.push({
                        type: "text",
                        value: text
                    });
                } else {
                    tokens.push({
                        type: "placeHolder",
                        value: parseInt(placeHolderNumber, 10)
                    });
                }
            });
            return tokens;
        },
        makePatternRenderer: function(pattern) {
            if (pattern) {
                var predefinedCodeFragments = [].slice.call(arguments, 1);
                return new Function("values", "return " + this.tokenizePattern(pattern).map(function(token) {
                    if (token.type === "placeHolder") {
                        return predefinedCodeFragments[token.value] || "values[" + token.value + "]";
                    } else {
                        return '"' + token.value.replace(/\"/g, '\\"').replace(/\n/g, "\\n") + '"';
                    }
                }).join("+") + ";");
            } else {
                return function() {
                    return "[! makePatternRenderer: No pattern provided !]";
                };
            }
        },
        makeFileSizeRenderer: function(numDecimals, numberSystemId) {
            var numberSymbols = this.numbers[numberSystemId || this.defaultNumberSystemId].symbols;
            function makeNumberRendererSource(sourceVariableNameOrExpression, numDecimals, suffix) {
                return "(" + sourceVariableNameOrExpression + ")" + ".toFixed(" + (numDecimals || 0) + ")" + (numberSymbols.decimalPoint === "." ? "" : ".replace('.', '" + numberSymbols.decimal.replace(/\'/g, "\\'") + "')") + (suffix ? "+'" + suffix.replace(/\'/g, "\\'") + "'" : "");
            }
            return new Function("size", "if (size < 1000) {" + "return " + makeNumberRendererSource("size", 0, " bytes", numberSystemId) + ";" + "} else if (size < 1000000) {" + "return " + makeNumberRendererSource("size/1024", numDecimals, " KB", numberSystemId) + ";" + "} else if (size < 1000000000) {" + "return " + makeNumberRendererSource("size/1048576", numDecimals, " MB", numberSystemId) + ";" + "} else if (size < 1000000000000) {" + "return " + makeNumberRendererSource("size/1073741824", numDecimals, " GB", numberSystemId) + ";" + "} else {" + "return " + makeNumberRendererSource("size/1099511627776", numDecimals, " TB", numberSystemId) + ";" + "}");
        },
        makeNumberRenderer: function(pattern, numberSystemId, currencyCode) {
            pattern = pattern || this.numbers.latn.formats.decimal["default"];
            var numberSystem = this.numbers[numberSystemId || "latn"], digits = numberSystem.digits;
            if (typeof digits === "string") {
                var that = this;
                return function(number) {
                    return that[digits](number);
                };
            }
            var maximumIntegerDigits = 40, minimumIntegerDigits = 1, maximumFractionDigits = 3, minimumFractionDigits = 0, minExponentDigits = 0, useSignForPositiveExponent = false, positivePrefix = "", positiveSuffix = "", negativePrefix = "-", negativeSuffix = "", multiplier = 1, groupingSize = 3, decimalSeparatorAlwaysShown = false, useExponentialNotation = false, pos = [ 0 ];
            positivePrefix = parseAffix(pattern, pos);
            var trunkStart = pos[0];
            parseTrunk(pattern, pos);
            var trunkLen = pos[0] - trunkStart;
            positiveSuffix = parseAffix(pattern, pos);
            if (pos[0] < pattern.length && pattern.charAt(pos[0]) === ";") {
                pos[0] += 1;
                negativePrefix = parseAffix(pattern, pos);
                pos[0] += trunkLen;
                negativeSuffix = parseAffix(pattern, pos);
            } else {
                negativePrefix = positivePrefix + negativePrefix;
                negativeSuffix += positiveSuffix;
            }
            function parseAffix(pattern, pos) {
                var affix = "", inQuote = false, len = pattern.length;
                for (;pos[0] < len; pos[0] += 1) {
                    var ch = pattern.charAt(pos[0]);
                    if (ch === "'") {
                        if (pos[0] + 1 < len && pattern.charAt(pos[0] + 1) === "'") {
                            pos[0] += 1;
                            affix += "'";
                        } else {
                            inQuote = !inQuote;
                        }
                        continue;
                    }
                    if (inQuote) {
                        affix += ch;
                    } else {
                        switch (ch) {
                          case "#":
                          case "0":
                          case ",":
                          case ".":
                          case ";":
                            return affix;

                          case "¤":
                            if (pos[0] + 1 < len && pattern.charAt(pos[0] + 1) === "¤") {
                                pos[0] += 1;
                                affix += currencyCode || "¤";
                            } else {
                                affix += currencyCode || "¤";
                            }
                            break;

                          case "%":
                            if (multiplier !== 1) {
                                throw Error("Too many percent/permill");
                            }
                            multiplier = 100;
                            affix += numberSystem.symbols.percentSign;
                            break;

                          case "‰":
                            if (multiplier !== 1) {
                                throw Error("Too many percent/permill");
                            }
                            multiplier = 1e3;
                            affix += numberSystem.symbols.perMille;
                            break;

                          default:
                            affix += ch;
                        }
                    }
                }
                return affix;
            }
            function subformatFixed(number, minIntDigits, parts) {
                var power = Math.pow(10, maximumFractionDigits), shiftedNumber = Math.round(number * power), intValue, fracValue;
                if (isFinite(shiftedNumber)) {
                    intValue = Math.floor(shiftedNumber / power);
                    fracValue = Math.floor(shiftedNumber - intValue * power);
                } else {
                    intValue = number;
                    fracValue = 0;
                }
                var fractionPresent = minimumFractionDigits > 0 || fracValue > 0, intPart = "", translatableInt = intValue;
                while (translatableInt > 1e20) {
                    intPart = "0" + intPart;
                    translatableInt = Math.round(translatableInt / 10);
                }
                intPart = translatableInt + intPart;
                var decimal = numberSystem.symbols.decimal, grouping = numberSystem.symbols.group, zeroCode = digits[0].charCodeAt(0), digitLen = intPart.length, i;
                if (intValue > 0 || minIntDigits > 0) {
                    for (i = digitLen; i < minIntDigits; i += 1) {
                        parts.push(String.fromCharCode(zeroCode));
                    }
                    for (i = 0; i < digitLen; i += 1) {
                        parts.push(String.fromCharCode(zeroCode + intPart.charAt(i) * 1));
                        if (digitLen - i > 1 && groupingSize > 0 && (digitLen - i) % groupingSize === 1) {
                            parts.push(grouping);
                        }
                    }
                } else if (!fractionPresent) {
                    parts.push(String.fromCharCode(zeroCode));
                }
                if (decimalSeparatorAlwaysShown || fractionPresent) {
                    parts.push(decimal);
                }
                var fracPart = "" + (fracValue + power), fracLen = fracPart.length;
                while (fracPart.charAt(fracLen - 1) === "0" && fracLen > minimumFractionDigits + 1) {
                    fracLen -= 1;
                }
                for (i = 1; i < fracLen; i += 1) {
                    parts.push(String.fromCharCode(zeroCode + fracPart.charAt(i) * 1));
                }
            }
            function addExponentPart(exponent, parts) {
                parts.push(numberSystem.symbols.exponential);
                if (exponent < 0) {
                    exponent = -exponent;
                    parts.push(numberSystem.symbols.minusSign);
                } else if (useSignForPositiveExponent) {
                    parts.push(numberSystem.symbols.plusSign);
                }
                var exponentDigits = "" + exponent, zeroChar = digits[0];
                for (var i = exponentDigits.length; i < minExponentDigits; i += 1) {
                    parts.push(zeroChar);
                }
                parts.push(exponentDigits);
            }
            function subformatExponential(number, parts) {
                if (number === 0) {
                    subformatFixed(number, minimumIntegerDigits, parts);
                    addExponentPart(0, parts);
                    return;
                }
                var exponent = Math.floor(Math.log(number) / Math.log(10));
                number /= Math.pow(10, exponent);
                var minIntDigits = minimumIntegerDigits;
                if (maximumIntegerDigits > 1 && maximumIntegerDigits > minimumIntegerDigits) {
                    while (exponent % maximumIntegerDigits !== 0) {
                        number *= 10;
                        exponent -= 1;
                    }
                    minIntDigits = 1;
                } else {
                    if (minimumIntegerDigits < 1) {
                        exponent += 1;
                        number /= 10;
                    } else {
                        exponent -= minimumIntegerDigits - 1;
                        number *= Math.pow(10, minimumIntegerDigits - 1);
                    }
                }
                subformatFixed(number, minIntDigits, parts);
                addExponentPart(exponent, parts);
            }
            function getDigit(ch) {
                var code = ch.charCodeAt(0);
                if (48 <= code && code < 58) {
                    return code - 48;
                } else {
                    var zeroCode = digits[0].charCodeAt(0);
                    return zeroCode <= code && code < zeroCode + 10 ? code - zeroCode : -1;
                }
            }
            function parseTrunk(pattern, pos) {
                var decimalPos = -1, digitLeftCount = 0, zeroDigitCount = 0, digitRightCount = 0, groupingCount = -1, len = pattern.length;
                for (var loop = true; pos[0] < len && loop; pos[0] += 1) {
                    var ch = pattern.charAt(pos[0]);
                    switch (ch) {
                      case "#":
                        if (zeroDigitCount > 0) {
                            digitRightCount += 1;
                        } else {
                            digitLeftCount += 1;
                        }
                        if (groupingCount >= 0 && decimalPos < 0) {
                            groupingCount += 1;
                        }
                        break;

                      case "0":
                        if (digitRightCount > 0) {
                            throw Error('Unexpected "0" in pattern "' + pattern + '"');
                        }
                        zeroDigitCount += 1;
                        if (groupingCount >= 0 && decimalPos < 0) {
                            groupingCount += 1;
                        }
                        break;

                      case ",":
                        groupingCount = 0;
                        break;

                      case ".":
                        if (decimalPos >= 0) {
                            throw Error('Multiple decimal separators in pattern "' + pattern + '"');
                        }
                        decimalPos = digitLeftCount + zeroDigitCount + digitRightCount;
                        break;

                      case "E":
                        if (useExponentialNotation) {
                            throw Error('Multiple exponential symbols in pattern "' + pattern + '"');
                        }
                        useExponentialNotation = true;
                        minExponentDigits = 0;
                        if (pos[0] + 1 < len && pattern.charAt(pos[0] + 1) === "+") {
                            pos[0] += 1;
                            useSignForPositiveExponent = true;
                        }
                        while (pos[0] + 1 < len && pattern.charAt(pos[0] + 1) === "0") {
                            pos[0] += 1;
                            minExponentDigits += 1;
                        }
                        if (digitLeftCount + zeroDigitCount < 1 || minExponentDigits < 1) {
                            throw Error('Malformed exponential pattern "' + pattern + '"');
                        }
                        loop = false;
                        break;

                      default:
                        pos[0] -= 1;
                        loop = false;
                        break;
                    }
                }
                if (zeroDigitCount === 0 && digitLeftCount > 0 && decimalPos >= 0) {
                    var n = decimalPos;
                    if (n === 0) {
                        n += 1;
                    }
                    digitRightCount = digitLeftCount - n;
                    digitLeftCount = n - 1;
                    zeroDigitCount = 1;
                }
                if (decimalPos < 0 && digitRightCount > 0 || decimalPos >= 0 && (decimalPos < digitLeftCount || decimalPos > digitLeftCount + zeroDigitCount) || groupingCount === 0) {
                    throw Error('Malformed pattern "' + pattern + '"');
                }
                var totalDigits = digitLeftCount + zeroDigitCount + digitRightCount;
                maximumFractionDigits = decimalPos >= 0 ? totalDigits - decimalPos : 0;
                if (decimalPos >= 0) {
                    minimumFractionDigits = digitLeftCount + zeroDigitCount - decimalPos;
                    if (minimumFractionDigits < 0) {
                        minimumFractionDigits = 0;
                    }
                }
                var effectiveDecimalPos = decimalPos >= 0 ? decimalPos : totalDigits;
                minimumIntegerDigits = effectiveDecimalPos - digitLeftCount;
                if (useExponentialNotation) {
                    maximumIntegerDigits = digitLeftCount + minimumIntegerDigits;
                    if (maximumFractionDigits === 0 && minimumIntegerDigits === 0) {
                        minimumIntegerDigits = 1;
                    }
                }
                groupingSize = Math.max(0, groupingCount);
                decimalSeparatorAlwaysShown = decimalPos === 0 || decimalPos === totalDigits;
            }
            return function format(number) {
                if (isNaN(number)) {
                    return numberSystem.symbols.nan;
                }
                var parts = [], isNegative = number < 0 || number === 0 && 1 / number < 0;
                parts.push(isNegative ? negativePrefix : positivePrefix);
                if (!isFinite(number)) {
                    parts.push(numberSystem.symbols.infinity);
                } else {
                    number *= isNegative ? -1 : 1;
                    number *= multiplier;
                    useExponentialNotation ? subformatExponential(number, parts) : subformatFixed(number, minimumIntegerDigits, parts);
                }
                parts.push(isNegative ? negativeSuffix : positiveSuffix);
                return parts.join("");
            };
        },
        makePercentageRenderer: function(numberSystemId) {
            numberSystemId = numberSystemId || "latn";
            var pattern = this.numbers[numberSystemId].formats.percent["default"];
            return this.makeNumberRenderer(pattern, numberSystemId);
        },
        tokenizeDateFormat: function(format) {
            var tokens = [];
            format.replace(/([^a-z']+)|'(')|'((?:[^']|'')+)'|(([a-z])\5*)/gi, function($0, unescapedText, escapedSingleQuote, escapedText, fieldToken) {
                if (fieldToken) {
                    tokens.push({
                        type: "field",
                        value: fieldToken
                    });
                } else {
                    if (escapedText) {
                        escapedText = escapedText.replace(/''/g, "'");
                    }
                    tokens.push({
                        type: "text",
                        value: (unescapedText || escapedSingleQuote || escapedText || $0).replace(/"/g, '\\"')
                    });
                }
            });
            return tokens;
        },
        getCodeFragmentForDateField: function() {
            var codeFragmentsByFormatChar = {
                G: [ "{eraNames.abbreviated}[{date}.getFullYear() > 0 ? 1 : 0]" ],
                y: [ '"0000".slice(String({date}.getFullYear()).length) + {date}.getFullYear()' ],
                Q: [ '"0" + ({date}.getMonth()/4)', "*", "{quarterNames.format.abbreviated}[Math.floor({date}.getMonth()/4)]", "{quarterNames.format.wide}[Math.floor({date}.getMonth()/4)]" ],
                M: [ "({date}.getMonth() + 1)", '({date}.getMonth() < 9 ? "0" : "") + ({date}.getMonth() + 1)', "{monthNames.format.abbreviated}[{date}.getMonth()]", "{monthNames.format.wide}[{date}.getMonth()]" ],
                L: [ "({date}.getMonth() + 1)", '({date}.getMonth() < 9 ? "0" : "") + ({date}.getMonth() + 1)', "{monthNames.format.abbreviated}[{date}.getMonth())", "{monthNames.format.wide}[{date}.getMonth()]" ],
                d: [ "{date}.getDate()", '({date}.getDate() < 10 ? "0" : "") + {date}.getDate()' ],
                D: [ "(1 + Math.floor(({date}.getTime() - new Date({date}.getFullYear(), 0, 1).getTime()) / 86400000))" ],
                F: [ "(1 + Math.floor((date.getDate() - 1) / 7))" ],
                E: [ "{dayNames.format.abbreviated}[{date}.getDay()]", "*", "*", "{dayNames.format.wide}[{date}.getDay()]" ],
                a: [ '({date}.getHours() < 12 ? "am" : "pm")' ],
                h: [ "(({date}.getHours() % 12) ? {date}.getHours() % 12 : 12)" ],
                H: [ '({date}.getHours() < 10 ? "0" : "") + {date}.getHours()' ],
                m: [ '({date}.getMinutes() < 10 ? "0" : "") + {date}.getMinutes()' ],
                s: [ '({date}.getSeconds() < 10 ? "0" : "") + {date}.getSeconds()' ]
            };
            return function(fieldToken, sourceVariableNameOrExpression, calendarId) {
                calendarId = calendarId || "gregorian";
                var codeFragments = codeFragmentsByFormatChar[fieldToken[0]];
                if (codeFragments) {
                    var codeFragmentNumber = Math.min(fieldToken.length, codeFragments.length) - 1;
                    while (codeFragments[codeFragmentNumber] === "*") {
                        codeFragmentNumber -= 1;
                    }
                    var that = this;
                    return codeFragments[codeFragmentNumber].replace(/\{([^\}]+)\}/g, function($0, varName) {
                        if (varName === "date") {
                            return "(" + sourceVariableNameOrExpression + ")";
                        } else {
                            var fragments = varName.split("."), obj = that.calendars[calendarId];
                            for (var i = 0; i < fragments.length; i += 1) {
                                obj = obj[fragments[i]];
                            }
                            return JSON.stringify(obj);
                        }
                    });
                }
            };
        }(),
        makeDateFormatRendererSource: function(sourceVariableNameOrExpression, format, calendarId) {
            calendarId = calendarId || "gregorian";
            var expressions = [];
            this.tokenizeDateFormat(format).forEach(function(token) {
                if (token.type === "text") {
                    expressions.push('"' + token.value.replace(/"/g, '\\"') + '"');
                } else {
                    var codeFragment = this.getCodeFragmentForDateField(token.value, sourceVariableNameOrExpression, calendarId);
                    if (codeFragment) {
                        expressions.push(codeFragment);
                    }
                }
            }, this);
            return expressions.join("+");
        },
        makeDateRenderer: function(formatId, calendarId) {
            return new Function("d", "return " + this.makeDateFormatRendererSource("d", this.getDateFormat(formatId, calendarId), calendarId) + ";");
        },
        makeDateFormatRenderer: function(format, calendarId) {
            return new Function("d", "return " + this.makeDateFormatRendererSource("d", format, calendarId) + ";");
        },
        getDateFormat: function(formatId, calendarId) {
            calendarId = calendarId || "gregorian";
            var icuFormat = this.calendars[calendarId].dateFormats.basic[formatId] || this.calendars[calendarId].dateFormats.cldr[formatId];
            if (icuFormat) {
                return icuFormat;
            } else {
                var bestCandidateFormatId = this.getBestICUFormatId(formatId, this.calendars[calendarId].dateFormats.cldr);
                if (bestCandidateFormatId) {
                    return this.calendars[calendarId].dateFormats.cldr[formatId] = this.adaptICUFormat(this.calendars[calendarId].dateFormats.cldr[bestCandidateFormatId], formatId);
                } else {
                    var matchFormatId = formatId.match(/^y+M+d+$/);
                    if (matchFormatId) {
                        return this.calendars[calendarId].dateFormats.cldr[formatId] = this.adaptICUFormat(this.calendars[calendarId].dateFormats.basic.shortDate, formatId);
                    }
                    matchFormatId = formatId.match(/^([yMQEd]+)([Hhms]+)$/);
                    if (matchFormatId) {
                        var dateFormat = this.getDateFormat(matchFormatId[1], calendarId), timeFormat = this.getDateFormat(matchFormatId[2], calendarId);
                        return this.renderPattern([ timeFormat, dateFormat ], this.calendars[calendarId].defaultDateTimePattern);
                    } else {
                        throw new Error("inter.getDateFormat: Cannot find format: " + formatId);
                    }
                }
            }
        },
        getBestICUFormatId: function(formatId, sourceObject) {
            var bestCandidateFormatId, matcher = new RegExp("^" + formatId.replace(/(([a-zA-Z])\2*)/g, function($0, formatToken, formatChar) {
                return formatChar + "{1," + formatToken.length + "}";
            }) + "$");
            for (var candidateFormatId in sourceObject) {
                if (matcher.test(candidateFormatId)) {
                    if (!bestCandidateFormatId || candidateFormatId.length > bestCandidateFormatId.length) {
                        bestCandidateFormatId = candidateFormatId;
                    }
                }
            }
            return bestCandidateFormatId;
        },
        adaptICUFormat: function(icuFormat, adaptToFormatId) {
            adaptToFormatId.replace(/(([a-zA-Z])\2*)/g, function($0, formatToken, formatChar) {
                icuFormat = icuFormat.replace(new RegExp(formatChar + "+", "g"), formatToken);
            });
            return icuFormat;
        }
    };
    [ "Unit", "Number", "Percentage", "FileSize", "Date", "DateFormat", "DateInterval", "Pattern" ].forEach(function(rendererType) {
        if ("make" + rendererType + "Renderer" in this) {
            this["get" + rendererType + "Renderer"] = function() {
                var rendererId = rendererType + ":" + [].join.call(arguments, "/");
                return this.renderers[rendererId] || (this.renderers[rendererId] = this["make" + rendererType + "Renderer"].apply(this, arguments));
            };
            this["render" + rendererType] = function(obj) {
                var makeRendererArgs = [].slice.call(arguments, 1);
                return (this.renderers[rendererType + ":" + makeRendererArgs.join("/")] || this["get" + rendererType + "Renderer"].apply(this, makeRendererArgs))(obj);
            };
        }
    }, inter);
    [ "timeZones", "countries", "territories", "regions", "languages", "currencies", "scripts" ].forEach(function(pluralName) {
        var singularName = pluralName.replace(/(ie)?s$/, function($0, ending) {
            return ending ? "y" : "";
        }), capitalizedSingularName = singularName.replace(/[a-z]/, function($0) {
            return $0.toUpperCase();
        });
        this["get" + capitalizedSingularName] = function(id) {
            if (!this.hasOwnProperty(singularName + "byId")) {
                if (!this[pluralName]) {
                    throw new Error("inter.get" + capitalizedSingularName + ": The library was compiled without --" + pluralName.toLowerCase());
                }
                var byId = this[singularName + "byId"] = {};
                this[pluralName].forEach(function(obj) {
                    byId[obj.id] = obj;
                });
            }
            return this[singularName + "byId"][id];
        };
    }, inter);
    if ("nb" === "en_us") {
        inter.id = "en_us";
        inter.delimiters = {
            quotationStart: "“",
            quotationEnd: "”",
            alternateQuotationStart: "‘",
            alternateQuotationEnd: "’"
        };
        inter.numbers = {
            latn: {
                symbols: {
                    decimal: ".",
                    group: ",",
                    list: ";",
                    percentSign: "%",
                    plusSign: "+",
                    minusSign: "-",
                    exponential: "E",
                    perMille: "‰",
                    infinity: "∞",
                    nan: "NaN"
                },
                formats: {
                    scientific: {
                        "default": "#E0"
                    },
                    decimal: {
                        "long": {
                            1e3: {
                                one: "0 thousand",
                                other: "0 thousand"
                            },
                            1e4: {
                                one: "00 thousand",
                                other: "00 thousand"
                            },
                            1e5: {
                                one: "000 thousand",
                                other: "000 thousand"
                            },
                            1e6: {
                                one: "0 million",
                                other: "0 million"
                            },
                            1e7: {
                                one: "00 million",
                                other: "00 million"
                            },
                            1e8: {
                                one: "000 million",
                                other: "000 million"
                            },
                            1e9: {
                                one: "0 billion",
                                other: "0 billion"
                            },
                            1e10: {
                                one: "00 billion",
                                other: "00 billion"
                            },
                            1e11: {
                                one: "000 billion",
                                other: "000 billion"
                            },
                            1e12: {
                                one: "0 trillion",
                                other: "0 trillion"
                            },
                            1e13: {
                                one: "00 trillion",
                                other: "00 trillion"
                            },
                            1e14: {
                                one: "000 trillion",
                                other: "000 trillion"
                            }
                        },
                        "short": {
                            1e3: {
                                one: "0K",
                                other: "0K"
                            },
                            1e4: {
                                one: "00K",
                                other: "00K"
                            },
                            1e5: {
                                one: "000K",
                                other: "000K"
                            },
                            1e6: {
                                one: "0M",
                                other: "0M"
                            },
                            1e7: {
                                one: "00M",
                                other: "00M"
                            },
                            1e8: {
                                one: "000M",
                                other: "000M"
                            },
                            1e9: {
                                one: "0B",
                                other: "0B"
                            },
                            1e10: {
                                one: "00B",
                                other: "00B"
                            },
                            1e11: {
                                one: "000B",
                                other: "000B"
                            },
                            1e12: {
                                one: "0T",
                                other: "0T"
                            },
                            1e13: {
                                one: "00T",
                                other: "00T"
                            },
                            1e14: {
                                one: "000T",
                                other: "000T"
                            }
                        },
                        "default": "#,##0.###"
                    },
                    currency: {
                        "default": "¤#,##0.00;(¤#,##0.00)",
                        one: "{0} {1}",
                        other: "{0} {1}"
                    },
                    percent: {
                        "default": "#,##0%"
                    }
                },
                digits: [ "0", "1", "2", "3", "4", "5", "6", "7", "8", "9" ]
            }
        };
        inter.defaultNumberSystemId = "latn";
        inter.calendars = {
            gregorian: {
                dateFormats: {
                    basic: {
                        fullDate: "EEEE, MMMM d, y",
                        longDate: "MMMM d, y",
                        mediumDate: "MMM d, y",
                        shortDate: "M/d/yy",
                        fullTime: "h:mm:ss a zzzz",
                        longTime: "h:mm:ss a z",
                        mediumTime: "h:mm:ss a",
                        shortTime: "h:mm a",
                        shortDateTime: "M/d/yy, h:mm a",
                        mediumDateTime: "MMM d, y, h:mm:ss a",
                        longDateTime: "MMMM d, y 'at' h:mm:ss a z",
                        fullDateTime: "EEEE, MMMM d, y 'at' h:mm:ss a zzzz"
                    },
                    cldr: {
                        d: "d",
                        Ed: "d E",
                        Ehm: "E h:mm a",
                        EHm: "E HH:mm",
                        Ehms: "E h:mm:ss a",
                        EHms: "E HH:mm:ss",
                        Gy: "y G",
                        hm: "h:mm a",
                        Hm: "HH:mm",
                        hms: "h:mm:ss a",
                        Hms: "HH:mm:ss",
                        M: "L",
                        Md: "M/d",
                        MEd: "E, M/d",
                        MMM: "LLL",
                        MMMd: "MMM d",
                        MMMEd: "E, MMM d",
                        ms: "mm:ss",
                        y: "y",
                        yM: "M/y",
                        yMd: "M/d/y",
                        yMEd: "E, M/d/y",
                        yMMM: "MMM y",
                        yMMMd: "MMM d, y",
                        yMMMEd: "E, MMM d, y",
                        yQQQ: "QQQ y",
                        yQQQQ: "QQQQ y",
                        h: "h a",
                        H: "HH"
                    }
                },
                defaultDateTimePattern: "{1}, {0}",
                datePartsOrder: "mdy",
                dayNames: {
                    format: {
                        abbreviated: [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ],
                        narrow: [ "S", "M", "T", "W", "T", "F", "S" ],
                        wide: [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ],
                        "short": [ "Su", "Mo", "Tu", "We", "Th", "Fr", "Sa" ]
                    },
                    standAlone: {
                        abbreviated: [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ],
                        narrow: [ "S", "M", "T", "W", "T", "F", "S" ],
                        wide: [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ],
                        "short": [ "Su", "Mo", "Tu", "We", "Th", "Fr", "Sa" ]
                    }
                },
                dayPeriods: {
                    format: {
                        abbreviated: {
                            am: "AM",
                            noon: "noon",
                            pm: "PM"
                        },
                        narrow: {
                            am: "a",
                            noon: "n",
                            pm: "p"
                        },
                        wide: {
                            am: "AM",
                            noon: "noon",
                            pm: "PM"
                        }
                    },
                    standAlone: {
                        abbreviated: {
                            am: "AM",
                            noon: "noon",
                            pm: "PM"
                        },
                        narrow: {
                            am: "a",
                            noon: "n",
                            pm: "p"
                        },
                        wide: {
                            am: "AM",
                            noon: "noon",
                            pm: "PM"
                        }
                    }
                },
                monthNames: {
                    format: {
                        abbreviated: [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ]
                    },
                    standAlone: {
                        abbreviated: [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ]
                    }
                },
                eraNames: {
                    wide: [ "Before Christ", "Anno Domini" ],
                    abbreviated: [ "BC", "AD" ]
                },
                quarterNames: {
                    format: {
                        abbreviated: [ "Q1", "Q2", "Q3", "Q4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1st quarter", "2nd quarter", "3rd quarter", "4th quarter" ]
                    },
                    standAlone: {
                        abbreviated: [ "Q1", "Q2", "Q3", "Q4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1st quarter", "2nd quarter", "3rd quarter", "4th quarter" ]
                    }
                }
            }
        };
        inter.pluralRule = function(n) {
            if (n === 1) return "one";
            return "other";
        };
        inter.languages = [ {
            id: "en_gb",
            displayName: "British English",
            nativeDisplayName: "British English"
        }, {
            id: "da",
            displayName: "Danish",
            nativeDisplayName: "dansk"
        }, {
            id: "de",
            displayName: "German",
            nativeDisplayName: "Deutsch"
        }, {
            id: "es",
            displayName: "Spanish",
            nativeDisplayName: "español"
        }, {
            id: "fr",
            displayName: "French",
            nativeDisplayName: "français"
        }, {
            id: "it",
            displayName: "Italian",
            nativeDisplayName: "italiano"
        }, {
            id: "nl",
            displayName: "Dutch",
            nativeDisplayName: "Nederlands"
        }, {
            id: "nb",
            displayName: "Norwegian Bokmål",
            nativeDisplayName: "norsk bokmål"
        }, {
            id: "pt",
            displayName: "Portuguese",
            nativeDisplayName: "português"
        }, {
            id: "sv",
            displayName: "Swedish",
            nativeDisplayName: "svenska"
        }, {
            id: "en_us",
            displayName: "U.S. English",
            nativeDisplayName: "U.S. English"
        } ];
    }
    if ("nb" === "en_gb") {
        inter.id = "en_gb";
        inter.delimiters = {
            quotationStart: "“",
            quotationEnd: "”",
            alternateQuotationStart: "‘",
            alternateQuotationEnd: "’"
        };
        inter.numbers = {
            latn: {
                symbols: {
                    decimal: ".",
                    group: ",",
                    list: ";",
                    percentSign: "%",
                    plusSign: "+",
                    minusSign: "-",
                    exponential: "E",
                    perMille: "‰",
                    infinity: "∞",
                    nan: "NaN"
                },
                formats: {
                    scientific: {
                        "default": "#E0"
                    },
                    decimal: {
                        "long": {
                            1e3: {
                                one: "0 thousand",
                                other: "0 thousand"
                            },
                            1e4: {
                                one: "00 thousand",
                                other: "00 thousand"
                            },
                            1e5: {
                                one: "000 thousand",
                                other: "000 thousand"
                            },
                            1e6: {
                                one: "0 million",
                                other: "0 million"
                            },
                            1e7: {
                                one: "00 million",
                                other: "00 million"
                            },
                            1e8: {
                                one: "000 million",
                                other: "000 million"
                            },
                            1e9: {
                                one: "0 billion",
                                other: "0 billion"
                            },
                            1e10: {
                                one: "00 billion",
                                other: "00 billion"
                            },
                            1e11: {
                                one: "000 billion",
                                other: "000 billion"
                            },
                            1e12: {
                                one: "0 trillion",
                                other: "0 trillion"
                            },
                            1e13: {
                                one: "00 trillion",
                                other: "00 trillion"
                            },
                            1e14: {
                                one: "000 trillion",
                                other: "000 trillion"
                            }
                        },
                        "short": {
                            1e3: {
                                one: "0K",
                                other: "0K"
                            },
                            1e4: {
                                one: "00K",
                                other: "00K"
                            },
                            1e5: {
                                one: "000K",
                                other: "000K"
                            },
                            1e6: {
                                one: "0M",
                                other: "0M"
                            },
                            1e7: {
                                one: "00M",
                                other: "00M"
                            },
                            1e8: {
                                one: "000M",
                                other: "000M"
                            },
                            1e9: {
                                one: "0B",
                                other: "0B"
                            },
                            1e10: {
                                one: "00B",
                                other: "00B"
                            },
                            1e11: {
                                one: "000B",
                                other: "000B"
                            },
                            1e12: {
                                one: "0T",
                                other: "0T"
                            },
                            1e13: {
                                one: "00T",
                                other: "00T"
                            },
                            1e14: {
                                one: "000T",
                                other: "000T"
                            }
                        },
                        "default": "#,##0.###"
                    },
                    currency: {
                        "default": "¤#,##0.00",
                        one: "{0} {1}",
                        other: "{0} {1}"
                    },
                    percent: {
                        "default": "#,##0%"
                    }
                },
                digits: [ "0", "1", "2", "3", "4", "5", "6", "7", "8", "9" ]
            }
        };
        inter.defaultNumberSystemId = "latn";
        inter.calendars = {
            gregorian: {
                dateFormats: {
                    basic: {
                        fullDate: "EEEE, d MMMM y",
                        longDate: "d MMMM y",
                        mediumDate: "d MMM y",
                        shortDate: "dd/MM/yyyy",
                        fullTime: "HH:mm:ss zzzz",
                        longTime: "HH:mm:ss z",
                        mediumTime: "HH:mm:ss",
                        shortTime: "HH:mm",
                        shortDateTime: "dd/MM/yyyy HH:mm",
                        mediumDateTime: "d MMM y HH:mm:ss",
                        longDateTime: "d MMMM y HH:mm:ss z",
                        fullDateTime: "EEEE, d MMMM y HH:mm:ss zzzz"
                    },
                    cldr: {
                        d: "d",
                        Ed: "E d",
                        Ehm: "E h:mm a",
                        EHm: "E HH:mm",
                        Ehms: "E h:mm:ss a",
                        EHms: "E HH:mm:ss",
                        h: "h a",
                        H: "HH",
                        hm: "h:mm a",
                        Hm: "HH:mm",
                        hms: "h:mm:ss a",
                        Hms: "HH:mm:ss",
                        M: "LL",
                        Md: "dd/MM",
                        MEd: "E dd/MM",
                        MMdd: "dd/MM",
                        MMM: "LLL",
                        MMMd: "d MMM",
                        MMMEd: "E d MMM",
                        MMMMd: "d MMMM",
                        ms: "mm:ss",
                        y: "y",
                        yM: "MM/y",
                        yMd: "dd/MM/yyyy",
                        yMEd: "E, dd/MM/yyyy",
                        yMMM: "MMM y",
                        yMMMd: "d MMM y",
                        yMMMEd: "E, d MMM y",
                        yQQQ: "QQQ y",
                        yQQQQ: "QQQQ y",
                        yyMMM: "MMM yy",
                        yyyyMM: "MM/yyyy",
                        yyyyMMMM: "MMMM y",
                        Gy: "y G"
                    }
                },
                defaultDateTimePattern: "{1} {0}",
                datePartsOrder: "dmy",
                dayNames: {
                    format: {
                        abbreviated: [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ],
                        narrow: [ "S", "M", "T", "W", "T", "F", "S" ],
                        wide: [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ],
                        "short": [ "Su", "Mo", "Tu", "We", "Th", "Fr", "Sa" ]
                    },
                    standAlone: {
                        abbreviated: [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ],
                        narrow: [ "S", "M", "T", "W", "T", "F", "S" ],
                        wide: [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ],
                        "short": [ "Su", "Mo", "Tu", "We", "Th", "Fr", "Sa" ]
                    }
                },
                dayPeriods: {
                    format: {
                        abbreviated: {
                            am: "am",
                            pm: "pm",
                            noon: "noon"
                        },
                        narrow: {
                            am: "a",
                            noon: "n",
                            pm: "p"
                        },
                        wide: {
                            am: "am",
                            pm: "pm",
                            noon: "noon"
                        }
                    },
                    standAlone: {
                        abbreviated: {
                            am: "am",
                            pm: "pm",
                            noon: "noon"
                        },
                        narrow: {
                            am: "a",
                            noon: "n",
                            pm: "p"
                        },
                        wide: {
                            am: "am",
                            pm: "pm",
                            noon: "noon"
                        }
                    }
                },
                monthNames: {
                    format: {
                        abbreviated: [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ]
                    },
                    standAlone: {
                        abbreviated: [ "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" ]
                    }
                },
                eraNames: {
                    wide: [ "Before Christ", "Anno Domini" ],
                    abbreviated: [ "BC", "AD" ]
                },
                quarterNames: {
                    format: {
                        abbreviated: [ "Q1", "Q2", "Q3", "Q4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1st quarter", "2nd quarter", "3rd quarter", "4th quarter" ]
                    },
                    standAlone: {
                        abbreviated: [ "Q1", "Q2", "Q3", "Q4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1st quarter", "2nd quarter", "3rd quarter", "4th quarter" ]
                    }
                }
            }
        };
        inter.pluralRule = function(n) {
            if (n === 1) return "one";
            return "other";
        };
        inter.languages = [ {
            id: "en_gb",
            displayName: "British English",
            nativeDisplayName: "British English"
        }, {
            id: "da",
            displayName: "Danish",
            nativeDisplayName: "dansk"
        }, {
            id: "de",
            displayName: "German",
            nativeDisplayName: "Deutsch"
        }, {
            id: "es",
            displayName: "Spanish",
            nativeDisplayName: "español"
        }, {
            id: "fr",
            displayName: "French",
            nativeDisplayName: "français"
        }, {
            id: "it",
            displayName: "Italian",
            nativeDisplayName: "italiano"
        }, {
            id: "nl",
            displayName: "Dutch",
            nativeDisplayName: "Nederlands"
        }, {
            id: "nb",
            displayName: "Norwegian Bokmål",
            nativeDisplayName: "norsk bokmål"
        }, {
            id: "pt",
            displayName: "Portuguese",
            nativeDisplayName: "português"
        }, {
            id: "sv",
            displayName: "Swedish",
            nativeDisplayName: "svenska"
        }, {
            id: "en_us",
            displayName: "US English",
            nativeDisplayName: "U.S. English"
        } ];
    }
    if ("nb" === "da") {
        inter.id = "da";
        inter.delimiters = {
            quotationStart: "“",
            quotationEnd: "”",
            alternateQuotationStart: "‘",
            alternateQuotationEnd: "’"
        };
        inter.numbers = {
            latn: {
                symbols: {
                    decimal: ",",
                    group: ".",
                    list: ",",
                    percentSign: "%",
                    plusSign: "+",
                    minusSign: "-",
                    exponential: "E",
                    perMille: "‰",
                    infinity: "∞",
                    nan: "NaN"
                },
                formats: {
                    scientific: {
                        "default": "#E0"
                    },
                    decimal: {
                        "long": {
                            1e3: {
                                one: "0 tusind",
                                other: "0 tusind"
                            },
                            1e4: {
                                one: "00 tusind",
                                other: "00 tusind"
                            },
                            1e5: {
                                one: "000 tusind",
                                other: "000 tusind"
                            },
                            1e6: {
                                one: "0 million",
                                other: "0 millioner"
                            },
                            1e7: {
                                one: "00 millioner",
                                other: "00 millioner"
                            },
                            1e8: {
                                one: "000 millioner",
                                other: "000 millioner"
                            },
                            1e9: {
                                one: "0 milliard",
                                other: "0 milliarder"
                            },
                            1e10: {
                                one: "00 milliarder",
                                other: "00 milliarder"
                            },
                            1e11: {
                                one: "000 milliarder",
                                other: "000 milliarder"
                            },
                            1e12: {
                                one: "0 billion",
                                other: "0 billioner"
                            },
                            1e13: {
                                one: "00 billioner",
                                other: "00 billioner"
                            },
                            1e14: {
                                one: "000 billioner",
                                other: "000 billioner"
                            }
                        },
                        "short": {
                            1e3: {
                                one: "0",
                                other: "0"
                            },
                            1e4: {
                                one: "0",
                                other: "0"
                            },
                            1e5: {
                                one: "0",
                                other: "0"
                            },
                            1e6: {
                                one: "0 mio",
                                other: "0 mio"
                            },
                            1e7: {
                                one: "00 mio",
                                other: "00 mio"
                            },
                            1e8: {
                                one: "000 mio",
                                other: "000 mio"
                            },
                            1e9: {
                                one: "0 mia",
                                other: "0 mia"
                            },
                            1e10: {
                                one: "00 mia",
                                other: "00 mia"
                            },
                            1e11: {
                                one: "000 mia",
                                other: "000 mia"
                            },
                            1e12: {
                                one: "0 bill",
                                other: "0 bill"
                            },
                            1e13: {
                                one: "00 bill",
                                other: "00 bill"
                            },
                            1e14: {
                                one: "000 bill",
                                other: "000 bill"
                            }
                        },
                        "default": "#,##0.###"
                    },
                    currency: {
                        "default": "#,##0.00 ¤",
                        one: "{0} {1}",
                        other: "{0} {1}"
                    },
                    percent: {
                        "default": "#,##0 %"
                    }
                },
                digits: [ "0", "1", "2", "3", "4", "5", "6", "7", "8", "9" ]
            }
        };
        inter.defaultNumberSystemId = "latn";
        inter.calendars = {
            gregorian: {
                dateFormats: {
                    basic: {
                        fullDate: "EEEE 'den' d. MMMM y",
                        longDate: "d. MMM y",
                        mediumDate: "dd/MM/yyyy",
                        shortDate: "dd/MM/yy",
                        fullTime: "HH.mm.ss zzzz",
                        longTime: "HH.mm.ss z",
                        mediumTime: "HH.mm.ss",
                        shortTime: "HH.mm",
                        shortDateTime: "dd/MM/yy HH.mm",
                        mediumDateTime: "dd/MM/yyyy HH.mm.ss",
                        longDateTime: "d. MMM y HH.mm.ss z",
                        fullDateTime: "EEEE 'den' d. MMMM y HH.mm.ss zzzz"
                    },
                    cldr: {
                        d: "d.",
                        Ed: "E 'd'. d.",
                        h: "h a",
                        H: "HH",
                        hm: "h.mm a",
                        Hm: "HH.mm",
                        hms: "h.mm.ss a",
                        Hms: "HH.mm.ss",
                        M: "M",
                        Md: "d/M",
                        MEd: "E d/M",
                        MMdd: "dd/MM",
                        MMM: "MMM",
                        MMMd: "d. MMM",
                        MMMEd: "E d. MMM",
                        MMMMEd: "E d. MMMM",
                        ms: "mm.ss",
                        y: "y",
                        yM: "M/y",
                        yMd: "d/M/y",
                        yMEd: "E d/M/y",
                        yMMM: "MMM y",
                        yMMMd: "d. MMM y",
                        yMMMEd: "E d. MMM y",
                        yQQQ: "QQQ y",
                        yQQQQ: "QQQQ y",
                        yyMM: "MM/yy",
                        yyMMM: "MMM yy",
                        yyyy: "y",
                        yyyyMM: "MM/yyyy",
                        yyyyMMM: "MMM y"
                    }
                },
                defaultDateTimePattern: "{1} {0}",
                datePartsOrder: "dmy",
                dayNames: {
                    format: {
                        abbreviated: [ "søn.", "man.", "tir.", "ons.", "tor.", "fre.", "lør." ],
                        narrow: [ "S", "M", "T", "O", "T", "F", "L" ],
                        wide: [ "søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag" ],
                        "short": [ "sø", "ma", "ti", "on", "to", "fr", "lø" ]
                    },
                    standAlone: {
                        abbreviated: [ "søn", "man", "tir", "ons", "tor", "fre", "lør" ],
                        narrow: [ "S", "M", "T", "O", "T", "F", "L" ],
                        wide: [ "søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag" ],
                        "short": [ "sø", "ma", "ti", "on", "to", "fr", "lø" ]
                    }
                },
                dayPeriods: {
                    format: {
                        abbreviated: {
                            noon: "middag",
                            am: "AM",
                            pm: "PM"
                        },
                        narrow: {
                            noon: "middag",
                            am: "AM",
                            pm: "PM"
                        },
                        wide: {
                            am: "AM",
                            noon: "middag",
                            pm: "PM"
                        }
                    },
                    standAlone: {
                        abbreviated: {
                            noon: "middag",
                            am: "AM",
                            pm: "PM"
                        },
                        narrow: {
                            noon: "middag",
                            am: "AM",
                            pm: "PM"
                        },
                        wide: {
                            am: "formiddag",
                            pm: "eftermiddag",
                            noon: "middag"
                        }
                    }
                },
                monthNames: {
                    format: {
                        abbreviated: [ "jan.", "feb.", "mar.", "apr.", "maj", "jun.", "jul.", "aug.", "sep.", "okt.", "nov.", "dec." ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "januar", "februar", "marts", "april", "maj", "juni", "juli", "august", "september", "oktober", "november", "december" ]
                    },
                    standAlone: {
                        abbreviated: [ "jan", "feb", "mar", "apr", "maj", "jun", "jul", "aug", "sep", "okt", "nov", "dec" ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "januar", "februar", "marts", "april", "maj", "juni", "juli", "august", "september", "oktober", "november", "december" ]
                    }
                },
                eraNames: {
                    wide: [ "f.Kr.", "e.Kr." ],
                    abbreviated: [ "f.Kr.", "e.Kr." ]
                },
                quarterNames: {
                    format: {
                        abbreviated: [ "K1", "K2", "K3", "K4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1. kvartal", "2. kvartal", "3. kvartal", "4. kvartal" ]
                    },
                    standAlone: {
                        abbreviated: [ "K1", "K2", "K3", "K4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1. kvartal", "2. kvartal", "3. kvartal", "4. kvartal" ]
                    }
                }
            }
        };
        inter.pluralRule = function(n) {
            if (n === 1) return "one";
            return "other";
        };
        inter.languages = [ {
            id: "en_gb",
            displayName: "britisk engelsk",
            nativeDisplayName: "British English"
        }, {
            id: "da",
            displayName: "dansk",
            nativeDisplayName: "dansk"
        }, {
            id: "de",
            displayName: "tysk",
            nativeDisplayName: "Deutsch"
        }, {
            id: "es",
            displayName: "spansk",
            nativeDisplayName: "español"
        }, {
            id: "fr",
            displayName: "fransk",
            nativeDisplayName: "français"
        }, {
            id: "it",
            displayName: "italiensk",
            nativeDisplayName: "italiano"
        }, {
            id: "nl",
            displayName: "hollandsk",
            nativeDisplayName: "Nederlands"
        }, {
            id: "nb",
            displayName: "norsk bokmål",
            nativeDisplayName: "norsk bokmål"
        }, {
            id: "pt",
            displayName: "portugisisk",
            nativeDisplayName: "português"
        }, {
            id: "sv",
            displayName: "svensk",
            nativeDisplayName: "svenska"
        }, {
            id: "en_us",
            displayName: "amerikansk engelsk",
            nativeDisplayName: "U.S. English"
        } ];
    }
    if ("nb" === "de") {
        inter.id = "de";
        inter.delimiters = {
            quotationStart: "„",
            quotationEnd: "“",
            alternateQuotationStart: "‚",
            alternateQuotationEnd: "‘"
        };
        inter.numbers = {
            latn: {
                symbols: {
                    decimal: ",",
                    group: ".",
                    list: ";",
                    percentSign: "%",
                    plusSign: "+",
                    minusSign: "-",
                    exponential: "E",
                    perMille: "‰",
                    infinity: "∞",
                    nan: "NaN"
                },
                formats: {
                    scientific: {
                        "default": "#E0"
                    },
                    decimal: {
                        "long": {
                            1e3: {
                                one: "0 Tausend",
                                other: "0 Tausend"
                            },
                            1e4: {
                                one: "00 Tausend",
                                other: "00 Tausend"
                            },
                            1e5: {
                                one: "000 Tausend",
                                other: "000 Tausend"
                            },
                            1e6: {
                                one: "0 Million",
                                other: "0 Millionen"
                            },
                            1e7: {
                                one: "00 Millionen",
                                other: "00 Millionen"
                            },
                            1e8: {
                                one: "000 Millionen",
                                other: "000 Millionen"
                            },
                            1e9: {
                                one: "0 Milliarde",
                                other: "0 Milliarden"
                            },
                            1e10: {
                                one: "00 Milliarden",
                                other: "00 Milliarden"
                            },
                            1e11: {
                                one: "000 Milliarden",
                                other: "000 Milliarden"
                            },
                            1e12: {
                                one: "0 Billion",
                                other: "0 Billionen"
                            },
                            1e13: {
                                one: "00 Billionen",
                                other: "00 Billionen"
                            },
                            1e14: {
                                one: "000 Billionen",
                                other: "000 Billionen"
                            }
                        },
                        "short": {
                            1e3: {
                                one: "0",
                                other: "0"
                            },
                            1e4: {
                                one: "0",
                                other: "0"
                            },
                            1e5: {
                                one: "0",
                                other: "0"
                            },
                            1e6: {
                                one: "0 Mio",
                                other: "0 Mio"
                            },
                            1e7: {
                                one: "00 Mio",
                                other: "00 Mio"
                            },
                            1e8: {
                                one: "000 Mio",
                                other: "000 Mio"
                            },
                            1e9: {
                                one: "0 Mrd",
                                other: "0 Mrd"
                            },
                            1e10: {
                                one: "00 Mrd",
                                other: "00 Mrd"
                            },
                            1e11: {
                                one: "000 Mrd",
                                other: "000 Mrd"
                            },
                            1e12: {
                                one: "0 Bio",
                                other: "0 Bio"
                            },
                            1e13: {
                                one: "00 Bio",
                                other: "00 Bio"
                            },
                            1e14: {
                                one: "000 Bio",
                                other: "000 Bio"
                            }
                        },
                        "default": "#,##0.###"
                    },
                    currency: {
                        "default": "#,##0.00 ¤",
                        one: "{0} {1}",
                        other: "{0} {1}"
                    },
                    percent: {
                        "default": "#,##0 %"
                    }
                },
                digits: [ "0", "1", "2", "3", "4", "5", "6", "7", "8", "9" ]
            }
        };
        inter.defaultNumberSystemId = "latn";
        inter.calendars = {
            gregorian: {
                dateFormats: {
                    basic: {
                        fullDate: "EEEE, d. MMMM y",
                        longDate: "d. MMMM y",
                        mediumDate: "dd.MM.yyyy",
                        shortDate: "dd.MM.yy",
                        fullTime: "HH:mm:ss zzzz",
                        longTime: "HH:mm:ss z",
                        mediumTime: "HH:mm:ss",
                        shortTime: "HH:mm",
                        shortDateTime: "dd.MM.yy HH:mm",
                        mediumDateTime: "dd.MM.yyyy HH:mm:ss",
                        longDateTime: "d. MMMM y HH:mm:ss z",
                        fullDateTime: "EEEE, d. MMMM y HH:mm:ss zzzz"
                    },
                    cldr: {
                        d: "d",
                        Ed: "E, d.",
                        h: "h a",
                        H: "HH 'Uhr'",
                        hm: "h:mm a",
                        Hm: "HH:mm",
                        hms: "h:mm:ss a",
                        Hms: "HH:mm:ss",
                        M: "L",
                        Md: "d.M.",
                        MEd: "E, d.M.",
                        MMd: "d.MM.",
                        MMdd: "dd.MM.",
                        MMM: "LLL",
                        MMMd: "d. MMM",
                        MMMEd: "E, d. MMM",
                        MMMMdd: "dd. MMMM",
                        MMMMEd: "E, d. MMMM",
                        ms: "mm:ss",
                        y: "y",
                        yM: "M.y",
                        yMd: "d.M.y",
                        yMEd: "E, d.M.y",
                        yMMM: "MMM y",
                        yMMMd: "d. MMM y",
                        yMMMEd: "E, d. MMM y",
                        yQQQ: "QQQ y",
                        yQQQQ: "QQQQ y",
                        yyMM: "MM.yy",
                        yyMMdd: "dd.MM.yy",
                        yyMMM: "MMM yy",
                        yyQQQ: "QQQ yy",
                        yyQQQQ: "QQQQ yy",
                        yyyy: "y",
                        yyyyMMMM: "MMMM y"
                    }
                },
                defaultDateTimePattern: "{1} {0}",
                datePartsOrder: "dmy",
                dayNames: {
                    format: {
                        abbreviated: [ "So.", "Mo.", "Di.", "Mi.", "Do.", "Fr.", "Sa." ],
                        narrow: [ "S", "M", "D", "M", "D", "F", "S" ],
                        wide: [ "Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag" ],
                        "short": [ "So.", "Mo.", "Di.", "Mi.", "Do.", "Fr.", "Sa." ]
                    },
                    standAlone: {
                        abbreviated: [ "So", "Mo", "Di", "Mi", "Do", "Fr", "Sa" ],
                        narrow: [ "S", "M", "D", "M", "D", "F", "S" ],
                        wide: [ "Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag" ],
                        "short": [ "So.", "Mo.", "Di.", "Mi.", "Do.", "Fr.", "Sa." ]
                    }
                },
                dayPeriods: {
                    format: {
                        abbreviated: {
                            afternoon: "nachmittags",
                            am: "vorm.",
                            earlyMorning: "morgens",
                            evening: "abends",
                            morning: "vormittags",
                            night: "nachts",
                            noon: "Mittag",
                            pm: "nachm."
                        },
                        narrow: {
                            afternoon: "nachmittags",
                            am: "vorm.",
                            earlyMorning: "morgens",
                            evening: "abends",
                            morning: "vormittags",
                            night: "nachts",
                            noon: "Mittag",
                            pm: "nachm."
                        },
                        wide: {
                            afternoon: "nachmittags",
                            am: "vorm.",
                            earlyMorning: "morgens",
                            evening: "abends",
                            morning: "vormittags",
                            night: "nachts",
                            noon: "Mittag",
                            pm: "nachm."
                        }
                    },
                    standAlone: {
                        abbreviated: {
                            afternoon: "nachmittags",
                            am: "vorm.",
                            earlyMorning: "morgens",
                            evening: "abends",
                            morning: "vormittags",
                            night: "nachts",
                            noon: "Mittag",
                            pm: "nachm."
                        },
                        narrow: {
                            afternoon: "nachmittags",
                            am: "vorm.",
                            earlyMorning: "morgens",
                            evening: "abends",
                            morning: "vormittags",
                            night: "nachts",
                            noon: "Mittag",
                            pm: "nachm."
                        },
                        wide: {
                            afternoon: "Nachmittag",
                            earlyMorning: "Morgen",
                            evening: "Abend",
                            morning: "Vormittag",
                            night: "Nacht",
                            noon: "Mittag",
                            am: "vorm.",
                            pm: "nachm."
                        }
                    }
                },
                monthNames: {
                    format: {
                        abbreviated: [ "Jan.", "Feb.", "Mär.", "Apr.", "Mai", "Juni", "Juli", "Aug.", "Sep.", "Okt.", "Nov.", "Dez." ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember" ]
                    },
                    standAlone: {
                        abbreviated: [ "Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez" ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember" ]
                    }
                },
                eraNames: {
                    wide: [ "v. Chr.", "n. Chr." ],
                    abbreviated: [ "v. Chr.", "n. Chr." ]
                },
                quarterNames: {
                    format: {
                        abbreviated: [ "Q1", "Q2", "Q3", "Q4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1. Quartal", "2. Quartal", "3. Quartal", "4. Quartal" ]
                    },
                    standAlone: {
                        abbreviated: [ "Q1", "Q2", "Q3", "Q4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1. Quartal", "2. Quartal", "3. Quartal", "4. Quartal" ]
                    }
                }
            }
        };
        inter.pluralRule = function(n) {
            if (n === 1) return "one";
            return "other";
        };
        inter.languages = [ {
            id: "en_gb",
            displayName: "Britisches Englisch",
            nativeDisplayName: "British English"
        }, {
            id: "da",
            displayName: "Dänisch",
            nativeDisplayName: "dansk"
        }, {
            id: "de",
            displayName: "Deutsch",
            nativeDisplayName: "Deutsch"
        }, {
            id: "es",
            displayName: "Spanisch",
            nativeDisplayName: "español"
        }, {
            id: "fr",
            displayName: "Französisch",
            nativeDisplayName: "français"
        }, {
            id: "it",
            displayName: "Italienisch",
            nativeDisplayName: "italiano"
        }, {
            id: "nl",
            displayName: "Niederländisch",
            nativeDisplayName: "Nederlands"
        }, {
            id: "nb",
            displayName: "Norwegisch Bokmål",
            nativeDisplayName: "norsk bokmål"
        }, {
            id: "pt",
            displayName: "Portugiesisch",
            nativeDisplayName: "português"
        }, {
            id: "sv",
            displayName: "Schwedisch",
            nativeDisplayName: "svenska"
        }, {
            id: "en_us",
            displayName: "Amerikanisches Englisch",
            nativeDisplayName: "U.S. English"
        } ];
    }
    if ("nb" === "sv") {
        inter.id = "sv";
        inter.delimiters = {
            quotationStart: "”",
            quotationEnd: "”",
            alternateQuotationStart: "’",
            alternateQuotationEnd: "’"
        };
        inter.numbers = {
            latn: {
                symbols: {
                    decimal: ",",
                    group: " ",
                    list: ";",
                    percentSign: "%",
                    plusSign: "+",
                    minusSign: "−",
                    exponential: "×10^",
                    perMille: "‰",
                    infinity: "∞",
                    nan: "¤¤¤",
                    currencyDecimal: ":",
                    currencyGroup: "."
                },
                formats: {
                    scientific: {
                        "default": "#E0"
                    },
                    decimal: {
                        "long": {
                            1e3: {
                                one: "0 tusen",
                                other: "0 tusen"
                            },
                            1e4: {
                                one: "00 tusen",
                                other: "00 tusen"
                            },
                            1e5: {
                                one: "000 tusen",
                                other: "000 tusen"
                            },
                            1e6: {
                                one: "0 miljon",
                                other: "0 miljoner"
                            },
                            1e7: {
                                one: "00 miljon",
                                other: "00 miljoner"
                            },
                            1e8: {
                                one: "000 miljon",
                                other: "000 miljoner"
                            },
                            1e9: {
                                one: "0 miljard",
                                other: "0 miljarder"
                            },
                            1e10: {
                                one: "00 miljard",
                                other: "00 miljarder"
                            },
                            1e11: {
                                one: "000 miljard",
                                other: "000 miljarder"
                            },
                            1e12: {
                                one: "0 biljon",
                                other: "0 biljoner"
                            },
                            1e13: {
                                one: "00 biljon",
                                other: "00 biljoner"
                            },
                            1e14: {
                                one: "000 biljon",
                                other: "000 biljoner"
                            }
                        },
                        "short": {
                            1e3: {
                                one: "0 tn",
                                other: "0 tn"
                            },
                            1e4: {
                                one: "00 tn",
                                other: "00 tn"
                            },
                            1e5: {
                                one: "000 tn",
                                other: "000 tn"
                            },
                            1e6: {
                                one: "0 mn",
                                other: "0 mn"
                            },
                            1e7: {
                                one: "00 mn",
                                other: "00 mn"
                            },
                            1e8: {
                                one: "000 mn",
                                other: "000 mn"
                            },
                            1e9: {
                                one: "0 md",
                                other: "0 md"
                            },
                            1e10: {
                                one: "00 md",
                                other: "00 md"
                            },
                            1e11: {
                                one: "000 md",
                                other: "000 md"
                            },
                            1e12: {
                                one: "0 bn",
                                other: "0 bn"
                            },
                            1e13: {
                                one: "00 bn",
                                other: "00 bn"
                            },
                            1e14: {
                                one: "000 bn",
                                other: "000 bn"
                            }
                        },
                        "default": "#,##0.###"
                    },
                    currency: {
                        "default": "#,##0.00 ¤",
                        one: "{0} {1}",
                        other: "{0} {1}"
                    },
                    percent: {
                        "default": "#,##0 %"
                    }
                },
                digits: [ "0", "1", "2", "3", "4", "5", "6", "7", "8", "9" ]
            }
        };
        inter.defaultNumberSystemId = "latn";
        inter.calendars = {
            gregorian: {
                dateFormats: {
                    basic: {
                        fullDate: "EEEE'en' 'den' d:'e' MMMM y",
                        longDate: "d MMMM y",
                        mediumDate: "d MMM y",
                        shortDate: "yyyy-MM-dd",
                        fullTime: "'kl'. HH:mm:ss zzzz",
                        longTime: "HH:mm:ss z",
                        mediumTime: "HH:mm:ss",
                        shortTime: "HH:mm",
                        shortDateTime: "yyyy-MM-dd HH:mm",
                        mediumDateTime: "d MMM y HH:mm:ss",
                        longDateTime: "d MMMM y HH:mm:ss z",
                        fullDateTime: "EEEE'en' 'den' d:'e' MMMM y 'kl'. HH:mm:ss zzzz"
                    },
                    cldr: {
                        d: "d",
                        Ed: "E d",
                        h: "h a",
                        H: "HH",
                        hm: "h:mm a",
                        Hm: "HH:mm",
                        hms: "h:mm:ss a",
                        Hms: "HH:mm:ss",
                        M: "L",
                        Md: "d/M",
                        MEd: "E d/M",
                        MMd: "d/M",
                        MMdd: "dd/MM",
                        MMM: "LLL",
                        MMMd: "d MMM",
                        MMMEd: "E d MMM",
                        MMMMd: "d:'e' MMMM",
                        MMMMEd: "E d:'e' MMMM",
                        ms: "mm:ss",
                        y: "y",
                        yM: "yyyy-MM",
                        yMd: "yyyy-MM-dd",
                        yMEd: "E, yyyy-MM-dd",
                        yMMM: "MMM y",
                        yMMMd: "d MMM y",
                        yMMMEd: "E d MMM y",
                        yQQQ: "y QQQ",
                        yQQQQ: "y QQQQ",
                        yyMM: "yy-MM",
                        yyMMM: "MMM -yy",
                        yyQQQ: "QQQ yy",
                        yyyyMM: "yyyy-MM",
                        yyyyMMM: "MMM y",
                        yyyyQQQQ: "QQQQ y"
                    }
                },
                defaultDateTimePattern: "{1} {0}",
                datePartsOrder: "ymd",
                dayNames: {
                    format: {
                        abbreviated: [ "sön", "mån", "tis", "ons", "tors", "fre", "lör" ],
                        narrow: [ "S", "M", "T", "O", "T", "F", "L" ],
                        wide: [ "söndag", "måndag", "tisdag", "onsdag", "torsdag", "fredag", "lördag" ],
                        "short": [ "sö", "må", "ti", "on", "to", "fr", "lö" ]
                    },
                    standAlone: {
                        abbreviated: [ "sön", "mån", "tis", "ons", "tor", "fre", "lör" ],
                        narrow: [ "S", "M", "T", "O", "T", "F", "L" ],
                        wide: [ "söndag", "måndag", "tisdag", "onsdag", "torsdag", "fredag", "lördag" ],
                        "short": [ "sö", "må", "ti", "on", "to", "fr", "lö" ]
                    }
                },
                dayPeriods: {
                    format: {
                        abbreviated: {
                            am: "FM",
                            pm: "EM"
                        },
                        narrow: {
                            am: "f",
                            pm: "e"
                        },
                        wide: {
                            am: "fm",
                            pm: "em"
                        }
                    },
                    standAlone: {
                        abbreviated: {
                            am: "fm",
                            pm: "em"
                        },
                        narrow: {
                            am: "f.m.",
                            pm: "e.m."
                        },
                        wide: {
                            am: "förmiddag",
                            pm: "eftermiddag"
                        }
                    }
                },
                monthNames: {
                    format: {
                        abbreviated: [ "jan", "feb", "mar", "apr", "maj", "jun", "jul", "aug", "sep", "okt", "nov", "dec" ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "januari", "februari", "mars", "april", "maj", "juni", "juli", "augusti", "september", "oktober", "november", "december" ]
                    },
                    standAlone: {
                        abbreviated: [ "jan", "feb", "mar", "apr", "maj", "jun", "jul", "aug", "sep", "okt", "nov", "dec" ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "januari", "februari", "mars", "april", "maj", "juni", "juli", "augusti", "september", "oktober", "november", "december" ]
                    }
                },
                eraNames: {
                    wide: [ "före Kristus", "efter Kristus" ],
                    abbreviated: [ "f.Kr.", "e.Kr." ]
                },
                quarterNames: {
                    format: {
                        abbreviated: [ "K1", "K2", "K3", "K4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1:a kvartalet", "2:a kvartalet", "3:e kvartalet", "4:e kvartalet" ]
                    },
                    standAlone: {
                        abbreviated: [ "K1", "K2", "K3", "K4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1:a kvartalet", "2:a kvartalet", "3:e kvartalet", "4:e kvartalet" ]
                    }
                }
            }
        };
        inter.pluralRule = function(n) {
            if (n === 1) return "one";
            return "other";
        };
        inter.languages = [ {
            id: "en_gb",
            displayName: "brittisk engelska",
            nativeDisplayName: "British English"
        }, {
            id: "da",
            displayName: "danska",
            nativeDisplayName: "dansk"
        }, {
            id: "de",
            displayName: "tyska",
            nativeDisplayName: "Deutsch"
        }, {
            id: "es",
            displayName: "spanska",
            nativeDisplayName: "español"
        }, {
            id: "fr",
            displayName: "franska",
            nativeDisplayName: "français"
        }, {
            id: "it",
            displayName: "italienska",
            nativeDisplayName: "italiano"
        }, {
            id: "nl",
            displayName: "nederländska",
            nativeDisplayName: "Nederlands"
        }, {
            id: "nb",
            displayName: "norskt bokmål",
            nativeDisplayName: "norsk bokmål"
        }, {
            id: "pt",
            displayName: "portugisiska",
            nativeDisplayName: "português"
        }, {
            id: "sv",
            displayName: "svenska",
            nativeDisplayName: "svenska"
        }, {
            id: "en_us",
            displayName: "amerikansk engelska",
            nativeDisplayName: "U.S. English"
        } ];
    }
    if ("nb" === "nb") {
        inter.id = "nb";
        inter.delimiters = {
            quotationStart: "«",
            quotationEnd: "»",
            alternateQuotationStart: "‘",
            alternateQuotationEnd: "’"
        };
        inter.numbers = {
            latn: {
                symbols: {
                    decimal: ",",
                    group: " ",
                    list: ";",
                    percentSign: "%",
                    plusSign: "+",
                    minusSign: "-",
                    exponential: "E",
                    perMille: "‰",
                    infinity: "∞",
                    nan: "NaN"
                },
                formats: {
                    scientific: {
                        "default": "#E0"
                    },
                    decimal: {
                        "long": {
                            1e3: {
                                one: "0 tusen",
                                other: "0 tusen"
                            },
                            1e4: {
                                one: "00 tusen",
                                other: "00 tusen"
                            },
                            1e5: {
                                one: "000 tusen",
                                other: "000 tusen"
                            },
                            1e6: {
                                one: "0 million",
                                other: "0 millioner"
                            },
                            1e7: {
                                one: "00 million",
                                other: "00 millioner"
                            },
                            1e8: {
                                one: "000 million",
                                other: "000 millioner"
                            },
                            1e9: {
                                one: "0 milliard",
                                other: "0 milliarder"
                            },
                            1e10: {
                                one: "00 milliard",
                                other: "00 milliarder"
                            },
                            1e11: {
                                one: "000 milliard",
                                other: "000 milliarder"
                            },
                            1e12: {
                                one: "0 billion",
                                other: "0 billioner"
                            },
                            1e13: {
                                one: "00 billion",
                                other: "00 billioner"
                            },
                            1e14: {
                                one: "000 billion",
                                other: "000 billioner"
                            }
                        },
                        "short": {
                            1e3: {
                                one: "0",
                                other: "0"
                            },
                            1e4: {
                                one: "0",
                                other: "0"
                            },
                            1e5: {
                                one: "0",
                                other: "0"
                            },
                            1e6: {
                                one: "0 mill",
                                other: "0 mill"
                            },
                            1e7: {
                                one: "00 mill",
                                other: "00 mill"
                            },
                            1e8: {
                                one: "000 mill",
                                other: "000 mill"
                            },
                            1e9: {
                                one: "0 mrd",
                                other: "0 mrd"
                            },
                            1e10: {
                                one: "00 mrd",
                                other: "00 mrd"
                            },
                            1e11: {
                                one: "000 mrd",
                                other: "000 mrd"
                            },
                            1e12: {
                                one: "0 bill",
                                other: "0 bill"
                            },
                            1e13: {
                                one: "00 bill",
                                other: "00 bill"
                            },
                            1e14: {
                                one: "000 bill",
                                other: "000 bill"
                            }
                        },
                        "default": "#,##0.###"
                    },
                    currency: {
                        "default": "¤ #,##0.00",
                        one: "{0} {1}",
                        other: "{0} {1}"
                    },
                    percent: {
                        "default": "#,##0 %"
                    }
                },
                digits: [ "0", "1", "2", "3", "4", "5", "6", "7", "8", "9" ]
            }
        };
        inter.defaultNumberSystemId = "latn";
        inter.calendars = {
            gregorian: {
                dateFormats: {
                    basic: {
                        fullDate: "EEEE d. MMMM y",
                        longDate: "d. MMMM y",
                        mediumDate: "d. MMM y",
                        shortDate: "dd.MM.yy",
                        fullTime: "'kl'. HH:mm:ss zzzz",
                        longTime: "HH:mm:ss z",
                        mediumTime: "HH:mm:ss",
                        shortTime: "HH:mm",
                        shortDateTime: "HH:mm dd.MM.yy",
                        mediumDateTime: "HH:mm:ss d. MMM y",
                        longDateTime: "HH:mm:ss z d. MMMM y",
                        fullDateTime: "'kl'. HH:mm:ss zzzz EEEE d. MMMM y"
                    },
                    cldr: {
                        d: "d.",
                        Ed: "E d.",
                        h: "h a",
                        H: "HH",
                        hm: "h:mm a",
                        Hm: "HH:mm",
                        hms: "h:mm:ss a",
                        Hms: "HH:mm:ss",
                        M: "L",
                        Md: "d.M.",
                        MEd: "E d.M",
                        MMdd: "d.M.",
                        MMM: "LLL",
                        MMMd: "d. MMM",
                        MMMEd: "E d. MMM",
                        ms: "mm:ss",
                        y: "y",
                        yM: "M y",
                        yMd: "d.M.yyyy",
                        yMEd: "E d.MM.y",
                        yMMM: "MMM y",
                        yMMMd: "d. MMM y",
                        yMMMEd: "E d. MMM y",
                        yQQQ: "QQQ y",
                        yQQQQ: "QQQQ y",
                        yyMM: "MM.yy",
                        yyMMM: "MMM yy",
                        yyyyMMMM: "MMMM y"
                    }
                },
                defaultDateTimePattern: "{0} {1}",
                datePartsOrder: "dmy",
                dayNames: {
                    format: {
                        abbreviated: [ "søn.", "man.", "tir.", "ons.", "tor.", "fre.", "lør." ],
                        narrow: [ "S", "M", "T", "O", "T", "F", "L" ],
                        wide: [ "søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag" ],
                        "short": [ "sø.", "ma.", "ti.", "on.", "to.", "fr.", "lø." ]
                    },
                    standAlone: {
                        abbreviated: [ "sø.", "ma.", "ti.", "on.", "to.", "fr.", "lø." ],
                        narrow: [ "S", "M", "T", "O", "T", "F", "L" ],
                        wide: [ "søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag" ],
                        "short": [ "sø.", "ma.", "ti.", "on.", "to.", "fr.", "lø." ]
                    }
                },
                dayPeriods: {
                    format: {
                        abbreviated: {
                            am: "a.m.",
                            pm: "p.m."
                        },
                        narrow: {
                            am: "a",
                            pm: "p"
                        },
                        wide: {
                            am: "AM",
                            pm: "PM"
                        }
                    },
                    standAlone: {
                        abbreviated: {
                            am: "a.m.",
                            pm: "p.m."
                        },
                        narrow: {
                            am: "a",
                            pm: "p"
                        },
                        wide: {
                            am: "AM",
                            pm: "PM"
                        }
                    }
                },
                monthNames: {
                    format: {
                        abbreviated: [ "jan.", "feb.", "mars", "apr.", "mai", "juni", "juli", "aug.", "sep.", "okt.", "nov.", "des." ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "januar", "februar", "mars", "april", "mai", "juni", "juli", "august", "september", "oktober", "november", "desember" ]
                    },
                    standAlone: {
                        abbreviated: [ "jan", "feb", "mar", "apr", "mai", "jun", "jul", "aug", "sep", "okt", "nov", "des" ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "januar", "februar", "mars", "april", "mai", "juni", "juli", "august", "september", "oktober", "november", "desember" ]
                    }
                },
                eraNames: {
                    wide: [ "f.Kr.", "e.Kr." ],
                    abbreviated: [ "f.Kr.", "e.Kr." ]
                },
                quarterNames: {
                    format: {
                        abbreviated: [ "K1", "K2", "K3", "K4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1. kvartal", "2. kvartal", "3. kvartal", "4. kvartal" ]
                    },
                    standAlone: {
                        abbreviated: [ "K1", "K2", "K3", "K4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1. kvartal", "2. kvartal", "3. kvartal", "4. kvartal" ]
                    }
                }
            }
        };
        inter.pluralRule = function(n) {
            if (n === 1) return "one";
            return "other";
        };
        inter.languages = [ {
            id: "en_gb",
            displayName: "britisk engelsk",
            nativeDisplayName: "British English"
        }, {
            id: "da",
            displayName: "dansk",
            nativeDisplayName: "dansk"
        }, {
            id: "de",
            displayName: "tysk",
            nativeDisplayName: "Deutsch"
        }, {
            id: "es",
            displayName: "spansk",
            nativeDisplayName: "español"
        }, {
            id: "fr",
            displayName: "fransk",
            nativeDisplayName: "français"
        }, {
            id: "it",
            displayName: "italiensk",
            nativeDisplayName: "italiano"
        }, {
            id: "nl",
            displayName: "nederlandsk",
            nativeDisplayName: "Nederlands"
        }, {
            id: "nb",
            displayName: "norsk bokmål",
            nativeDisplayName: "norsk bokmål"
        }, {
            id: "pt",
            displayName: "portugisisk",
            nativeDisplayName: "português"
        }, {
            id: "sv",
            displayName: "svensk",
            nativeDisplayName: "svenska"
        }, {
            id: "en_us",
            displayName: "amerikansk engelsk",
            nativeDisplayName: "U.S. English"
        } ];
    }
    if ("nb" === "nl") {
        inter.id = "nl";
        inter.delimiters = {
            quotationStart: "“",
            quotationEnd: "”",
            alternateQuotationStart: "‘",
            alternateQuotationEnd: "’"
        };
        inter.numbers = {
            latn: {
                symbols: {
                    decimal: ",",
                    group: ".",
                    list: ";",
                    percentSign: "%",
                    plusSign: "+",
                    minusSign: "-",
                    exponential: "E",
                    perMille: "‰",
                    infinity: "∞",
                    nan: "NaN"
                },
                formats: {
                    scientific: {
                        "default": "#E0"
                    },
                    decimal: {
                        "long": {
                            1e3: {
                                one: "0 duizend",
                                other: "0 duizend"
                            },
                            1e4: {
                                one: "00 duizend",
                                other: "00 duizend"
                            },
                            1e5: {
                                one: "000 duizend",
                                other: "000 duizend"
                            },
                            1e6: {
                                one: "0 miljoen",
                                other: "0 miljoen"
                            },
                            1e7: {
                                one: "00 miljoen",
                                other: "00 miljoen"
                            },
                            1e8: {
                                one: "000 miljoen",
                                other: "000 miljoen"
                            },
                            1e9: {
                                one: "0 miljard",
                                other: "0 miljard"
                            },
                            1e10: {
                                one: "00 miljard",
                                other: "00 miljard"
                            },
                            1e11: {
                                one: "000 miljard",
                                other: "000 miljard"
                            },
                            1e12: {
                                one: "0 biljoen",
                                other: "0 biljoen"
                            },
                            1e13: {
                                one: "00 biljoen",
                                other: "00 biljoen"
                            },
                            1e14: {
                                one: "000 biljoen",
                                other: "000 biljoen"
                            }
                        },
                        "short": {
                            1e3: {
                                one: "0K",
                                other: "0K"
                            },
                            1e4: {
                                one: "00K",
                                other: "00K"
                            },
                            1e5: {
                                one: "000K",
                                other: "000K"
                            },
                            1e6: {
                                one: "0 mln'.'",
                                other: "0 mln'.'"
                            },
                            1e7: {
                                one: "00 mln'.'",
                                other: "00 mln'.'"
                            },
                            1e8: {
                                one: "000 mln'.'",
                                other: "000 mln'.'"
                            },
                            1e9: {
                                one: "0 mld'.'",
                                other: "0 mld'.'"
                            },
                            1e10: {
                                one: "00 mld'.'",
                                other: "00 mld'.'"
                            },
                            1e11: {
                                one: "000 mld'.'",
                                other: "000 mld'.'"
                            },
                            1e12: {
                                one: "0 bln'.'",
                                other: "0 bln'.'"
                            },
                            1e13: {
                                one: "00 bln'.'",
                                other: "00 bln'.'"
                            },
                            1e14: {
                                one: "000 bln'.'",
                                other: "000 bln'.'"
                            }
                        },
                        "default": "#,##0.###"
                    },
                    currency: {
                        "default": "¤ #,##0.00;¤ #,##0.00-",
                        one: "{0} {1}",
                        other: "{0} {1}"
                    },
                    percent: {
                        "default": "#,##0%"
                    }
                },
                digits: [ "0", "1", "2", "3", "4", "5", "6", "7", "8", "9" ]
            }
        };
        inter.defaultNumberSystemId = "latn";
        inter.calendars = {
            gregorian: {
                dateFormats: {
                    basic: {
                        fullDate: "EEEE d MMMM y",
                        longDate: "d MMMM y",
                        mediumDate: "d MMM y",
                        shortDate: "dd-MM-yy",
                        fullTime: "HH:mm:ss zzzz",
                        longTime: "HH:mm:ss z",
                        mediumTime: "HH:mm:ss",
                        shortTime: "HH:mm",
                        shortDateTime: "dd-MM-yy HH:mm",
                        mediumDateTime: "d MMM y HH:mm:ss",
                        longDateTime: "d MMMM y HH:mm:ss z",
                        fullDateTime: "EEEE d MMMM y HH:mm:ss zzzz"
                    },
                    cldr: {
                        d: "d",
                        Ed: "E d",
                        h: "h a",
                        H: "HH",
                        hm: "h:mm a",
                        Hm: "HH:mm",
                        hms: "h:mm:ss a",
                        Hms: "HH:mm:ss",
                        M: "L",
                        Md: "d-M",
                        MEd: "E d-M",
                        MMd: "d-MM",
                        MMdd: "dd-MM",
                        MMM: "LLL",
                        MMMd: "d MMM",
                        MMMEd: "E d MMM",
                        MMMMd: "d MMMM",
                        ms: "mm:ss",
                        y: "y",
                        yM: "M-y",
                        yMd: "d-M-y",
                        yMEd: "E d-M-y",
                        yMMM: "MMM y",
                        yMMMd: "d MMM y",
                        yMMMEd: "E d MMM y",
                        yQQQ: "QQQ y",
                        yQQQQ: "QQQQ y",
                        yyMM: "MM-yy",
                        yyMMM: "MMM yy",
                        yyyyMMMM: "MMMM y"
                    }
                },
                defaultDateTimePattern: "{1} {0}",
                datePartsOrder: "dmy",
                dayNames: {
                    format: {
                        abbreviated: [ "zo", "ma", "di", "wo", "do", "vr", "za" ],
                        narrow: [ "Z", "M", "D", "W", "D", "V", "Z" ],
                        wide: [ "zondag", "maandag", "dinsdag", "woensdag", "donderdag", "vrijdag", "zaterdag" ],
                        "short": [ "zo", "ma", "di", "wo", "do", "vr", "za" ]
                    },
                    standAlone: {
                        abbreviated: [ "zo", "ma", "di", "wo", "do", "vr", "za" ],
                        narrow: [ "Z", "M", "D", "W", "D", "V", "Z" ],
                        wide: [ "zondag", "maandag", "dinsdag", "woensdag", "donderdag", "vrijdag", "zaterdag" ],
                        "short": [ "zo", "ma", "di", "wo", "do", "vr", "za" ]
                    }
                },
                dayPeriods: {
                    format: {
                        abbreviated: {
                            noon: "12 uur 's middags",
                            am: "AM",
                            pm: "PM"
                        },
                        narrow: {
                            noon: "n",
                            am: "AM",
                            pm: "PM"
                        },
                        wide: {
                            am: "AM",
                            noon: "12 uur 's middags",
                            pm: "PM"
                        }
                    },
                    standAlone: {
                        abbreviated: {
                            am: "a.m.",
                            pm: "p.m.",
                            noon: "12 uur 's middags"
                        },
                        narrow: {
                            noon: "n",
                            am: "AM",
                            pm: "PM"
                        },
                        wide: {
                            am: "voormiddag",
                            pm: "p.m.",
                            noon: "12 uur 's middags"
                        }
                    }
                },
                monthNames: {
                    format: {
                        abbreviated: [ "jan.", "feb.", "mrt.", "apr.", "mei", "jun.", "jul.", "aug.", "sep.", "okt.", "nov.", "dec." ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "januari", "februari", "maart", "april", "mei", "juni", "juli", "augustus", "september", "oktober", "november", "december" ]
                    },
                    standAlone: {
                        abbreviated: [ "jan", "feb", "mrt", "apr", "mei", "jun", "jul", "aug", "sep", "okt", "nov", "dec" ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "januari", "februari", "maart", "april", "mei", "juni", "juli", "augustus", "september", "oktober", "november", "december" ]
                    }
                },
                eraNames: {
                    wide: [ "Voor Christus", "na Christus" ],
                    abbreviated: [ "v.Chr.", "n.Chr." ]
                },
                quarterNames: {
                    format: {
                        abbreviated: [ "K1", "K2", "K3", "K4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1e kwartaal", "2e kwartaal", "3e kwartaal", "4e kwartaal" ]
                    },
                    standAlone: {
                        abbreviated: [ "K1", "K2", "K3", "K4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1e kwartaal", "2e kwartaal", "3e kwartaal", "4e kwartaal" ]
                    }
                }
            }
        };
        inter.pluralRule = function(n) {
            if (n === 1) return "one";
            return "other";
        };
        inter.languages = [ {
            id: "en_gb",
            displayName: "Brits Engels",
            nativeDisplayName: "British English"
        }, {
            id: "da",
            displayName: "Deens",
            nativeDisplayName: "dansk"
        }, {
            id: "de",
            displayName: "Duits",
            nativeDisplayName: "Deutsch"
        }, {
            id: "es",
            displayName: "Spaans",
            nativeDisplayName: "español"
        }, {
            id: "fr",
            displayName: "Frans",
            nativeDisplayName: "français"
        }, {
            id: "it",
            displayName: "Italiaans",
            nativeDisplayName: "italiano"
        }, {
            id: "nl",
            displayName: "Nederlands",
            nativeDisplayName: "Nederlands"
        }, {
            id: "nb",
            displayName: "Noors - Bokmål",
            nativeDisplayName: "norsk bokmål"
        }, {
            id: "pt",
            displayName: "Portugees",
            nativeDisplayName: "português"
        }, {
            id: "sv",
            displayName: "Zweeds",
            nativeDisplayName: "svenska"
        }, {
            id: "en_us",
            displayName: "Amerikaans Engels",
            nativeDisplayName: "U.S. English"
        } ];
    }
    if ("nb" === "es") {
        inter.id = "es";
        inter.delimiters = {
            quotationStart: "“",
            quotationEnd: "”",
            alternateQuotationStart: "«",
            alternateQuotationEnd: "»"
        };
        inter.numbers = {
            latn: {
                symbols: {
                    decimal: ",",
                    group: ".",
                    list: ";",
                    percentSign: "%",
                    plusSign: "+",
                    minusSign: "-",
                    exponential: "E",
                    perMille: "‰",
                    infinity: "∞",
                    nan: "NaN"
                },
                formats: {
                    scientific: {
                        "default": "#E0"
                    },
                    decimal: {
                        "long": {
                            1e3: {
                                one: "0 mil",
                                other: "0 mil"
                            },
                            1e4: {
                                one: "00 mil",
                                other: "00 mil"
                            },
                            1e5: {
                                one: "000 mil",
                                other: "000 mil"
                            },
                            1e6: {
                                one: "0 millón",
                                other: "0 millones"
                            },
                            1e7: {
                                one: "00 millones",
                                other: "00 millones"
                            },
                            1e8: {
                                one: "000 millones",
                                other: "000 millones"
                            },
                            1e9: {
                                one: "0 millardo",
                                other: "0 millardos"
                            },
                            1e10: {
                                one: "00 millardos",
                                other: "00 millardos"
                            },
                            1e11: {
                                one: "000 millardos",
                                other: "000 millardos"
                            },
                            1e12: {
                                one: "0 billón",
                                other: "0 billones"
                            },
                            1e13: {
                                one: "00 billones",
                                other: "00 billones"
                            },
                            1e14: {
                                one: "000 billones",
                                other: "000 billones"
                            }
                        },
                        "short": {
                            1e3: {
                                one: "0 K",
                                other: "0 K"
                            },
                            1e4: {
                                one: "00 K",
                                other: "00 K"
                            },
                            1e5: {
                                one: "000 K",
                                other: "000 K"
                            },
                            1e6: {
                                one: "0 M",
                                other: "0 M"
                            },
                            1e7: {
                                one: "00 M",
                                other: "00 M"
                            },
                            1e8: {
                                one: "000 M",
                                other: "000 M"
                            },
                            1e9: {
                                one: "0000 M",
                                other: "0000 M"
                            },
                            1e10: {
                                one: "00 K M",
                                other: "00 K M"
                            },
                            1e11: {
                                one: "000 K M",
                                other: "000 K M"
                            },
                            1e12: {
                                one: "0 B",
                                other: "0 B"
                            },
                            1e13: {
                                one: "00 B",
                                other: "00 B"
                            },
                            1e14: {
                                one: "000 B",
                                other: "000 B"
                            }
                        },
                        "default": "#,##0.###"
                    },
                    currency: {
                        "default": "#,##0.00 ¤",
                        one: "{0} {1}",
                        other: "{0} {1}"
                    },
                    percent: {
                        "default": "#,##0%"
                    }
                },
                digits: [ "0", "1", "2", "3", "4", "5", "6", "7", "8", "9" ]
            }
        };
        inter.defaultNumberSystemId = "latn";
        inter.calendars = {
            gregorian: {
                dateFormats: {
                    basic: {
                        fullDate: "EEEE, d 'de' MMMM 'de' y",
                        longDate: "d 'de' MMMM 'de' y",
                        mediumDate: "dd/MM/yyyy",
                        shortDate: "dd/MM/yy",
                        fullTime: "HH:mm:ss zzzz",
                        longTime: "HH:mm:ss z",
                        mediumTime: "HH:mm:ss",
                        shortTime: "HH:mm",
                        shortDateTime: "dd/MM/yy HH:mm",
                        mediumDateTime: "dd/MM/yyyy HH:mm:ss",
                        longDateTime: "d 'de' MMMM 'de' y HH:mm:ss z",
                        fullDateTime: "EEEE, d 'de' MMMM 'de' y HH:mm:ss zzzz"
                    },
                    cldr: {
                        d: "d",
                        Ed: "E d",
                        h: "hh a",
                        H: "HH",
                        hm: "hh:mm a",
                        Hm: "HH:mm",
                        hms: "hh:mm:ss a",
                        Hms: "HH:mm:ss",
                        M: "L",
                        Md: "d/M",
                        MEd: "E, d/M",
                        MMd: "d/MM",
                        MMdd: "dd/MM",
                        MMM: "LLL",
                        MMMd: "d MMM",
                        MMMdd: "dd-MMM",
                        MMMEd: "E d MMM",
                        MMMMd: "d 'de' MMMM",
                        ms: "mm:ss",
                        y: "y",
                        yM: "M/y",
                        yMd: "d/M/y",
                        yMEd: "EEE, d/M/y",
                        yMMM: "MMM y",
                        yMMMd: "d MMM y",
                        yMMMEd: "EEE, d 'de' MMMM 'de' y",
                        yMMMM: "MMMM 'de' y",
                        yQQQ: "QQQ y",
                        yQQQQ: "QQQQ 'de' y",
                        yyMM: "MM/yy",
                        yyMMM: "MMM-yy",
                        yyyyMM: "MM/yyyy"
                    }
                },
                defaultDateTimePattern: "{1} {0}",
                datePartsOrder: "dmy",
                dayNames: {
                    format: {
                        abbreviated: [ "dom", "lun", "mar", "mié", "jue", "vie", "sáb" ],
                        narrow: [ "D", "L", "M", "X", "J", "V", "S" ],
                        wide: [ "domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado" ],
                        "short": [ "D", "L", "M", "X", "J", "V", "S" ]
                    },
                    standAlone: {
                        abbreviated: [ "dom", "lun", "mar", "mié", "jue", "vie", "sáb" ],
                        narrow: [ "D", "L", "M", "X", "J", "V", "S" ],
                        wide: [ "domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado" ],
                        "short": [ "D", "L", "M", "X", "J", "V", "S" ]
                    }
                },
                dayPeriods: {
                    format: {
                        abbreviated: {
                            am: "a.m.",
                            pm: "p.m."
                        },
                        narrow: {
                            am: "a.m.",
                            pm: "p.m."
                        },
                        wide: {
                            am: "a.m.",
                            pm: "p.m."
                        }
                    },
                    standAlone: {
                        abbreviated: {
                            am: "a.m.",
                            pm: "p.m."
                        },
                        narrow: {
                            am: "a.m.",
                            pm: "p.m."
                        },
                        wide: {
                            am: "a.m.",
                            pm: "p.m."
                        }
                    }
                },
                monthNames: {
                    format: {
                        abbreviated: [ "ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic" ],
                        narrow: [ "E", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre" ]
                    },
                    standAlone: {
                        abbreviated: [ "ene", "feb", "mar", "abr", "mayo", "jun", "jul", "ago", "sep", "oct", "nov", "dic" ],
                        narrow: [ "E", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre" ]
                    }
                },
                eraNames: {
                    wide: [ "antes de Cristo", "anno Dómini" ],
                    abbreviated: [ "a.C.", "d.C." ]
                },
                quarterNames: {
                    format: {
                        abbreviated: [ "T1", "T2", "T3", "T4" ],
                        narrow: [ "1T", "2T", "3T", "4T" ],
                        wide: [ "1er trimestre", "2º trimestre", "3er trimestre", "4º trimestre" ]
                    },
                    standAlone: {
                        abbreviated: [ "T1", "T2", "T3", "T4" ],
                        narrow: [ "1T", "2T", "3T", "4T" ],
                        wide: [ "1.er trimestre", "2.º trimestre", "3.er trimestre", "4.º trimestre" ]
                    }
                }
            }
        };
        inter.pluralRule = function(n) {
            if (n === 1) return "one";
            return "other";
        };
        inter.languages = [ {
            id: "en_gb",
            displayName: "inglés británico",
            nativeDisplayName: "British English"
        }, {
            id: "da",
            displayName: "danés",
            nativeDisplayName: "dansk"
        }, {
            id: "de",
            displayName: "alemán",
            nativeDisplayName: "Deutsch"
        }, {
            id: "es",
            displayName: "español",
            nativeDisplayName: "español"
        }, {
            id: "fr",
            displayName: "francés",
            nativeDisplayName: "français"
        }, {
            id: "it",
            displayName: "italiano",
            nativeDisplayName: "italiano"
        }, {
            id: "nl",
            displayName: "neerlandés",
            nativeDisplayName: "Nederlands"
        }, {
            id: "nb",
            displayName: "bokmal noruego",
            nativeDisplayName: "norsk bokmål"
        }, {
            id: "pt",
            displayName: "portugués",
            nativeDisplayName: "português"
        }, {
            id: "sv",
            displayName: "sueco",
            nativeDisplayName: "svenska"
        }, {
            id: "en_us",
            displayName: "inglés estadounidense",
            nativeDisplayName: "U.S. English"
        } ];
    }
    if ("nb" === "it") {
        inter.id = "it";
        inter.delimiters = {
            quotationStart: "«",
            quotationEnd: "»",
            alternateQuotationStart: "“",
            alternateQuotationEnd: "”"
        };
        inter.numbers = {
            latn: {
                symbols: {
                    decimal: ",",
                    group: ".",
                    list: ";",
                    percentSign: "%",
                    plusSign: "+",
                    minusSign: "-",
                    exponential: "E",
                    perMille: "‰",
                    infinity: "∞",
                    nan: "NaN"
                },
                formats: {
                    scientific: {
                        "default": "#E0"
                    },
                    decimal: {
                        "long": {
                            1e3: {
                                one: "0 migliaio",
                                other: "0 migliaia"
                            },
                            1e4: {
                                one: "00 migliaia",
                                other: "00 migliaia"
                            },
                            1e5: {
                                one: "000 migliaia",
                                other: "000 migliaia"
                            },
                            1e6: {
                                one: "0 milione",
                                other: "0 milioni"
                            },
                            1e7: {
                                one: "00 milioni",
                                other: "00 milioni"
                            },
                            1e8: {
                                one: "000 milioni",
                                other: "000 milioni"
                            },
                            1e9: {
                                one: "0 miliardi",
                                other: "0 miliardi"
                            },
                            1e10: {
                                one: "00 miliardi",
                                other: "00 miliardi"
                            },
                            1e11: {
                                one: "000 miliardi",
                                other: "000 miliardi"
                            },
                            1e12: {
                                one: "0 bilione",
                                other: "0 bilioni"
                            },
                            1e13: {
                                one: "00 bilioni",
                                other: "00 bilioni"
                            },
                            1e14: {
                                one: "000 bilioni",
                                other: "000 bilioni"
                            }
                        },
                        "short": {
                            1e3: {
                                one: "0",
                                other: "0"
                            },
                            1e4: {
                                one: "0",
                                other: "0"
                            },
                            1e5: {
                                one: "0",
                                other: "0"
                            },
                            1e6: {
                                one: "0 Mln",
                                other: "0 Mln"
                            },
                            1e7: {
                                one: "00 Mln",
                                other: "00 Mln"
                            },
                            1e8: {
                                one: "000 Mln",
                                other: "000 Mln"
                            },
                            1e9: {
                                one: "0 Mld",
                                other: "0 Mld"
                            },
                            1e10: {
                                one: "00 Mld",
                                other: "00 Mld"
                            },
                            1e11: {
                                one: "000 Mld",
                                other: "000 Mld"
                            },
                            1e12: {
                                one: "0 Bln",
                                other: "0 Bln"
                            },
                            1e13: {
                                one: "00 Bln",
                                other: "00 Bln"
                            },
                            1e14: {
                                one: "000 Bln",
                                other: "000 Bln"
                            }
                        },
                        "default": "#,##0.###"
                    },
                    currency: {
                        "default": "¤ #,##0.00",
                        one: "{0} {1}",
                        other: "{0} {1}"
                    },
                    percent: {
                        "default": "#,##0%"
                    }
                },
                digits: [ "0", "1", "2", "3", "4", "5", "6", "7", "8", "9" ]
            }
        };
        inter.defaultNumberSystemId = "latn";
        inter.calendars = {
            gregorian: {
                dateFormats: {
                    basic: {
                        fullDate: "EEEE d MMMM y",
                        longDate: "dd MMMM y",
                        mediumDate: "dd/MMM/y",
                        shortDate: "dd/MM/yy",
                        fullTime: "HH:mm:ss zzzz",
                        longTime: "HH:mm:ss z",
                        mediumTime: "HH:mm:ss",
                        shortTime: "HH:mm",
                        shortDateTime: "dd/MM/yy HH:mm",
                        mediumDateTime: "dd/MMM/y HH:mm:ss",
                        longDateTime: "dd MMMM y HH:mm:ss z",
                        fullDateTime: "EEEE d MMMM y HH:mm:ss zzzz"
                    },
                    cldr: {
                        d: "d",
                        Ed: "E d",
                        h: "hh a",
                        H: "HH",
                        hm: "hh:mm a",
                        Hm: "HH:mm",
                        hms: "hh:mm:ss a",
                        Hms: "HH:mm:ss",
                        M: "L",
                        Md: "d/M",
                        MEd: "E d/M",
                        MMdd: "dd/MM",
                        MMM: "LLL",
                        MMMd: "d MMM",
                        MMMEd: "E d MMM",
                        MMMMdd: "dd MMMM",
                        ms: "mm:ss",
                        y: "y",
                        yM: "M/y",
                        yMd: "d/M/y",
                        yMEd: "E d/M/y",
                        yMMM: "MMM y",
                        yMMMd: "d MMM y",
                        yMMMEd: "E d MMM y",
                        yQQQ: "QQQ y",
                        yQQQQ: "QQQQ y",
                        yyMM: "MM/yy",
                        yyQQQQ: "QQQQ yy",
                        yyyyMMMM: "MMMM y"
                    }
                },
                defaultDateTimePattern: "{1} {0}",
                datePartsOrder: "dmy",
                dayNames: {
                    format: {
                        abbreviated: [ "dom", "lun", "mar", "mer", "gio", "ven", "sab" ],
                        narrow: [ "D", "L", "M", "M", "G", "V", "S" ],
                        wide: [ "domenica", "lunedì", "martedì", "mercoledì", "giovedì", "venerdì", "sabato" ],
                        "short": [ "dom", "lun", "mar", "mer", "gio", "ven", "sab" ]
                    },
                    standAlone: {
                        abbreviated: [ "dom", "lun", "mar", "mer", "gio", "ven", "sab" ],
                        narrow: [ "D", "L", "M", "M", "G", "V", "S" ],
                        wide: [ "Domenica", "Lunedì", "Martedì", "Mercoledì", "Giovedì", "Venerdì", "Sabato" ],
                        "short": [ "dom", "lun", "mar", "mer", "gio", "ven", "sab" ]
                    }
                },
                dayPeriods: {
                    format: {
                        abbreviated: {
                            am: "AM",
                            pm: "PM"
                        },
                        narrow: {
                            am: "m.",
                            pm: "p."
                        },
                        wide: {
                            am: "AM",
                            pm: "PM"
                        }
                    },
                    standAlone: {
                        abbreviated: {
                            am: "AM",
                            pm: "PM"
                        },
                        narrow: {
                            am: "m.",
                            pm: "p."
                        },
                        wide: {
                            am: "AM",
                            pm: "PM"
                        }
                    }
                },
                monthNames: {
                    format: {
                        abbreviated: [ "gen", "feb", "mar", "apr", "mag", "giu", "lug", "ago", "set", "ott", "nov", "dic" ],
                        narrow: [ "G", "F", "M", "A", "M", "G", "L", "A", "S", "O", "N", "D" ],
                        wide: [ "gennaio", "febbraio", "marzo", "aprile", "maggio", "giugno", "luglio", "agosto", "settembre", "ottobre", "novembre", "dicembre" ]
                    },
                    standAlone: {
                        abbreviated: [ "gen", "feb", "mar", "apr", "mag", "giu", "lug", "ago", "set", "ott", "nov", "dic" ],
                        narrow: [ "G", "F", "M", "A", "M", "G", "L", "A", "S", "O", "N", "D" ],
                        wide: [ "Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno", "Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre" ]
                    }
                },
                eraNames: {
                    wide: [ "a.C.", "d.C" ],
                    abbreviated: [ "aC", "dC" ]
                },
                quarterNames: {
                    format: {
                        abbreviated: [ "T1", "T2", "T3", "T4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1o trimestre", "2o trimestre", "3o trimestre", "4o trimestre" ]
                    },
                    standAlone: {
                        abbreviated: [ "T1", "T2", "T3", "T4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "Primo trimestre", "Secondo trimestre", "Terzo trimestre", "Quarto trimestre" ]
                    }
                }
            }
        };
        inter.pluralRule = function(n) {
            if (n === 1) return "one";
            return "other";
        };
        inter.languages = [ {
            id: "en_gb",
            displayName: "inglese britannico",
            nativeDisplayName: "British English"
        }, {
            id: "da",
            displayName: "danese",
            nativeDisplayName: "dansk"
        }, {
            id: "de",
            displayName: "tedesco",
            nativeDisplayName: "Deutsch"
        }, {
            id: "es",
            displayName: "spagnolo",
            nativeDisplayName: "español"
        }, {
            id: "fr",
            displayName: "francese",
            nativeDisplayName: "français"
        }, {
            id: "it",
            displayName: "italiano",
            nativeDisplayName: "italiano"
        }, {
            id: "nl",
            displayName: "olandese",
            nativeDisplayName: "Nederlands"
        }, {
            id: "nb",
            displayName: "norvegese bokmal",
            nativeDisplayName: "norsk bokmål"
        }, {
            id: "pt",
            displayName: "portoghese",
            nativeDisplayName: "português"
        }, {
            id: "sv",
            displayName: "svedese",
            nativeDisplayName: "svenska"
        }, {
            id: "en_us",
            displayName: "inglese americano",
            nativeDisplayName: "U.S. English"
        } ];
    }
    if ("nb" === "fr") {
        inter.id = "fr";
        inter.delimiters = {
            quotationStart: "«",
            quotationEnd: "»",
            alternateQuotationStart: "«",
            alternateQuotationEnd: "»"
        };
        inter.numbers = {
            latn: {
                symbols: {
                    decimal: ",",
                    group: " ",
                    list: ";",
                    percentSign: "%",
                    plusSign: "+",
                    minusSign: "-",
                    exponential: "E",
                    perMille: "‰",
                    infinity: "∞",
                    nan: "NaN"
                },
                formats: {
                    scientific: {
                        "default": "#E0"
                    },
                    decimal: {
                        "long": {
                            1e3: {
                                one: "0 millier",
                                other: "0 mille"
                            },
                            1e4: {
                                one: "00 mille",
                                other: "00 mille"
                            },
                            1e5: {
                                one: "000 mille",
                                other: "000 mille"
                            },
                            1e6: {
                                one: "0 million",
                                other: "0 millions"
                            },
                            1e7: {
                                one: "00 million",
                                other: "00 millions"
                            },
                            1e8: {
                                one: "000 million",
                                other: "000 millions"
                            },
                            1e9: {
                                one: "0 milliard",
                                other: "0 milliards"
                            },
                            1e10: {
                                one: "00 milliard",
                                other: "00 milliards"
                            },
                            1e11: {
                                one: "000 milliards",
                                other: "000 milliards"
                            },
                            1e12: {
                                one: "0 billion",
                                other: "0 billions"
                            },
                            1e13: {
                                one: "00 billions",
                                other: "00 billions"
                            },
                            1e14: {
                                one: "000 billions",
                                other: "000 billions"
                            }
                        },
                        "short": {
                            1e3: {
                                one: "0 K",
                                other: "0 K"
                            },
                            1e4: {
                                one: "00 K",
                                other: "00 K"
                            },
                            1e5: {
                                one: "000 K",
                                other: "000 K"
                            },
                            1e6: {
                                one: "0 M",
                                other: "0 M"
                            },
                            1e7: {
                                one: "00 M",
                                other: "00 M"
                            },
                            1e8: {
                                one: "000 M",
                                other: "000 M"
                            },
                            1e9: {
                                one: "0 Md",
                                other: "0 Md"
                            },
                            1e10: {
                                one: "00 Md",
                                other: "00 Md"
                            },
                            1e11: {
                                one: "000 Md",
                                other: "000 Md"
                            },
                            1e12: {
                                one: "0 Bn",
                                other: "0 Bn"
                            },
                            1e13: {
                                one: "00 Bn",
                                other: "00 Bn"
                            },
                            1e14: {
                                one: "000 Bn",
                                other: "000 Bn"
                            }
                        },
                        "default": "#,##0.###"
                    },
                    currency: {
                        "default": "#,##0.00 ¤;(#,##0.00 ¤)",
                        one: "{0} {1}",
                        other: "{0} {1}"
                    },
                    percent: {
                        "default": "#,##0 %"
                    }
                },
                digits: [ "0", "1", "2", "3", "4", "5", "6", "7", "8", "9" ]
            }
        };
        inter.defaultNumberSystemId = "latn";
        inter.calendars = {
            gregorian: {
                dateFormats: {
                    basic: {
                        fullDate: "EEEE d MMMM y",
                        longDate: "d MMMM y",
                        mediumDate: "d MMM y",
                        shortDate: "dd/MM/yy",
                        fullTime: "HH:mm:ss zzzz",
                        longTime: "HH:mm:ss z",
                        mediumTime: "HH:mm:ss",
                        shortTime: "HH:mm",
                        shortDateTime: "dd/MM/yy HH:mm",
                        mediumDateTime: "d MMM y HH:mm:ss",
                        longDateTime: "d MMMM y HH:mm:ss z",
                        fullDateTime: "EEEE d MMMM y HH:mm:ss zzzz"
                    },
                    cldr: {
                        d: "d",
                        Ed: "E d",
                        h: "h a",
                        H: "HH",
                        hm: "h:mm a",
                        Hm: "HH:mm",
                        hms: "h:mm:ss a",
                        Hms: "HH:mm:ss",
                        M: "L",
                        Md: "d/M",
                        MEd: "E d/M",
                        MMd: "d/MM",
                        MMdd: "dd/MM",
                        MMM: "LLL",
                        MMMd: "d MMM",
                        MMMdd: "dd MMM",
                        MMMEd: "E d MMM",
                        MMMMEd: "E d MMMM",
                        ms: "mm:ss",
                        y: "y",
                        yM: "M/yyyy",
                        yMd: "d/M/yyyy",
                        yMEd: "E d/M/yyyy",
                        yMMM: "MMM y",
                        yMMMd: "d MMM y",
                        yMMMEd: "E d MMM y",
                        yQQQ: "QQQ y",
                        yQQQQ: "QQQQ y",
                        yyMM: "MM/yy",
                        yyMMM: "MMM yy",
                        yyMMMd: "d MMM yy",
                        yyMMMEd: "E d MMM yy",
                        yyyyMMMM: "MMMM y"
                    }
                },
                defaultDateTimePattern: "{1} {0}",
                datePartsOrder: "dmy",
                dayNames: {
                    format: {
                        abbreviated: [ "dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam." ],
                        narrow: [ "D", "L", "M", "M", "J", "V", "S" ],
                        wide: [ "dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi" ],
                        "short": [ "di", "lu", "ma", "me", "je", "ve", "sa" ]
                    },
                    standAlone: {
                        abbreviated: [ "dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam." ],
                        narrow: [ "D", "L", "M", "M", "J", "V", "S" ],
                        wide: [ "dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi" ],
                        "short": [ "dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam." ]
                    }
                },
                dayPeriods: {
                    format: {
                        abbreviated: {
                            afternoon: "ap.m.",
                            am: "AM",
                            pm: "PM",
                            morning: "matin",
                            night: "soir",
                            noon: "midi"
                        },
                        narrow: {
                            afternoon: "ap.m.",
                            am: "AM",
                            morning: "matin",
                            night: "soir",
                            noon: "midi",
                            pm: "p"
                        },
                        wide: {
                            afternoon: "après-midi",
                            am: "AM",
                            morning: "matin",
                            night: "soir",
                            noon: "midi",
                            pm: "PM"
                        }
                    },
                    standAlone: {
                        abbreviated: {
                            afternoon: "ap.m.",
                            am: "av.m.",
                            pm: "ap.m.",
                            morning: "matin",
                            night: "soir",
                            noon: "midi"
                        },
                        narrow: {
                            afternoon: "ap.m.",
                            am: "AM",
                            morning: "matin",
                            night: "soir",
                            noon: "midi",
                            pm: "p"
                        },
                        wide: {
                            afternoon: "après-midi",
                            am: "avant-midi",
                            morning: "matin",
                            night: "soir",
                            noon: "midi",
                            pm: "après-midi"
                        }
                    }
                },
                monthNames: {
                    format: {
                        abbreviated: [ "janv.", "févr.", "mars", "avr.", "mai", "juin", "juil.", "août", "sept.", "oct.", "nov.", "déc." ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre" ]
                    },
                    standAlone: {
                        abbreviated: [ "janv.", "févr.", "mars", "avr.", "mai", "juin", "juil.", "août", "sept.", "oct.", "nov.", "déc." ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre" ]
                    }
                },
                eraNames: {
                    wide: [ "avant Jésus-Christ", "après Jésus-Christ" ],
                    abbreviated: [ "av. J.-C.", "ap. J.-C." ]
                },
                quarterNames: {
                    format: {
                        abbreviated: [ "T1", "T2", "T3", "T4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1er trimestre", "2e trimestre", "3e trimestre", "4e trimestre" ]
                    },
                    standAlone: {
                        abbreviated: [ "T1", "T2", "T3", "T4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1er trimestre", "2e trimestre", "3e trimestre", "4e trimestre" ]
                    }
                }
            }
        };
        inter.pluralRule = function(n) {
            if (n >= 0 && n <= 2 && n !== 2) return "one";
            return "other";
        };
        inter.languages = [ {
            id: "en_gb",
            displayName: "anglais britannique",
            nativeDisplayName: "British English"
        }, {
            id: "da",
            displayName: "danois",
            nativeDisplayName: "dansk"
        }, {
            id: "de",
            displayName: "allemand",
            nativeDisplayName: "Deutsch"
        }, {
            id: "es",
            displayName: "espagnol",
            nativeDisplayName: "español"
        }, {
            id: "fr",
            displayName: "français",
            nativeDisplayName: "français"
        }, {
            id: "it",
            displayName: "italien",
            nativeDisplayName: "italiano"
        }, {
            id: "nl",
            displayName: "néerlandais",
            nativeDisplayName: "Nederlands"
        }, {
            id: "nb",
            displayName: "norvégien bokmål",
            nativeDisplayName: "norsk bokmål"
        }, {
            id: "pt",
            displayName: "portugais",
            nativeDisplayName: "português"
        }, {
            id: "sv",
            displayName: "suédois",
            nativeDisplayName: "svenska"
        }, {
            id: "en_us",
            displayName: "anglais américain",
            nativeDisplayName: "U.S. English"
        } ];
    }
    if ("nb" === "pt") {
        inter.id = "pt";
        inter.delimiters = {
            quotationStart: "“",
            quotationEnd: "”",
            alternateQuotationStart: "‘",
            alternateQuotationEnd: "’"
        };
        inter.numbers = {
            latn: {
                symbols: {
                    decimal: ",",
                    group: ".",
                    list: ";",
                    percentSign: "%",
                    plusSign: "+",
                    minusSign: "-",
                    exponential: "E",
                    perMille: "‰",
                    infinity: "∞",
                    nan: "NaN"
                },
                formats: {
                    scientific: {
                        "default": "#E0"
                    },
                    decimal: {
                        "long": {
                            1e3: {
                                one: "0 mil",
                                other: "0 mil"
                            },
                            1e4: {
                                one: "00 mil",
                                other: "00 mil"
                            },
                            1e5: {
                                one: "000 mil",
                                other: "000 mil"
                            },
                            1e6: {
                                one: "0 milhão",
                                other: "0 milhões"
                            },
                            1e7: {
                                one: "00 milhão",
                                other: "00 milhões"
                            },
                            1e8: {
                                one: "000 milhão",
                                other: "000 milhões"
                            },
                            1e9: {
                                one: "0 bilhão",
                                other: "0 bilhões"
                            },
                            1e10: {
                                one: "00 bilhão",
                                other: "00 bilhões"
                            },
                            1e11: {
                                one: "000 bilhão",
                                other: "000 bilhões"
                            },
                            1e12: {
                                one: "0 trilhão",
                                other: "0 trilhões"
                            },
                            1e13: {
                                one: "00 trilhão",
                                other: "00 trilhões"
                            },
                            1e14: {
                                one: "000 trilhão",
                                other: "000 trilhões"
                            }
                        },
                        "short": {
                            1e3: {
                                one: "0 mil",
                                other: "0 mil"
                            },
                            1e4: {
                                one: "00 mil",
                                other: "00 mil"
                            },
                            1e5: {
                                one: "000 mil",
                                other: "000 mil"
                            },
                            1e6: {
                                one: "0 mi",
                                other: "0 mi"
                            },
                            1e7: {
                                one: "00 mi",
                                other: "00 mi"
                            },
                            1e8: {
                                one: "000 mi",
                                other: "000 mi"
                            },
                            1e9: {
                                one: "0 bi",
                                other: "0 bi"
                            },
                            1e10: {
                                one: "00 bi",
                                other: "00 bi"
                            },
                            1e11: {
                                one: "000 bi",
                                other: "000 bi"
                            },
                            1e12: {
                                one: "0 tri",
                                other: "0 tri"
                            },
                            1e13: {
                                one: "00 tri",
                                other: "00 tri"
                            },
                            1e14: {
                                one: "000 tri",
                                other: "000 tri"
                            }
                        },
                        "default": "#,##0.###"
                    },
                    currency: {
                        "default": "¤#,##0.00;(¤#,##0.00)",
                        one: "{0} {1}",
                        other: "{0} {1}"
                    },
                    percent: {
                        "default": "#,##0%"
                    }
                },
                digits: [ "0", "1", "2", "3", "4", "5", "6", "7", "8", "9" ]
            }
        };
        inter.defaultNumberSystemId = "latn";
        inter.calendars = {
            gregorian: {
                dateFormats: {
                    basic: {
                        fullDate: "EEEE, d 'de' MMMM 'de' y",
                        longDate: "d 'de' MMMM 'de' y",
                        mediumDate: "dd/MM/yyyy",
                        shortDate: "dd/MM/yy",
                        fullTime: "HH:mm:ss zzzz",
                        longTime: "HH:mm:ss z",
                        mediumTime: "HH:mm:ss",
                        shortTime: "HH:mm",
                        shortDateTime: "dd/MM/yy HH:mm",
                        mediumDateTime: "dd/MM/yyyy HH:mm:ss",
                        longDateTime: "d 'de' MMMM 'de' y HH:mm:ss z",
                        fullDateTime: "EEEE, d 'de' MMMM 'de' y HH:mm:ss zzzz"
                    },
                    cldr: {
                        d: "d",
                        Ed: "E, d",
                        h: "h a",
                        H: "HH",
                        HHmm: "HH:mm",
                        HHmmss: "HH:mm:ss",
                        hm: "h:mm a",
                        Hm: "HH:mm",
                        hms: "h:mm:ss a",
                        Hms: "HH:mm:ss",
                        M: "L",
                        Md: "d/M",
                        MEd: "E, dd/MM",
                        MMdd: "dd/MM",
                        MMM: "LLL",
                        MMMd: "d 'de' MMM",
                        MMMEd: "E, d 'de' MMM",
                        ms: "mm:ss",
                        y: "y",
                        yM: "MM/yyyy",
                        yMd: "dd/MM/yyyy",
                        yMEd: "E, dd/MM/yyyy",
                        yMMM: "MMM 'de' y",
                        yMMMd: "d 'de' MMM 'de' y",
                        yMMMEd: "E, d 'de' MMM 'de' y",
                        yQQQ: "y QQQ",
                        yQQQQ: "y QQQQ",
                        yyMM: "MM/yy",
                        yyMMM: "MMM 'de' yy",
                        yyMMMd: "d 'de' MMM 'de' yy",
                        yyMMMEd: "E, d 'de' MMM 'de' yy",
                        yyQQQ: "QQQ yy",
                        yyyyMM: "MM/yyyy",
                        yyyyMMM: "MMM 'de' y"
                    }
                },
                defaultDateTimePattern: "{1} {0}",
                datePartsOrder: "dmy",
                dayNames: {
                    format: {
                        abbreviated: [ "dom", "seg", "ter", "qua", "qui", "sex", "sáb" ],
                        narrow: [ "D", "S", "T", "Q", "Q", "S", "S" ],
                        wide: [ "domingo", "segunda-feira", "terça-feira", "quarta-feira", "quinta-feira", "sexta-feira", "sábado" ],
                        "short": [ "dom", "seg", "ter", "qua", "qui", "sex", "sáb" ]
                    },
                    standAlone: {
                        abbreviated: [ "dom", "seg", "ter", "qua", "qui", "sex", "sáb" ],
                        narrow: [ "D", "S", "T", "Q", "Q", "S", "S" ],
                        wide: [ "domingo", "segunda-feira", "terça-feira", "quarta-feira", "quinta-feira", "sexta-feira", "sábado" ],
                        "short": [ "dom", "seg", "ter", "qua", "qui", "sex", "sáb" ]
                    }
                },
                dayPeriods: {
                    format: {
                        abbreviated: {
                            am: "AM",
                            pm: "PM",
                            afternoon: "tarde",
                            morning: "manhã",
                            night: "noite",
                            noon: "meio-dia"
                        },
                        narrow: {
                            am: "a",
                            pm: "p",
                            afternoon: "tarde",
                            morning: "manhã",
                            night: "noite",
                            noon: "meio-dia"
                        },
                        wide: {
                            afternoon: "tarde",
                            am: "AM",
                            morning: "manhã",
                            night: "noite",
                            noon: "meio-dia",
                            pm: "PM"
                        }
                    },
                    standAlone: {
                        abbreviated: {
                            afternoon: "tarde",
                            morning: "manhã",
                            night: "noite",
                            noon: "meia-noite",
                            am: "AM",
                            pm: "PM"
                        },
                        narrow: {
                            am: "a",
                            pm: "p",
                            afternoon: "tarde",
                            morning: "manhã",
                            night: "noite",
                            noon: "meio-dia"
                        },
                        wide: {
                            afternoon: "tarde",
                            am: "AM",
                            morning: "manhã",
                            night: "noite",
                            noon: "meio-dia",
                            pm: "PM"
                        }
                    }
                },
                monthNames: {
                    format: {
                        abbreviated: [ "jan", "fev", "mar", "abr", "mai", "jun", "jul", "ago", "set", "out", "nov", "dez" ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "janeiro", "fevereiro", "março", "abril", "maio", "junho", "julho", "agosto", "setembro", "outubro", "novembro", "dezembro" ]
                    },
                    standAlone: {
                        abbreviated: [ "jan", "fev", "mar", "abr", "mai", "jun", "jul", "ago", "set", "out", "nov", "dez" ],
                        narrow: [ "J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D" ],
                        wide: [ "janeiro", "fevereiro", "março", "abril", "maio", "junho", "julho", "agosto", "setembro", "outubro", "novembro", "dezembro" ]
                    }
                },
                eraNames: {
                    wide: [ "Antes de Cristo", "Ano do Senhor" ],
                    abbreviated: [ "a.C.", "d.C." ]
                },
                quarterNames: {
                    format: {
                        abbreviated: [ "T1", "T2", "T3", "T4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1º trimestre", "2º trimestre", "3º trimestre", "4º trimestre" ]
                    },
                    standAlone: {
                        abbreviated: [ "T1", "T2", "T3", "T4" ],
                        narrow: [ "1", "2", "3", "4" ],
                        wide: [ "1º trimestre", "2º trimestre", "3º trimestre", "4º trimestre" ]
                    }
                }
            }
        };
        inter.pluralRule = function(n) {
            if (n === 1) return "one";
            return "other";
        };
        inter.languages = [ {
            id: "en_gb",
            displayName: "inglês britânico",
            nativeDisplayName: "British English"
        }, {
            id: "da",
            displayName: "dinamarquês",
            nativeDisplayName: "dansk"
        }, {
            id: "de",
            displayName: "alemão",
            nativeDisplayName: "Deutsch"
        }, {
            id: "es",
            displayName: "espanhol",
            nativeDisplayName: "español"
        }, {
            id: "fr",
            displayName: "francês",
            nativeDisplayName: "français"
        }, {
            id: "it",
            displayName: "italiano",
            nativeDisplayName: "italiano"
        }, {
            id: "nl",
            displayName: "holandês",
            nativeDisplayName: "Nederlands"
        }, {
            id: "nb",
            displayName: "bokmål norueguês",
            nativeDisplayName: "norsk bokmål"
        }, {
            id: "pt",
            displayName: "português",
            nativeDisplayName: "português"
        }, {
            id: "sv",
            displayName: "sueco",
            nativeDisplayName: "svenska"
        }, {
            id: "en_us",
            displayName: "inglês americano",
            nativeDisplayName: "U.S. English"
        } ];
    }
    return inter;
});

(function(window, undefined) {
    var TraceKit = {};
    var _oldTraceKit = window.TraceKit;
    var _slice = [].slice;
    var UNKNOWN_FUNCTION = "?";
    function _has(object, key) {
        return Object.prototype.hasOwnProperty.call(object, key);
    }
    function _isUndefined(what) {
        return typeof what === "undefined";
    }
    TraceKit.noConflict = function noConflict() {
        window.TraceKit = _oldTraceKit;
        return TraceKit;
    };
    TraceKit.wrap = function traceKitWrapper(func) {
        function wrapped() {
            try {
                return func.apply(this, arguments);
            } catch (e) {
                TraceKit.report(e);
                throw e;
            }
        }
        return wrapped;
    };
    TraceKit.report = function reportModuleWrapper() {
        var handlers = [], lastException = null, lastExceptionStack = null;
        function subscribe(handler, installGlobal) {
            if (typeof installGlobal === "undefined") {
                installGlobal = true;
            }
            if (installGlobal) {
                installGlobalHandler();
            }
            handlers.push(handler);
        }
        function unsubscribe(handler) {
            for (var i = handlers.length - 1; i >= 0; --i) {
                if (handlers[i] === handler) {
                    handlers.splice(i, 1);
                }
            }
        }
        function notifyHandlers(stack, windowError) {
            var exception = null;
            if (windowError && !TraceKit.collectWindowErrors) {
                return;
            }
            for (var i in handlers) {
                if (_has(handlers, i)) {
                    try {
                        handlers[i].apply(null, [ stack ].concat(_slice.call(arguments, 2)));
                    } catch (inner) {
                        exception = inner;
                    }
                }
            }
            if (exception) {
                throw exception;
            }
        }
        var _oldOnerrorHandler, _onErrorHandlerInstalled;
        function traceKitWindowOnError(message, url, lineNo) {
            var stack = null;
            if (lastExceptionStack) {
                TraceKit.computeStackTrace.augmentStackTraceWithInitialElement(lastExceptionStack, url, lineNo, message);
                stack = lastExceptionStack;
                lastExceptionStack = null;
                lastException = null;
            } else {
                var location = {
                    url: url,
                    line: lineNo
                };
                location.func = TraceKit.computeStackTrace.guessFunctionName(location.url, location.line);
                location.context = TraceKit.computeStackTrace.gatherContext(location.url, location.line);
                stack = {
                    mode: "onerror",
                    message: message,
                    url: document.location.href,
                    stack: [ location ],
                    useragent: navigator.userAgent
                };
            }
            notifyHandlers(stack, "from window.onerror");
            if (_oldOnerrorHandler) {
                return _oldOnerrorHandler.apply(this, arguments);
            }
            return false;
        }
        function installGlobalHandler() {
            if (_onErrorHandlerInstalled === true) {
                return;
            }
            _oldOnerrorHandler = window.onerror;
            window.onerror = traceKitWindowOnError;
            (function extendToAsynchronousCallbacks() {
                var _helper = function _helper(fnName) {
                    var originalFn = window[fnName];
                    window[fnName] = function traceKitAsyncExtension() {
                        var args = _slice.call(arguments);
                        var originalCallback = args[0];
                        if (typeof originalCallback === "function") {
                            args[0] = TraceKit.wrap(originalCallback);
                        }
                        if (originalFn.apply) {
                            return originalFn.apply(this, args);
                        } else {
                            return originalFn(args[0], args[1]);
                        }
                    };
                };
                _helper("setTimeout");
                _helper("setInterval");
            })();
            _onErrorHandlerInstalled = true;
        }
        function report(ex, throwGlobal) {
            var args = _slice.call(arguments, 1);
            if (lastExceptionStack) {
                if (lastException === ex) {
                    return;
                } else {
                    var s = lastExceptionStack;
                    lastExceptionStack = null;
                    lastException = null;
                    notifyHandlers.apply(null, [ s, null ].concat(args));
                }
            }
            var stack = TraceKit.computeStackTrace(ex);
            lastExceptionStack = stack;
            lastException = ex;
            window.setTimeout(function() {
                if (lastException === ex) {
                    lastExceptionStack = null;
                    lastException = null;
                    notifyHandlers.apply(null, [ stack, null ].concat(args));
                }
            }, stack.incomplete ? 2e3 : 0);
            if (!throwGlobal) {
                return;
            }
            throw ex;
        }
        report.subscribe = subscribe;
        report.unsubscribe = unsubscribe;
        return report;
    }();
    TraceKit.computeStackTrace = function computeStackTraceWrapper() {
        var debug = false, sourceCache = {};
        function loadSource(url) {
            if (!TraceKit.remoteFetching) {
                return "";
            }
            try {
                var getXHR = function() {
                    try {
                        return new window.XMLHttpRequest();
                    } catch (e) {
                        return new window.ActiveXObject("Microsoft.XMLHTTP");
                    }
                };
                var request = getXHR();
                request.open("GET", url, false);
                request.send("");
                return request.responseText;
            } catch (e) {
                return "";
            }
        }
        function getSource(url) {
            if (!_has(sourceCache, url)) {
                var source = "";
                if (url.indexOf(document.domain) !== -1) {
                    source = loadSource(url);
                }
                sourceCache[url] = source ? source.split("\n") : [];
            }
            return sourceCache[url];
        }
        function guessFunctionName(url, lineNo) {
            var reFunctionArgNames = /function ([^(]*)\(([^)]*)\)/, reGuessFunction = /['"]?([0-9A-Za-z$_]+)['"]?\s*[:=]\s*(function|eval|new Function)/, line = "", maxLines = 10, source = getSource(url), m;
            if (!source.length) {
                return UNKNOWN_FUNCTION;
            }
            for (var i = 0; i < maxLines; ++i) {
                line = source[lineNo - i] + line;
                if (!_isUndefined(line)) {
                    if (m = reGuessFunction.exec(line)) {
                        return m[1];
                    } else if (m = reFunctionArgNames.exec(line)) {
                        return m[1];
                    }
                }
            }
            return UNKNOWN_FUNCTION;
        }
        function gatherContext(url, line) {
            var source = getSource(url);
            if (!source.length) {
                return null;
            }
            var context = [], linesBefore = Math.floor(TraceKit.linesOfContext / 2), linesAfter = linesBefore + TraceKit.linesOfContext % 2, start = Math.max(0, line - linesBefore - 1), end = Math.min(source.length, line + linesAfter - 1);
            line -= 1;
            for (var i = start; i < end; ++i) {
                if (!_isUndefined(source[i])) {
                    context.push(source[i]);
                }
            }
            return context.length > 0 ? context : null;
        }
        function escapeRegExp(text) {
            return text.replace(/[\-\[\]{}()*+?.,\\\^$|#]/g, "\\$&");
        }
        function escapeCodeAsRegExpForMatchingInsideHTML(body) {
            return escapeRegExp(body).replace("<", "(?:<|&lt;)").replace(">", "(?:>|&gt;)").replace("&", "(?:&|&amp;)").replace('"', '(?:"|&quot;)').replace(/\s+/g, "\\s+");
        }
        function findSourceInUrls(re, urls) {
            var source, m;
            for (var i = 0, j = urls.length; i < j; ++i) {
                if ((source = getSource(urls[i])).length) {
                    source = source.join("\n");
                    if (m = re.exec(source)) {
                        return {
                            url: urls[i],
                            line: source.substring(0, m.index).split("\n").length,
                            column: m.index - source.lastIndexOf("\n", m.index) - 1
                        };
                    }
                }
            }
            return null;
        }
        function findSourceInLine(fragment, url, line) {
            var source = getSource(url), re = new RegExp("\\b" + escapeRegExp(fragment) + "\\b"), m;
            line -= 1;
            if (source && source.length > line && (m = re.exec(source[line]))) {
                return m.index;
            }
            return null;
        }
        function findSourceByFunctionBody(func) {
            var urls = [ window.location.href ], scripts = document.getElementsByTagName("script"), body, code = "" + func, codeRE = /^function(?:\s+([\w$]+))?\s*\(([\w\s,]*)\)\s*\{\s*(\S[\s\S]*\S)\s*\}\s*$/, eventRE = /^function on([\w$]+)\s*\(event\)\s*\{\s*(\S[\s\S]*\S)\s*\}\s*$/, re, parts, result;
            for (var i = 0; i < scripts.length; ++i) {
                var script = scripts[i];
                if (script.src) {
                    urls.push(script.src);
                }
            }
            if (!(parts = codeRE.exec(code))) {
                re = new RegExp(escapeRegExp(code).replace(/\s+/g, "\\s+"));
            } else {
                var name = parts[1] ? "\\s+" + parts[1] : "", args = parts[2].split(",").join("\\s*,\\s*");
                body = escapeRegExp(parts[3]).replace(/;$/, ";?");
                re = new RegExp("function" + name + "\\s*\\(\\s*" + args + "\\s*\\)\\s*{\\s*" + body + "\\s*}");
            }
            if (result = findSourceInUrls(re, urls)) {
                return result;
            }
            if (parts = eventRE.exec(code)) {
                var event = parts[1];
                body = escapeCodeAsRegExpForMatchingInsideHTML(parts[2]);
                re = new RegExp("on" + event + "=[\\'\"]\\s*" + body + "\\s*[\\'\"]", "i");
                if (result = findSourceInUrls(re, urls[0])) {
                    return result;
                }
                re = new RegExp(body);
                if (result = findSourceInUrls(re, urls)) {
                    return result;
                }
            }
            return null;
        }
        function computeStackTraceFromStackProp(ex) {
            if (!ex.stack) {
                return null;
            }
            var chrome = /^\s*at (?:((?:\[object object\])?\S+(?: \[as \S+\])?) )?\(?((?:file|http|https):.*?):(\d+)(?::(\d+))?\)?\s*$/i, gecko = /^\s*(\S*)(?:\((.*?)\))?@((?:file|http|https).*?):(\d+)(?::(\d+))?\s*$/i, lines = ex.stack.split("\n"), stack = [], parts, element, reference = /^(.*) is undefined$/.exec(ex.message);
            for (var i = 0, j = lines.length; i < j; ++i) {
                if (parts = gecko.exec(lines[i])) {
                    element = {
                        url: parts[3],
                        func: parts[1] || UNKNOWN_FUNCTION,
                        args: parts[2] ? parts[2].split(",") : "",
                        line: +parts[4],
                        column: parts[5] ? +parts[5] : null
                    };
                } else if (parts = chrome.exec(lines[i])) {
                    element = {
                        url: parts[2],
                        func: parts[1] || UNKNOWN_FUNCTION,
                        line: +parts[3],
                        column: parts[4] ? +parts[4] : null
                    };
                } else {
                    continue;
                }
                if (!element.func && element.line) {
                    element.func = guessFunctionName(element.url, element.line);
                }
                if (element.line) {
                    element.context = gatherContext(element.url, element.line);
                }
                stack.push(element);
            }
            if (stack[0] && stack[0].line && !stack[0].column && reference) {
                stack[0].column = findSourceInLine(reference[1], stack[0].url, stack[0].line);
            }
            if (!stack.length) {
                return null;
            }
            return {
                mode: "stack",
                name: ex.name,
                message: ex.message,
                url: document.location.href,
                stack: stack,
                useragent: navigator.userAgent
            };
        }
        function computeStackTraceFromStacktraceProp(ex) {
            var stacktrace = ex.stacktrace;
            var testRE = / line (\d+), column (\d+) in (?:<anonymous function: ([^>]+)>|([^\)]+))\((.*)\) in (.*):\s*$/i, lines = stacktrace.split("\n"), stack = [], parts;
            for (var i = 0, j = lines.length; i < j; i += 2) {
                if (parts = testRE.exec(lines[i])) {
                    var element = {
                        line: +parts[1],
                        column: +parts[2],
                        func: parts[3] || parts[4],
                        args: parts[5] ? parts[5].split(",") : [],
                        url: parts[6]
                    };
                    if (!element.func && element.line) {
                        element.func = guessFunctionName(element.url, element.line);
                    }
                    if (element.line) {
                        try {
                            element.context = gatherContext(element.url, element.line);
                        } catch (exc) {}
                    }
                    if (!element.context) {
                        element.context = [ lines[i + 1] ];
                    }
                    stack.push(element);
                }
            }
            if (!stack.length) {
                return null;
            }
            return {
                mode: "stacktrace",
                name: ex.name,
                message: ex.message,
                url: document.location.href,
                stack: stack,
                useragent: navigator.userAgent
            };
        }
        function computeStackTraceFromOperaMultiLineMessage(ex) {
            var lines = ex.message.split("\n");
            if (lines.length < 4) {
                return null;
            }
            var lineRE1 = /^\s*Line (\d+) of linked script ((?:file|http|https)\S+)(?:: in function (\S+))?\s*$/i, lineRE2 = /^\s*Line (\d+) of inline#(\d+) script in ((?:file|http|https)\S+)(?:: in function (\S+))?\s*$/i, lineRE3 = /^\s*Line (\d+) of function script\s*$/i, stack = [], scripts = document.getElementsByTagName("script"), inlineScriptBlocks = [], parts, i, len, source;
            for (i in scripts) {
                if (_has(scripts, i) && !scripts[i].src) {
                    inlineScriptBlocks.push(scripts[i]);
                }
            }
            for (i = 2, len = lines.length; i < len; i += 2) {
                var item = null;
                if (parts = lineRE1.exec(lines[i])) {
                    item = {
                        url: parts[2],
                        func: parts[3],
                        line: +parts[1]
                    };
                } else if (parts = lineRE2.exec(lines[i])) {
                    item = {
                        url: parts[3],
                        func: parts[4]
                    };
                    var relativeLine = +parts[1];
                    var script = inlineScriptBlocks[parts[2] - 1];
                    if (script) {
                        source = getSource(item.url);
                        if (source) {
                            source = source.join("\n");
                            var pos = source.indexOf(script.innerText);
                            if (pos >= 0) {
                                item.line = relativeLine + source.substring(0, pos).split("\n").length;
                            }
                        }
                    }
                } else if (parts = lineRE3.exec(lines[i])) {
                    var url = window.location.href.replace(/#.*$/, ""), line = parts[1];
                    var re = new RegExp(escapeCodeAsRegExpForMatchingInsideHTML(lines[i + 1]));
                    source = findSourceInUrls(re, [ url ]);
                    item = {
                        url: url,
                        line: source ? source.line : line,
                        func: ""
                    };
                }
                if (item) {
                    if (!item.func) {
                        item.func = guessFunctionName(item.url, item.line);
                    }
                    var context = gatherContext(item.url, item.line);
                    var midline = context ? context[Math.floor(context.length / 2)] : null;
                    if (context && midline.replace(/^\s*/, "") === lines[i + 1].replace(/^\s*/, "")) {
                        item.context = context;
                    } else {
                        item.context = [ lines[i + 1] ];
                    }
                    stack.push(item);
                }
            }
            if (!stack.length) {
                return null;
            }
            return {
                mode: "multiline",
                name: ex.name,
                message: lines[0],
                url: document.location.href,
                stack: stack,
                useragent: navigator.userAgent
            };
        }
        function augmentStackTraceWithInitialElement(stackInfo, url, lineNo, message) {
            var initial = {
                url: url,
                line: lineNo
            };
            if (initial.url && initial.line) {
                stackInfo.incomplete = false;
                if (!initial.func) {
                    initial.func = guessFunctionName(initial.url, initial.line);
                }
                if (!initial.context) {
                    initial.context = gatherContext(initial.url, initial.line);
                }
                var reference = / '([^']+)' /.exec(message);
                if (reference) {
                    initial.column = findSourceInLine(reference[1], initial.url, initial.line);
                }
                if (stackInfo.stack.length > 0) {
                    if (stackInfo.stack[0].url === initial.url) {
                        if (stackInfo.stack[0].line === initial.line) {
                            return false;
                        } else if (!stackInfo.stack[0].line && stackInfo.stack[0].func === initial.func) {
                            stackInfo.stack[0].line = initial.line;
                            stackInfo.stack[0].context = initial.context;
                            return false;
                        }
                    }
                }
                stackInfo.stack.unshift(initial);
                stackInfo.partial = true;
                return true;
            } else {
                stackInfo.incomplete = true;
            }
            return false;
        }
        function computeStackTraceByWalkingCallerChain(ex, depth) {
            var functionName = /function\s+([_$a-zA-Z\xA0-\uFFFF][_$a-zA-Z0-9\xA0-\uFFFF]*)?\s*\(/i, stack = [], funcs = {}, recursion = false, parts, item, source;
            for (var curr = computeStackTraceByWalkingCallerChain.caller; curr && !recursion; curr = curr.caller) {
                if (curr === computeStackTrace || curr === TraceKit.report) {
                    continue;
                }
                item = {
                    url: null,
                    func: UNKNOWN_FUNCTION,
                    line: null,
                    column: null
                };
                if (curr.name) {
                    item.func = curr.name;
                } else if (parts = functionName.exec(curr.toString())) {
                    item.func = parts[1];
                }
                if (source = findSourceByFunctionBody(curr)) {
                    item.url = source.url;
                    item.line = source.line;
                    if (item.func === UNKNOWN_FUNCTION) {
                        item.func = guessFunctionName(item.url, item.line);
                    }
                    var reference = / '([^']+)' /.exec(ex.message || ex.description);
                    if (reference) {
                        item.column = findSourceInLine(reference[1], source.url, source.line);
                    }
                }
                if (funcs["" + curr]) {
                    recursion = true;
                } else {
                    funcs["" + curr] = true;
                }
                stack.push(item);
            }
            if (depth) {
                stack.splice(0, depth);
            }
            var result = {
                mode: "callers",
                name: ex.name,
                message: ex.message,
                url: document.location.href,
                stack: stack,
                useragent: navigator.userAgent
            };
            augmentStackTraceWithInitialElement(result, ex.sourceURL || ex.fileName, ex.line || ex.lineNumber, ex.message || ex.description);
            return result;
        }
        function computeStackTrace(ex, depth) {
            var stack = null;
            depth = depth == null ? 0 : +depth;
            try {
                stack = computeStackTraceFromStacktraceProp(ex);
                if (stack) {
                    return stack;
                }
            } catch (e) {
                if (debug) {
                    throw e;
                }
            }
            try {
                stack = computeStackTraceFromStackProp(ex);
                if (stack) {
                    return stack;
                }
            } catch (e) {
                if (debug) {
                    throw e;
                }
            }
            try {
                stack = computeStackTraceFromOperaMultiLineMessage(ex);
                if (stack) {
                    return stack;
                }
            } catch (e) {
                if (debug) {
                    throw e;
                }
            }
            try {
                stack = computeStackTraceByWalkingCallerChain(ex, depth + 1);
                if (stack) {
                    return stack;
                }
            } catch (e) {
                if (debug) {
                    throw e;
                }
            }
            return {
                mode: "failed"
            };
        }
        function computeStackTraceOfCaller(depth) {
            depth = (depth == null ? 0 : +depth) + 1;
            try {
                throw new Error();
            } catch (ex) {
                return computeStackTrace(ex, depth + 1);
            }
        }
        computeStackTrace = function(computeStackTrace) {
            return function(ex, depth) {
                var ret = computeStackTrace(ex, depth);
                ret.error = ex;
                return ret;
            };
        }(computeStackTrace);
        computeStackTrace.augmentStackTraceWithInitialElement = augmentStackTraceWithInitialElement;
        computeStackTrace.guessFunctionName = guessFunctionName;
        computeStackTrace.gatherContext = gatherContext;
        computeStackTrace.ofCaller = computeStackTraceOfCaller;
        return computeStackTrace;
    }();
    if (!TraceKit.remoteFetching) {
        TraceKit.remoteFetching = true;
    }
    if (!TraceKit.collectWindowErrors) {
        TraceKit.collectWindowErrors = true;
    }
    if (!TraceKit.linesOfContext || TraceKit.linesOfContext < 1) {
        TraceKit.linesOfContext = 11;
    }
    window.TraceKit = TraceKit;
})(window);

window.one = window.one || {};

(function() {
    function CrashLogger(size) {
        this.logSize = size;
        this.index = 0;
        this.logBuffer = [];
    }
    function leftPad(str, length, padChar) {
        str = String(str);
        while (str.length < length) {
            str = (padChar || " ") + str;
        }
        return str;
    }
    CrashLogger.prototype.log = function() {
        var args = Array.prototype.slice.call(arguments);
        var d = new Date();
        var timestamp = d.getHours() + ":" + leftPad(d.getMinutes(), 2, "0") + ":" + leftPad(d.getSeconds(), 2, "0") + "." + leftPad(d.getMilliseconds(), 3, "0");
        this.logBuffer[this.index] = timestamp + ": " + args.join(", ");
        this.index = (this.index + 1) % this.logSize;
    };
    CrashLogger.prototype.getEntries = function() {
        var result = [];
        var start = this.index - this.logSize;
        start = start < 0 ? this.logSize + start : start;
        for (var i = 0; i < this.logSize; i += 1) {
            var entry = this.logBuffer[(start + i) % this.logSize];
            if (entry) {
                result.push(entry);
            }
        }
        return result;
    };
    CrashLogger.prototype.toString = function() {
        return this.getEntries().join("\n");
    };
    one.crashLogger = new CrashLogger(60);
})();

window.one = window.one || {};

(function() {
    function CrashReporter(options) {
        var that = this;
        options = options || {};
        that.hash = {};
        that.reportUrl = options.reportUrl || "/api/crashreporter/";
        function createApplicationCrash(error, additionalInfo) {
            error = error || new Error();
            additionalInfo = additionalInfo || {};
            if (additionalInfo.hasOwnProperty("message")) {
                error.customMessage = additionalInfo.message;
            }
            return error;
        }
        that.provokeScriptError = function() {
            setTimeout(function() {
                that.undefinedFunction();
            }, 1);
        };
        that.reportCrash = function(error, additionalInfo) {
            try {
                throw createApplicationCrash(error, additionalInfo);
            } catch (e) {
                TraceKit.report(e);
            }
        };
        function sanitiseMessageString(data, clean) {
            if (typeof data !== "string") {
                return "";
            }
            if (clean) {
                try {
                    JSON.parse(data);
                    return "";
                } catch (e) {}
            }
            return data;
        }
        function createTaggedErrorMessage(err, message, clean) {
            var tmp;
            message = !!message ? message : "Application error.";
            if (err.tags) {
                message += ' tags: "' + err.tags.join(" ") + '"';
            }
            message += " [" + err.status + ":";
            message += " " + (!!err.statusText ? err.statusText : "application error");
            tmp = sanitiseMessageString(err.responseText, clean);
            message = !!tmp ? message + " - " + tmp : message;
            message = message + "]";
            return message;
        }
        that.reportTaggedCrash = function(err, message) {
            var additionalInfo = [];
            if (err.tags) {
                additionalInfo.push("Routing tags: " + err.tags.join(" "));
            }
            if (typeof err.status !== "undefined") {
                var xhrInfo = [];
                xhrInfo.push("Request method: " + err.requestMethod);
                xhrInfo.push("Request url: " + err.requestUrl);
                xhrInfo.push("Response status: " + err.status);
                xhrInfo.push("Response statusText: " + err.statusText);
                xhrInfo.push("Response headers: " + err.responseHeaders);
                xhrInfo.push("Response body: " + err.responseText);
                additionalInfo.push(xhrInfo.join("\n"));
            }
            err.additionalInfo = additionalInfo.join("\n");
            that.reportCrash(err, {
                message: createTaggedErrorMessage(err, message)
            });
        };
        function isBlacklisted(err) {
            if (!window.JSON) {
                return true;
            }
            var userAgentString = navigator.userAgent, matchMsieVersion = userAgentString && userAgentString.match(/msie (\d+(\.\d+)?);/i);
            if (matchMsieVersion && parseInt(matchMsieVersion, 10) < 9) {
                return true;
            }
            var ignoreUrls = [ ".cloudfront.net", "chrome://", "google-analytics.com", "extension", "superfish", "admedia" ], url = err.fileName, found = false;
            if (url) {
                ignoreUrls.forEach(function(ignoreUrl) {
                    if (url.match(ignoreUrl)) {
                        found = true;
                        return;
                    }
                });
                if (found) {
                    return true;
                }
            }
            if (err.message === "Script error." && err.fileName === "" && err.lineNumber === 0 || /TOOLBAR_READY/.test(err.message) || err.message === "RequireJS load error" || /conduitPage/.test(err.message) || false) {
                return true;
            }
            return false;
        }
        that.sendReport = function(err) {
            if (isBlacklisted(err)) {
                return;
            }
            var xhr;
            try {
                xhr = new XMLHttpRequest();
            } catch (e) {
                try {
                    xhr = new ActiveXObject("Microsoft.XmlHTTP");
                } catch (e2) {}
            }
            if (!xhr) {
                throw new Error("Couldn't initialize an XMLHttpRequest object.");
            }
            var now = new Date().getTime(), then = that.hash[err.message];
            if (then && now - then < 12e4) {
                that.hash[err.message] = now;
                return;
            }
            that.hash[err.message] = now;
            var crashReport = "";
            var user;
            if (err.user) {
                user = err.user;
            }
            var fileNameMatch = (err.fileName || "").match(/^(?:https?:\/\/)(?:[^\/]+)(\/[^#]*)/);
            fileNameMatch = fileNameMatch ? fileNameMatch[1] : err.fileName;
            var filePosition = fileNameMatch + ":" + err.lineNumber;
            var customMessage = err.customMessage || "none";
            var message = err.message || customMessage;
            if (err.name && message.indexOf(err.name) === -1) {
                message = err.name + ": " + message;
            }
            crashReport += message + " " + filePosition + " (" + (user ? user : "unknown") + ")\n\n";
            crashReport += "Name: " + err.name + "\n";
            crashReport += "Message: " + (err.message || "none") + "\n";
            crashReport += "Custom message: " + customMessage + "\n";
            crashReport += "User: " + (user ? user : "unknown") + "\n";
            crashReport += "URL: " + err.fileName + "\n";
            crashReport += "Line: " + err.lineNumber + "\n";
            crashReport += "Locale: " + "nb" + "\n";
            if ("additionalInfo" in err && err.additionalInfo) {
                crashReport += "\nAdditional info:\n" + err.additionalInfo + "\n";
            }
            if (one.version) {
                crashReport += "Server version: " + one.version.serverVersion() + "\n";
                crashReport += "Client version: " + one.version.clientVersion() + "\n\n";
            } else {
                crashReport += "No version data available." + "\n\n";
            }
            if (err.hasOwnProperty("stack")) {
                crashReport += "Stack trace:\n" + err.stack + "\n\n";
            }
            if (err.response && err.response.hasOwnProperty("stack")) {
                var serverStackTrace = typeof err.response.stack.join === "function" ? err.response.stack.join("\n    ") : err.response.stack;
                crashReport += "Server stack trace:\n" + serverStackTrace + "\n\n";
            }
            crashReport += "Log:\n";
            crashReport += one.crashLogger.toString();
            crashReport += "\n\n";
            var timeString = new Date(now).toUTCString();
            crashReport += "Browser time: " + timeString + "\n";
            [ "vendor", "platform", "product", "appName", "userAgent", "appVersion", "language" ].forEach(function(propertyName) {
                if (navigator[propertyName]) {
                    crashReport += "navigator." + propertyName + ": " + navigator[propertyName] + "\n";
                }
            });
            xhr.open("post", that.reportUrl, false);
            xhr.send(crashReport);
        };
        that.sendReportFromTraceKit = function(errorReport) {
            var firstFrame = errorReport.stack && errorReport.stack.length > 0 ? errorReport.stack[0] : {};
            var err = errorReport.error || function() {
                var e = new Error();
                e.message = errorReport.message;
                return e;
            }();
            err.fileName = firstFrame.url;
            err.lineNumber = firstFrame.line;
            err.pageName = errorReport.url;
            that.sendReport(err);
        };
    }
    one.crashReporter = new CrashReporter({});
})();

TraceKit.report.subscribe(one.crashReporter.sendReportFromTraceKit);

(function(window) {
    var characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=", fromCharCode = String.fromCharCode, INVALID_CHARACTER_ERR = function() {
        try {
            document.createElement("$");
        } catch (error) {
            return error;
        }
    }();
    window.btoa || (window.btoa = function(string) {
        var a, b, b1, b2, b3, b4, c, i = 0, len = string.length, max = Math.max, result = "";
        while (i < len) {
            a = string.charCodeAt(i++) || 0;
            b = string.charCodeAt(i++) || 0;
            c = string.charCodeAt(i++) || 0;
            if (max(a, b, c) > 255) {
                throw INVALID_CHARACTER_ERR;
            }
            b1 = a >> 2 & 63;
            b2 = (a & 3) << 4 | b >> 4 & 15;
            b3 = (b & 15) << 2 | c >> 6 & 3;
            b4 = c & 63;
            if (!b) {
                b3 = b4 = 64;
            } else if (!c) {
                b4 = 64;
            }
            result += characters.charAt(b1) + characters.charAt(b2) + characters.charAt(b3) + characters.charAt(b4);
        }
        return result;
    });
    window.atob || (window.atob = function(string) {
        string = string.replace(/=+$/, "");
        var a, b, b1, b2, b3, b4, c, i = 0, len = string.length, chars = [];
        if (len % 4 === 1) throw INVALID_CHARACTER_ERR;
        while (i < len) {
            b1 = characters.indexOf(string.charAt(i++));
            b2 = characters.indexOf(string.charAt(i++));
            b3 = characters.indexOf(string.charAt(i++));
            b4 = characters.indexOf(string.charAt(i++));
            a = (b1 & 63) << 2 | b2 >> 4 & 3;
            b = (b2 & 15) << 4 | b3 >> 2 & 15;
            c = (b3 & 3) << 6 | b4 & 63;
            chars.push(fromCharCode(a));
            b && chars.push(fromCharCode(b));
            c && chars.push(fromCharCode(c));
        }
        return chars.join("");
    });
})(this);

/** vim: et:ts=4:sw=4:sts=4
 * @license RequireJS 2.1.6 Copyright (c) 2010-2012, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/requirejs for details
 */
var requirejs, require, define;

(function(global) {
    var req, s, head, baseElement, dataMain, src, interactiveScript, currentlyAddingScript, mainScript, subPath, version = "2.1.6", commentRegExp = /(\/\*([\s\S]*?)\*\/|([^:]|^)\/\/(.*)$)/gm, cjsRequireRegExp = /[^.]\s*require\s*\(\s*["']([^'"\s]+)["']\s*\)/g, jsSuffixRegExp = /\.js$/, currDirRegExp = /^\.\//, op = Object.prototype, ostring = op.toString, hasOwn = op.hasOwnProperty, ap = Array.prototype, apsp = ap.splice, isBrowser = !!(typeof window !== "undefined" && navigator && window.document), isWebWorker = !isBrowser && typeof importScripts !== "undefined", readyRegExp = isBrowser && navigator.platform === "PLAYSTATION 3" ? /^complete$/ : /^(complete|loaded)$/, defContextName = "_", isOpera = typeof opera !== "undefined" && opera.toString() === "[object Opera]", contexts = {}, cfg = {}, globalDefQueue = [], useInteractive = false;
    function isFunction(it) {
        return ostring.call(it) === "[object Function]";
    }
    function isArray(it) {
        return ostring.call(it) === "[object Array]";
    }
    function each(ary, func) {
        if (ary) {
            var i;
            for (i = 0; i < ary.length; i += 1) {
                if (ary[i] && func(ary[i], i, ary)) {
                    break;
                }
            }
        }
    }
    function eachReverse(ary, func) {
        if (ary) {
            var i;
            for (i = ary.length - 1; i > -1; i -= 1) {
                if (ary[i] && func(ary[i], i, ary)) {
                    break;
                }
            }
        }
    }
    function hasProp(obj, prop) {
        return hasOwn.call(obj, prop);
    }
    function getOwn(obj, prop) {
        return hasProp(obj, prop) && obj[prop];
    }
    function eachProp(obj, func) {
        var prop;
        for (prop in obj) {
            if (hasProp(obj, prop)) {
                if (func(obj[prop], prop)) {
                    break;
                }
            }
        }
    }
    function mixin(target, source, force, deepStringMixin) {
        if (source) {
            eachProp(source, function(value, prop) {
                if (force || !hasProp(target, prop)) {
                    if (deepStringMixin && typeof value !== "string") {
                        if (!target[prop]) {
                            target[prop] = {};
                        }
                        mixin(target[prop], value, force, deepStringMixin);
                    } else {
                        target[prop] = value;
                    }
                }
            });
        }
        return target;
    }
    function bind(obj, fn) {
        return function() {
            return fn.apply(obj, arguments);
        };
    }
    function scripts() {
        return document.getElementsByTagName("script");
    }
    function defaultOnError(err) {
        throw err;
    }
    function getGlobal(value) {
        if (!value) {
            return value;
        }
        var g = global;
        each(value.split("."), function(part) {
            g = g[part];
        });
        return g;
    }
    function makeError(id, msg, err, requireModules) {
        var e = new Error(msg + "\nhttp://requirejs.org/docs/errors.html#" + id);
        e.requireType = id;
        e.requireModules = requireModules;
        if (err) {
            e.originalError = err;
        }
        return e;
    }
    if (typeof define !== "undefined") {
        return;
    }
    if (typeof requirejs !== "undefined") {
        if (isFunction(requirejs)) {
            return;
        }
        cfg = requirejs;
        requirejs = undefined;
    }
    if (typeof require !== "undefined" && !isFunction(require)) {
        cfg = require;
        require = undefined;
    }
    function newContext(contextName) {
        var inCheckLoaded, Module, context, handlers, checkLoadedTimeoutId, config = {
            waitSeconds: 7,
            baseUrl: "./",
            paths: {},
            pkgs: {},
            shim: {},
            config: {}
        }, registry = {}, enabledRegistry = {}, undefEvents = {}, defQueue = [], defined = {}, urlFetched = {}, requireCounter = 1, unnormalizedCounter = 1;
        function trimDots(ary) {
            var i, part;
            for (i = 0; ary[i]; i += 1) {
                part = ary[i];
                if (part === ".") {
                    ary.splice(i, 1);
                    i -= 1;
                } else if (part === "..") {
                    if (i === 1 && (ary[2] === ".." || ary[0] === "..")) {
                        break;
                    } else if (i > 0) {
                        ary.splice(i - 1, 2);
                        i -= 2;
                    }
                }
            }
        }
        function normalize(name, baseName, applyMap) {
            var pkgName, pkgConfig, mapValue, nameParts, i, j, nameSegment, foundMap, foundI, foundStarMap, starI, baseParts = baseName && baseName.split("/"), normalizedBaseParts = baseParts, map = config.map, starMap = map && map["*"];
            if (name && name.charAt(0) === ".") {
                if (baseName) {
                    if (getOwn(config.pkgs, baseName)) {
                        normalizedBaseParts = baseParts = [ baseName ];
                    } else {
                        normalizedBaseParts = baseParts.slice(0, baseParts.length - 1);
                    }
                    name = normalizedBaseParts.concat(name.split("/"));
                    trimDots(name);
                    pkgConfig = getOwn(config.pkgs, pkgName = name[0]);
                    name = name.join("/");
                    if (pkgConfig && name === pkgName + "/" + pkgConfig.main) {
                        name = pkgName;
                    }
                } else if (name.indexOf("./") === 0) {
                    name = name.substring(2);
                }
            }
            if (applyMap && map && (baseParts || starMap)) {
                nameParts = name.split("/");
                for (i = nameParts.length; i > 0; i -= 1) {
                    nameSegment = nameParts.slice(0, i).join("/");
                    if (baseParts) {
                        for (j = baseParts.length; j > 0; j -= 1) {
                            mapValue = getOwn(map, baseParts.slice(0, j).join("/"));
                            if (mapValue) {
                                mapValue = getOwn(mapValue, nameSegment);
                                if (mapValue) {
                                    foundMap = mapValue;
                                    foundI = i;
                                    break;
                                }
                            }
                        }
                    }
                    if (foundMap) {
                        break;
                    }
                    if (!foundStarMap && starMap && getOwn(starMap, nameSegment)) {
                        foundStarMap = getOwn(starMap, nameSegment);
                        starI = i;
                    }
                }
                if (!foundMap && foundStarMap) {
                    foundMap = foundStarMap;
                    foundI = starI;
                }
                if (foundMap) {
                    nameParts.splice(0, foundI, foundMap);
                    name = nameParts.join("/");
                }
            }
            return name;
        }
        function removeScript(name) {
            if (isBrowser) {
                each(scripts(), function(scriptNode) {
                    if (scriptNode.getAttribute("data-requiremodule") === name && scriptNode.getAttribute("data-requirecontext") === context.contextName) {
                        scriptNode.parentNode.removeChild(scriptNode);
                        return true;
                    }
                });
            }
        }
        function hasPathFallback(id) {
            var pathConfig = getOwn(config.paths, id);
            if (pathConfig && isArray(pathConfig) && pathConfig.length > 1) {
                removeScript(id);
                pathConfig.shift();
                context.require.undef(id);
                context.require([ id ]);
                return true;
            }
        }
        function splitPrefix(name) {
            var prefix, index = name ? name.indexOf("!") : -1;
            if (index > -1) {
                prefix = name.substring(0, index);
                name = name.substring(index + 1, name.length);
            }
            return [ prefix, name ];
        }
        function makeModuleMap(name, parentModuleMap, isNormalized, applyMap) {
            var url, pluginModule, suffix, nameParts, prefix = null, parentName = parentModuleMap ? parentModuleMap.name : null, originalName = name, isDefine = true, normalizedName = "";
            if (!name) {
                isDefine = false;
                name = "_@r" + (requireCounter += 1);
            }
            nameParts = splitPrefix(name);
            prefix = nameParts[0];
            name = nameParts[1];
            if (prefix) {
                prefix = normalize(prefix, parentName, applyMap);
                pluginModule = getOwn(defined, prefix);
            }
            if (name) {
                if (prefix) {
                    if (pluginModule && pluginModule.normalize) {
                        normalizedName = pluginModule.normalize(name, function(name) {
                            return normalize(name, parentName, applyMap);
                        });
                    } else {
                        normalizedName = normalize(name, parentName, applyMap);
                    }
                } else {
                    normalizedName = normalize(name, parentName, applyMap);
                    nameParts = splitPrefix(normalizedName);
                    prefix = nameParts[0];
                    normalizedName = nameParts[1];
                    isNormalized = true;
                    url = context.nameToUrl(normalizedName);
                }
            }
            suffix = prefix && !pluginModule && !isNormalized ? "_unnormalized" + (unnormalizedCounter += 1) : "";
            return {
                prefix: prefix,
                name: normalizedName,
                parentMap: parentModuleMap,
                unnormalized: !!suffix,
                url: url,
                originalName: originalName,
                isDefine: isDefine,
                id: (prefix ? prefix + "!" + normalizedName : normalizedName) + suffix
            };
        }
        function getModule(depMap) {
            var id = depMap.id, mod = getOwn(registry, id);
            if (!mod) {
                mod = registry[id] = new context.Module(depMap);
            }
            return mod;
        }
        function on(depMap, name, fn) {
            var id = depMap.id, mod = getOwn(registry, id);
            if (hasProp(defined, id) && (!mod || mod.defineEmitComplete)) {
                if (name === "defined") {
                    fn(defined[id]);
                }
            } else {
                mod = getModule(depMap);
                if (mod.error && name === "error") {
                    fn(mod.error);
                } else {
                    mod.on(name, fn);
                }
            }
        }
        function onError(err, errback) {
            var ids = err.requireModules, notified = false;
            if (errback) {
                errback(err);
            } else {
                each(ids, function(id) {
                    var mod = getOwn(registry, id);
                    if (mod) {
                        mod.error = err;
                        if (mod.events.error) {
                            notified = true;
                            mod.emit("error", err);
                        }
                    }
                });
                if (!notified) {
                    req.onError(err);
                }
            }
        }
        function takeGlobalQueue() {
            if (globalDefQueue.length) {
                apsp.apply(defQueue, [ defQueue.length - 1, 0 ].concat(globalDefQueue));
                globalDefQueue = [];
            }
        }
        handlers = {
            require: function(mod) {
                if (mod.require) {
                    return mod.require;
                } else {
                    return mod.require = context.makeRequire(mod.map);
                }
            },
            exports: function(mod) {
                mod.usingExports = true;
                if (mod.map.isDefine) {
                    if (mod.exports) {
                        return mod.exports;
                    } else {
                        return mod.exports = defined[mod.map.id] = {};
                    }
                }
            },
            module: function(mod) {
                if (mod.module) {
                    return mod.module;
                } else {
                    return mod.module = {
                        id: mod.map.id,
                        uri: mod.map.url,
                        config: function() {
                            var c, pkg = getOwn(config.pkgs, mod.map.id);
                            c = pkg ? getOwn(config.config, mod.map.id + "/" + pkg.main) : getOwn(config.config, mod.map.id);
                            return c || {};
                        },
                        exports: defined[mod.map.id]
                    };
                }
            }
        };
        function cleanRegistry(id) {
            delete registry[id];
            delete enabledRegistry[id];
        }
        function breakCycle(mod, traced, processed) {
            var id = mod.map.id;
            if (mod.error) {
                mod.emit("error", mod.error);
            } else {
                traced[id] = true;
                each(mod.depMaps, function(depMap, i) {
                    var depId = depMap.id, dep = getOwn(registry, depId);
                    if (dep && !mod.depMatched[i] && !processed[depId]) {
                        if (getOwn(traced, depId)) {
                            mod.defineDep(i, defined[depId]);
                            mod.check();
                        } else {
                            breakCycle(dep, traced, processed);
                        }
                    }
                });
                processed[id] = true;
            }
        }
        function checkLoaded() {
            var map, modId, err, usingPathFallback, waitInterval = config.waitSeconds * 1e3, expired = waitInterval && context.startTime + waitInterval < new Date().getTime(), noLoads = [], reqCalls = [], stillLoading = false, needCycleCheck = true;
            if (inCheckLoaded) {
                return;
            }
            inCheckLoaded = true;
            eachProp(enabledRegistry, function(mod) {
                map = mod.map;
                modId = map.id;
                if (!mod.enabled) {
                    return;
                }
                if (!map.isDefine) {
                    reqCalls.push(mod);
                }
                if (!mod.error) {
                    if (!mod.inited && expired) {
                        if (hasPathFallback(modId)) {
                            usingPathFallback = true;
                            stillLoading = true;
                        } else {
                            noLoads.push(modId);
                            removeScript(modId);
                        }
                    } else if (!mod.inited && mod.fetched && map.isDefine) {
                        stillLoading = true;
                        if (!map.prefix) {
                            return needCycleCheck = false;
                        }
                    }
                }
            });
            if (expired && noLoads.length) {
                err = makeError("timeout", "Load timeout for modules: " + noLoads, null, noLoads);
                err.contextName = context.contextName;
                return onError(err);
            }
            if (needCycleCheck) {
                each(reqCalls, function(mod) {
                    breakCycle(mod, {}, {});
                });
            }
            if ((!expired || usingPathFallback) && stillLoading) {
                if ((isBrowser || isWebWorker) && !checkLoadedTimeoutId) {
                    checkLoadedTimeoutId = setTimeout(function() {
                        checkLoadedTimeoutId = 0;
                        checkLoaded();
                    }, 50);
                }
            }
            inCheckLoaded = false;
        }
        Module = function(map) {
            this.events = getOwn(undefEvents, map.id) || {};
            this.map = map;
            this.shim = getOwn(config.shim, map.id);
            this.depExports = [];
            this.depMaps = [];
            this.depMatched = [];
            this.pluginMaps = {};
            this.depCount = 0;
        };
        Module.prototype = {
            init: function(depMaps, factory, errback, options) {
                options = options || {};
                if (this.inited) {
                    return;
                }
                this.factory = factory;
                if (errback) {
                    this.on("error", errback);
                } else if (this.events.error) {
                    errback = bind(this, function(err) {
                        this.emit("error", err);
                    });
                }
                this.depMaps = depMaps && depMaps.slice(0);
                this.errback = errback;
                this.inited = true;
                this.ignore = options.ignore;
                if (options.enabled || this.enabled) {
                    this.enable();
                } else {
                    this.check();
                }
            },
            defineDep: function(i, depExports) {
                if (!this.depMatched[i]) {
                    this.depMatched[i] = true;
                    this.depCount -= 1;
                    this.depExports[i] = depExports;
                }
            },
            fetch: function() {
                if (this.fetched) {
                    return;
                }
                this.fetched = true;
                context.startTime = new Date().getTime();
                var map = this.map;
                if (this.shim) {
                    context.makeRequire(this.map, {
                        enableBuildCallback: true
                    })(this.shim.deps || [], bind(this, function() {
                        return map.prefix ? this.callPlugin() : this.load();
                    }));
                } else {
                    return map.prefix ? this.callPlugin() : this.load();
                }
            },
            load: function() {
                var url = this.map.url;
                if (!urlFetched[url]) {
                    urlFetched[url] = true;
                    context.load(this.map.id, url);
                }
            },
            check: function() {
                if (!this.enabled || this.enabling) {
                    return;
                }
                var err, cjsModule, id = this.map.id, depExports = this.depExports, exports = this.exports, factory = this.factory;
                if (!this.inited) {
                    this.fetch();
                } else if (this.error) {
                    this.emit("error", this.error);
                } else if (!this.defining) {
                    this.defining = true;
                    if (this.depCount < 1 && !this.defined) {
                        if (isFunction(factory)) {
                            if (this.events.error && this.map.isDefine || req.onError !== defaultOnError) {
                                try {
                                    exports = context.execCb(id, factory, depExports, exports);
                                } catch (e) {
                                    err = e;
                                }
                            } else {
                                exports = context.execCb(id, factory, depExports, exports);
                            }
                            if (this.map.isDefine) {
                                cjsModule = this.module;
                                if (cjsModule && cjsModule.exports !== undefined && cjsModule.exports !== this.exports) {
                                    exports = cjsModule.exports;
                                } else if (exports === undefined && this.usingExports) {
                                    exports = this.exports;
                                }
                            }
                            if (err) {
                                err.requireMap = this.map;
                                err.requireModules = this.map.isDefine ? [ this.map.id ] : null;
                                err.requireType = this.map.isDefine ? "define" : "require";
                                return onError(this.error = err);
                            }
                        } else {
                            exports = factory;
                        }
                        this.exports = exports;
                        if (this.map.isDefine && !this.ignore) {
                            defined[id] = exports;
                            if (req.onResourceLoad) {
                                req.onResourceLoad(context, this.map, this.depMaps);
                            }
                        }
                        cleanRegistry(id);
                        this.defined = true;
                    }
                    this.defining = false;
                    if (this.defined && !this.defineEmitted) {
                        this.defineEmitted = true;
                        this.emit("defined", this.exports);
                        this.defineEmitComplete = true;
                    }
                }
            },
            callPlugin: function() {
                var map = this.map, id = map.id, pluginMap = makeModuleMap(map.prefix);
                this.depMaps.push(pluginMap);
                on(pluginMap, "defined", bind(this, function(plugin) {
                    var load, normalizedMap, normalizedMod, name = this.map.name, parentName = this.map.parentMap ? this.map.parentMap.name : null, localRequire = context.makeRequire(map.parentMap, {
                        enableBuildCallback: true
                    });
                    if (this.map.unnormalized) {
                        if (plugin.normalize) {
                            name = plugin.normalize(name, function(name) {
                                return normalize(name, parentName, true);
                            }) || "";
                        }
                        normalizedMap = makeModuleMap(map.prefix + "!" + name, this.map.parentMap);
                        on(normalizedMap, "defined", bind(this, function(value) {
                            this.init([], function() {
                                return value;
                            }, null, {
                                enabled: true,
                                ignore: true
                            });
                        }));
                        normalizedMod = getOwn(registry, normalizedMap.id);
                        if (normalizedMod) {
                            this.depMaps.push(normalizedMap);
                            if (this.events.error) {
                                normalizedMod.on("error", bind(this, function(err) {
                                    this.emit("error", err);
                                }));
                            }
                            normalizedMod.enable();
                        }
                        return;
                    }
                    load = bind(this, function(value) {
                        this.init([], function() {
                            return value;
                        }, null, {
                            enabled: true
                        });
                    });
                    load.error = bind(this, function(err) {
                        this.inited = true;
                        this.error = err;
                        err.requireModules = [ id ];
                        eachProp(registry, function(mod) {
                            if (mod.map.id.indexOf(id + "_unnormalized") === 0) {
                                cleanRegistry(mod.map.id);
                            }
                        });
                        onError(err);
                    });
                    load.fromText = bind(this, function(text, textAlt) {
                        var moduleName = map.name, moduleMap = makeModuleMap(moduleName), hasInteractive = useInteractive;
                        if (textAlt) {
                            text = textAlt;
                        }
                        if (hasInteractive) {
                            useInteractive = false;
                        }
                        getModule(moduleMap);
                        if (hasProp(config.config, id)) {
                            config.config[moduleName] = config.config[id];
                        }
                        try {
                            req.exec(text);
                        } catch (e) {
                            return onError(makeError("fromtexteval", "fromText eval for " + id + " failed: " + e, e, [ id ]));
                        }
                        if (hasInteractive) {
                            useInteractive = true;
                        }
                        this.depMaps.push(moduleMap);
                        context.completeLoad(moduleName);
                        localRequire([ moduleName ], load);
                    });
                    plugin.load(map.name, localRequire, load, config);
                }));
                context.enable(pluginMap, this);
                this.pluginMaps[pluginMap.id] = pluginMap;
            },
            enable: function() {
                enabledRegistry[this.map.id] = this;
                this.enabled = true;
                this.enabling = true;
                each(this.depMaps, bind(this, function(depMap, i) {
                    var id, mod, handler;
                    if (typeof depMap === "string") {
                        depMap = makeModuleMap(depMap, this.map.isDefine ? this.map : this.map.parentMap, false, !this.skipMap);
                        this.depMaps[i] = depMap;
                        handler = getOwn(handlers, depMap.id);
                        if (handler) {
                            this.depExports[i] = handler(this);
                            return;
                        }
                        this.depCount += 1;
                        on(depMap, "defined", bind(this, function(depExports) {
                            this.defineDep(i, depExports);
                            this.check();
                        }));
                        if (this.errback) {
                            on(depMap, "error", bind(this, this.errback));
                        }
                    }
                    id = depMap.id;
                    mod = registry[id];
                    if (!hasProp(handlers, id) && mod && !mod.enabled) {
                        context.enable(depMap, this);
                    }
                }));
                eachProp(this.pluginMaps, bind(this, function(pluginMap) {
                    var mod = getOwn(registry, pluginMap.id);
                    if (mod && !mod.enabled) {
                        context.enable(pluginMap, this);
                    }
                }));
                this.enabling = false;
                this.check();
            },
            on: function(name, cb) {
                var cbs = this.events[name];
                if (!cbs) {
                    cbs = this.events[name] = [];
                }
                cbs.push(cb);
            },
            emit: function(name, evt) {
                each(this.events[name], function(cb) {
                    cb(evt);
                });
                if (name === "error") {
                    delete this.events[name];
                }
            }
        };
        function callGetModule(args) {
            if (!hasProp(defined, args[0])) {
                getModule(makeModuleMap(args[0], null, true)).init(args[1], args[2]);
            }
        }
        function removeListener(node, func, name, ieName) {
            if (node.detachEvent && !isOpera) {
                if (ieName) {
                    node.detachEvent(ieName, func);
                }
            } else {
                node.removeEventListener(name, func, false);
            }
        }
        function getScriptData(evt) {
            var node = evt.currentTarget || evt.srcElement;
            removeListener(node, context.onScriptLoad, "load", "onreadystatechange");
            removeListener(node, context.onScriptError, "error");
            return {
                node: node,
                id: node && node.getAttribute("data-requiremodule")
            };
        }
        function intakeDefines() {
            var args;
            takeGlobalQueue();
            while (defQueue.length) {
                args = defQueue.shift();
                if (args[0] === null) {
                    return onError(makeError("mismatch", "Mismatched anonymous define() module: " + args[args.length - 1]));
                } else {
                    callGetModule(args);
                }
            }
        }
        context = {
            config: config,
            contextName: contextName,
            registry: registry,
            defined: defined,
            urlFetched: urlFetched,
            defQueue: defQueue,
            Module: Module,
            makeModuleMap: makeModuleMap,
            nextTick: req.nextTick,
            onError: onError,
            configure: function(cfg) {
                if (cfg.baseUrl) {
                    if (cfg.baseUrl.charAt(cfg.baseUrl.length - 1) !== "/") {
                        cfg.baseUrl += "/";
                    }
                }
                var pkgs = config.pkgs, shim = config.shim, objs = {
                    paths: true,
                    config: true,
                    map: true
                };
                eachProp(cfg, function(value, prop) {
                    if (objs[prop]) {
                        if (prop === "map") {
                            if (!config.map) {
                                config.map = {};
                            }
                            mixin(config[prop], value, true, true);
                        } else {
                            mixin(config[prop], value, true);
                        }
                    } else {
                        config[prop] = value;
                    }
                });
                if (cfg.shim) {
                    eachProp(cfg.shim, function(value, id) {
                        if (isArray(value)) {
                            value = {
                                deps: value
                            };
                        }
                        if ((value.exports || value.init) && !value.exportsFn) {
                            value.exportsFn = context.makeShimExports(value);
                        }
                        shim[id] = value;
                    });
                    config.shim = shim;
                }
                if (cfg.packages) {
                    each(cfg.packages, function(pkgObj) {
                        var location;
                        pkgObj = typeof pkgObj === "string" ? {
                            name: pkgObj
                        } : pkgObj;
                        location = pkgObj.location;
                        pkgs[pkgObj.name] = {
                            name: pkgObj.name,
                            location: location || pkgObj.name,
                            main: (pkgObj.main || "main").replace(currDirRegExp, "").replace(jsSuffixRegExp, "")
                        };
                    });
                    config.pkgs = pkgs;
                }
                eachProp(registry, function(mod, id) {
                    if (!mod.inited && !mod.map.unnormalized) {
                        mod.map = makeModuleMap(id);
                    }
                });
                if (cfg.deps || cfg.callback) {
                    context.require(cfg.deps || [], cfg.callback);
                }
            },
            makeShimExports: function(value) {
                function fn() {
                    var ret;
                    if (value.init) {
                        ret = value.init.apply(global, arguments);
                    }
                    return ret || value.exports && getGlobal(value.exports);
                }
                return fn;
            },
            makeRequire: function(relMap, options) {
                options = options || {};
                function localRequire(deps, callback, errback) {
                    var id, map, requireMod;
                    if (options.enableBuildCallback && callback && isFunction(callback)) {
                        callback.__requireJsBuild = true;
                    }
                    if (typeof deps === "string") {
                        if (isFunction(callback)) {
                            return onError(makeError("requireargs", "Invalid require call"), errback);
                        }
                        if (relMap && hasProp(handlers, deps)) {
                            return handlers[deps](registry[relMap.id]);
                        }
                        if (req.get) {
                            return req.get(context, deps, relMap, localRequire);
                        }
                        map = makeModuleMap(deps, relMap, false, true);
                        id = map.id;
                        if (!hasProp(defined, id)) {
                            return onError(makeError("notloaded", 'Module name "' + id + '" has not been loaded yet for context: ' + contextName + (relMap ? "" : ". Use require([])")));
                        }
                        return defined[id];
                    }
                    intakeDefines();
                    context.nextTick(function() {
                        intakeDefines();
                        requireMod = getModule(makeModuleMap(null, relMap));
                        requireMod.skipMap = options.skipMap;
                        requireMod.init(deps, callback, errback, {
                            enabled: true
                        });
                        checkLoaded();
                    });
                    return localRequire;
                }
                mixin(localRequire, {
                    isBrowser: isBrowser,
                    toUrl: function(moduleNamePlusExt) {
                        var ext, index = moduleNamePlusExt.lastIndexOf("."), segment = moduleNamePlusExt.split("/")[0], isRelative = segment === "." || segment === "..";
                        if (index !== -1 && (!isRelative || index > 1)) {
                            ext = moduleNamePlusExt.substring(index, moduleNamePlusExt.length);
                            moduleNamePlusExt = moduleNamePlusExt.substring(0, index);
                        }
                        return context.nameToUrl(normalize(moduleNamePlusExt, relMap && relMap.id, true), ext, true);
                    },
                    defined: function(id) {
                        return hasProp(defined, makeModuleMap(id, relMap, false, true).id);
                    },
                    specified: function(id) {
                        id = makeModuleMap(id, relMap, false, true).id;
                        return hasProp(defined, id) || hasProp(registry, id);
                    }
                });
                if (!relMap) {
                    localRequire.undef = function(id) {
                        takeGlobalQueue();
                        var map = makeModuleMap(id, relMap, true), mod = getOwn(registry, id);
                        delete defined[id];
                        delete urlFetched[map.url];
                        delete undefEvents[id];
                        if (mod) {
                            if (mod.events.defined) {
                                undefEvents[id] = mod.events;
                            }
                            cleanRegistry(id);
                        }
                    };
                }
                return localRequire;
            },
            enable: function(depMap) {
                var mod = getOwn(registry, depMap.id);
                if (mod) {
                    getModule(depMap).enable();
                }
            },
            completeLoad: function(moduleName) {
                var found, args, mod, shim = getOwn(config.shim, moduleName) || {}, shExports = shim.exports;
                takeGlobalQueue();
                while (defQueue.length) {
                    args = defQueue.shift();
                    if (args[0] === null) {
                        args[0] = moduleName;
                        if (found) {
                            break;
                        }
                        found = true;
                    } else if (args[0] === moduleName) {
                        found = true;
                    }
                    callGetModule(args);
                }
                mod = getOwn(registry, moduleName);
                if (!found && !hasProp(defined, moduleName) && mod && !mod.inited) {
                    if (config.enforceDefine && (!shExports || !getGlobal(shExports))) {
                        if (hasPathFallback(moduleName)) {
                            return;
                        } else {
                            return onError(makeError("nodefine", "No define call for " + moduleName, null, [ moduleName ]));
                        }
                    } else {
                        callGetModule([ moduleName, shim.deps || [], shim.exportsFn ]);
                    }
                }
                checkLoaded();
            },
            nameToUrl: function(moduleName, ext, skipExt) {
                var paths, pkgs, pkg, pkgPath, syms, i, parentModule, url, parentPath;
                if (req.jsExtRegExp.test(moduleName)) {
                    url = moduleName + (ext || "");
                } else {
                    paths = config.paths;
                    pkgs = config.pkgs;
                    syms = moduleName.split("/");
                    for (i = syms.length; i > 0; i -= 1) {
                        parentModule = syms.slice(0, i).join("/");
                        pkg = getOwn(pkgs, parentModule);
                        parentPath = getOwn(paths, parentModule);
                        if (parentPath) {
                            if (isArray(parentPath)) {
                                parentPath = parentPath[0];
                            }
                            syms.splice(0, i, parentPath);
                            break;
                        } else if (pkg) {
                            if (moduleName === pkg.name) {
                                pkgPath = pkg.location + "/" + pkg.main;
                            } else {
                                pkgPath = pkg.location;
                            }
                            syms.splice(0, i, pkgPath);
                            break;
                        }
                    }
                    url = syms.join("/");
                    url += ext || (/\?/.test(url) || skipExt ? "" : ".js");
                    url = (url.charAt(0) === "/" || url.match(/^[\w\+\.\-]+:/) ? "" : config.baseUrl) + url;
                }
                return config.urlArgs ? url + ((url.indexOf("?") === -1 ? "?" : "&") + config.urlArgs) : url;
            },
            load: function(id, url) {
                req.load(context, id, url);
            },
            execCb: function(name, callback, args, exports) {
                return callback.apply(exports, args);
            },
            onScriptLoad: function(evt) {
                if (evt.type === "load" || readyRegExp.test((evt.currentTarget || evt.srcElement).readyState)) {
                    interactiveScript = null;
                    var data = getScriptData(evt);
                    context.completeLoad(data.id);
                }
            },
            onScriptError: function(evt) {
                var data = getScriptData(evt);
                if (!hasPathFallback(data.id)) {
                    return onError(makeError("scripterror", "Script error for: " + data.id, evt, [ data.id ]));
                }
            }
        };
        context.require = context.makeRequire();
        return context;
    }
    req = requirejs = function(deps, callback, errback, optional) {
        var context, config, contextName = defContextName;
        if (!isArray(deps) && typeof deps !== "string") {
            config = deps;
            if (isArray(callback)) {
                deps = callback;
                callback = errback;
                errback = optional;
            } else {
                deps = [];
            }
        }
        if (config && config.context) {
            contextName = config.context;
        }
        context = getOwn(contexts, contextName);
        if (!context) {
            context = contexts[contextName] = req.s.newContext(contextName);
        }
        if (config) {
            context.configure(config);
        }
        return context.require(deps, callback, errback);
    };
    req.config = function(config) {
        return req(config);
    };
    req.nextTick = typeof setTimeout !== "undefined" ? function(fn) {
        setTimeout(fn, 4);
    } : function(fn) {
        fn();
    };
    if (!require) {
        require = req;
    }
    req.version = version;
    req.jsExtRegExp = /^\/|:|\?|\.js$/;
    req.isBrowser = isBrowser;
    s = req.s = {
        contexts: contexts,
        newContext: newContext
    };
    req({});
    each([ "toUrl", "undef", "defined", "specified" ], function(prop) {
        req[prop] = function() {
            var ctx = contexts[defContextName];
            return ctx.require[prop].apply(ctx, arguments);
        };
    });
    if (isBrowser) {
        head = s.head = document.getElementsByTagName("head")[0];
        baseElement = document.getElementsByTagName("base")[0];
        if (baseElement) {
            head = s.head = baseElement.parentNode;
        }
    }
    req.onError = defaultOnError;
    req.load = function(context, moduleName, url) {
        var config = context && context.config || {}, node;
        if (isBrowser) {
            node = config.xhtml ? document.createElementNS("http://www.w3.org/1999/xhtml", "html:script") : document.createElement("script");
            node.type = config.scriptType || "text/javascript";
            node.charset = "utf-8";
            node.async = true;
            node.setAttribute("data-requirecontext", context.contextName);
            node.setAttribute("data-requiremodule", moduleName);
            if (node.attachEvent && !(node.attachEvent.toString && node.attachEvent.toString().indexOf("[native code") < 0) && !isOpera) {
                useInteractive = true;
                node.attachEvent("onreadystatechange", context.onScriptLoad);
            } else {
                node.addEventListener("load", context.onScriptLoad, false);
                node.addEventListener("error", context.onScriptError, false);
            }
            node.src = url;
            currentlyAddingScript = node;
            if (baseElement) {
                head.insertBefore(node, baseElement);
            } else {
                head.appendChild(node);
            }
            currentlyAddingScript = null;
            return node;
        } else if (isWebWorker) {
            try {
                importScripts(url);
                context.completeLoad(moduleName);
            } catch (e) {
                context.onError(makeError("importscripts", "importScripts failed for " + moduleName + " at " + url, e, [ moduleName ]));
            }
        }
    };
    function getInteractiveScript() {
        if (interactiveScript && interactiveScript.readyState === "interactive") {
            return interactiveScript;
        }
        eachReverse(scripts(), function(script) {
            if (script.readyState === "interactive") {
                return interactiveScript = script;
            }
        });
        return interactiveScript;
    }
    if (isBrowser) {
        eachReverse(scripts(), function(script) {
            if (!head) {
                head = script.parentNode;
            }
            dataMain = script.getAttribute("data-main");
            if (dataMain) {
                mainScript = dataMain;
                if (!cfg.baseUrl) {
                    src = mainScript.split("/");
                    mainScript = src.pop();
                    subPath = src.length ? src.join("/") + "/" : "./";
                    cfg.baseUrl = subPath;
                }
                mainScript = mainScript.replace(jsSuffixRegExp, "");
                if (req.jsExtRegExp.test(mainScript)) {
                    mainScript = dataMain;
                }
                cfg.deps = cfg.deps ? cfg.deps.concat(mainScript) : [ mainScript ];
                return true;
            }
        });
    }
    define = function(name, deps, callback) {
        var node, context;
        if (typeof name !== "string") {
            callback = deps;
            deps = name;
            name = null;
        }
        if (!isArray(deps)) {
            callback = deps;
            deps = null;
        }
        if (!deps && isFunction(callback)) {
            deps = [];
            if (callback.length) {
                callback.toString().replace(commentRegExp, "").replace(cjsRequireRegExp, function(match, dep) {
                    deps.push(dep);
                });
                deps = (callback.length === 1 ? [ "require" ] : [ "require", "exports", "module" ]).concat(deps);
            }
        }
        if (useInteractive) {
            node = currentlyAddingScript || getInteractiveScript();
            if (node) {
                if (!name) {
                    name = node.getAttribute("data-requiremodule");
                }
                context = contexts[node.getAttribute("data-requirecontext")];
            }
        }
        (context ? context.defQueue : globalDefQueue).push([ name, deps, callback ]);
    };
    define.amd = {
        jQuery: true
    };
    req.exec = function(text) {
        return eval(text);
    };
    req(cfg);
})(this);

/*!
 * jQuery JavaScript Library v1.11.0
 * http://jquery.com/
 *
 * Includes Sizzle.js
 * http://sizzlejs.com/
 *
 * Copyright 2005, 2014 jQuery Foundation, Inc. and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2014-01-23T21:02Z
 */
(function(global, factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        module.exports = global.document ? factory(global, true) : function(w) {
            if (!w.document) {
                throw new Error("jQuery requires a window with a document");
            }
            return factory(w);
        };
    } else {
        factory(global);
    }
})(typeof window !== "undefined" ? window : this, function(window, noGlobal) {
    var deletedIds = [];
    var slice = deletedIds.slice;
    var concat = deletedIds.concat;
    var push = deletedIds.push;
    var indexOf = deletedIds.indexOf;
    var class2type = {};
    var toString = class2type.toString;
    var hasOwn = class2type.hasOwnProperty;
    var trim = "".trim;
    var support = {};
    var version = "1.11.0", jQuery = function(selector, context) {
        return new jQuery.fn.init(selector, context);
    }, rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, rmsPrefix = /^-ms-/, rdashAlpha = /-([\da-z])/gi, fcamelCase = function(all, letter) {
        return letter.toUpperCase();
    };
    jQuery.fn = jQuery.prototype = {
        jquery: version,
        constructor: jQuery,
        selector: "",
        length: 0,
        toArray: function() {
            return slice.call(this);
        },
        get: function(num) {
            return num != null ? num < 0 ? this[num + this.length] : this[num] : slice.call(this);
        },
        pushStack: function(elems) {
            var ret = jQuery.merge(this.constructor(), elems);
            ret.prevObject = this;
            ret.context = this.context;
            return ret;
        },
        each: function(callback, args) {
            return jQuery.each(this, callback, args);
        },
        map: function(callback) {
            return this.pushStack(jQuery.map(this, function(elem, i) {
                return callback.call(elem, i, elem);
            }));
        },
        slice: function() {
            return this.pushStack(slice.apply(this, arguments));
        },
        first: function() {
            return this.eq(0);
        },
        last: function() {
            return this.eq(-1);
        },
        eq: function(i) {
            var len = this.length, j = +i + (i < 0 ? len : 0);
            return this.pushStack(j >= 0 && j < len ? [ this[j] ] : []);
        },
        end: function() {
            return this.prevObject || this.constructor(null);
        },
        push: push,
        sort: deletedIds.sort,
        splice: deletedIds.splice
    };
    jQuery.extend = jQuery.fn.extend = function() {
        var src, copyIsArray, copy, name, options, clone, target = arguments[0] || {}, i = 1, length = arguments.length, deep = false;
        if (typeof target === "boolean") {
            deep = target;
            target = arguments[i] || {};
            i++;
        }
        if (typeof target !== "object" && !jQuery.isFunction(target)) {
            target = {};
        }
        if (i === length) {
            target = this;
            i--;
        }
        for (;i < length; i++) {
            if ((options = arguments[i]) != null) {
                for (name in options) {
                    src = target[name];
                    copy = options[name];
                    if (target === copy) {
                        continue;
                    }
                    if (deep && copy && (jQuery.isPlainObject(copy) || (copyIsArray = jQuery.isArray(copy)))) {
                        if (copyIsArray) {
                            copyIsArray = false;
                            clone = src && jQuery.isArray(src) ? src : [];
                        } else {
                            clone = src && jQuery.isPlainObject(src) ? src : {};
                        }
                        target[name] = jQuery.extend(deep, clone, copy);
                    } else if (copy !== undefined) {
                        target[name] = copy;
                    }
                }
            }
        }
        return target;
    };
    jQuery.extend({
        expando: "jQuery" + (version + Math.random()).replace(/\D/g, ""),
        isReady: true,
        error: function(msg) {
            throw new Error(msg);
        },
        noop: function() {},
        isFunction: function(obj) {
            return jQuery.type(obj) === "function";
        },
        isArray: Array.isArray || function(obj) {
            return jQuery.type(obj) === "array";
        },
        isWindow: function(obj) {
            return obj != null && obj == obj.window;
        },
        isNumeric: function(obj) {
            return obj - parseFloat(obj) >= 0;
        },
        isEmptyObject: function(obj) {
            var name;
            for (name in obj) {
                return false;
            }
            return true;
        },
        isPlainObject: function(obj) {
            var key;
            if (!obj || jQuery.type(obj) !== "object" || obj.nodeType || jQuery.isWindow(obj)) {
                return false;
            }
            try {
                if (obj.constructor && !hasOwn.call(obj, "constructor") && !hasOwn.call(obj.constructor.prototype, "isPrototypeOf")) {
                    return false;
                }
            } catch (e) {
                return false;
            }
            if (support.ownLast) {
                for (key in obj) {
                    return hasOwn.call(obj, key);
                }
            }
            for (key in obj) {}
            return key === undefined || hasOwn.call(obj, key);
        },
        type: function(obj) {
            if (obj == null) {
                return obj + "";
            }
            return typeof obj === "object" || typeof obj === "function" ? class2type[toString.call(obj)] || "object" : typeof obj;
        },
        globalEval: function(data) {
            if (data && jQuery.trim(data)) {
                (window.execScript || function(data) {
                    window["eval"].call(window, data);
                })(data);
            }
        },
        camelCase: function(string) {
            return string.replace(rmsPrefix, "ms-").replace(rdashAlpha, fcamelCase);
        },
        nodeName: function(elem, name) {
            return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();
        },
        each: function(obj, callback, args) {
            var value, i = 0, length = obj.length, isArray = isArraylike(obj);
            if (args) {
                if (isArray) {
                    for (;i < length; i++) {
                        value = callback.apply(obj[i], args);
                        if (value === false) {
                            break;
                        }
                    }
                } else {
                    for (i in obj) {
                        value = callback.apply(obj[i], args);
                        if (value === false) {
                            break;
                        }
                    }
                }
            } else {
                if (isArray) {
                    for (;i < length; i++) {
                        value = callback.call(obj[i], i, obj[i]);
                        if (value === false) {
                            break;
                        }
                    }
                } else {
                    for (i in obj) {
                        value = callback.call(obj[i], i, obj[i]);
                        if (value === false) {
                            break;
                        }
                    }
                }
            }
            return obj;
        },
        trim: trim && !trim.call(" ") ? function(text) {
            return text == null ? "" : trim.call(text);
        } : function(text) {
            return text == null ? "" : (text + "").replace(rtrim, "");
        },
        makeArray: function(arr, results) {
            var ret = results || [];
            if (arr != null) {
                if (isArraylike(Object(arr))) {
                    jQuery.merge(ret, typeof arr === "string" ? [ arr ] : arr);
                } else {
                    push.call(ret, arr);
                }
            }
            return ret;
        },
        inArray: function(elem, arr, i) {
            var len;
            if (arr) {
                if (indexOf) {
                    return indexOf.call(arr, elem, i);
                }
                len = arr.length;
                i = i ? i < 0 ? Math.max(0, len + i) : i : 0;
                for (;i < len; i++) {
                    if (i in arr && arr[i] === elem) {
                        return i;
                    }
                }
            }
            return -1;
        },
        merge: function(first, second) {
            var len = +second.length, j = 0, i = first.length;
            while (j < len) {
                first[i++] = second[j++];
            }
            if (len !== len) {
                while (second[j] !== undefined) {
                    first[i++] = second[j++];
                }
            }
            first.length = i;
            return first;
        },
        grep: function(elems, callback, invert) {
            var callbackInverse, matches = [], i = 0, length = elems.length, callbackExpect = !invert;
            for (;i < length; i++) {
                callbackInverse = !callback(elems[i], i);
                if (callbackInverse !== callbackExpect) {
                    matches.push(elems[i]);
                }
            }
            return matches;
        },
        map: function(elems, callback, arg) {
            var value, i = 0, length = elems.length, isArray = isArraylike(elems), ret = [];
            if (isArray) {
                for (;i < length; i++) {
                    value = callback(elems[i], i, arg);
                    if (value != null) {
                        ret.push(value);
                    }
                }
            } else {
                for (i in elems) {
                    value = callback(elems[i], i, arg);
                    if (value != null) {
                        ret.push(value);
                    }
                }
            }
            return concat.apply([], ret);
        },
        guid: 1,
        proxy: function(fn, context) {
            var args, proxy, tmp;
            if (typeof context === "string") {
                tmp = fn[context];
                context = fn;
                fn = tmp;
            }
            if (!jQuery.isFunction(fn)) {
                return undefined;
            }
            args = slice.call(arguments, 2);
            proxy = function() {
                return fn.apply(context || this, args.concat(slice.call(arguments)));
            };
            proxy.guid = fn.guid = fn.guid || jQuery.guid++;
            return proxy;
        },
        now: function() {
            return +new Date();
        },
        support: support
    });
    jQuery.each("Boolean Number String Function Array Date RegExp Object Error".split(" "), function(i, name) {
        class2type["[object " + name + "]"] = name.toLowerCase();
    });
    function isArraylike(obj) {
        var length = obj.length, type = jQuery.type(obj);
        if (type === "function" || jQuery.isWindow(obj)) {
            return false;
        }
        if (obj.nodeType === 1 && length) {
            return true;
        }
        return type === "array" || length === 0 || typeof length === "number" && length > 0 && length - 1 in obj;
    }
    var Sizzle = /*!
 * Sizzle CSS Selector Engine v1.10.16
 * http://sizzlejs.com/
 *
 * Copyright 2013 jQuery Foundation, Inc. and other contributors
 * Released under the MIT license
 * http://jquery.org/license
 *
 * Date: 2014-01-13
 */
    function(window) {
        var i, support, Expr, getText, isXML, compile, outermostContext, sortInput, hasDuplicate, setDocument, document, docElem, documentIsHTML, rbuggyQSA, rbuggyMatches, matches, contains, expando = "sizzle" + -new Date(), preferredDoc = window.document, dirruns = 0, done = 0, classCache = createCache(), tokenCache = createCache(), compilerCache = createCache(), sortOrder = function(a, b) {
            if (a === b) {
                hasDuplicate = true;
            }
            return 0;
        }, strundefined = typeof undefined, MAX_NEGATIVE = 1 << 31, hasOwn = {}.hasOwnProperty, arr = [], pop = arr.pop, push_native = arr.push, push = arr.push, slice = arr.slice, indexOf = arr.indexOf || function(elem) {
            var i = 0, len = this.length;
            for (;i < len; i++) {
                if (this[i] === elem) {
                    return i;
                }
            }
            return -1;
        }, booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped", whitespace = "[\\x20\\t\\r\\n\\f]", characterEncoding = "(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+", identifier = characterEncoding.replace("w", "w#"), attributes = "\\[" + whitespace + "*(" + characterEncoding + ")" + whitespace + "*(?:([*^$|!~]?=)" + whitespace + "*(?:(['\"])((?:\\\\.|[^\\\\])*?)\\3|(" + identifier + ")|)|)" + whitespace + "*\\]", pseudos = ":(" + characterEncoding + ")(?:\\(((['\"])((?:\\\\.|[^\\\\])*?)\\3|((?:\\\\.|[^\\\\()[\\]]|" + attributes.replace(3, 8) + ")*)|.*)\\)|)", rtrim = new RegExp("^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g"), rcomma = new RegExp("^" + whitespace + "*," + whitespace + "*"), rcombinators = new RegExp("^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*"), rattributeQuotes = new RegExp("=" + whitespace + "*([^\\]'\"]*?)" + whitespace + "*\\]", "g"), rpseudo = new RegExp(pseudos), ridentifier = new RegExp("^" + identifier + "$"), matchExpr = {
            ID: new RegExp("^#(" + characterEncoding + ")"),
            CLASS: new RegExp("^\\.(" + characterEncoding + ")"),
            TAG: new RegExp("^(" + characterEncoding.replace("w", "w*") + ")"),
            ATTR: new RegExp("^" + attributes),
            PSEUDO: new RegExp("^" + pseudos),
            CHILD: new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i"),
            bool: new RegExp("^(?:" + booleans + ")$", "i"),
            needsContext: new RegExp("^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i")
        }, rinputs = /^(?:input|select|textarea|button)$/i, rheader = /^h\d$/i, rnative = /^[^{]+\{\s*\[native \w/, rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/, rsibling = /[+~]/, rescape = /'|\\/g, runescape = new RegExp("\\\\([\\da-f]{1,6}" + whitespace + "?|(" + whitespace + ")|.)", "ig"), funescape = function(_, escaped, escapedWhitespace) {
            var high = "0x" + escaped - 65536;
            return high !== high || escapedWhitespace ? escaped : high < 0 ? String.fromCharCode(high + 65536) : String.fromCharCode(high >> 10 | 55296, high & 1023 | 56320);
        };
        try {
            push.apply(arr = slice.call(preferredDoc.childNodes), preferredDoc.childNodes);
            arr[preferredDoc.childNodes.length].nodeType;
        } catch (e) {
            push = {
                apply: arr.length ? function(target, els) {
                    push_native.apply(target, slice.call(els));
                } : function(target, els) {
                    var j = target.length, i = 0;
                    while (target[j++] = els[i++]) {}
                    target.length = j - 1;
                }
            };
        }
        function Sizzle(selector, context, results, seed) {
            var match, elem, m, nodeType, i, groups, old, nid, newContext, newSelector;
            if ((context ? context.ownerDocument || context : preferredDoc) !== document) {
                setDocument(context);
            }
            context = context || document;
            results = results || [];
            if (!selector || typeof selector !== "string") {
                return results;
            }
            if ((nodeType = context.nodeType) !== 1 && nodeType !== 9) {
                return [];
            }
            if (documentIsHTML && !seed) {
                if (match = rquickExpr.exec(selector)) {
                    if (m = match[1]) {
                        if (nodeType === 9) {
                            elem = context.getElementById(m);
                            if (elem && elem.parentNode) {
                                if (elem.id === m) {
                                    results.push(elem);
                                    return results;
                                }
                            } else {
                                return results;
                            }
                        } else {
                            if (context.ownerDocument && (elem = context.ownerDocument.getElementById(m)) && contains(context, elem) && elem.id === m) {
                                results.push(elem);
                                return results;
                            }
                        }
                    } else if (match[2]) {
                        push.apply(results, context.getElementsByTagName(selector));
                        return results;
                    } else if ((m = match[3]) && support.getElementsByClassName && context.getElementsByClassName) {
                        push.apply(results, context.getElementsByClassName(m));
                        return results;
                    }
                }
                if (support.qsa && (!rbuggyQSA || !rbuggyQSA.test(selector))) {
                    nid = old = expando;
                    newContext = context;
                    newSelector = nodeType === 9 && selector;
                    if (nodeType === 1 && context.nodeName.toLowerCase() !== "object") {
                        groups = tokenize(selector);
                        if (old = context.getAttribute("id")) {
                            nid = old.replace(rescape, "\\$&");
                        } else {
                            context.setAttribute("id", nid);
                        }
                        nid = "[id='" + nid + "'] ";
                        i = groups.length;
                        while (i--) {
                            groups[i] = nid + toSelector(groups[i]);
                        }
                        newContext = rsibling.test(selector) && testContext(context.parentNode) || context;
                        newSelector = groups.join(",");
                    }
                    if (newSelector) {
                        try {
                            push.apply(results, newContext.querySelectorAll(newSelector));
                            return results;
                        } catch (qsaError) {} finally {
                            if (!old) {
                                context.removeAttribute("id");
                            }
                        }
                    }
                }
            }
            return select(selector.replace(rtrim, "$1"), context, results, seed);
        }
        function createCache() {
            var keys = [];
            function cache(key, value) {
                if (keys.push(key + " ") > Expr.cacheLength) {
                    delete cache[keys.shift()];
                }
                return cache[key + " "] = value;
            }
            return cache;
        }
        function markFunction(fn) {
            fn[expando] = true;
            return fn;
        }
        function assert(fn) {
            var div = document.createElement("div");
            try {
                return !!fn(div);
            } catch (e) {
                return false;
            } finally {
                if (div.parentNode) {
                    div.parentNode.removeChild(div);
                }
                div = null;
            }
        }
        function addHandle(attrs, handler) {
            var arr = attrs.split("|"), i = attrs.length;
            while (i--) {
                Expr.attrHandle[arr[i]] = handler;
            }
        }
        function siblingCheck(a, b) {
            var cur = b && a, diff = cur && a.nodeType === 1 && b.nodeType === 1 && (~b.sourceIndex || MAX_NEGATIVE) - (~a.sourceIndex || MAX_NEGATIVE);
            if (diff) {
                return diff;
            }
            if (cur) {
                while (cur = cur.nextSibling) {
                    if (cur === b) {
                        return -1;
                    }
                }
            }
            return a ? 1 : -1;
        }
        function createInputPseudo(type) {
            return function(elem) {
                var name = elem.nodeName.toLowerCase();
                return name === "input" && elem.type === type;
            };
        }
        function createButtonPseudo(type) {
            return function(elem) {
                var name = elem.nodeName.toLowerCase();
                return (name === "input" || name === "button") && elem.type === type;
            };
        }
        function createPositionalPseudo(fn) {
            return markFunction(function(argument) {
                argument = +argument;
                return markFunction(function(seed, matches) {
                    var j, matchIndexes = fn([], seed.length, argument), i = matchIndexes.length;
                    while (i--) {
                        if (seed[j = matchIndexes[i]]) {
                            seed[j] = !(matches[j] = seed[j]);
                        }
                    }
                });
            });
        }
        function testContext(context) {
            return context && typeof context.getElementsByTagName !== strundefined && context;
        }
        support = Sizzle.support = {};
        isXML = Sizzle.isXML = function(elem) {
            var documentElement = elem && (elem.ownerDocument || elem).documentElement;
            return documentElement ? documentElement.nodeName !== "HTML" : false;
        };
        setDocument = Sizzle.setDocument = function(node) {
            var hasCompare, doc = node ? node.ownerDocument || node : preferredDoc, parent = doc.defaultView;
            if (doc === document || doc.nodeType !== 9 || !doc.documentElement) {
                return document;
            }
            document = doc;
            docElem = doc.documentElement;
            documentIsHTML = !isXML(doc);
            if (parent && parent !== parent.top) {
                if (parent.addEventListener) {
                    parent.addEventListener("unload", function() {
                        setDocument();
                    }, false);
                } else if (parent.attachEvent) {
                    parent.attachEvent("onunload", function() {
                        setDocument();
                    });
                }
            }
            support.attributes = assert(function(div) {
                div.className = "i";
                return !div.getAttribute("className");
            });
            support.getElementsByTagName = assert(function(div) {
                div.appendChild(doc.createComment(""));
                return !div.getElementsByTagName("*").length;
            });
            support.getElementsByClassName = rnative.test(doc.getElementsByClassName) && assert(function(div) {
                div.innerHTML = "<div class='a'></div><div class='a i'></div>";
                div.firstChild.className = "i";
                return div.getElementsByClassName("i").length === 2;
            });
            support.getById = assert(function(div) {
                docElem.appendChild(div).id = expando;
                return !doc.getElementsByName || !doc.getElementsByName(expando).length;
            });
            if (support.getById) {
                Expr.find["ID"] = function(id, context) {
                    if (typeof context.getElementById !== strundefined && documentIsHTML) {
                        var m = context.getElementById(id);
                        return m && m.parentNode ? [ m ] : [];
                    }
                };
                Expr.filter["ID"] = function(id) {
                    var attrId = id.replace(runescape, funescape);
                    return function(elem) {
                        return elem.getAttribute("id") === attrId;
                    };
                };
            } else {
                delete Expr.find["ID"];
                Expr.filter["ID"] = function(id) {
                    var attrId = id.replace(runescape, funescape);
                    return function(elem) {
                        var node = typeof elem.getAttributeNode !== strundefined && elem.getAttributeNode("id");
                        return node && node.value === attrId;
                    };
                };
            }
            Expr.find["TAG"] = support.getElementsByTagName ? function(tag, context) {
                if (typeof context.getElementsByTagName !== strundefined) {
                    return context.getElementsByTagName(tag);
                }
            } : function(tag, context) {
                var elem, tmp = [], i = 0, results = context.getElementsByTagName(tag);
                if (tag === "*") {
                    while (elem = results[i++]) {
                        if (elem.nodeType === 1) {
                            tmp.push(elem);
                        }
                    }
                    return tmp;
                }
                return results;
            };
            Expr.find["CLASS"] = support.getElementsByClassName && function(className, context) {
                if (typeof context.getElementsByClassName !== strundefined && documentIsHTML) {
                    return context.getElementsByClassName(className);
                }
            };
            rbuggyMatches = [];
            rbuggyQSA = [];
            if (support.qsa = rnative.test(doc.querySelectorAll)) {
                assert(function(div) {
                    div.innerHTML = "<select t=''><option selected=''></option></select>";
                    if (div.querySelectorAll("[t^='']").length) {
                        rbuggyQSA.push("[*^$]=" + whitespace + "*(?:''|\"\")");
                    }
                    if (!div.querySelectorAll("[selected]").length) {
                        rbuggyQSA.push("\\[" + whitespace + "*(?:value|" + booleans + ")");
                    }
                    if (!div.querySelectorAll(":checked").length) {
                        rbuggyQSA.push(":checked");
                    }
                });
                assert(function(div) {
                    var input = doc.createElement("input");
                    input.setAttribute("type", "hidden");
                    div.appendChild(input).setAttribute("name", "D");
                    if (div.querySelectorAll("[name=d]").length) {
                        rbuggyQSA.push("name" + whitespace + "*[*^$|!~]?=");
                    }
                    if (!div.querySelectorAll(":enabled").length) {
                        rbuggyQSA.push(":enabled", ":disabled");
                    }
                    div.querySelectorAll("*,:x");
                    rbuggyQSA.push(",.*:");
                });
            }
            if (support.matchesSelector = rnative.test(matches = docElem.webkitMatchesSelector || docElem.mozMatchesSelector || docElem.oMatchesSelector || docElem.msMatchesSelector)) {
                assert(function(div) {
                    support.disconnectedMatch = matches.call(div, "div");
                    matches.call(div, "[s!='']:x");
                    rbuggyMatches.push("!=", pseudos);
                });
            }
            rbuggyQSA = rbuggyQSA.length && new RegExp(rbuggyQSA.join("|"));
            rbuggyMatches = rbuggyMatches.length && new RegExp(rbuggyMatches.join("|"));
            hasCompare = rnative.test(docElem.compareDocumentPosition);
            contains = hasCompare || rnative.test(docElem.contains) ? function(a, b) {
                var adown = a.nodeType === 9 ? a.documentElement : a, bup = b && b.parentNode;
                return a === bup || !!(bup && bup.nodeType === 1 && (adown.contains ? adown.contains(bup) : a.compareDocumentPosition && a.compareDocumentPosition(bup) & 16));
            } : function(a, b) {
                if (b) {
                    while (b = b.parentNode) {
                        if (b === a) {
                            return true;
                        }
                    }
                }
                return false;
            };
            sortOrder = hasCompare ? function(a, b) {
                if (a === b) {
                    hasDuplicate = true;
                    return 0;
                }
                var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
                if (compare) {
                    return compare;
                }
                compare = (a.ownerDocument || a) === (b.ownerDocument || b) ? a.compareDocumentPosition(b) : 1;
                if (compare & 1 || !support.sortDetached && b.compareDocumentPosition(a) === compare) {
                    if (a === doc || a.ownerDocument === preferredDoc && contains(preferredDoc, a)) {
                        return -1;
                    }
                    if (b === doc || b.ownerDocument === preferredDoc && contains(preferredDoc, b)) {
                        return 1;
                    }
                    return sortInput ? indexOf.call(sortInput, a) - indexOf.call(sortInput, b) : 0;
                }
                return compare & 4 ? -1 : 1;
            } : function(a, b) {
                if (a === b) {
                    hasDuplicate = true;
                    return 0;
                }
                var cur, i = 0, aup = a.parentNode, bup = b.parentNode, ap = [ a ], bp = [ b ];
                if (!aup || !bup) {
                    return a === doc ? -1 : b === doc ? 1 : aup ? -1 : bup ? 1 : sortInput ? indexOf.call(sortInput, a) - indexOf.call(sortInput, b) : 0;
                } else if (aup === bup) {
                    return siblingCheck(a, b);
                }
                cur = a;
                while (cur = cur.parentNode) {
                    ap.unshift(cur);
                }
                cur = b;
                while (cur = cur.parentNode) {
                    bp.unshift(cur);
                }
                while (ap[i] === bp[i]) {
                    i++;
                }
                return i ? siblingCheck(ap[i], bp[i]) : ap[i] === preferredDoc ? -1 : bp[i] === preferredDoc ? 1 : 0;
            };
            return doc;
        };
        Sizzle.matches = function(expr, elements) {
            return Sizzle(expr, null, null, elements);
        };
        Sizzle.matchesSelector = function(elem, expr) {
            if ((elem.ownerDocument || elem) !== document) {
                setDocument(elem);
            }
            expr = expr.replace(rattributeQuotes, "='$1']");
            if (support.matchesSelector && documentIsHTML && (!rbuggyMatches || !rbuggyMatches.test(expr)) && (!rbuggyQSA || !rbuggyQSA.test(expr))) {
                try {
                    var ret = matches.call(elem, expr);
                    if (ret || support.disconnectedMatch || elem.document && elem.document.nodeType !== 11) {
                        return ret;
                    }
                } catch (e) {}
            }
            return Sizzle(expr, document, null, [ elem ]).length > 0;
        };
        Sizzle.contains = function(context, elem) {
            if ((context.ownerDocument || context) !== document) {
                setDocument(context);
            }
            return contains(context, elem);
        };
        Sizzle.attr = function(elem, name) {
            if ((elem.ownerDocument || elem) !== document) {
                setDocument(elem);
            }
            var fn = Expr.attrHandle[name.toLowerCase()], val = fn && hasOwn.call(Expr.attrHandle, name.toLowerCase()) ? fn(elem, name, !documentIsHTML) : undefined;
            return val !== undefined ? val : support.attributes || !documentIsHTML ? elem.getAttribute(name) : (val = elem.getAttributeNode(name)) && val.specified ? val.value : null;
        };
        Sizzle.error = function(msg) {
            throw new Error("Syntax error, unrecognized expression: " + msg);
        };
        Sizzle.uniqueSort = function(results) {
            var elem, duplicates = [], j = 0, i = 0;
            hasDuplicate = !support.detectDuplicates;
            sortInput = !support.sortStable && results.slice(0);
            results.sort(sortOrder);
            if (hasDuplicate) {
                while (elem = results[i++]) {
                    if (elem === results[i]) {
                        j = duplicates.push(i);
                    }
                }
                while (j--) {
                    results.splice(duplicates[j], 1);
                }
            }
            sortInput = null;
            return results;
        };
        getText = Sizzle.getText = function(elem) {
            var node, ret = "", i = 0, nodeType = elem.nodeType;
            if (!nodeType) {
                while (node = elem[i++]) {
                    ret += getText(node);
                }
            } else if (nodeType === 1 || nodeType === 9 || nodeType === 11) {
                if (typeof elem.textContent === "string") {
                    return elem.textContent;
                } else {
                    for (elem = elem.firstChild; elem; elem = elem.nextSibling) {
                        ret += getText(elem);
                    }
                }
            } else if (nodeType === 3 || nodeType === 4) {
                return elem.nodeValue;
            }
            return ret;
        };
        Expr = Sizzle.selectors = {
            cacheLength: 50,
            createPseudo: markFunction,
            match: matchExpr,
            attrHandle: {},
            find: {},
            relative: {
                ">": {
                    dir: "parentNode",
                    first: true
                },
                " ": {
                    dir: "parentNode"
                },
                "+": {
                    dir: "previousSibling",
                    first: true
                },
                "~": {
                    dir: "previousSibling"
                }
            },
            preFilter: {
                ATTR: function(match) {
                    match[1] = match[1].replace(runescape, funescape);
                    match[3] = (match[4] || match[5] || "").replace(runescape, funescape);
                    if (match[2] === "~=") {
                        match[3] = " " + match[3] + " ";
                    }
                    return match.slice(0, 4);
                },
                CHILD: function(match) {
                    match[1] = match[1].toLowerCase();
                    if (match[1].slice(0, 3) === "nth") {
                        if (!match[3]) {
                            Sizzle.error(match[0]);
                        }
                        match[4] = +(match[4] ? match[5] + (match[6] || 1) : 2 * (match[3] === "even" || match[3] === "odd"));
                        match[5] = +(match[7] + match[8] || match[3] === "odd");
                    } else if (match[3]) {
                        Sizzle.error(match[0]);
                    }
                    return match;
                },
                PSEUDO: function(match) {
                    var excess, unquoted = !match[5] && match[2];
                    if (matchExpr["CHILD"].test(match[0])) {
                        return null;
                    }
                    if (match[3] && match[4] !== undefined) {
                        match[2] = match[4];
                    } else if (unquoted && rpseudo.test(unquoted) && (excess = tokenize(unquoted, true)) && (excess = unquoted.indexOf(")", unquoted.length - excess) - unquoted.length)) {
                        match[0] = match[0].slice(0, excess);
                        match[2] = unquoted.slice(0, excess);
                    }
                    return match.slice(0, 3);
                }
            },
            filter: {
                TAG: function(nodeNameSelector) {
                    var nodeName = nodeNameSelector.replace(runescape, funescape).toLowerCase();
                    return nodeNameSelector === "*" ? function() {
                        return true;
                    } : function(elem) {
                        return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
                    };
                },
                CLASS: function(className) {
                    var pattern = classCache[className + " "];
                    return pattern || (pattern = new RegExp("(^|" + whitespace + ")" + className + "(" + whitespace + "|$)")) && classCache(className, function(elem) {
                        return pattern.test(typeof elem.className === "string" && elem.className || typeof elem.getAttribute !== strundefined && elem.getAttribute("class") || "");
                    });
                },
                ATTR: function(name, operator, check) {
                    return function(elem) {
                        var result = Sizzle.attr(elem, name);
                        if (result == null) {
                            return operator === "!=";
                        }
                        if (!operator) {
                            return true;
                        }
                        result += "";
                        return operator === "=" ? result === check : operator === "!=" ? result !== check : operator === "^=" ? check && result.indexOf(check) === 0 : operator === "*=" ? check && result.indexOf(check) > -1 : operator === "$=" ? check && result.slice(-check.length) === check : operator === "~=" ? (" " + result + " ").indexOf(check) > -1 : operator === "|=" ? result === check || result.slice(0, check.length + 1) === check + "-" : false;
                    };
                },
                CHILD: function(type, what, argument, first, last) {
                    var simple = type.slice(0, 3) !== "nth", forward = type.slice(-4) !== "last", ofType = what === "of-type";
                    return first === 1 && last === 0 ? function(elem) {
                        return !!elem.parentNode;
                    } : function(elem, context, xml) {
                        var cache, outerCache, node, diff, nodeIndex, start, dir = simple !== forward ? "nextSibling" : "previousSibling", parent = elem.parentNode, name = ofType && elem.nodeName.toLowerCase(), useCache = !xml && !ofType;
                        if (parent) {
                            if (simple) {
                                while (dir) {
                                    node = elem;
                                    while (node = node[dir]) {
                                        if (ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1) {
                                            return false;
                                        }
                                    }
                                    start = dir = type === "only" && !start && "nextSibling";
                                }
                                return true;
                            }
                            start = [ forward ? parent.firstChild : parent.lastChild ];
                            if (forward && useCache) {
                                outerCache = parent[expando] || (parent[expando] = {});
                                cache = outerCache[type] || [];
                                nodeIndex = cache[0] === dirruns && cache[1];
                                diff = cache[0] === dirruns && cache[2];
                                node = nodeIndex && parent.childNodes[nodeIndex];
                                while (node = ++nodeIndex && node && node[dir] || (diff = nodeIndex = 0) || start.pop()) {
                                    if (node.nodeType === 1 && ++diff && node === elem) {
                                        outerCache[type] = [ dirruns, nodeIndex, diff ];
                                        break;
                                    }
                                }
                            } else if (useCache && (cache = (elem[expando] || (elem[expando] = {}))[type]) && cache[0] === dirruns) {
                                diff = cache[1];
                            } else {
                                while (node = ++nodeIndex && node && node[dir] || (diff = nodeIndex = 0) || start.pop()) {
                                    if ((ofType ? node.nodeName.toLowerCase() === name : node.nodeType === 1) && ++diff) {
                                        if (useCache) {
                                            (node[expando] || (node[expando] = {}))[type] = [ dirruns, diff ];
                                        }
                                        if (node === elem) {
                                            break;
                                        }
                                    }
                                }
                            }
                            diff -= last;
                            return diff === first || diff % first === 0 && diff / first >= 0;
                        }
                    };
                },
                PSEUDO: function(pseudo, argument) {
                    var args, fn = Expr.pseudos[pseudo] || Expr.setFilters[pseudo.toLowerCase()] || Sizzle.error("unsupported pseudo: " + pseudo);
                    if (fn[expando]) {
                        return fn(argument);
                    }
                    if (fn.length > 1) {
                        args = [ pseudo, pseudo, "", argument ];
                        return Expr.setFilters.hasOwnProperty(pseudo.toLowerCase()) ? markFunction(function(seed, matches) {
                            var idx, matched = fn(seed, argument), i = matched.length;
                            while (i--) {
                                idx = indexOf.call(seed, matched[i]);
                                seed[idx] = !(matches[idx] = matched[i]);
                            }
                        }) : function(elem) {
                            return fn(elem, 0, args);
                        };
                    }
                    return fn;
                }
            },
            pseudos: {
                not: markFunction(function(selector) {
                    var input = [], results = [], matcher = compile(selector.replace(rtrim, "$1"));
                    return matcher[expando] ? markFunction(function(seed, matches, context, xml) {
                        var elem, unmatched = matcher(seed, null, xml, []), i = seed.length;
                        while (i--) {
                            if (elem = unmatched[i]) {
                                seed[i] = !(matches[i] = elem);
                            }
                        }
                    }) : function(elem, context, xml) {
                        input[0] = elem;
                        matcher(input, null, xml, results);
                        return !results.pop();
                    };
                }),
                has: markFunction(function(selector) {
                    return function(elem) {
                        return Sizzle(selector, elem).length > 0;
                    };
                }),
                contains: markFunction(function(text) {
                    return function(elem) {
                        return (elem.textContent || elem.innerText || getText(elem)).indexOf(text) > -1;
                    };
                }),
                lang: markFunction(function(lang) {
                    if (!ridentifier.test(lang || "")) {
                        Sizzle.error("unsupported lang: " + lang);
                    }
                    lang = lang.replace(runescape, funescape).toLowerCase();
                    return function(elem) {
                        var elemLang;
                        do {
                            if (elemLang = documentIsHTML ? elem.lang : elem.getAttribute("xml:lang") || elem.getAttribute("lang")) {
                                elemLang = elemLang.toLowerCase();
                                return elemLang === lang || elemLang.indexOf(lang + "-") === 0;
                            }
                        } while ((elem = elem.parentNode) && elem.nodeType === 1);
                        return false;
                    };
                }),
                target: function(elem) {
                    var hash = window.location && window.location.hash;
                    return hash && hash.slice(1) === elem.id;
                },
                root: function(elem) {
                    return elem === docElem;
                },
                focus: function(elem) {
                    return elem === document.activeElement && (!document.hasFocus || document.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
                },
                enabled: function(elem) {
                    return elem.disabled === false;
                },
                disabled: function(elem) {
                    return elem.disabled === true;
                },
                checked: function(elem) {
                    var nodeName = elem.nodeName.toLowerCase();
                    return nodeName === "input" && !!elem.checked || nodeName === "option" && !!elem.selected;
                },
                selected: function(elem) {
                    if (elem.parentNode) {
                        elem.parentNode.selectedIndex;
                    }
                    return elem.selected === true;
                },
                empty: function(elem) {
                    for (elem = elem.firstChild; elem; elem = elem.nextSibling) {
                        if (elem.nodeType < 6) {
                            return false;
                        }
                    }
                    return true;
                },
                parent: function(elem) {
                    return !Expr.pseudos["empty"](elem);
                },
                header: function(elem) {
                    return rheader.test(elem.nodeName);
                },
                input: function(elem) {
                    return rinputs.test(elem.nodeName);
                },
                button: function(elem) {
                    var name = elem.nodeName.toLowerCase();
                    return name === "input" && elem.type === "button" || name === "button";
                },
                text: function(elem) {
                    var attr;
                    return elem.nodeName.toLowerCase() === "input" && elem.type === "text" && ((attr = elem.getAttribute("type")) == null || attr.toLowerCase() === "text");
                },
                first: createPositionalPseudo(function() {
                    return [ 0 ];
                }),
                last: createPositionalPseudo(function(matchIndexes, length) {
                    return [ length - 1 ];
                }),
                eq: createPositionalPseudo(function(matchIndexes, length, argument) {
                    return [ argument < 0 ? argument + length : argument ];
                }),
                even: createPositionalPseudo(function(matchIndexes, length) {
                    var i = 0;
                    for (;i < length; i += 2) {
                        matchIndexes.push(i);
                    }
                    return matchIndexes;
                }),
                odd: createPositionalPseudo(function(matchIndexes, length) {
                    var i = 1;
                    for (;i < length; i += 2) {
                        matchIndexes.push(i);
                    }
                    return matchIndexes;
                }),
                lt: createPositionalPseudo(function(matchIndexes, length, argument) {
                    var i = argument < 0 ? argument + length : argument;
                    for (;--i >= 0; ) {
                        matchIndexes.push(i);
                    }
                    return matchIndexes;
                }),
                gt: createPositionalPseudo(function(matchIndexes, length, argument) {
                    var i = argument < 0 ? argument + length : argument;
                    for (;++i < length; ) {
                        matchIndexes.push(i);
                    }
                    return matchIndexes;
                })
            }
        };
        Expr.pseudos["nth"] = Expr.pseudos["eq"];
        for (i in {
            radio: true,
            checkbox: true,
            file: true,
            password: true,
            image: true
        }) {
            Expr.pseudos[i] = createInputPseudo(i);
        }
        for (i in {
            submit: true,
            reset: true
        }) {
            Expr.pseudos[i] = createButtonPseudo(i);
        }
        function setFilters() {}
        setFilters.prototype = Expr.filters = Expr.pseudos;
        Expr.setFilters = new setFilters();
        function tokenize(selector, parseOnly) {
            var matched, match, tokens, type, soFar, groups, preFilters, cached = tokenCache[selector + " "];
            if (cached) {
                return parseOnly ? 0 : cached.slice(0);
            }
            soFar = selector;
            groups = [];
            preFilters = Expr.preFilter;
            while (soFar) {
                if (!matched || (match = rcomma.exec(soFar))) {
                    if (match) {
                        soFar = soFar.slice(match[0].length) || soFar;
                    }
                    groups.push(tokens = []);
                }
                matched = false;
                if (match = rcombinators.exec(soFar)) {
                    matched = match.shift();
                    tokens.push({
                        value: matched,
                        type: match[0].replace(rtrim, " ")
                    });
                    soFar = soFar.slice(matched.length);
                }
                for (type in Expr.filter) {
                    if ((match = matchExpr[type].exec(soFar)) && (!preFilters[type] || (match = preFilters[type](match)))) {
                        matched = match.shift();
                        tokens.push({
                            value: matched,
                            type: type,
                            matches: match
                        });
                        soFar = soFar.slice(matched.length);
                    }
                }
                if (!matched) {
                    break;
                }
            }
            return parseOnly ? soFar.length : soFar ? Sizzle.error(selector) : tokenCache(selector, groups).slice(0);
        }
        function toSelector(tokens) {
            var i = 0, len = tokens.length, selector = "";
            for (;i < len; i++) {
                selector += tokens[i].value;
            }
            return selector;
        }
        function addCombinator(matcher, combinator, base) {
            var dir = combinator.dir, checkNonElements = base && dir === "parentNode", doneName = done++;
            return combinator.first ? function(elem, context, xml) {
                while (elem = elem[dir]) {
                    if (elem.nodeType === 1 || checkNonElements) {
                        return matcher(elem, context, xml);
                    }
                }
            } : function(elem, context, xml) {
                var oldCache, outerCache, newCache = [ dirruns, doneName ];
                if (xml) {
                    while (elem = elem[dir]) {
                        if (elem.nodeType === 1 || checkNonElements) {
                            if (matcher(elem, context, xml)) {
                                return true;
                            }
                        }
                    }
                } else {
                    while (elem = elem[dir]) {
                        if (elem.nodeType === 1 || checkNonElements) {
                            outerCache = elem[expando] || (elem[expando] = {});
                            if ((oldCache = outerCache[dir]) && oldCache[0] === dirruns && oldCache[1] === doneName) {
                                return newCache[2] = oldCache[2];
                            } else {
                                outerCache[dir] = newCache;
                                if (newCache[2] = matcher(elem, context, xml)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            };
        }
        function elementMatcher(matchers) {
            return matchers.length > 1 ? function(elem, context, xml) {
                var i = matchers.length;
                while (i--) {
                    if (!matchers[i](elem, context, xml)) {
                        return false;
                    }
                }
                return true;
            } : matchers[0];
        }
        function condense(unmatched, map, filter, context, xml) {
            var elem, newUnmatched = [], i = 0, len = unmatched.length, mapped = map != null;
            for (;i < len; i++) {
                if (elem = unmatched[i]) {
                    if (!filter || filter(elem, context, xml)) {
                        newUnmatched.push(elem);
                        if (mapped) {
                            map.push(i);
                        }
                    }
                }
            }
            return newUnmatched;
        }
        function setMatcher(preFilter, selector, matcher, postFilter, postFinder, postSelector) {
            if (postFilter && !postFilter[expando]) {
                postFilter = setMatcher(postFilter);
            }
            if (postFinder && !postFinder[expando]) {
                postFinder = setMatcher(postFinder, postSelector);
            }
            return markFunction(function(seed, results, context, xml) {
                var temp, i, elem, preMap = [], postMap = [], preexisting = results.length, elems = seed || multipleContexts(selector || "*", context.nodeType ? [ context ] : context, []), matcherIn = preFilter && (seed || !selector) ? condense(elems, preMap, preFilter, context, xml) : elems, matcherOut = matcher ? postFinder || (seed ? preFilter : preexisting || postFilter) ? [] : results : matcherIn;
                if (matcher) {
                    matcher(matcherIn, matcherOut, context, xml);
                }
                if (postFilter) {
                    temp = condense(matcherOut, postMap);
                    postFilter(temp, [], context, xml);
                    i = temp.length;
                    while (i--) {
                        if (elem = temp[i]) {
                            matcherOut[postMap[i]] = !(matcherIn[postMap[i]] = elem);
                        }
                    }
                }
                if (seed) {
                    if (postFinder || preFilter) {
                        if (postFinder) {
                            temp = [];
                            i = matcherOut.length;
                            while (i--) {
                                if (elem = matcherOut[i]) {
                                    temp.push(matcherIn[i] = elem);
                                }
                            }
                            postFinder(null, matcherOut = [], temp, xml);
                        }
                        i = matcherOut.length;
                        while (i--) {
                            if ((elem = matcherOut[i]) && (temp = postFinder ? indexOf.call(seed, elem) : preMap[i]) > -1) {
                                seed[temp] = !(results[temp] = elem);
                            }
                        }
                    }
                } else {
                    matcherOut = condense(matcherOut === results ? matcherOut.splice(preexisting, matcherOut.length) : matcherOut);
                    if (postFinder) {
                        postFinder(null, results, matcherOut, xml);
                    } else {
                        push.apply(results, matcherOut);
                    }
                }
            });
        }
        function matcherFromTokens(tokens) {
            var checkContext, matcher, j, len = tokens.length, leadingRelative = Expr.relative[tokens[0].type], implicitRelative = leadingRelative || Expr.relative[" "], i = leadingRelative ? 1 : 0, matchContext = addCombinator(function(elem) {
                return elem === checkContext;
            }, implicitRelative, true), matchAnyContext = addCombinator(function(elem) {
                return indexOf.call(checkContext, elem) > -1;
            }, implicitRelative, true), matchers = [ function(elem, context, xml) {
                return !leadingRelative && (xml || context !== outermostContext) || ((checkContext = context).nodeType ? matchContext(elem, context, xml) : matchAnyContext(elem, context, xml));
            } ];
            for (;i < len; i++) {
                if (matcher = Expr.relative[tokens[i].type]) {
                    matchers = [ addCombinator(elementMatcher(matchers), matcher) ];
                } else {
                    matcher = Expr.filter[tokens[i].type].apply(null, tokens[i].matches);
                    if (matcher[expando]) {
                        j = ++i;
                        for (;j < len; j++) {
                            if (Expr.relative[tokens[j].type]) {
                                break;
                            }
                        }
                        return setMatcher(i > 1 && elementMatcher(matchers), i > 1 && toSelector(tokens.slice(0, i - 1).concat({
                            value: tokens[i - 2].type === " " ? "*" : ""
                        })).replace(rtrim, "$1"), matcher, i < j && matcherFromTokens(tokens.slice(i, j)), j < len && matcherFromTokens(tokens = tokens.slice(j)), j < len && toSelector(tokens));
                    }
                    matchers.push(matcher);
                }
            }
            return elementMatcher(matchers);
        }
        function matcherFromGroupMatchers(elementMatchers, setMatchers) {
            var bySet = setMatchers.length > 0, byElement = elementMatchers.length > 0, superMatcher = function(seed, context, xml, results, outermost) {
                var elem, j, matcher, matchedCount = 0, i = "0", unmatched = seed && [], setMatched = [], contextBackup = outermostContext, elems = seed || byElement && Expr.find["TAG"]("*", outermost), dirrunsUnique = dirruns += contextBackup == null ? 1 : Math.random() || .1, len = elems.length;
                if (outermost) {
                    outermostContext = context !== document && context;
                }
                for (;i !== len && (elem = elems[i]) != null; i++) {
                    if (byElement && elem) {
                        j = 0;
                        while (matcher = elementMatchers[j++]) {
                            if (matcher(elem, context, xml)) {
                                results.push(elem);
                                break;
                            }
                        }
                        if (outermost) {
                            dirruns = dirrunsUnique;
                        }
                    }
                    if (bySet) {
                        if (elem = !matcher && elem) {
                            matchedCount--;
                        }
                        if (seed) {
                            unmatched.push(elem);
                        }
                    }
                }
                matchedCount += i;
                if (bySet && i !== matchedCount) {
                    j = 0;
                    while (matcher = setMatchers[j++]) {
                        matcher(unmatched, setMatched, context, xml);
                    }
                    if (seed) {
                        if (matchedCount > 0) {
                            while (i--) {
                                if (!(unmatched[i] || setMatched[i])) {
                                    setMatched[i] = pop.call(results);
                                }
                            }
                        }
                        setMatched = condense(setMatched);
                    }
                    push.apply(results, setMatched);
                    if (outermost && !seed && setMatched.length > 0 && matchedCount + setMatchers.length > 1) {
                        Sizzle.uniqueSort(results);
                    }
                }
                if (outermost) {
                    dirruns = dirrunsUnique;
                    outermostContext = contextBackup;
                }
                return unmatched;
            };
            return bySet ? markFunction(superMatcher) : superMatcher;
        }
        compile = Sizzle.compile = function(selector, group) {
            var i, setMatchers = [], elementMatchers = [], cached = compilerCache[selector + " "];
            if (!cached) {
                if (!group) {
                    group = tokenize(selector);
                }
                i = group.length;
                while (i--) {
                    cached = matcherFromTokens(group[i]);
                    if (cached[expando]) {
                        setMatchers.push(cached);
                    } else {
                        elementMatchers.push(cached);
                    }
                }
                cached = compilerCache(selector, matcherFromGroupMatchers(elementMatchers, setMatchers));
            }
            return cached;
        };
        function multipleContexts(selector, contexts, results) {
            var i = 0, len = contexts.length;
            for (;i < len; i++) {
                Sizzle(selector, contexts[i], results);
            }
            return results;
        }
        function select(selector, context, results, seed) {
            var i, tokens, token, type, find, match = tokenize(selector);
            if (!seed) {
                if (match.length === 1) {
                    tokens = match[0] = match[0].slice(0);
                    if (tokens.length > 2 && (token = tokens[0]).type === "ID" && support.getById && context.nodeType === 9 && documentIsHTML && Expr.relative[tokens[1].type]) {
                        context = (Expr.find["ID"](token.matches[0].replace(runescape, funescape), context) || [])[0];
                        if (!context) {
                            return results;
                        }
                        selector = selector.slice(tokens.shift().value.length);
                    }
                    i = matchExpr["needsContext"].test(selector) ? 0 : tokens.length;
                    while (i--) {
                        token = tokens[i];
                        if (Expr.relative[type = token.type]) {
                            break;
                        }
                        if (find = Expr.find[type]) {
                            if (seed = find(token.matches[0].replace(runescape, funescape), rsibling.test(tokens[0].type) && testContext(context.parentNode) || context)) {
                                tokens.splice(i, 1);
                                selector = seed.length && toSelector(tokens);
                                if (!selector) {
                                    push.apply(results, seed);
                                    return results;
                                }
                                break;
                            }
                        }
                    }
                }
            }
            compile(selector, match)(seed, context, !documentIsHTML, results, rsibling.test(selector) && testContext(context.parentNode) || context);
            return results;
        }
        support.sortStable = expando.split("").sort(sortOrder).join("") === expando;
        support.detectDuplicates = !!hasDuplicate;
        setDocument();
        support.sortDetached = assert(function(div1) {
            return div1.compareDocumentPosition(document.createElement("div")) & 1;
        });
        if (!assert(function(div) {
            div.innerHTML = "<a href='#'></a>";
            return div.firstChild.getAttribute("href") === "#";
        })) {
            addHandle("type|href|height|width", function(elem, name, isXML) {
                if (!isXML) {
                    return elem.getAttribute(name, name.toLowerCase() === "type" ? 1 : 2);
                }
            });
        }
        if (!support.attributes || !assert(function(div) {
            div.innerHTML = "<input/>";
            div.firstChild.setAttribute("value", "");
            return div.firstChild.getAttribute("value") === "";
        })) {
            addHandle("value", function(elem, name, isXML) {
                if (!isXML && elem.nodeName.toLowerCase() === "input") {
                    return elem.defaultValue;
                }
            });
        }
        if (!assert(function(div) {
            return div.getAttribute("disabled") == null;
        })) {
            addHandle(booleans, function(elem, name, isXML) {
                var val;
                if (!isXML) {
                    return elem[name] === true ? name.toLowerCase() : (val = elem.getAttributeNode(name)) && val.specified ? val.value : null;
                }
            });
        }
        return Sizzle;
    }(window);
    jQuery.find = Sizzle;
    jQuery.expr = Sizzle.selectors;
    jQuery.expr[":"] = jQuery.expr.pseudos;
    jQuery.unique = Sizzle.uniqueSort;
    jQuery.text = Sizzle.getText;
    jQuery.isXMLDoc = Sizzle.isXML;
    jQuery.contains = Sizzle.contains;
    var rneedsContext = jQuery.expr.match.needsContext;
    var rsingleTag = /^<(\w+)\s*\/?>(?:<\/\1>|)$/;
    var risSimple = /^.[^:#\[\.,]*$/;
    function winnow(elements, qualifier, not) {
        if (jQuery.isFunction(qualifier)) {
            return jQuery.grep(elements, function(elem, i) {
                return !!qualifier.call(elem, i, elem) !== not;
            });
        }
        if (qualifier.nodeType) {
            return jQuery.grep(elements, function(elem) {
                return elem === qualifier !== not;
            });
        }
        if (typeof qualifier === "string") {
            if (risSimple.test(qualifier)) {
                return jQuery.filter(qualifier, elements, not);
            }
            qualifier = jQuery.filter(qualifier, elements);
        }
        return jQuery.grep(elements, function(elem) {
            return jQuery.inArray(elem, qualifier) >= 0 !== not;
        });
    }
    jQuery.filter = function(expr, elems, not) {
        var elem = elems[0];
        if (not) {
            expr = ":not(" + expr + ")";
        }
        return elems.length === 1 && elem.nodeType === 1 ? jQuery.find.matchesSelector(elem, expr) ? [ elem ] : [] : jQuery.find.matches(expr, jQuery.grep(elems, function(elem) {
            return elem.nodeType === 1;
        }));
    };
    jQuery.fn.extend({
        find: function(selector) {
            var i, ret = [], self = this, len = self.length;
            if (typeof selector !== "string") {
                return this.pushStack(jQuery(selector).filter(function() {
                    for (i = 0; i < len; i++) {
                        if (jQuery.contains(self[i], this)) {
                            return true;
                        }
                    }
                }));
            }
            for (i = 0; i < len; i++) {
                jQuery.find(selector, self[i], ret);
            }
            ret = this.pushStack(len > 1 ? jQuery.unique(ret) : ret);
            ret.selector = this.selector ? this.selector + " " + selector : selector;
            return ret;
        },
        filter: function(selector) {
            return this.pushStack(winnow(this, selector || [], false));
        },
        not: function(selector) {
            return this.pushStack(winnow(this, selector || [], true));
        },
        is: function(selector) {
            return !!winnow(this, typeof selector === "string" && rneedsContext.test(selector) ? jQuery(selector) : selector || [], false).length;
        }
    });
    var rootjQuery, document = window.document, rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/, init = jQuery.fn.init = function(selector, context) {
        var match, elem;
        if (!selector) {
            return this;
        }
        if (typeof selector === "string") {
            if (selector.charAt(0) === "<" && selector.charAt(selector.length - 1) === ">" && selector.length >= 3) {
                match = [ null, selector, null ];
            } else {
                match = rquickExpr.exec(selector);
            }
            if (match && (match[1] || !context)) {
                if (match[1]) {
                    context = context instanceof jQuery ? context[0] : context;
                    jQuery.merge(this, jQuery.parseHTML(match[1], context && context.nodeType ? context.ownerDocument || context : document, true));
                    if (rsingleTag.test(match[1]) && jQuery.isPlainObject(context)) {
                        for (match in context) {
                            if (jQuery.isFunction(this[match])) {
                                this[match](context[match]);
                            } else {
                                this.attr(match, context[match]);
                            }
                        }
                    }
                    return this;
                } else {
                    elem = document.getElementById(match[2]);
                    if (elem && elem.parentNode) {
                        if (elem.id !== match[2]) {
                            return rootjQuery.find(selector);
                        }
                        this.length = 1;
                        this[0] = elem;
                    }
                    this.context = document;
                    this.selector = selector;
                    return this;
                }
            } else if (!context || context.jquery) {
                return (context || rootjQuery).find(selector);
            } else {
                return this.constructor(context).find(selector);
            }
        } else if (selector.nodeType) {
            this.context = this[0] = selector;
            this.length = 1;
            return this;
        } else if (jQuery.isFunction(selector)) {
            return typeof rootjQuery.ready !== "undefined" ? rootjQuery.ready(selector) : selector(jQuery);
        }
        if (selector.selector !== undefined) {
            this.selector = selector.selector;
            this.context = selector.context;
        }
        return jQuery.makeArray(selector, this);
    };
    init.prototype = jQuery.fn;
    rootjQuery = jQuery(document);
    var rparentsprev = /^(?:parents|prev(?:Until|All))/, guaranteedUnique = {
        children: true,
        contents: true,
        next: true,
        prev: true
    };
    jQuery.extend({
        dir: function(elem, dir, until) {
            var matched = [], cur = elem[dir];
            while (cur && cur.nodeType !== 9 && (until === undefined || cur.nodeType !== 1 || !jQuery(cur).is(until))) {
                if (cur.nodeType === 1) {
                    matched.push(cur);
                }
                cur = cur[dir];
            }
            return matched;
        },
        sibling: function(n, elem) {
            var r = [];
            for (;n; n = n.nextSibling) {
                if (n.nodeType === 1 && n !== elem) {
                    r.push(n);
                }
            }
            return r;
        }
    });
    jQuery.fn.extend({
        has: function(target) {
            var i, targets = jQuery(target, this), len = targets.length;
            return this.filter(function() {
                for (i = 0; i < len; i++) {
                    if (jQuery.contains(this, targets[i])) {
                        return true;
                    }
                }
            });
        },
        closest: function(selectors, context) {
            var cur, i = 0, l = this.length, matched = [], pos = rneedsContext.test(selectors) || typeof selectors !== "string" ? jQuery(selectors, context || this.context) : 0;
            for (;i < l; i++) {
                for (cur = this[i]; cur && cur !== context; cur = cur.parentNode) {
                    if (cur.nodeType < 11 && (pos ? pos.index(cur) > -1 : cur.nodeType === 1 && jQuery.find.matchesSelector(cur, selectors))) {
                        matched.push(cur);
                        break;
                    }
                }
            }
            return this.pushStack(matched.length > 1 ? jQuery.unique(matched) : matched);
        },
        index: function(elem) {
            if (!elem) {
                return this[0] && this[0].parentNode ? this.first().prevAll().length : -1;
            }
            if (typeof elem === "string") {
                return jQuery.inArray(this[0], jQuery(elem));
            }
            return jQuery.inArray(elem.jquery ? elem[0] : elem, this);
        },
        add: function(selector, context) {
            return this.pushStack(jQuery.unique(jQuery.merge(this.get(), jQuery(selector, context))));
        },
        addBack: function(selector) {
            return this.add(selector == null ? this.prevObject : this.prevObject.filter(selector));
        }
    });
    function sibling(cur, dir) {
        do {
            cur = cur[dir];
        } while (cur && cur.nodeType !== 1);
        return cur;
    }
    jQuery.each({
        parent: function(elem) {
            var parent = elem.parentNode;
            return parent && parent.nodeType !== 11 ? parent : null;
        },
        parents: function(elem) {
            return jQuery.dir(elem, "parentNode");
        },
        parentsUntil: function(elem, i, until) {
            return jQuery.dir(elem, "parentNode", until);
        },
        next: function(elem) {
            return sibling(elem, "nextSibling");
        },
        prev: function(elem) {
            return sibling(elem, "previousSibling");
        },
        nextAll: function(elem) {
            return jQuery.dir(elem, "nextSibling");
        },
        prevAll: function(elem) {
            return jQuery.dir(elem, "previousSibling");
        },
        nextUntil: function(elem, i, until) {
            return jQuery.dir(elem, "nextSibling", until);
        },
        prevUntil: function(elem, i, until) {
            return jQuery.dir(elem, "previousSibling", until);
        },
        siblings: function(elem) {
            return jQuery.sibling((elem.parentNode || {}).firstChild, elem);
        },
        children: function(elem) {
            return jQuery.sibling(elem.firstChild);
        },
        contents: function(elem) {
            return jQuery.nodeName(elem, "iframe") ? elem.contentDocument || elem.contentWindow.document : jQuery.merge([], elem.childNodes);
        }
    }, function(name, fn) {
        jQuery.fn[name] = function(until, selector) {
            var ret = jQuery.map(this, fn, until);
            if (name.slice(-5) !== "Until") {
                selector = until;
            }
            if (selector && typeof selector === "string") {
                ret = jQuery.filter(selector, ret);
            }
            if (this.length > 1) {
                if (!guaranteedUnique[name]) {
                    ret = jQuery.unique(ret);
                }
                if (rparentsprev.test(name)) {
                    ret = ret.reverse();
                }
            }
            return this.pushStack(ret);
        };
    });
    var rnotwhite = /\S+/g;
    var optionsCache = {};
    function createOptions(options) {
        var object = optionsCache[options] = {};
        jQuery.each(options.match(rnotwhite) || [], function(_, flag) {
            object[flag] = true;
        });
        return object;
    }
    jQuery.Callbacks = function(options) {
        options = typeof options === "string" ? optionsCache[options] || createOptions(options) : jQuery.extend({}, options);
        var firing, memory, fired, firingLength, firingIndex, firingStart, list = [], stack = !options.once && [], fire = function(data) {
            memory = options.memory && data;
            fired = true;
            firingIndex = firingStart || 0;
            firingStart = 0;
            firingLength = list.length;
            firing = true;
            for (;list && firingIndex < firingLength; firingIndex++) {
                if (list[firingIndex].apply(data[0], data[1]) === false && options.stopOnFalse) {
                    memory = false;
                    break;
                }
            }
            firing = false;
            if (list) {
                if (stack) {
                    if (stack.length) {
                        fire(stack.shift());
                    }
                } else if (memory) {
                    list = [];
                } else {
                    self.disable();
                }
            }
        }, self = {
            add: function() {
                if (list) {
                    var start = list.length;
                    (function add(args) {
                        jQuery.each(args, function(_, arg) {
                            var type = jQuery.type(arg);
                            if (type === "function") {
                                if (!options.unique || !self.has(arg)) {
                                    list.push(arg);
                                }
                            } else if (arg && arg.length && type !== "string") {
                                add(arg);
                            }
                        });
                    })(arguments);
                    if (firing) {
                        firingLength = list.length;
                    } else if (memory) {
                        firingStart = start;
                        fire(memory);
                    }
                }
                return this;
            },
            remove: function() {
                if (list) {
                    jQuery.each(arguments, function(_, arg) {
                        var index;
                        while ((index = jQuery.inArray(arg, list, index)) > -1) {
                            list.splice(index, 1);
                            if (firing) {
                                if (index <= firingLength) {
                                    firingLength--;
                                }
                                if (index <= firingIndex) {
                                    firingIndex--;
                                }
                            }
                        }
                    });
                }
                return this;
            },
            has: function(fn) {
                return fn ? jQuery.inArray(fn, list) > -1 : !!(list && list.length);
            },
            empty: function() {
                list = [];
                firingLength = 0;
                return this;
            },
            disable: function() {
                list = stack = memory = undefined;
                return this;
            },
            disabled: function() {
                return !list;
            },
            lock: function() {
                stack = undefined;
                if (!memory) {
                    self.disable();
                }
                return this;
            },
            locked: function() {
                return !stack;
            },
            fireWith: function(context, args) {
                if (list && (!fired || stack)) {
                    args = args || [];
                    args = [ context, args.slice ? args.slice() : args ];
                    if (firing) {
                        stack.push(args);
                    } else {
                        fire(args);
                    }
                }
                return this;
            },
            fire: function() {
                self.fireWith(this, arguments);
                return this;
            },
            fired: function() {
                return !!fired;
            }
        };
        return self;
    };
    jQuery.extend({
        Deferred: function(func) {
            var tuples = [ [ "resolve", "done", jQuery.Callbacks("once memory"), "resolved" ], [ "reject", "fail", jQuery.Callbacks("once memory"), "rejected" ], [ "notify", "progress", jQuery.Callbacks("memory") ] ], state = "pending", promise = {
                state: function() {
                    return state;
                },
                always: function() {
                    deferred.done(arguments).fail(arguments);
                    return this;
                },
                then: function() {
                    var fns = arguments;
                    return jQuery.Deferred(function(newDefer) {
                        jQuery.each(tuples, function(i, tuple) {
                            var fn = jQuery.isFunction(fns[i]) && fns[i];
                            deferred[tuple[1]](function() {
                                var returned = fn && fn.apply(this, arguments);
                                if (returned && jQuery.isFunction(returned.promise)) {
                                    returned.promise().done(newDefer.resolve).fail(newDefer.reject).progress(newDefer.notify);
                                } else {
                                    newDefer[tuple[0] + "With"](this === promise ? newDefer.promise() : this, fn ? [ returned ] : arguments);
                                }
                            });
                        });
                        fns = null;
                    }).promise();
                },
                promise: function(obj) {
                    return obj != null ? jQuery.extend(obj, promise) : promise;
                }
            }, deferred = {};
            promise.pipe = promise.then;
            jQuery.each(tuples, function(i, tuple) {
                var list = tuple[2], stateString = tuple[3];
                promise[tuple[1]] = list.add;
                if (stateString) {
                    list.add(function() {
                        state = stateString;
                    }, tuples[i ^ 1][2].disable, tuples[2][2].lock);
                }
                deferred[tuple[0]] = function() {
                    deferred[tuple[0] + "With"](this === deferred ? promise : this, arguments);
                    return this;
                };
                deferred[tuple[0] + "With"] = list.fireWith;
            });
            promise.promise(deferred);
            if (func) {
                func.call(deferred, deferred);
            }
            return deferred;
        },
        when: function(subordinate) {
            var i = 0, resolveValues = slice.call(arguments), length = resolveValues.length, remaining = length !== 1 || subordinate && jQuery.isFunction(subordinate.promise) ? length : 0, deferred = remaining === 1 ? subordinate : jQuery.Deferred(), updateFunc = function(i, contexts, values) {
                return function(value) {
                    contexts[i] = this;
                    values[i] = arguments.length > 1 ? slice.call(arguments) : value;
                    if (values === progressValues) {
                        deferred.notifyWith(contexts, values);
                    } else if (!--remaining) {
                        deferred.resolveWith(contexts, values);
                    }
                };
            }, progressValues, progressContexts, resolveContexts;
            if (length > 1) {
                progressValues = new Array(length);
                progressContexts = new Array(length);
                resolveContexts = new Array(length);
                for (;i < length; i++) {
                    if (resolveValues[i] && jQuery.isFunction(resolveValues[i].promise)) {
                        resolveValues[i].promise().done(updateFunc(i, resolveContexts, resolveValues)).fail(deferred.reject).progress(updateFunc(i, progressContexts, progressValues));
                    } else {
                        --remaining;
                    }
                }
            }
            if (!remaining) {
                deferred.resolveWith(resolveContexts, resolveValues);
            }
            return deferred.promise();
        }
    });
    var readyList;
    jQuery.fn.ready = function(fn) {
        jQuery.ready.promise().done(fn);
        return this;
    };
    jQuery.extend({
        isReady: false,
        readyWait: 1,
        holdReady: function(hold) {
            if (hold) {
                jQuery.readyWait++;
            } else {
                jQuery.ready(true);
            }
        },
        ready: function(wait) {
            if (wait === true ? --jQuery.readyWait : jQuery.isReady) {
                return;
            }
            if (!document.body) {
                return setTimeout(jQuery.ready);
            }
            jQuery.isReady = true;
            if (wait !== true && --jQuery.readyWait > 0) {
                return;
            }
            readyList.resolveWith(document, [ jQuery ]);
            if (jQuery.fn.trigger) {
                jQuery(document).trigger("ready").off("ready");
            }
        }
    });
    function detach() {
        if (document.addEventListener) {
            document.removeEventListener("DOMContentLoaded", completed, false);
            window.removeEventListener("load", completed, false);
        } else {
            document.detachEvent("onreadystatechange", completed);
            window.detachEvent("onload", completed);
        }
    }
    function completed() {
        if (document.addEventListener || event.type === "load" || document.readyState === "complete") {
            detach();
            jQuery.ready();
        }
    }
    jQuery.ready.promise = function(obj) {
        if (!readyList) {
            readyList = jQuery.Deferred();
            if (document.readyState === "complete") {
                setTimeout(jQuery.ready);
            } else if (document.addEventListener) {
                document.addEventListener("DOMContentLoaded", completed, false);
                window.addEventListener("load", completed, false);
            } else {
                document.attachEvent("onreadystatechange", completed);
                window.attachEvent("onload", completed);
                var top = false;
                try {
                    top = window.frameElement == null && document.documentElement;
                } catch (e) {}
                if (top && top.doScroll) {
                    (function doScrollCheck() {
                        if (!jQuery.isReady) {
                            try {
                                top.doScroll("left");
                            } catch (e) {
                                return setTimeout(doScrollCheck, 50);
                            }
                            detach();
                            jQuery.ready();
                        }
                    })();
                }
            }
        }
        return readyList.promise(obj);
    };
    var strundefined = typeof undefined;
    var i;
    for (i in jQuery(support)) {
        break;
    }
    support.ownLast = i !== "0";
    support.inlineBlockNeedsLayout = false;
    jQuery(function() {
        var container, div, body = document.getElementsByTagName("body")[0];
        if (!body) {
            return;
        }
        container = document.createElement("div");
        container.style.cssText = "border:0;width:0;height:0;position:absolute;top:0;left:-9999px;margin-top:1px";
        div = document.createElement("div");
        body.appendChild(container).appendChild(div);
        if (typeof div.style.zoom !== strundefined) {
            div.style.cssText = "border:0;margin:0;width:1px;padding:1px;display:inline;zoom:1";
            if (support.inlineBlockNeedsLayout = div.offsetWidth === 3) {
                body.style.zoom = 1;
            }
        }
        body.removeChild(container);
        container = div = null;
    });
    (function() {
        var div = document.createElement("div");
        if (support.deleteExpando == null) {
            support.deleteExpando = true;
            try {
                delete div.test;
            } catch (e) {
                support.deleteExpando = false;
            }
        }
        div = null;
    })();
    jQuery.acceptData = function(elem) {
        var noData = jQuery.noData[(elem.nodeName + " ").toLowerCase()], nodeType = +elem.nodeType || 1;
        return nodeType !== 1 && nodeType !== 9 ? false : !noData || noData !== true && elem.getAttribute("classid") === noData;
    };
    var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/, rmultiDash = /([A-Z])/g;
    function dataAttr(elem, key, data) {
        if (data === undefined && elem.nodeType === 1) {
            var name = "data-" + key.replace(rmultiDash, "-$1").toLowerCase();
            data = elem.getAttribute(name);
            if (typeof data === "string") {
                try {
                    data = data === "true" ? true : data === "false" ? false : data === "null" ? null : +data + "" === data ? +data : rbrace.test(data) ? jQuery.parseJSON(data) : data;
                } catch (e) {}
                jQuery.data(elem, key, data);
            } else {
                data = undefined;
            }
        }
        return data;
    }
    function isEmptyDataObject(obj) {
        var name;
        for (name in obj) {
            if (name === "data" && jQuery.isEmptyObject(obj[name])) {
                continue;
            }
            if (name !== "toJSON") {
                return false;
            }
        }
        return true;
    }
    function internalData(elem, name, data, pvt) {
        if (!jQuery.acceptData(elem)) {
            return;
        }
        var ret, thisCache, internalKey = jQuery.expando, isNode = elem.nodeType, cache = isNode ? jQuery.cache : elem, id = isNode ? elem[internalKey] : elem[internalKey] && internalKey;
        if ((!id || !cache[id] || !pvt && !cache[id].data) && data === undefined && typeof name === "string") {
            return;
        }
        if (!id) {
            if (isNode) {
                id = elem[internalKey] = deletedIds.pop() || jQuery.guid++;
            } else {
                id = internalKey;
            }
        }
        if (!cache[id]) {
            cache[id] = isNode ? {} : {
                toJSON: jQuery.noop
            };
        }
        if (typeof name === "object" || typeof name === "function") {
            if (pvt) {
                cache[id] = jQuery.extend(cache[id], name);
            } else {
                cache[id].data = jQuery.extend(cache[id].data, name);
            }
        }
        thisCache = cache[id];
        if (!pvt) {
            if (!thisCache.data) {
                thisCache.data = {};
            }
            thisCache = thisCache.data;
        }
        if (data !== undefined) {
            thisCache[jQuery.camelCase(name)] = data;
        }
        if (typeof name === "string") {
            ret = thisCache[name];
            if (ret == null) {
                ret = thisCache[jQuery.camelCase(name)];
            }
        } else {
            ret = thisCache;
        }
        return ret;
    }
    function internalRemoveData(elem, name, pvt) {
        if (!jQuery.acceptData(elem)) {
            return;
        }
        var thisCache, i, isNode = elem.nodeType, cache = isNode ? jQuery.cache : elem, id = isNode ? elem[jQuery.expando] : jQuery.expando;
        if (!cache[id]) {
            return;
        }
        if (name) {
            thisCache = pvt ? cache[id] : cache[id].data;
            if (thisCache) {
                if (!jQuery.isArray(name)) {
                    if (name in thisCache) {
                        name = [ name ];
                    } else {
                        name = jQuery.camelCase(name);
                        if (name in thisCache) {
                            name = [ name ];
                        } else {
                            name = name.split(" ");
                        }
                    }
                } else {
                    name = name.concat(jQuery.map(name, jQuery.camelCase));
                }
                i = name.length;
                while (i--) {
                    delete thisCache[name[i]];
                }
                if (pvt ? !isEmptyDataObject(thisCache) : !jQuery.isEmptyObject(thisCache)) {
                    return;
                }
            }
        }
        if (!pvt) {
            delete cache[id].data;
            if (!isEmptyDataObject(cache[id])) {
                return;
            }
        }
        if (isNode) {
            jQuery.cleanData([ elem ], true);
        } else if (support.deleteExpando || cache != cache.window) {
            delete cache[id];
        } else {
            cache[id] = null;
        }
    }
    jQuery.extend({
        cache: {},
        noData: {
            "applet ": true,
            "embed ": true,
            "object ": "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000"
        },
        hasData: function(elem) {
            elem = elem.nodeType ? jQuery.cache[elem[jQuery.expando]] : elem[jQuery.expando];
            return !!elem && !isEmptyDataObject(elem);
        },
        data: function(elem, name, data) {
            return internalData(elem, name, data);
        },
        removeData: function(elem, name) {
            return internalRemoveData(elem, name);
        },
        _data: function(elem, name, data) {
            return internalData(elem, name, data, true);
        },
        _removeData: function(elem, name) {
            return internalRemoveData(elem, name, true);
        }
    });
    jQuery.fn.extend({
        data: function(key, value) {
            var i, name, data, elem = this[0], attrs = elem && elem.attributes;
            if (key === undefined) {
                if (this.length) {
                    data = jQuery.data(elem);
                    if (elem.nodeType === 1 && !jQuery._data(elem, "parsedAttrs")) {
                        i = attrs.length;
                        while (i--) {
                            name = attrs[i].name;
                            if (name.indexOf("data-") === 0) {
                                name = jQuery.camelCase(name.slice(5));
                                dataAttr(elem, name, data[name]);
                            }
                        }
                        jQuery._data(elem, "parsedAttrs", true);
                    }
                }
                return data;
            }
            if (typeof key === "object") {
                return this.each(function() {
                    jQuery.data(this, key);
                });
            }
            return arguments.length > 1 ? this.each(function() {
                jQuery.data(this, key, value);
            }) : elem ? dataAttr(elem, key, jQuery.data(elem, key)) : undefined;
        },
        removeData: function(key) {
            return this.each(function() {
                jQuery.removeData(this, key);
            });
        }
    });
    jQuery.extend({
        queue: function(elem, type, data) {
            var queue;
            if (elem) {
                type = (type || "fx") + "queue";
                queue = jQuery._data(elem, type);
                if (data) {
                    if (!queue || jQuery.isArray(data)) {
                        queue = jQuery._data(elem, type, jQuery.makeArray(data));
                    } else {
                        queue.push(data);
                    }
                }
                return queue || [];
            }
        },
        dequeue: function(elem, type) {
            type = type || "fx";
            var queue = jQuery.queue(elem, type), startLength = queue.length, fn = queue.shift(), hooks = jQuery._queueHooks(elem, type), next = function() {
                jQuery.dequeue(elem, type);
            };
            if (fn === "inprogress") {
                fn = queue.shift();
                startLength--;
            }
            if (fn) {
                if (type === "fx") {
                    queue.unshift("inprogress");
                }
                delete hooks.stop;
                fn.call(elem, next, hooks);
            }
            if (!startLength && hooks) {
                hooks.empty.fire();
            }
        },
        _queueHooks: function(elem, type) {
            var key = type + "queueHooks";
            return jQuery._data(elem, key) || jQuery._data(elem, key, {
                empty: jQuery.Callbacks("once memory").add(function() {
                    jQuery._removeData(elem, type + "queue");
                    jQuery._removeData(elem, key);
                })
            });
        }
    });
    jQuery.fn.extend({
        queue: function(type, data) {
            var setter = 2;
            if (typeof type !== "string") {
                data = type;
                type = "fx";
                setter--;
            }
            if (arguments.length < setter) {
                return jQuery.queue(this[0], type);
            }
            return data === undefined ? this : this.each(function() {
                var queue = jQuery.queue(this, type, data);
                jQuery._queueHooks(this, type);
                if (type === "fx" && queue[0] !== "inprogress") {
                    jQuery.dequeue(this, type);
                }
            });
        },
        dequeue: function(type) {
            return this.each(function() {
                jQuery.dequeue(this, type);
            });
        },
        clearQueue: function(type) {
            return this.queue(type || "fx", []);
        },
        promise: function(type, obj) {
            var tmp, count = 1, defer = jQuery.Deferred(), elements = this, i = this.length, resolve = function() {
                if (!--count) {
                    defer.resolveWith(elements, [ elements ]);
                }
            };
            if (typeof type !== "string") {
                obj = type;
                type = undefined;
            }
            type = type || "fx";
            while (i--) {
                tmp = jQuery._data(elements[i], type + "queueHooks");
                if (tmp && tmp.empty) {
                    count++;
                    tmp.empty.add(resolve);
                }
            }
            resolve();
            return defer.promise(obj);
        }
    });
    var pnum = /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source;
    var cssExpand = [ "Top", "Right", "Bottom", "Left" ];
    var isHidden = function(elem, el) {
        elem = el || elem;
        return jQuery.css(elem, "display") === "none" || !jQuery.contains(elem.ownerDocument, elem);
    };
    var access = jQuery.access = function(elems, fn, key, value, chainable, emptyGet, raw) {
        var i = 0, length = elems.length, bulk = key == null;
        if (jQuery.type(key) === "object") {
            chainable = true;
            for (i in key) {
                jQuery.access(elems, fn, i, key[i], true, emptyGet, raw);
            }
        } else if (value !== undefined) {
            chainable = true;
            if (!jQuery.isFunction(value)) {
                raw = true;
            }
            if (bulk) {
                if (raw) {
                    fn.call(elems, value);
                    fn = null;
                } else {
                    bulk = fn;
                    fn = function(elem, key, value) {
                        return bulk.call(jQuery(elem), value);
                    };
                }
            }
            if (fn) {
                for (;i < length; i++) {
                    fn(elems[i], key, raw ? value : value.call(elems[i], i, fn(elems[i], key)));
                }
            }
        }
        return chainable ? elems : bulk ? fn.call(elems) : length ? fn(elems[0], key) : emptyGet;
    };
    var rcheckableType = /^(?:checkbox|radio)$/i;
    (function() {
        var fragment = document.createDocumentFragment(), div = document.createElement("div"), input = document.createElement("input");
        div.setAttribute("className", "t");
        div.innerHTML = "  <link/><table></table><a href='/a'>a</a>";
        support.leadingWhitespace = div.firstChild.nodeType === 3;
        support.tbody = !div.getElementsByTagName("tbody").length;
        support.htmlSerialize = !!div.getElementsByTagName("link").length;
        support.html5Clone = document.createElement("nav").cloneNode(true).outerHTML !== "<:nav></:nav>";
        input.type = "checkbox";
        input.checked = true;
        fragment.appendChild(input);
        support.appendChecked = input.checked;
        div.innerHTML = "<textarea>x</textarea>";
        support.noCloneChecked = !!div.cloneNode(true).lastChild.defaultValue;
        fragment.appendChild(div);
        div.innerHTML = "<input type='radio' checked='checked' name='t'/>";
        support.checkClone = div.cloneNode(true).cloneNode(true).lastChild.checked;
        support.noCloneEvent = true;
        if (div.attachEvent) {
            div.attachEvent("onclick", function() {
                support.noCloneEvent = false;
            });
            div.cloneNode(true).click();
        }
        if (support.deleteExpando == null) {
            support.deleteExpando = true;
            try {
                delete div.test;
            } catch (e) {
                support.deleteExpando = false;
            }
        }
        fragment = div = input = null;
    })();
    (function() {
        var i, eventName, div = document.createElement("div");
        for (i in {
            submit: true,
            change: true,
            focusin: true
        }) {
            eventName = "on" + i;
            if (!(support[i + "Bubbles"] = eventName in window)) {
                div.setAttribute(eventName, "t");
                support[i + "Bubbles"] = div.attributes[eventName].expando === false;
            }
        }
        div = null;
    })();
    var rformElems = /^(?:input|select|textarea)$/i, rkeyEvent = /^key/, rmouseEvent = /^(?:mouse|contextmenu)|click/, rfocusMorph = /^(?:focusinfocus|focusoutblur)$/, rtypenamespace = /^([^.]*)(?:\.(.+)|)$/;
    function returnTrue() {
        return true;
    }
    function returnFalse() {
        return false;
    }
    function safeActiveElement() {
        try {
            return document.activeElement;
        } catch (err) {}
    }
    jQuery.event = {
        global: {},
        add: function(elem, types, handler, data, selector) {
            var tmp, events, t, handleObjIn, special, eventHandle, handleObj, handlers, type, namespaces, origType, elemData = jQuery._data(elem);
            if (!elemData) {
                return;
            }
            if (handler.handler) {
                handleObjIn = handler;
                handler = handleObjIn.handler;
                selector = handleObjIn.selector;
            }
            if (!handler.guid) {
                handler.guid = jQuery.guid++;
            }
            if (!(events = elemData.events)) {
                events = elemData.events = {};
            }
            if (!(eventHandle = elemData.handle)) {
                eventHandle = elemData.handle = function(e) {
                    return typeof jQuery !== strundefined && (!e || jQuery.event.triggered !== e.type) ? jQuery.event.dispatch.apply(eventHandle.elem, arguments) : undefined;
                };
                eventHandle.elem = elem;
            }
            types = (types || "").match(rnotwhite) || [ "" ];
            t = types.length;
            while (t--) {
                tmp = rtypenamespace.exec(types[t]) || [];
                type = origType = tmp[1];
                namespaces = (tmp[2] || "").split(".").sort();
                if (!type) {
                    continue;
                }
                special = jQuery.event.special[type] || {};
                type = (selector ? special.delegateType : special.bindType) || type;
                special = jQuery.event.special[type] || {};
                handleObj = jQuery.extend({
                    type: type,
                    origType: origType,
                    data: data,
                    handler: handler,
                    guid: handler.guid,
                    selector: selector,
                    needsContext: selector && jQuery.expr.match.needsContext.test(selector),
                    namespace: namespaces.join(".")
                }, handleObjIn);
                if (!(handlers = events[type])) {
                    handlers = events[type] = [];
                    handlers.delegateCount = 0;
                    if (!special.setup || special.setup.call(elem, data, namespaces, eventHandle) === false) {
                        if (elem.addEventListener) {
                            elem.addEventListener(type, eventHandle, false);
                        } else if (elem.attachEvent) {
                            elem.attachEvent("on" + type, eventHandle);
                        }
                    }
                }
                if (special.add) {
                    special.add.call(elem, handleObj);
                    if (!handleObj.handler.guid) {
                        handleObj.handler.guid = handler.guid;
                    }
                }
                if (selector) {
                    handlers.splice(handlers.delegateCount++, 0, handleObj);
                } else {
                    handlers.push(handleObj);
                }
                jQuery.event.global[type] = true;
            }
            elem = null;
        },
        remove: function(elem, types, handler, selector, mappedTypes) {
            var j, handleObj, tmp, origCount, t, events, special, handlers, type, namespaces, origType, elemData = jQuery.hasData(elem) && jQuery._data(elem);
            if (!elemData || !(events = elemData.events)) {
                return;
            }
            types = (types || "").match(rnotwhite) || [ "" ];
            t = types.length;
            while (t--) {
                tmp = rtypenamespace.exec(types[t]) || [];
                type = origType = tmp[1];
                namespaces = (tmp[2] || "").split(".").sort();
                if (!type) {
                    for (type in events) {
                        jQuery.event.remove(elem, type + types[t], handler, selector, true);
                    }
                    continue;
                }
                special = jQuery.event.special[type] || {};
                type = (selector ? special.delegateType : special.bindType) || type;
                handlers = events[type] || [];
                tmp = tmp[2] && new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)");
                origCount = j = handlers.length;
                while (j--) {
                    handleObj = handlers[j];
                    if ((mappedTypes || origType === handleObj.origType) && (!handler || handler.guid === handleObj.guid) && (!tmp || tmp.test(handleObj.namespace)) && (!selector || selector === handleObj.selector || selector === "**" && handleObj.selector)) {
                        handlers.splice(j, 1);
                        if (handleObj.selector) {
                            handlers.delegateCount--;
                        }
                        if (special.remove) {
                            special.remove.call(elem, handleObj);
                        }
                    }
                }
                if (origCount && !handlers.length) {
                    if (!special.teardown || special.teardown.call(elem, namespaces, elemData.handle) === false) {
                        jQuery.removeEvent(elem, type, elemData.handle);
                    }
                    delete events[type];
                }
            }
            if (jQuery.isEmptyObject(events)) {
                delete elemData.handle;
                jQuery._removeData(elem, "events");
            }
        },
        trigger: function(event, data, elem, onlyHandlers) {
            var handle, ontype, cur, bubbleType, special, tmp, i, eventPath = [ elem || document ], type = hasOwn.call(event, "type") ? event.type : event, namespaces = hasOwn.call(event, "namespace") ? event.namespace.split(".") : [];
            cur = tmp = elem = elem || document;
            if (elem.nodeType === 3 || elem.nodeType === 8) {
                return;
            }
            if (rfocusMorph.test(type + jQuery.event.triggered)) {
                return;
            }
            if (type.indexOf(".") >= 0) {
                namespaces = type.split(".");
                type = namespaces.shift();
                namespaces.sort();
            }
            ontype = type.indexOf(":") < 0 && "on" + type;
            event = event[jQuery.expando] ? event : new jQuery.Event(type, typeof event === "object" && event);
            event.isTrigger = onlyHandlers ? 2 : 3;
            event.namespace = namespaces.join(".");
            event.namespace_re = event.namespace ? new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)") : null;
            event.result = undefined;
            if (!event.target) {
                event.target = elem;
            }
            data = data == null ? [ event ] : jQuery.makeArray(data, [ event ]);
            special = jQuery.event.special[type] || {};
            if (!onlyHandlers && special.trigger && special.trigger.apply(elem, data) === false) {
                return;
            }
            if (!onlyHandlers && !special.noBubble && !jQuery.isWindow(elem)) {
                bubbleType = special.delegateType || type;
                if (!rfocusMorph.test(bubbleType + type)) {
                    cur = cur.parentNode;
                }
                for (;cur; cur = cur.parentNode) {
                    eventPath.push(cur);
                    tmp = cur;
                }
                if (tmp === (elem.ownerDocument || document)) {
                    eventPath.push(tmp.defaultView || tmp.parentWindow || window);
                }
            }
            i = 0;
            while ((cur = eventPath[i++]) && !event.isPropagationStopped()) {
                event.type = i > 1 ? bubbleType : special.bindType || type;
                handle = (jQuery._data(cur, "events") || {})[event.type] && jQuery._data(cur, "handle");
                if (handle) {
                    handle.apply(cur, data);
                }
                handle = ontype && cur[ontype];
                if (handle && handle.apply && jQuery.acceptData(cur)) {
                    event.result = handle.apply(cur, data);
                    if (event.result === false) {
                        event.preventDefault();
                    }
                }
            }
            event.type = type;
            if (!onlyHandlers && !event.isDefaultPrevented()) {
                if ((!special._default || special._default.apply(eventPath.pop(), data) === false) && jQuery.acceptData(elem)) {
                    if (ontype && elem[type] && !jQuery.isWindow(elem)) {
                        tmp = elem[ontype];
                        if (tmp) {
                            elem[ontype] = null;
                        }
                        jQuery.event.triggered = type;
                        try {
                            elem[type]();
                        } catch (e) {}
                        jQuery.event.triggered = undefined;
                        if (tmp) {
                            elem[ontype] = tmp;
                        }
                    }
                }
            }
            return event.result;
        },
        dispatch: function(event) {
            event = jQuery.event.fix(event);
            var i, ret, handleObj, matched, j, handlerQueue = [], args = slice.call(arguments), handlers = (jQuery._data(this, "events") || {})[event.type] || [], special = jQuery.event.special[event.type] || {};
            args[0] = event;
            event.delegateTarget = this;
            if (special.preDispatch && special.preDispatch.call(this, event) === false) {
                return;
            }
            handlerQueue = jQuery.event.handlers.call(this, event, handlers);
            i = 0;
            while ((matched = handlerQueue[i++]) && !event.isPropagationStopped()) {
                event.currentTarget = matched.elem;
                j = 0;
                while ((handleObj = matched.handlers[j++]) && !event.isImmediatePropagationStopped()) {
                    if (!event.namespace_re || event.namespace_re.test(handleObj.namespace)) {
                        event.handleObj = handleObj;
                        event.data = handleObj.data;
                        ret = ((jQuery.event.special[handleObj.origType] || {}).handle || handleObj.handler).apply(matched.elem, args);
                        if (ret !== undefined) {
                            if ((event.result = ret) === false) {
                                event.preventDefault();
                                event.stopPropagation();
                            }
                        }
                    }
                }
            }
            if (special.postDispatch) {
                special.postDispatch.call(this, event);
            }
            return event.result;
        },
        handlers: function(event, handlers) {
            var sel, handleObj, matches, i, handlerQueue = [], delegateCount = handlers.delegateCount, cur = event.target;
            if (delegateCount && cur.nodeType && (!event.button || event.type !== "click")) {
                for (;cur != this; cur = cur.parentNode || this) {
                    if (cur.nodeType === 1 && (cur.disabled !== true || event.type !== "click")) {
                        matches = [];
                        for (i = 0; i < delegateCount; i++) {
                            handleObj = handlers[i];
                            sel = handleObj.selector + " ";
                            if (matches[sel] === undefined) {
                                matches[sel] = handleObj.needsContext ? jQuery(sel, this).index(cur) >= 0 : jQuery.find(sel, this, null, [ cur ]).length;
                            }
                            if (matches[sel]) {
                                matches.push(handleObj);
                            }
                        }
                        if (matches.length) {
                            handlerQueue.push({
                                elem: cur,
                                handlers: matches
                            });
                        }
                    }
                }
            }
            if (delegateCount < handlers.length) {
                handlerQueue.push({
                    elem: this,
                    handlers: handlers.slice(delegateCount)
                });
            }
            return handlerQueue;
        },
        fix: function(event) {
            if (event[jQuery.expando]) {
                return event;
            }
            var i, prop, copy, type = event.type, originalEvent = event, fixHook = this.fixHooks[type];
            if (!fixHook) {
                this.fixHooks[type] = fixHook = rmouseEvent.test(type) ? this.mouseHooks : rkeyEvent.test(type) ? this.keyHooks : {};
            }
            copy = fixHook.props ? this.props.concat(fixHook.props) : this.props;
            event = new jQuery.Event(originalEvent);
            i = copy.length;
            while (i--) {
                prop = copy[i];
                event[prop] = originalEvent[prop];
            }
            if (!event.target) {
                event.target = originalEvent.srcElement || document;
            }
            if (event.target.nodeType === 3) {
                event.target = event.target.parentNode;
            }
            event.metaKey = !!event.metaKey;
            return fixHook.filter ? fixHook.filter(event, originalEvent) : event;
        },
        props: "altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),
        fixHooks: {},
        keyHooks: {
            props: "char charCode key keyCode".split(" "),
            filter: function(event, original) {
                if (event.which == null) {
                    event.which = original.charCode != null ? original.charCode : original.keyCode;
                }
                return event;
            }
        },
        mouseHooks: {
            props: "button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "),
            filter: function(event, original) {
                var body, eventDoc, doc, button = original.button, fromElement = original.fromElement;
                if (event.pageX == null && original.clientX != null) {
                    eventDoc = event.target.ownerDocument || document;
                    doc = eventDoc.documentElement;
                    body = eventDoc.body;
                    event.pageX = original.clientX + (doc && doc.scrollLeft || body && body.scrollLeft || 0) - (doc && doc.clientLeft || body && body.clientLeft || 0);
                    event.pageY = original.clientY + (doc && doc.scrollTop || body && body.scrollTop || 0) - (doc && doc.clientTop || body && body.clientTop || 0);
                }
                if (!event.relatedTarget && fromElement) {
                    event.relatedTarget = fromElement === event.target ? original.toElement : fromElement;
                }
                if (!event.which && button !== undefined) {
                    event.which = button & 1 ? 1 : button & 2 ? 3 : button & 4 ? 2 : 0;
                }
                return event;
            }
        },
        special: {
            load: {
                noBubble: true
            },
            focus: {
                trigger: function() {
                    if (this !== safeActiveElement() && this.focus) {
                        try {
                            this.focus();
                            return false;
                        } catch (e) {}
                    }
                },
                delegateType: "focusin"
            },
            blur: {
                trigger: function() {
                    if (this === safeActiveElement() && this.blur) {
                        this.blur();
                        return false;
                    }
                },
                delegateType: "focusout"
            },
            click: {
                trigger: function() {
                    if (jQuery.nodeName(this, "input") && this.type === "checkbox" && this.click) {
                        this.click();
                        return false;
                    }
                },
                _default: function(event) {
                    return jQuery.nodeName(event.target, "a");
                }
            },
            beforeunload: {
                postDispatch: function(event) {
                    if (event.result !== undefined) {
                        event.originalEvent.returnValue = event.result;
                    }
                }
            }
        },
        simulate: function(type, elem, event, bubble) {
            var e = jQuery.extend(new jQuery.Event(), event, {
                type: type,
                isSimulated: true,
                originalEvent: {}
            });
            if (bubble) {
                jQuery.event.trigger(e, null, elem);
            } else {
                jQuery.event.dispatch.call(elem, e);
            }
            if (e.isDefaultPrevented()) {
                event.preventDefault();
            }
        }
    };
    jQuery.removeEvent = document.removeEventListener ? function(elem, type, handle) {
        if (elem.removeEventListener) {
            elem.removeEventListener(type, handle, false);
        }
    } : function(elem, type, handle) {
        var name = "on" + type;
        if (elem.detachEvent) {
            if (typeof elem[name] === strundefined) {
                elem[name] = null;
            }
            elem.detachEvent(name, handle);
        }
    };
    jQuery.Event = function(src, props) {
        if (!(this instanceof jQuery.Event)) {
            return new jQuery.Event(src, props);
        }
        if (src && src.type) {
            this.originalEvent = src;
            this.type = src.type;
            this.isDefaultPrevented = src.defaultPrevented || src.defaultPrevented === undefined && (src.returnValue === false || src.getPreventDefault && src.getPreventDefault()) ? returnTrue : returnFalse;
        } else {
            this.type = src;
        }
        if (props) {
            jQuery.extend(this, props);
        }
        this.timeStamp = src && src.timeStamp || jQuery.now();
        this[jQuery.expando] = true;
    };
    jQuery.Event.prototype = {
        isDefaultPrevented: returnFalse,
        isPropagationStopped: returnFalse,
        isImmediatePropagationStopped: returnFalse,
        preventDefault: function() {
            var e = this.originalEvent;
            this.isDefaultPrevented = returnTrue;
            if (!e) {
                return;
            }
            if (e.preventDefault) {
                e.preventDefault();
            } else {
                e.returnValue = false;
            }
        },
        stopPropagation: function() {
            var e = this.originalEvent;
            this.isPropagationStopped = returnTrue;
            if (!e) {
                return;
            }
            if (e.stopPropagation) {
                e.stopPropagation();
            }
            e.cancelBubble = true;
        },
        stopImmediatePropagation: function() {
            this.isImmediatePropagationStopped = returnTrue;
            this.stopPropagation();
        }
    };
    jQuery.each({
        mouseenter: "mouseover",
        mouseleave: "mouseout"
    }, function(orig, fix) {
        jQuery.event.special[orig] = {
            delegateType: fix,
            bindType: fix,
            handle: function(event) {
                var ret, target = this, related = event.relatedTarget, handleObj = event.handleObj;
                if (!related || related !== target && !jQuery.contains(target, related)) {
                    event.type = handleObj.origType;
                    ret = handleObj.handler.apply(this, arguments);
                    event.type = fix;
                }
                return ret;
            }
        };
    });
    if (!support.submitBubbles) {
        jQuery.event.special.submit = {
            setup: function() {
                if (jQuery.nodeName(this, "form")) {
                    return false;
                }
                jQuery.event.add(this, "click._submit keypress._submit", function(e) {
                    var elem = e.target, form = jQuery.nodeName(elem, "input") || jQuery.nodeName(elem, "button") ? elem.form : undefined;
                    if (form && !jQuery._data(form, "submitBubbles")) {
                        jQuery.event.add(form, "submit._submit", function(event) {
                            event._submit_bubble = true;
                        });
                        jQuery._data(form, "submitBubbles", true);
                    }
                });
            },
            postDispatch: function(event) {
                if (event._submit_bubble) {
                    delete event._submit_bubble;
                    if (this.parentNode && !event.isTrigger) {
                        jQuery.event.simulate("submit", this.parentNode, event, true);
                    }
                }
            },
            teardown: function() {
                if (jQuery.nodeName(this, "form")) {
                    return false;
                }
                jQuery.event.remove(this, "._submit");
            }
        };
    }
    if (!support.changeBubbles) {
        jQuery.event.special.change = {
            setup: function() {
                if (rformElems.test(this.nodeName)) {
                    if (this.type === "checkbox" || this.type === "radio") {
                        jQuery.event.add(this, "propertychange._change", function(event) {
                            if (event.originalEvent.propertyName === "checked") {
                                this._just_changed = true;
                            }
                        });
                        jQuery.event.add(this, "click._change", function(event) {
                            if (this._just_changed && !event.isTrigger) {
                                this._just_changed = false;
                            }
                            jQuery.event.simulate("change", this, event, true);
                        });
                    }
                    return false;
                }
                jQuery.event.add(this, "beforeactivate._change", function(e) {
                    var elem = e.target;
                    if (rformElems.test(elem.nodeName) && !jQuery._data(elem, "changeBubbles")) {
                        jQuery.event.add(elem, "change._change", function(event) {
                            if (this.parentNode && !event.isSimulated && !event.isTrigger) {
                                jQuery.event.simulate("change", this.parentNode, event, true);
                            }
                        });
                        jQuery._data(elem, "changeBubbles", true);
                    }
                });
            },
            handle: function(event) {
                var elem = event.target;
                if (this !== elem || event.isSimulated || event.isTrigger || elem.type !== "radio" && elem.type !== "checkbox") {
                    return event.handleObj.handler.apply(this, arguments);
                }
            },
            teardown: function() {
                jQuery.event.remove(this, "._change");
                return !rformElems.test(this.nodeName);
            }
        };
    }
    if (!support.focusinBubbles) {
        jQuery.each({
            focus: "focusin",
            blur: "focusout"
        }, function(orig, fix) {
            var handler = function(event) {
                jQuery.event.simulate(fix, event.target, jQuery.event.fix(event), true);
            };
            jQuery.event.special[fix] = {
                setup: function() {
                    var doc = this.ownerDocument || this, attaches = jQuery._data(doc, fix);
                    if (!attaches) {
                        doc.addEventListener(orig, handler, true);
                    }
                    jQuery._data(doc, fix, (attaches || 0) + 1);
                },
                teardown: function() {
                    var doc = this.ownerDocument || this, attaches = jQuery._data(doc, fix) - 1;
                    if (!attaches) {
                        doc.removeEventListener(orig, handler, true);
                        jQuery._removeData(doc, fix);
                    } else {
                        jQuery._data(doc, fix, attaches);
                    }
                }
            };
        });
    }
    jQuery.fn.extend({
        on: function(types, selector, data, fn, one) {
            var type, origFn;
            if (typeof types === "object") {
                if (typeof selector !== "string") {
                    data = data || selector;
                    selector = undefined;
                }
                for (type in types) {
                    this.on(type, selector, data, types[type], one);
                }
                return this;
            }
            if (data == null && fn == null) {
                fn = selector;
                data = selector = undefined;
            } else if (fn == null) {
                if (typeof selector === "string") {
                    fn = data;
                    data = undefined;
                } else {
                    fn = data;
                    data = selector;
                    selector = undefined;
                }
            }
            if (fn === false) {
                fn = returnFalse;
            } else if (!fn) {
                return this;
            }
            if (one === 1) {
                origFn = fn;
                fn = function(event) {
                    jQuery().off(event);
                    return origFn.apply(this, arguments);
                };
                fn.guid = origFn.guid || (origFn.guid = jQuery.guid++);
            }
            return this.each(function() {
                jQuery.event.add(this, types, fn, data, selector);
            });
        },
        one: function(types, selector, data, fn) {
            return this.on(types, selector, data, fn, 1);
        },
        off: function(types, selector, fn) {
            var handleObj, type;
            if (types && types.preventDefault && types.handleObj) {
                handleObj = types.handleObj;
                jQuery(types.delegateTarget).off(handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType, handleObj.selector, handleObj.handler);
                return this;
            }
            if (typeof types === "object") {
                for (type in types) {
                    this.off(type, selector, types[type]);
                }
                return this;
            }
            if (selector === false || typeof selector === "function") {
                fn = selector;
                selector = undefined;
            }
            if (fn === false) {
                fn = returnFalse;
            }
            return this.each(function() {
                jQuery.event.remove(this, types, fn, selector);
            });
        },
        trigger: function(type, data) {
            return this.each(function() {
                jQuery.event.trigger(type, data, this);
            });
        },
        triggerHandler: function(type, data) {
            var elem = this[0];
            if (elem) {
                return jQuery.event.trigger(type, data, elem, true);
            }
        }
    });
    function createSafeFragment(document) {
        var list = nodeNames.split("|"), safeFrag = document.createDocumentFragment();
        if (safeFrag.createElement) {
            while (list.length) {
                safeFrag.createElement(list.pop());
            }
        }
        return safeFrag;
    }
    var nodeNames = "abbr|article|aside|audio|bdi|canvas|data|datalist|details|figcaption|figure|footer|" + "header|hgroup|mark|meter|nav|output|progress|section|summary|time|video", rinlinejQuery = / jQuery\d+="(?:null|\d+)"/g, rnoshimcache = new RegExp("<(?:" + nodeNames + ")[\\s/>]", "i"), rleadingWhitespace = /^\s+/, rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi, rtagName = /<([\w:]+)/, rtbody = /<tbody/i, rhtml = /<|&#?\w+;/, rnoInnerhtml = /<(?:script|style|link)/i, rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i, rscriptType = /^$|\/(?:java|ecma)script/i, rscriptTypeMasked = /^true\/(.*)/, rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g, wrapMap = {
        option: [ 1, "<select multiple='multiple'>", "</select>" ],
        legend: [ 1, "<fieldset>", "</fieldset>" ],
        area: [ 1, "<map>", "</map>" ],
        param: [ 1, "<object>", "</object>" ],
        thead: [ 1, "<table>", "</table>" ],
        tr: [ 2, "<table><tbody>", "</tbody></table>" ],
        col: [ 2, "<table><tbody></tbody><colgroup>", "</colgroup></table>" ],
        td: [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ],
        _default: support.htmlSerialize ? [ 0, "", "" ] : [ 1, "X<div>", "</div>" ]
    }, safeFragment = createSafeFragment(document), fragmentDiv = safeFragment.appendChild(document.createElement("div"));
    wrapMap.optgroup = wrapMap.option;
    wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;
    wrapMap.th = wrapMap.td;
    function getAll(context, tag) {
        var elems, elem, i = 0, found = typeof context.getElementsByTagName !== strundefined ? context.getElementsByTagName(tag || "*") : typeof context.querySelectorAll !== strundefined ? context.querySelectorAll(tag || "*") : undefined;
        if (!found) {
            for (found = [], elems = context.childNodes || context; (elem = elems[i]) != null; i++) {
                if (!tag || jQuery.nodeName(elem, tag)) {
                    found.push(elem);
                } else {
                    jQuery.merge(found, getAll(elem, tag));
                }
            }
        }
        return tag === undefined || tag && jQuery.nodeName(context, tag) ? jQuery.merge([ context ], found) : found;
    }
    function fixDefaultChecked(elem) {
        if (rcheckableType.test(elem.type)) {
            elem.defaultChecked = elem.checked;
        }
    }
    function manipulationTarget(elem, content) {
        return jQuery.nodeName(elem, "table") && jQuery.nodeName(content.nodeType !== 11 ? content : content.firstChild, "tr") ? elem.getElementsByTagName("tbody")[0] || elem.appendChild(elem.ownerDocument.createElement("tbody")) : elem;
    }
    function disableScript(elem) {
        elem.type = (jQuery.find.attr(elem, "type") !== null) + "/" + elem.type;
        return elem;
    }
    function restoreScript(elem) {
        var match = rscriptTypeMasked.exec(elem.type);
        if (match) {
            elem.type = match[1];
        } else {
            elem.removeAttribute("type");
        }
        return elem;
    }
    function setGlobalEval(elems, refElements) {
        var elem, i = 0;
        for (;(elem = elems[i]) != null; i++) {
            jQuery._data(elem, "globalEval", !refElements || jQuery._data(refElements[i], "globalEval"));
        }
    }
    function cloneCopyEvent(src, dest) {
        if (dest.nodeType !== 1 || !jQuery.hasData(src)) {
            return;
        }
        var type, i, l, oldData = jQuery._data(src), curData = jQuery._data(dest, oldData), events = oldData.events;
        if (events) {
            delete curData.handle;
            curData.events = {};
            for (type in events) {
                for (i = 0, l = events[type].length; i < l; i++) {
                    jQuery.event.add(dest, type, events[type][i]);
                }
            }
        }
        if (curData.data) {
            curData.data = jQuery.extend({}, curData.data);
        }
    }
    function fixCloneNodeIssues(src, dest) {
        var nodeName, e, data;
        if (dest.nodeType !== 1) {
            return;
        }
        nodeName = dest.nodeName.toLowerCase();
        if (!support.noCloneEvent && dest[jQuery.expando]) {
            data = jQuery._data(dest);
            for (e in data.events) {
                jQuery.removeEvent(dest, e, data.handle);
            }
            dest.removeAttribute(jQuery.expando);
        }
        if (nodeName === "script" && dest.text !== src.text) {
            disableScript(dest).text = src.text;
            restoreScript(dest);
        } else if (nodeName === "object") {
            if (dest.parentNode) {
                dest.outerHTML = src.outerHTML;
            }
            if (support.html5Clone && (src.innerHTML && !jQuery.trim(dest.innerHTML))) {
                dest.innerHTML = src.innerHTML;
            }
        } else if (nodeName === "input" && rcheckableType.test(src.type)) {
            dest.defaultChecked = dest.checked = src.checked;
            if (dest.value !== src.value) {
                dest.value = src.value;
            }
        } else if (nodeName === "option") {
            dest.defaultSelected = dest.selected = src.defaultSelected;
        } else if (nodeName === "input" || nodeName === "textarea") {
            dest.defaultValue = src.defaultValue;
        }
    }
    jQuery.extend({
        clone: function(elem, dataAndEvents, deepDataAndEvents) {
            var destElements, node, clone, i, srcElements, inPage = jQuery.contains(elem.ownerDocument, elem);
            if (support.html5Clone || jQuery.isXMLDoc(elem) || !rnoshimcache.test("<" + elem.nodeName + ">")) {
                clone = elem.cloneNode(true);
            } else {
                fragmentDiv.innerHTML = elem.outerHTML;
                fragmentDiv.removeChild(clone = fragmentDiv.firstChild);
            }
            if ((!support.noCloneEvent || !support.noCloneChecked) && (elem.nodeType === 1 || elem.nodeType === 11) && !jQuery.isXMLDoc(elem)) {
                destElements = getAll(clone);
                srcElements = getAll(elem);
                for (i = 0; (node = srcElements[i]) != null; ++i) {
                    if (destElements[i]) {
                        fixCloneNodeIssues(node, destElements[i]);
                    }
                }
            }
            if (dataAndEvents) {
                if (deepDataAndEvents) {
                    srcElements = srcElements || getAll(elem);
                    destElements = destElements || getAll(clone);
                    for (i = 0; (node = srcElements[i]) != null; i++) {
                        cloneCopyEvent(node, destElements[i]);
                    }
                } else {
                    cloneCopyEvent(elem, clone);
                }
            }
            destElements = getAll(clone, "script");
            if (destElements.length > 0) {
                setGlobalEval(destElements, !inPage && getAll(elem, "script"));
            }
            destElements = srcElements = node = null;
            return clone;
        },
        buildFragment: function(elems, context, scripts, selection) {
            var j, elem, contains, tmp, tag, tbody, wrap, l = elems.length, safe = createSafeFragment(context), nodes = [], i = 0;
            for (;i < l; i++) {
                elem = elems[i];
                if (elem || elem === 0) {
                    if (jQuery.type(elem) === "object") {
                        jQuery.merge(nodes, elem.nodeType ? [ elem ] : elem);
                    } else if (!rhtml.test(elem)) {
                        nodes.push(context.createTextNode(elem));
                    } else {
                        tmp = tmp || safe.appendChild(context.createElement("div"));
                        tag = (rtagName.exec(elem) || [ "", "" ])[1].toLowerCase();
                        wrap = wrapMap[tag] || wrapMap._default;
                        tmp.innerHTML = wrap[1] + elem.replace(rxhtmlTag, "<$1></$2>") + wrap[2];
                        j = wrap[0];
                        while (j--) {
                            tmp = tmp.lastChild;
                        }
                        if (!support.leadingWhitespace && rleadingWhitespace.test(elem)) {
                            nodes.push(context.createTextNode(rleadingWhitespace.exec(elem)[0]));
                        }
                        if (!support.tbody) {
                            elem = tag === "table" && !rtbody.test(elem) ? tmp.firstChild : wrap[1] === "<table>" && !rtbody.test(elem) ? tmp : 0;
                            j = elem && elem.childNodes.length;
                            while (j--) {
                                if (jQuery.nodeName(tbody = elem.childNodes[j], "tbody") && !tbody.childNodes.length) {
                                    elem.removeChild(tbody);
                                }
                            }
                        }
                        jQuery.merge(nodes, tmp.childNodes);
                        tmp.textContent = "";
                        while (tmp.firstChild) {
                            tmp.removeChild(tmp.firstChild);
                        }
                        tmp = safe.lastChild;
                    }
                }
            }
            if (tmp) {
                safe.removeChild(tmp);
            }
            if (!support.appendChecked) {
                jQuery.grep(getAll(nodes, "input"), fixDefaultChecked);
            }
            i = 0;
            while (elem = nodes[i++]) {
                if (selection && jQuery.inArray(elem, selection) !== -1) {
                    continue;
                }
                contains = jQuery.contains(elem.ownerDocument, elem);
                tmp = getAll(safe.appendChild(elem), "script");
                if (contains) {
                    setGlobalEval(tmp);
                }
                if (scripts) {
                    j = 0;
                    while (elem = tmp[j++]) {
                        if (rscriptType.test(elem.type || "")) {
                            scripts.push(elem);
                        }
                    }
                }
            }
            tmp = null;
            return safe;
        },
        cleanData: function(elems, acceptData) {
            var elem, type, id, data, i = 0, internalKey = jQuery.expando, cache = jQuery.cache, deleteExpando = support.deleteExpando, special = jQuery.event.special;
            for (;(elem = elems[i]) != null; i++) {
                if (acceptData || jQuery.acceptData(elem)) {
                    id = elem[internalKey];
                    data = id && cache[id];
                    if (data) {
                        if (data.events) {
                            for (type in data.events) {
                                if (special[type]) {
                                    jQuery.event.remove(elem, type);
                                } else {
                                    jQuery.removeEvent(elem, type, data.handle);
                                }
                            }
                        }
                        if (cache[id]) {
                            delete cache[id];
                            if (deleteExpando) {
                                delete elem[internalKey];
                            } else if (typeof elem.removeAttribute !== strundefined) {
                                elem.removeAttribute(internalKey);
                            } else {
                                elem[internalKey] = null;
                            }
                            deletedIds.push(id);
                        }
                    }
                }
            }
        }
    });
    jQuery.fn.extend({
        text: function(value) {
            return access(this, function(value) {
                return value === undefined ? jQuery.text(this) : this.empty().append((this[0] && this[0].ownerDocument || document).createTextNode(value));
            }, null, value, arguments.length);
        },
        append: function() {
            return this.domManip(arguments, function(elem) {
                if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
                    var target = manipulationTarget(this, elem);
                    target.appendChild(elem);
                }
            });
        },
        prepend: function() {
            return this.domManip(arguments, function(elem) {
                if (this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9) {
                    var target = manipulationTarget(this, elem);
                    target.insertBefore(elem, target.firstChild);
                }
            });
        },
        before: function() {
            return this.domManip(arguments, function(elem) {
                if (this.parentNode) {
                    this.parentNode.insertBefore(elem, this);
                }
            });
        },
        after: function() {
            return this.domManip(arguments, function(elem) {
                if (this.parentNode) {
                    this.parentNode.insertBefore(elem, this.nextSibling);
                }
            });
        },
        remove: function(selector, keepData) {
            var elem, elems = selector ? jQuery.filter(selector, this) : this, i = 0;
            for (;(elem = elems[i]) != null; i++) {
                if (!keepData && elem.nodeType === 1) {
                    jQuery.cleanData(getAll(elem));
                }
                if (elem.parentNode) {
                    if (keepData && jQuery.contains(elem.ownerDocument, elem)) {
                        setGlobalEval(getAll(elem, "script"));
                    }
                    elem.parentNode.removeChild(elem);
                }
            }
            return this;
        },
        empty: function() {
            var elem, i = 0;
            for (;(elem = this[i]) != null; i++) {
                if (elem.nodeType === 1) {
                    jQuery.cleanData(getAll(elem, false));
                }
                while (elem.firstChild) {
                    elem.removeChild(elem.firstChild);
                }
                if (elem.options && jQuery.nodeName(elem, "select")) {
                    elem.options.length = 0;
                }
            }
            return this;
        },
        clone: function(dataAndEvents, deepDataAndEvents) {
            dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
            deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;
            return this.map(function() {
                return jQuery.clone(this, dataAndEvents, deepDataAndEvents);
            });
        },
        html: function(value) {
            return access(this, function(value) {
                var elem = this[0] || {}, i = 0, l = this.length;
                if (value === undefined) {
                    return elem.nodeType === 1 ? elem.innerHTML.replace(rinlinejQuery, "") : undefined;
                }
                if (typeof value === "string" && !rnoInnerhtml.test(value) && (support.htmlSerialize || !rnoshimcache.test(value)) && (support.leadingWhitespace || !rleadingWhitespace.test(value)) && !wrapMap[(rtagName.exec(value) || [ "", "" ])[1].toLowerCase()]) {
                    value = value.replace(rxhtmlTag, "<$1></$2>");
                    try {
                        for (;i < l; i++) {
                            elem = this[i] || {};
                            if (elem.nodeType === 1) {
                                jQuery.cleanData(getAll(elem, false));
                                elem.innerHTML = value;
                            }
                        }
                        elem = 0;
                    } catch (e) {}
                }
                if (elem) {
                    this.empty().append(value);
                }
            }, null, value, arguments.length);
        },
        replaceWith: function() {
            var arg = arguments[0];
            this.domManip(arguments, function(elem) {
                arg = this.parentNode;
                jQuery.cleanData(getAll(this));
                if (arg) {
                    arg.replaceChild(elem, this);
                }
            });
            return arg && (arg.length || arg.nodeType) ? this : this.remove();
        },
        detach: function(selector) {
            return this.remove(selector, true);
        },
        domManip: function(args, callback) {
            args = concat.apply([], args);
            var first, node, hasScripts, scripts, doc, fragment, i = 0, l = this.length, set = this, iNoClone = l - 1, value = args[0], isFunction = jQuery.isFunction(value);
            if (isFunction || l > 1 && typeof value === "string" && !support.checkClone && rchecked.test(value)) {
                return this.each(function(index) {
                    var self = set.eq(index);
                    if (isFunction) {
                        args[0] = value.call(this, index, self.html());
                    }
                    self.domManip(args, callback);
                });
            }
            if (l) {
                fragment = jQuery.buildFragment(args, this[0].ownerDocument, false, this);
                first = fragment.firstChild;
                if (fragment.childNodes.length === 1) {
                    fragment = first;
                }
                if (first) {
                    scripts = jQuery.map(getAll(fragment, "script"), disableScript);
                    hasScripts = scripts.length;
                    for (;i < l; i++) {
                        node = fragment;
                        if (i !== iNoClone) {
                            node = jQuery.clone(node, true, true);
                            if (hasScripts) {
                                jQuery.merge(scripts, getAll(node, "script"));
                            }
                        }
                        callback.call(this[i], node, i);
                    }
                    if (hasScripts) {
                        doc = scripts[scripts.length - 1].ownerDocument;
                        jQuery.map(scripts, restoreScript);
                        for (i = 0; i < hasScripts; i++) {
                            node = scripts[i];
                            if (rscriptType.test(node.type || "") && !jQuery._data(node, "globalEval") && jQuery.contains(doc, node)) {
                                if (node.src) {
                                    if (jQuery._evalUrl) {
                                        jQuery._evalUrl(node.src);
                                    }
                                } else {
                                    jQuery.globalEval((node.text || node.textContent || node.innerHTML || "").replace(rcleanScript, ""));
                                }
                            }
                        }
                    }
                    fragment = first = null;
                }
            }
            return this;
        }
    });
    jQuery.each({
        appendTo: "append",
        prependTo: "prepend",
        insertBefore: "before",
        insertAfter: "after",
        replaceAll: "replaceWith"
    }, function(name, original) {
        jQuery.fn[name] = function(selector) {
            var elems, i = 0, ret = [], insert = jQuery(selector), last = insert.length - 1;
            for (;i <= last; i++) {
                elems = i === last ? this : this.clone(true);
                jQuery(insert[i])[original](elems);
                push.apply(ret, elems.get());
            }
            return this.pushStack(ret);
        };
    });
    var iframe, elemdisplay = {};
    function actualDisplay(name, doc) {
        var elem = jQuery(doc.createElement(name)).appendTo(doc.body), display = window.getDefaultComputedStyle ? window.getDefaultComputedStyle(elem[0]).display : jQuery.css(elem[0], "display");
        elem.detach();
        return display;
    }
    function defaultDisplay(nodeName) {
        var doc = document, display = elemdisplay[nodeName];
        if (!display) {
            display = actualDisplay(nodeName, doc);
            if (display === "none" || !display) {
                iframe = (iframe || jQuery("<iframe frameborder='0' width='0' height='0'/>")).appendTo(doc.documentElement);
                doc = (iframe[0].contentWindow || iframe[0].contentDocument).document;
                doc.write();
                doc.close();
                display = actualDisplay(nodeName, doc);
                iframe.detach();
            }
            elemdisplay[nodeName] = display;
        }
        return display;
    }
    (function() {
        var a, shrinkWrapBlocksVal, div = document.createElement("div"), divReset = "-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;" + "display:block;padding:0;margin:0;border:0";
        div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";
        a = div.getElementsByTagName("a")[0];
        a.style.cssText = "float:left;opacity:.5";
        support.opacity = /^0.5/.test(a.style.opacity);
        support.cssFloat = !!a.style.cssFloat;
        div.style.backgroundClip = "content-box";
        div.cloneNode(true).style.backgroundClip = "";
        support.clearCloneStyle = div.style.backgroundClip === "content-box";
        a = div = null;
        support.shrinkWrapBlocks = function() {
            var body, container, div, containerStyles;
            if (shrinkWrapBlocksVal == null) {
                body = document.getElementsByTagName("body")[0];
                if (!body) {
                    return;
                }
                containerStyles = "border:0;width:0;height:0;position:absolute;top:0;left:-9999px";
                container = document.createElement("div");
                div = document.createElement("div");
                body.appendChild(container).appendChild(div);
                shrinkWrapBlocksVal = false;
                if (typeof div.style.zoom !== strundefined) {
                    div.style.cssText = divReset + ";width:1px;padding:1px;zoom:1";
                    div.innerHTML = "<div></div>";
                    div.firstChild.style.width = "5px";
                    shrinkWrapBlocksVal = div.offsetWidth !== 3;
                }
                body.removeChild(container);
                body = container = div = null;
            }
            return shrinkWrapBlocksVal;
        };
    })();
    var rmargin = /^margin/;
    var rnumnonpx = new RegExp("^(" + pnum + ")(?!px)[a-z%]+$", "i");
    var getStyles, curCSS, rposition = /^(top|right|bottom|left)$/;
    if (window.getComputedStyle) {
        getStyles = function(elem) {
            return elem.ownerDocument.defaultView.getComputedStyle(elem, null);
        };
        curCSS = function(elem, name, computed) {
            var width, minWidth, maxWidth, ret, style = elem.style;
            computed = computed || getStyles(elem);
            ret = computed ? computed.getPropertyValue(name) || computed[name] : undefined;
            if (computed) {
                if (ret === "" && !jQuery.contains(elem.ownerDocument, elem)) {
                    ret = jQuery.style(elem, name);
                }
                if (rnumnonpx.test(ret) && rmargin.test(name)) {
                    width = style.width;
                    minWidth = style.minWidth;
                    maxWidth = style.maxWidth;
                    style.minWidth = style.maxWidth = style.width = ret;
                    ret = computed.width;
                    style.width = width;
                    style.minWidth = minWidth;
                    style.maxWidth = maxWidth;
                }
            }
            return ret === undefined ? ret : ret + "";
        };
    } else if (document.documentElement.currentStyle) {
        getStyles = function(elem) {
            return elem.currentStyle;
        };
        curCSS = function(elem, name, computed) {
            var left, rs, rsLeft, ret, style = elem.style;
            computed = computed || getStyles(elem);
            ret = computed ? computed[name] : undefined;
            if (ret == null && style && style[name]) {
                ret = style[name];
            }
            if (rnumnonpx.test(ret) && !rposition.test(name)) {
                left = style.left;
                rs = elem.runtimeStyle;
                rsLeft = rs && rs.left;
                if (rsLeft) {
                    rs.left = elem.currentStyle.left;
                }
                style.left = name === "fontSize" ? "1em" : ret;
                ret = style.pixelLeft + "px";
                style.left = left;
                if (rsLeft) {
                    rs.left = rsLeft;
                }
            }
            return ret === undefined ? ret : ret + "" || "auto";
        };
    }
    function addGetHookIf(conditionFn, hookFn) {
        return {
            get: function() {
                var condition = conditionFn();
                if (condition == null) {
                    return;
                }
                if (condition) {
                    delete this.get;
                    return;
                }
                return (this.get = hookFn).apply(this, arguments);
            }
        };
    }
    (function() {
        var a, reliableHiddenOffsetsVal, boxSizingVal, boxSizingReliableVal, pixelPositionVal, reliableMarginRightVal, div = document.createElement("div"), containerStyles = "border:0;width:0;height:0;position:absolute;top:0;left:-9999px", divReset = "-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;" + "display:block;padding:0;margin:0;border:0";
        div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";
        a = div.getElementsByTagName("a")[0];
        a.style.cssText = "float:left;opacity:.5";
        support.opacity = /^0.5/.test(a.style.opacity);
        support.cssFloat = !!a.style.cssFloat;
        div.style.backgroundClip = "content-box";
        div.cloneNode(true).style.backgroundClip = "";
        support.clearCloneStyle = div.style.backgroundClip === "content-box";
        a = div = null;
        jQuery.extend(support, {
            reliableHiddenOffsets: function() {
                if (reliableHiddenOffsetsVal != null) {
                    return reliableHiddenOffsetsVal;
                }
                var container, tds, isSupported, div = document.createElement("div"), body = document.getElementsByTagName("body")[0];
                if (!body) {
                    return;
                }
                div.setAttribute("className", "t");
                div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";
                container = document.createElement("div");
                container.style.cssText = containerStyles;
                body.appendChild(container).appendChild(div);
                div.innerHTML = "<table><tr><td></td><td>t</td></tr></table>";
                tds = div.getElementsByTagName("td");
                tds[0].style.cssText = "padding:0;margin:0;border:0;display:none";
                isSupported = tds[0].offsetHeight === 0;
                tds[0].style.display = "";
                tds[1].style.display = "none";
                reliableHiddenOffsetsVal = isSupported && tds[0].offsetHeight === 0;
                body.removeChild(container);
                div = body = null;
                return reliableHiddenOffsetsVal;
            },
            boxSizing: function() {
                if (boxSizingVal == null) {
                    computeStyleTests();
                }
                return boxSizingVal;
            },
            boxSizingReliable: function() {
                if (boxSizingReliableVal == null) {
                    computeStyleTests();
                }
                return boxSizingReliableVal;
            },
            pixelPosition: function() {
                if (pixelPositionVal == null) {
                    computeStyleTests();
                }
                return pixelPositionVal;
            },
            reliableMarginRight: function() {
                var body, container, div, marginDiv;
                if (reliableMarginRightVal == null && window.getComputedStyle) {
                    body = document.getElementsByTagName("body")[0];
                    if (!body) {
                        return;
                    }
                    container = document.createElement("div");
                    div = document.createElement("div");
                    container.style.cssText = containerStyles;
                    body.appendChild(container).appendChild(div);
                    marginDiv = div.appendChild(document.createElement("div"));
                    marginDiv.style.cssText = div.style.cssText = divReset;
                    marginDiv.style.marginRight = marginDiv.style.width = "0";
                    div.style.width = "1px";
                    reliableMarginRightVal = !parseFloat((window.getComputedStyle(marginDiv, null) || {}).marginRight);
                    body.removeChild(container);
                }
                return reliableMarginRightVal;
            }
        });
        function computeStyleTests() {
            var container, div, body = document.getElementsByTagName("body")[0];
            if (!body) {
                return;
            }
            container = document.createElement("div");
            div = document.createElement("div");
            container.style.cssText = containerStyles;
            body.appendChild(container).appendChild(div);
            div.style.cssText = "-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;" + "position:absolute;display:block;padding:1px;border:1px;width:4px;" + "margin-top:1%;top:1%";
            jQuery.swap(body, body.style.zoom != null ? {
                zoom: 1
            } : {}, function() {
                boxSizingVal = div.offsetWidth === 4;
            });
            boxSizingReliableVal = true;
            pixelPositionVal = false;
            reliableMarginRightVal = true;
            if (window.getComputedStyle) {
                pixelPositionVal = (window.getComputedStyle(div, null) || {}).top !== "1%";
                boxSizingReliableVal = (window.getComputedStyle(div, null) || {
                    width: "4px"
                }).width === "4px";
            }
            body.removeChild(container);
            div = body = null;
        }
    })();
    jQuery.swap = function(elem, options, callback, args) {
        var ret, name, old = {};
        for (name in options) {
            old[name] = elem.style[name];
            elem.style[name] = options[name];
        }
        ret = callback.apply(elem, args || []);
        for (name in options) {
            elem.style[name] = old[name];
        }
        return ret;
    };
    var ralpha = /alpha\([^)]*\)/i, ropacity = /opacity\s*=\s*([^)]*)/, rdisplayswap = /^(none|table(?!-c[ea]).+)/, rnumsplit = new RegExp("^(" + pnum + ")(.*)$", "i"), rrelNum = new RegExp("^([+-])=(" + pnum + ")", "i"), cssShow = {
        position: "absolute",
        visibility: "hidden",
        display: "block"
    }, cssNormalTransform = {
        letterSpacing: 0,
        fontWeight: 400
    }, cssPrefixes = [ "Webkit", "O", "Moz", "ms" ];
    function vendorPropName(style, name) {
        if (name in style) {
            return name;
        }
        var capName = name.charAt(0).toUpperCase() + name.slice(1), origName = name, i = cssPrefixes.length;
        while (i--) {
            name = cssPrefixes[i] + capName;
            if (name in style) {
                return name;
            }
        }
        return origName;
    }
    function showHide(elements, show) {
        var display, elem, hidden, values = [], index = 0, length = elements.length;
        for (;index < length; index++) {
            elem = elements[index];
            if (!elem.style) {
                continue;
            }
            values[index] = jQuery._data(elem, "olddisplay");
            display = elem.style.display;
            if (show) {
                if (!values[index] && display === "none") {
                    elem.style.display = "";
                }
                if (elem.style.display === "" && isHidden(elem)) {
                    values[index] = jQuery._data(elem, "olddisplay", defaultDisplay(elem.nodeName));
                }
            } else {
                if (!values[index]) {
                    hidden = isHidden(elem);
                    if (display && display !== "none" || !hidden) {
                        jQuery._data(elem, "olddisplay", hidden ? display : jQuery.css(elem, "display"));
                    }
                }
            }
        }
        for (index = 0; index < length; index++) {
            elem = elements[index];
            if (!elem.style) {
                continue;
            }
            if (!show || elem.style.display === "none" || elem.style.display === "") {
                elem.style.display = show ? values[index] || "" : "none";
            }
        }
        return elements;
    }
    function setPositiveNumber(elem, value, subtract) {
        var matches = rnumsplit.exec(value);
        return matches ? Math.max(0, matches[1] - (subtract || 0)) + (matches[2] || "px") : value;
    }
    function augmentWidthOrHeight(elem, name, extra, isBorderBox, styles) {
        var i = extra === (isBorderBox ? "border" : "content") ? 4 : name === "width" ? 1 : 0, val = 0;
        for (;i < 4; i += 2) {
            if (extra === "margin") {
                val += jQuery.css(elem, extra + cssExpand[i], true, styles);
            }
            if (isBorderBox) {
                if (extra === "content") {
                    val -= jQuery.css(elem, "padding" + cssExpand[i], true, styles);
                }
                if (extra !== "margin") {
                    val -= jQuery.css(elem, "border" + cssExpand[i] + "Width", true, styles);
                }
            } else {
                val += jQuery.css(elem, "padding" + cssExpand[i], true, styles);
                if (extra !== "padding") {
                    val += jQuery.css(elem, "border" + cssExpand[i] + "Width", true, styles);
                }
            }
        }
        return val;
    }
    function getWidthOrHeight(elem, name, extra) {
        var valueIsBorderBox = true, val = name === "width" ? elem.offsetWidth : elem.offsetHeight, styles = getStyles(elem), isBorderBox = support.boxSizing() && jQuery.css(elem, "boxSizing", false, styles) === "border-box";
        if (val <= 0 || val == null) {
            val = curCSS(elem, name, styles);
            if (val < 0 || val == null) {
                val = elem.style[name];
            }
            if (rnumnonpx.test(val)) {
                return val;
            }
            valueIsBorderBox = isBorderBox && (support.boxSizingReliable() || val === elem.style[name]);
            val = parseFloat(val) || 0;
        }
        return val + augmentWidthOrHeight(elem, name, extra || (isBorderBox ? "border" : "content"), valueIsBorderBox, styles) + "px";
    }
    jQuery.extend({
        cssHooks: {
            opacity: {
                get: function(elem, computed) {
                    if (computed) {
                        var ret = curCSS(elem, "opacity");
                        return ret === "" ? "1" : ret;
                    }
                }
            }
        },
        cssNumber: {
            columnCount: true,
            fillOpacity: true,
            fontWeight: true,
            lineHeight: true,
            opacity: true,
            order: true,
            orphans: true,
            widows: true,
            zIndex: true,
            zoom: true
        },
        cssProps: {
            "float": support.cssFloat ? "cssFloat" : "styleFloat"
        },
        style: function(elem, name, value, extra) {
            if (!elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style) {
                return;
            }
            var ret, type, hooks, origName = jQuery.camelCase(name), style = elem.style;
            name = jQuery.cssProps[origName] || (jQuery.cssProps[origName] = vendorPropName(style, origName));
            hooks = jQuery.cssHooks[name] || jQuery.cssHooks[origName];
            if (value !== undefined) {
                type = typeof value;
                if (type === "string" && (ret = rrelNum.exec(value))) {
                    value = (ret[1] + 1) * ret[2] + parseFloat(jQuery.css(elem, name));
                    type = "number";
                }
                if (value == null || value !== value) {
                    return;
                }
                if (type === "number" && !jQuery.cssNumber[origName]) {
                    value += "px";
                }
                if (!support.clearCloneStyle && value === "" && name.indexOf("background") === 0) {
                    style[name] = "inherit";
                }
                if (!hooks || !("set" in hooks) || (value = hooks.set(elem, value, extra)) !== undefined) {
                    try {
                        style[name] = "";
                        style[name] = value;
                    } catch (e) {}
                }
            } else {
                if (hooks && "get" in hooks && (ret = hooks.get(elem, false, extra)) !== undefined) {
                    return ret;
                }
                return style[name];
            }
        },
        css: function(elem, name, extra, styles) {
            var num, val, hooks, origName = jQuery.camelCase(name);
            name = jQuery.cssProps[origName] || (jQuery.cssProps[origName] = vendorPropName(elem.style, origName));
            hooks = jQuery.cssHooks[name] || jQuery.cssHooks[origName];
            if (hooks && "get" in hooks) {
                val = hooks.get(elem, true, extra);
            }
            if (val === undefined) {
                val = curCSS(elem, name, styles);
            }
            if (val === "normal" && name in cssNormalTransform) {
                val = cssNormalTransform[name];
            }
            if (extra === "" || extra) {
                num = parseFloat(val);
                return extra === true || jQuery.isNumeric(num) ? num || 0 : val;
            }
            return val;
        }
    });
    jQuery.each([ "height", "width" ], function(i, name) {
        jQuery.cssHooks[name] = {
            get: function(elem, computed, extra) {
                if (computed) {
                    return elem.offsetWidth === 0 && rdisplayswap.test(jQuery.css(elem, "display")) ? jQuery.swap(elem, cssShow, function() {
                        return getWidthOrHeight(elem, name, extra);
                    }) : getWidthOrHeight(elem, name, extra);
                }
            },
            set: function(elem, value, extra) {
                var styles = extra && getStyles(elem);
                return setPositiveNumber(elem, value, extra ? augmentWidthOrHeight(elem, name, extra, support.boxSizing() && jQuery.css(elem, "boxSizing", false, styles) === "border-box", styles) : 0);
            }
        };
    });
    if (!support.opacity) {
        jQuery.cssHooks.opacity = {
            get: function(elem, computed) {
                return ropacity.test((computed && elem.currentStyle ? elem.currentStyle.filter : elem.style.filter) || "") ? .01 * parseFloat(RegExp.$1) + "" : computed ? "1" : "";
            },
            set: function(elem, value) {
                var style = elem.style, currentStyle = elem.currentStyle, opacity = jQuery.isNumeric(value) ? "alpha(opacity=" + value * 100 + ")" : "", filter = currentStyle && currentStyle.filter || style.filter || "";
                style.zoom = 1;
                if ((value >= 1 || value === "") && jQuery.trim(filter.replace(ralpha, "")) === "" && style.removeAttribute) {
                    style.removeAttribute("filter");
                    if (value === "" || currentStyle && !currentStyle.filter) {
                        return;
                    }
                }
                style.filter = ralpha.test(filter) ? filter.replace(ralpha, opacity) : filter + " " + opacity;
            }
        };
    }
    jQuery.cssHooks.marginRight = addGetHookIf(support.reliableMarginRight, function(elem, computed) {
        if (computed) {
            return jQuery.swap(elem, {
                display: "inline-block"
            }, curCSS, [ elem, "marginRight" ]);
        }
    });
    jQuery.each({
        margin: "",
        padding: "",
        border: "Width"
    }, function(prefix, suffix) {
        jQuery.cssHooks[prefix + suffix] = {
            expand: function(value) {
                var i = 0, expanded = {}, parts = typeof value === "string" ? value.split(" ") : [ value ];
                for (;i < 4; i++) {
                    expanded[prefix + cssExpand[i] + suffix] = parts[i] || parts[i - 2] || parts[0];
                }
                return expanded;
            }
        };
        if (!rmargin.test(prefix)) {
            jQuery.cssHooks[prefix + suffix].set = setPositiveNumber;
        }
    });
    jQuery.fn.extend({
        css: function(name, value) {
            return access(this, function(elem, name, value) {
                var styles, len, map = {}, i = 0;
                if (jQuery.isArray(name)) {
                    styles = getStyles(elem);
                    len = name.length;
                    for (;i < len; i++) {
                        map[name[i]] = jQuery.css(elem, name[i], false, styles);
                    }
                    return map;
                }
                return value !== undefined ? jQuery.style(elem, name, value) : jQuery.css(elem, name);
            }, name, value, arguments.length > 1);
        },
        show: function() {
            return showHide(this, true);
        },
        hide: function() {
            return showHide(this);
        },
        toggle: function(state) {
            if (typeof state === "boolean") {
                return state ? this.show() : this.hide();
            }
            return this.each(function() {
                if (isHidden(this)) {
                    jQuery(this).show();
                } else {
                    jQuery(this).hide();
                }
            });
        }
    });
    function Tween(elem, options, prop, end, easing) {
        return new Tween.prototype.init(elem, options, prop, end, easing);
    }
    jQuery.Tween = Tween;
    Tween.prototype = {
        constructor: Tween,
        init: function(elem, options, prop, end, easing, unit) {
            this.elem = elem;
            this.prop = prop;
            this.easing = easing || "swing";
            this.options = options;
            this.start = this.now = this.cur();
            this.end = end;
            this.unit = unit || (jQuery.cssNumber[prop] ? "" : "px");
        },
        cur: function() {
            var hooks = Tween.propHooks[this.prop];
            return hooks && hooks.get ? hooks.get(this) : Tween.propHooks._default.get(this);
        },
        run: function(percent) {
            var eased, hooks = Tween.propHooks[this.prop];
            if (this.options.duration) {
                this.pos = eased = jQuery.easing[this.easing](percent, this.options.duration * percent, 0, 1, this.options.duration);
            } else {
                this.pos = eased = percent;
            }
            this.now = (this.end - this.start) * eased + this.start;
            if (this.options.step) {
                this.options.step.call(this.elem, this.now, this);
            }
            if (hooks && hooks.set) {
                hooks.set(this);
            } else {
                Tween.propHooks._default.set(this);
            }
            return this;
        }
    };
    Tween.prototype.init.prototype = Tween.prototype;
    Tween.propHooks = {
        _default: {
            get: function(tween) {
                var result;
                if (tween.elem[tween.prop] != null && (!tween.elem.style || tween.elem.style[tween.prop] == null)) {
                    return tween.elem[tween.prop];
                }
                result = jQuery.css(tween.elem, tween.prop, "");
                return !result || result === "auto" ? 0 : result;
            },
            set: function(tween) {
                if (jQuery.fx.step[tween.prop]) {
                    jQuery.fx.step[tween.prop](tween);
                } else if (tween.elem.style && (tween.elem.style[jQuery.cssProps[tween.prop]] != null || jQuery.cssHooks[tween.prop])) {
                    jQuery.style(tween.elem, tween.prop, tween.now + tween.unit);
                } else {
                    tween.elem[tween.prop] = tween.now;
                }
            }
        }
    };
    Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
        set: function(tween) {
            if (tween.elem.nodeType && tween.elem.parentNode) {
                tween.elem[tween.prop] = tween.now;
            }
        }
    };
    jQuery.easing = {
        linear: function(p) {
            return p;
        },
        swing: function(p) {
            return .5 - Math.cos(p * Math.PI) / 2;
        }
    };
    jQuery.fx = Tween.prototype.init;
    jQuery.fx.step = {};
    var fxNow, timerId, rfxtypes = /^(?:toggle|show|hide)$/, rfxnum = new RegExp("^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i"), rrun = /queueHooks$/, animationPrefilters = [ defaultPrefilter ], tweeners = {
        "*": [ function(prop, value) {
            var tween = this.createTween(prop, value), target = tween.cur(), parts = rfxnum.exec(value), unit = parts && parts[3] || (jQuery.cssNumber[prop] ? "" : "px"), start = (jQuery.cssNumber[prop] || unit !== "px" && +target) && rfxnum.exec(jQuery.css(tween.elem, prop)), scale = 1, maxIterations = 20;
            if (start && start[3] !== unit) {
                unit = unit || start[3];
                parts = parts || [];
                start = +target || 1;
                do {
                    scale = scale || ".5";
                    start = start / scale;
                    jQuery.style(tween.elem, prop, start + unit);
                } while (scale !== (scale = tween.cur() / target) && scale !== 1 && --maxIterations);
            }
            if (parts) {
                start = tween.start = +start || +target || 0;
                tween.unit = unit;
                tween.end = parts[1] ? start + (parts[1] + 1) * parts[2] : +parts[2];
            }
            return tween;
        } ]
    };
    function createFxNow() {
        setTimeout(function() {
            fxNow = undefined;
        });
        return fxNow = jQuery.now();
    }
    function genFx(type, includeWidth) {
        var which, attrs = {
            height: type
        }, i = 0;
        includeWidth = includeWidth ? 1 : 0;
        for (;i < 4; i += 2 - includeWidth) {
            which = cssExpand[i];
            attrs["margin" + which] = attrs["padding" + which] = type;
        }
        if (includeWidth) {
            attrs.opacity = attrs.width = type;
        }
        return attrs;
    }
    function createTween(value, prop, animation) {
        var tween, collection = (tweeners[prop] || []).concat(tweeners["*"]), index = 0, length = collection.length;
        for (;index < length; index++) {
            if (tween = collection[index].call(animation, prop, value)) {
                return tween;
            }
        }
    }
    function defaultPrefilter(elem, props, opts) {
        var prop, value, toggle, tween, hooks, oldfire, display, dDisplay, anim = this, orig = {}, style = elem.style, hidden = elem.nodeType && isHidden(elem), dataShow = jQuery._data(elem, "fxshow");
        if (!opts.queue) {
            hooks = jQuery._queueHooks(elem, "fx");
            if (hooks.unqueued == null) {
                hooks.unqueued = 0;
                oldfire = hooks.empty.fire;
                hooks.empty.fire = function() {
                    if (!hooks.unqueued) {
                        oldfire();
                    }
                };
            }
            hooks.unqueued++;
            anim.always(function() {
                anim.always(function() {
                    hooks.unqueued--;
                    if (!jQuery.queue(elem, "fx").length) {
                        hooks.empty.fire();
                    }
                });
            });
        }
        if (elem.nodeType === 1 && ("height" in props || "width" in props)) {
            opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];
            display = jQuery.css(elem, "display");
            dDisplay = defaultDisplay(elem.nodeName);
            if (display === "none") {
                display = dDisplay;
            }
            if (display === "inline" && jQuery.css(elem, "float") === "none") {
                if (!support.inlineBlockNeedsLayout || dDisplay === "inline") {
                    style.display = "inline-block";
                } else {
                    style.zoom = 1;
                }
            }
        }
        if (opts.overflow) {
            style.overflow = "hidden";
            if (!support.shrinkWrapBlocks()) {
                anim.always(function() {
                    style.overflow = opts.overflow[0];
                    style.overflowX = opts.overflow[1];
                    style.overflowY = opts.overflow[2];
                });
            }
        }
        for (prop in props) {
            value = props[prop];
            if (rfxtypes.exec(value)) {
                delete props[prop];
                toggle = toggle || value === "toggle";
                if (value === (hidden ? "hide" : "show")) {
                    if (value === "show" && dataShow && dataShow[prop] !== undefined) {
                        hidden = true;
                    } else {
                        continue;
                    }
                }
                orig[prop] = dataShow && dataShow[prop] || jQuery.style(elem, prop);
            }
        }
        if (!jQuery.isEmptyObject(orig)) {
            if (dataShow) {
                if ("hidden" in dataShow) {
                    hidden = dataShow.hidden;
                }
            } else {
                dataShow = jQuery._data(elem, "fxshow", {});
            }
            if (toggle) {
                dataShow.hidden = !hidden;
            }
            if (hidden) {
                jQuery(elem).show();
            } else {
                anim.done(function() {
                    jQuery(elem).hide();
                });
            }
            anim.done(function() {
                var prop;
                jQuery._removeData(elem, "fxshow");
                for (prop in orig) {
                    jQuery.style(elem, prop, orig[prop]);
                }
            });
            for (prop in orig) {
                tween = createTween(hidden ? dataShow[prop] : 0, prop, anim);
                if (!(prop in dataShow)) {
                    dataShow[prop] = tween.start;
                    if (hidden) {
                        tween.end = tween.start;
                        tween.start = prop === "width" || prop === "height" ? 1 : 0;
                    }
                }
            }
        }
    }
    function propFilter(props, specialEasing) {
        var index, name, easing, value, hooks;
        for (index in props) {
            name = jQuery.camelCase(index);
            easing = specialEasing[name];
            value = props[index];
            if (jQuery.isArray(value)) {
                easing = value[1];
                value = props[index] = value[0];
            }
            if (index !== name) {
                props[name] = value;
                delete props[index];
            }
            hooks = jQuery.cssHooks[name];
            if (hooks && "expand" in hooks) {
                value = hooks.expand(value);
                delete props[name];
                for (index in value) {
                    if (!(index in props)) {
                        props[index] = value[index];
                        specialEasing[index] = easing;
                    }
                }
            } else {
                specialEasing[name] = easing;
            }
        }
    }
    function Animation(elem, properties, options) {
        var result, stopped, index = 0, length = animationPrefilters.length, deferred = jQuery.Deferred().always(function() {
            delete tick.elem;
        }), tick = function() {
            if (stopped) {
                return false;
            }
            var currentTime = fxNow || createFxNow(), remaining = Math.max(0, animation.startTime + animation.duration - currentTime), temp = remaining / animation.duration || 0, percent = 1 - temp, index = 0, length = animation.tweens.length;
            for (;index < length; index++) {
                animation.tweens[index].run(percent);
            }
            deferred.notifyWith(elem, [ animation, percent, remaining ]);
            if (percent < 1 && length) {
                return remaining;
            } else {
                deferred.resolveWith(elem, [ animation ]);
                return false;
            }
        }, animation = deferred.promise({
            elem: elem,
            props: jQuery.extend({}, properties),
            opts: jQuery.extend(true, {
                specialEasing: {}
            }, options),
            originalProperties: properties,
            originalOptions: options,
            startTime: fxNow || createFxNow(),
            duration: options.duration,
            tweens: [],
            createTween: function(prop, end) {
                var tween = jQuery.Tween(elem, animation.opts, prop, end, animation.opts.specialEasing[prop] || animation.opts.easing);
                animation.tweens.push(tween);
                return tween;
            },
            stop: function(gotoEnd) {
                var index = 0, length = gotoEnd ? animation.tweens.length : 0;
                if (stopped) {
                    return this;
                }
                stopped = true;
                for (;index < length; index++) {
                    animation.tweens[index].run(1);
                }
                if (gotoEnd) {
                    deferred.resolveWith(elem, [ animation, gotoEnd ]);
                } else {
                    deferred.rejectWith(elem, [ animation, gotoEnd ]);
                }
                return this;
            }
        }), props = animation.props;
        propFilter(props, animation.opts.specialEasing);
        for (;index < length; index++) {
            result = animationPrefilters[index].call(animation, elem, props, animation.opts);
            if (result) {
                return result;
            }
        }
        jQuery.map(props, createTween, animation);
        if (jQuery.isFunction(animation.opts.start)) {
            animation.opts.start.call(elem, animation);
        }
        jQuery.fx.timer(jQuery.extend(tick, {
            elem: elem,
            anim: animation,
            queue: animation.opts.queue
        }));
        return animation.progress(animation.opts.progress).done(animation.opts.done, animation.opts.complete).fail(animation.opts.fail).always(animation.opts.always);
    }
    jQuery.Animation = jQuery.extend(Animation, {
        tweener: function(props, callback) {
            if (jQuery.isFunction(props)) {
                callback = props;
                props = [ "*" ];
            } else {
                props = props.split(" ");
            }
            var prop, index = 0, length = props.length;
            for (;index < length; index++) {
                prop = props[index];
                tweeners[prop] = tweeners[prop] || [];
                tweeners[prop].unshift(callback);
            }
        },
        prefilter: function(callback, prepend) {
            if (prepend) {
                animationPrefilters.unshift(callback);
            } else {
                animationPrefilters.push(callback);
            }
        }
    });
    jQuery.speed = function(speed, easing, fn) {
        var opt = speed && typeof speed === "object" ? jQuery.extend({}, speed) : {
            complete: fn || !fn && easing || jQuery.isFunction(speed) && speed,
            duration: speed,
            easing: fn && easing || easing && !jQuery.isFunction(easing) && easing
        };
        opt.duration = jQuery.fx.off ? 0 : typeof opt.duration === "number" ? opt.duration : opt.duration in jQuery.fx.speeds ? jQuery.fx.speeds[opt.duration] : jQuery.fx.speeds._default;
        if (opt.queue == null || opt.queue === true) {
            opt.queue = "fx";
        }
        opt.old = opt.complete;
        opt.complete = function() {
            if (jQuery.isFunction(opt.old)) {
                opt.old.call(this);
            }
            if (opt.queue) {
                jQuery.dequeue(this, opt.queue);
            }
        };
        return opt;
    };
    jQuery.fn.extend({
        fadeTo: function(speed, to, easing, callback) {
            return this.filter(isHidden).css("opacity", 0).show().end().animate({
                opacity: to
            }, speed, easing, callback);
        },
        animate: function(prop, speed, easing, callback) {
            var empty = jQuery.isEmptyObject(prop), optall = jQuery.speed(speed, easing, callback), doAnimation = function() {
                var anim = Animation(this, jQuery.extend({}, prop), optall);
                if (empty || jQuery._data(this, "finish")) {
                    anim.stop(true);
                }
            };
            doAnimation.finish = doAnimation;
            return empty || optall.queue === false ? this.each(doAnimation) : this.queue(optall.queue, doAnimation);
        },
        stop: function(type, clearQueue, gotoEnd) {
            var stopQueue = function(hooks) {
                var stop = hooks.stop;
                delete hooks.stop;
                stop(gotoEnd);
            };
            if (typeof type !== "string") {
                gotoEnd = clearQueue;
                clearQueue = type;
                type = undefined;
            }
            if (clearQueue && type !== false) {
                this.queue(type || "fx", []);
            }
            return this.each(function() {
                var dequeue = true, index = type != null && type + "queueHooks", timers = jQuery.timers, data = jQuery._data(this);
                if (index) {
                    if (data[index] && data[index].stop) {
                        stopQueue(data[index]);
                    }
                } else {
                    for (index in data) {
                        if (data[index] && data[index].stop && rrun.test(index)) {
                            stopQueue(data[index]);
                        }
                    }
                }
                for (index = timers.length; index--; ) {
                    if (timers[index].elem === this && (type == null || timers[index].queue === type)) {
                        timers[index].anim.stop(gotoEnd);
                        dequeue = false;
                        timers.splice(index, 1);
                    }
                }
                if (dequeue || !gotoEnd) {
                    jQuery.dequeue(this, type);
                }
            });
        },
        finish: function(type) {
            if (type !== false) {
                type = type || "fx";
            }
            return this.each(function() {
                var index, data = jQuery._data(this), queue = data[type + "queue"], hooks = data[type + "queueHooks"], timers = jQuery.timers, length = queue ? queue.length : 0;
                data.finish = true;
                jQuery.queue(this, type, []);
                if (hooks && hooks.stop) {
                    hooks.stop.call(this, true);
                }
                for (index = timers.length; index--; ) {
                    if (timers[index].elem === this && timers[index].queue === type) {
                        timers[index].anim.stop(true);
                        timers.splice(index, 1);
                    }
                }
                for (index = 0; index < length; index++) {
                    if (queue[index] && queue[index].finish) {
                        queue[index].finish.call(this);
                    }
                }
                delete data.finish;
            });
        }
    });
    jQuery.each([ "toggle", "show", "hide" ], function(i, name) {
        var cssFn = jQuery.fn[name];
        jQuery.fn[name] = function(speed, easing, callback) {
            return speed == null || typeof speed === "boolean" ? cssFn.apply(this, arguments) : this.animate(genFx(name, true), speed, easing, callback);
        };
    });
    jQuery.each({
        slideDown: genFx("show"),
        slideUp: genFx("hide"),
        slideToggle: genFx("toggle"),
        fadeIn: {
            opacity: "show"
        },
        fadeOut: {
            opacity: "hide"
        },
        fadeToggle: {
            opacity: "toggle"
        }
    }, function(name, props) {
        jQuery.fn[name] = function(speed, easing, callback) {
            return this.animate(props, speed, easing, callback);
        };
    });
    jQuery.timers = [];
    jQuery.fx.tick = function() {
        var timer, timers = jQuery.timers, i = 0;
        fxNow = jQuery.now();
        for (;i < timers.length; i++) {
            timer = timers[i];
            if (!timer() && timers[i] === timer) {
                timers.splice(i--, 1);
            }
        }
        if (!timers.length) {
            jQuery.fx.stop();
        }
        fxNow = undefined;
    };
    jQuery.fx.timer = function(timer) {
        jQuery.timers.push(timer);
        if (timer()) {
            jQuery.fx.start();
        } else {
            jQuery.timers.pop();
        }
    };
    jQuery.fx.interval = 13;
    jQuery.fx.start = function() {
        if (!timerId) {
            timerId = setInterval(jQuery.fx.tick, jQuery.fx.interval);
        }
    };
    jQuery.fx.stop = function() {
        clearInterval(timerId);
        timerId = null;
    };
    jQuery.fx.speeds = {
        slow: 600,
        fast: 200,
        _default: 400
    };
    jQuery.fn.delay = function(time, type) {
        time = jQuery.fx ? jQuery.fx.speeds[time] || time : time;
        type = type || "fx";
        return this.queue(type, function(next, hooks) {
            var timeout = setTimeout(next, time);
            hooks.stop = function() {
                clearTimeout(timeout);
            };
        });
    };
    (function() {
        var a, input, select, opt, div = document.createElement("div");
        div.setAttribute("className", "t");
        div.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>";
        a = div.getElementsByTagName("a")[0];
        select = document.createElement("select");
        opt = select.appendChild(document.createElement("option"));
        input = div.getElementsByTagName("input")[0];
        a.style.cssText = "top:1px";
        support.getSetAttribute = div.className !== "t";
        support.style = /top/.test(a.getAttribute("style"));
        support.hrefNormalized = a.getAttribute("href") === "/a";
        support.checkOn = !!input.value;
        support.optSelected = opt.selected;
        support.enctype = !!document.createElement("form").enctype;
        select.disabled = true;
        support.optDisabled = !opt.disabled;
        input = document.createElement("input");
        input.setAttribute("value", "");
        support.input = input.getAttribute("value") === "";
        input.value = "t";
        input.setAttribute("type", "radio");
        support.radioValue = input.value === "t";
        a = input = select = opt = div = null;
    })();
    var rreturn = /\r/g;
    jQuery.fn.extend({
        val: function(value) {
            var hooks, ret, isFunction, elem = this[0];
            if (!arguments.length) {
                if (elem) {
                    hooks = jQuery.valHooks[elem.type] || jQuery.valHooks[elem.nodeName.toLowerCase()];
                    if (hooks && "get" in hooks && (ret = hooks.get(elem, "value")) !== undefined) {
                        return ret;
                    }
                    ret = elem.value;
                    return typeof ret === "string" ? ret.replace(rreturn, "") : ret == null ? "" : ret;
                }
                return;
            }
            isFunction = jQuery.isFunction(value);
            return this.each(function(i) {
                var val;
                if (this.nodeType !== 1) {
                    return;
                }
                if (isFunction) {
                    val = value.call(this, i, jQuery(this).val());
                } else {
                    val = value;
                }
                if (val == null) {
                    val = "";
                } else if (typeof val === "number") {
                    val += "";
                } else if (jQuery.isArray(val)) {
                    val = jQuery.map(val, function(value) {
                        return value == null ? "" : value + "";
                    });
                }
                hooks = jQuery.valHooks[this.type] || jQuery.valHooks[this.nodeName.toLowerCase()];
                if (!hooks || !("set" in hooks) || hooks.set(this, val, "value") === undefined) {
                    this.value = val;
                }
            });
        }
    });
    jQuery.extend({
        valHooks: {
            option: {
                get: function(elem) {
                    var val = jQuery.find.attr(elem, "value");
                    return val != null ? val : jQuery.text(elem);
                }
            },
            select: {
                get: function(elem) {
                    var value, option, options = elem.options, index = elem.selectedIndex, one = elem.type === "select-one" || index < 0, values = one ? null : [], max = one ? index + 1 : options.length, i = index < 0 ? max : one ? index : 0;
                    for (;i < max; i++) {
                        option = options[i];
                        if ((option.selected || i === index) && (support.optDisabled ? !option.disabled : option.getAttribute("disabled") === null) && (!option.parentNode.disabled || !jQuery.nodeName(option.parentNode, "optgroup"))) {
                            value = jQuery(option).val();
                            if (one) {
                                return value;
                            }
                            values.push(value);
                        }
                    }
                    return values;
                },
                set: function(elem, value) {
                    var optionSet, option, options = elem.options, values = jQuery.makeArray(value), i = options.length;
                    while (i--) {
                        option = options[i];
                        if (jQuery.inArray(jQuery.valHooks.option.get(option), values) >= 0) {
                            try {
                                option.selected = optionSet = true;
                            } catch (_) {
                                option.scrollHeight;
                            }
                        } else {
                            option.selected = false;
                        }
                    }
                    if (!optionSet) {
                        elem.selectedIndex = -1;
                    }
                    return options;
                }
            }
        }
    });
    jQuery.each([ "radio", "checkbox" ], function() {
        jQuery.valHooks[this] = {
            set: function(elem, value) {
                if (jQuery.isArray(value)) {
                    return elem.checked = jQuery.inArray(jQuery(elem).val(), value) >= 0;
                }
            }
        };
        if (!support.checkOn) {
            jQuery.valHooks[this].get = function(elem) {
                return elem.getAttribute("value") === null ? "on" : elem.value;
            };
        }
    });
    var nodeHook, boolHook, attrHandle = jQuery.expr.attrHandle, ruseDefault = /^(?:checked|selected)$/i, getSetAttribute = support.getSetAttribute, getSetInput = support.input;
    jQuery.fn.extend({
        attr: function(name, value) {
            return access(this, jQuery.attr, name, value, arguments.length > 1);
        },
        removeAttr: function(name) {
            return this.each(function() {
                jQuery.removeAttr(this, name);
            });
        }
    });
    jQuery.extend({
        attr: function(elem, name, value) {
            var hooks, ret, nType = elem.nodeType;
            if (!elem || nType === 3 || nType === 8 || nType === 2) {
                return;
            }
            if (typeof elem.getAttribute === strundefined) {
                return jQuery.prop(elem, name, value);
            }
            if (nType !== 1 || !jQuery.isXMLDoc(elem)) {
                name = name.toLowerCase();
                hooks = jQuery.attrHooks[name] || (jQuery.expr.match.bool.test(name) ? boolHook : nodeHook);
            }
            if (value !== undefined) {
                if (value === null) {
                    jQuery.removeAttr(elem, name);
                } else if (hooks && "set" in hooks && (ret = hooks.set(elem, value, name)) !== undefined) {
                    return ret;
                } else {
                    elem.setAttribute(name, value + "");
                    return value;
                }
            } else if (hooks && "get" in hooks && (ret = hooks.get(elem, name)) !== null) {
                return ret;
            } else {
                ret = jQuery.find.attr(elem, name);
                return ret == null ? undefined : ret;
            }
        },
        removeAttr: function(elem, value) {
            var name, propName, i = 0, attrNames = value && value.match(rnotwhite);
            if (attrNames && elem.nodeType === 1) {
                while (name = attrNames[i++]) {
                    propName = jQuery.propFix[name] || name;
                    if (jQuery.expr.match.bool.test(name)) {
                        if (getSetInput && getSetAttribute || !ruseDefault.test(name)) {
                            elem[propName] = false;
                        } else {
                            elem[jQuery.camelCase("default-" + name)] = elem[propName] = false;
                        }
                    } else {
                        jQuery.attr(elem, name, "");
                    }
                    elem.removeAttribute(getSetAttribute ? name : propName);
                }
            }
        },
        attrHooks: {
            type: {
                set: function(elem, value) {
                    if (!support.radioValue && value === "radio" && jQuery.nodeName(elem, "input")) {
                        var val = elem.value;
                        elem.setAttribute("type", value);
                        if (val) {
                            elem.value = val;
                        }
                        return value;
                    }
                }
            }
        }
    });
    boolHook = {
        set: function(elem, value, name) {
            if (value === false) {
                jQuery.removeAttr(elem, name);
            } else if (getSetInput && getSetAttribute || !ruseDefault.test(name)) {
                elem.setAttribute(!getSetAttribute && jQuery.propFix[name] || name, name);
            } else {
                elem[jQuery.camelCase("default-" + name)] = elem[name] = true;
            }
            return name;
        }
    };
    jQuery.each(jQuery.expr.match.bool.source.match(/\w+/g), function(i, name) {
        var getter = attrHandle[name] || jQuery.find.attr;
        attrHandle[name] = getSetInput && getSetAttribute || !ruseDefault.test(name) ? function(elem, name, isXML) {
            var ret, handle;
            if (!isXML) {
                handle = attrHandle[name];
                attrHandle[name] = ret;
                ret = getter(elem, name, isXML) != null ? name.toLowerCase() : null;
                attrHandle[name] = handle;
            }
            return ret;
        } : function(elem, name, isXML) {
            if (!isXML) {
                return elem[jQuery.camelCase("default-" + name)] ? name.toLowerCase() : null;
            }
        };
    });
    if (!getSetInput || !getSetAttribute) {
        jQuery.attrHooks.value = {
            set: function(elem, value, name) {
                if (jQuery.nodeName(elem, "input")) {
                    elem.defaultValue = value;
                } else {
                    return nodeHook && nodeHook.set(elem, value, name);
                }
            }
        };
    }
    if (!getSetAttribute) {
        nodeHook = {
            set: function(elem, value, name) {
                var ret = elem.getAttributeNode(name);
                if (!ret) {
                    elem.setAttributeNode(ret = elem.ownerDocument.createAttribute(name));
                }
                ret.value = value += "";
                if (name === "value" || value === elem.getAttribute(name)) {
                    return value;
                }
            }
        };
        attrHandle.id = attrHandle.name = attrHandle.coords = function(elem, name, isXML) {
            var ret;
            if (!isXML) {
                return (ret = elem.getAttributeNode(name)) && ret.value !== "" ? ret.value : null;
            }
        };
        jQuery.valHooks.button = {
            get: function(elem, name) {
                var ret = elem.getAttributeNode(name);
                if (ret && ret.specified) {
                    return ret.value;
                }
            },
            set: nodeHook.set
        };
        jQuery.attrHooks.contenteditable = {
            set: function(elem, value, name) {
                nodeHook.set(elem, value === "" ? false : value, name);
            }
        };
        jQuery.each([ "width", "height" ], function(i, name) {
            jQuery.attrHooks[name] = {
                set: function(elem, value) {
                    if (value === "") {
                        elem.setAttribute(name, "auto");
                        return value;
                    }
                }
            };
        });
    }
    if (!support.style) {
        jQuery.attrHooks.style = {
            get: function(elem) {
                return elem.style.cssText || undefined;
            },
            set: function(elem, value) {
                return elem.style.cssText = value + "";
            }
        };
    }
    var rfocusable = /^(?:input|select|textarea|button|object)$/i, rclickable = /^(?:a|area)$/i;
    jQuery.fn.extend({
        prop: function(name, value) {
            return access(this, jQuery.prop, name, value, arguments.length > 1);
        },
        removeProp: function(name) {
            name = jQuery.propFix[name] || name;
            return this.each(function() {
                try {
                    this[name] = undefined;
                    delete this[name];
                } catch (e) {}
            });
        }
    });
    jQuery.extend({
        propFix: {
            "for": "htmlFor",
            "class": "className"
        },
        prop: function(elem, name, value) {
            var ret, hooks, notxml, nType = elem.nodeType;
            if (!elem || nType === 3 || nType === 8 || nType === 2) {
                return;
            }
            notxml = nType !== 1 || !jQuery.isXMLDoc(elem);
            if (notxml) {
                name = jQuery.propFix[name] || name;
                hooks = jQuery.propHooks[name];
            }
            if (value !== undefined) {
                return hooks && "set" in hooks && (ret = hooks.set(elem, value, name)) !== undefined ? ret : elem[name] = value;
            } else {
                return hooks && "get" in hooks && (ret = hooks.get(elem, name)) !== null ? ret : elem[name];
            }
        },
        propHooks: {
            tabIndex: {
                get: function(elem) {
                    var tabindex = jQuery.find.attr(elem, "tabindex");
                    return tabindex ? parseInt(tabindex, 10) : rfocusable.test(elem.nodeName) || rclickable.test(elem.nodeName) && elem.href ? 0 : -1;
                }
            }
        }
    });
    if (!support.hrefNormalized) {
        jQuery.each([ "href", "src" ], function(i, name) {
            jQuery.propHooks[name] = {
                get: function(elem) {
                    return elem.getAttribute(name, 4);
                }
            };
        });
    }
    if (!support.optSelected) {
        jQuery.propHooks.selected = {
            get: function(elem) {
                var parent = elem.parentNode;
                if (parent) {
                    parent.selectedIndex;
                    if (parent.parentNode) {
                        parent.parentNode.selectedIndex;
                    }
                }
                return null;
            }
        };
    }
    jQuery.each([ "tabIndex", "readOnly", "maxLength", "cellSpacing", "cellPadding", "rowSpan", "colSpan", "useMap", "frameBorder", "contentEditable" ], function() {
        jQuery.propFix[this.toLowerCase()] = this;
    });
    if (!support.enctype) {
        jQuery.propFix.enctype = "encoding";
    }
    var rclass = /[\t\r\n\f]/g;
    jQuery.fn.extend({
        addClass: function(value) {
            var classes, elem, cur, clazz, j, finalValue, i = 0, len = this.length, proceed = typeof value === "string" && value;
            if (jQuery.isFunction(value)) {
                return this.each(function(j) {
                    jQuery(this).addClass(value.call(this, j, this.className));
                });
            }
            if (proceed) {
                classes = (value || "").match(rnotwhite) || [];
                for (;i < len; i++) {
                    elem = this[i];
                    cur = elem.nodeType === 1 && (elem.className ? (" " + elem.className + " ").replace(rclass, " ") : " ");
                    if (cur) {
                        j = 0;
                        while (clazz = classes[j++]) {
                            if (cur.indexOf(" " + clazz + " ") < 0) {
                                cur += clazz + " ";
                            }
                        }
                        finalValue = jQuery.trim(cur);
                        if (elem.className !== finalValue) {
                            elem.className = finalValue;
                        }
                    }
                }
            }
            return this;
        },
        removeClass: function(value) {
            var classes, elem, cur, clazz, j, finalValue, i = 0, len = this.length, proceed = arguments.length === 0 || typeof value === "string" && value;
            if (jQuery.isFunction(value)) {
                return this.each(function(j) {
                    jQuery(this).removeClass(value.call(this, j, this.className));
                });
            }
            if (proceed) {
                classes = (value || "").match(rnotwhite) || [];
                for (;i < len; i++) {
                    elem = this[i];
                    cur = elem.nodeType === 1 && (elem.className ? (" " + elem.className + " ").replace(rclass, " ") : "");
                    if (cur) {
                        j = 0;
                        while (clazz = classes[j++]) {
                            while (cur.indexOf(" " + clazz + " ") >= 0) {
                                cur = cur.replace(" " + clazz + " ", " ");
                            }
                        }
                        finalValue = value ? jQuery.trim(cur) : "";
                        if (elem.className !== finalValue) {
                            elem.className = finalValue;
                        }
                    }
                }
            }
            return this;
        },
        toggleClass: function(value, stateVal) {
            var type = typeof value;
            if (typeof stateVal === "boolean" && type === "string") {
                return stateVal ? this.addClass(value) : this.removeClass(value);
            }
            if (jQuery.isFunction(value)) {
                return this.each(function(i) {
                    jQuery(this).toggleClass(value.call(this, i, this.className, stateVal), stateVal);
                });
            }
            return this.each(function() {
                if (type === "string") {
                    var className, i = 0, self = jQuery(this), classNames = value.match(rnotwhite) || [];
                    while (className = classNames[i++]) {
                        if (self.hasClass(className)) {
                            self.removeClass(className);
                        } else {
                            self.addClass(className);
                        }
                    }
                } else if (type === strundefined || type === "boolean") {
                    if (this.className) {
                        jQuery._data(this, "__className__", this.className);
                    }
                    this.className = this.className || value === false ? "" : jQuery._data(this, "__className__") || "";
                }
            });
        },
        hasClass: function(selector) {
            var className = " " + selector + " ", i = 0, l = this.length;
            for (;i < l; i++) {
                if (this[i].nodeType === 1 && (" " + this[i].className + " ").replace(rclass, " ").indexOf(className) >= 0) {
                    return true;
                }
            }
            return false;
        }
    });
    jQuery.each(("blur focus focusin focusout load resize scroll unload click dblclick " + "mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " + "change select submit keydown keypress keyup error contextmenu").split(" "), function(i, name) {
        jQuery.fn[name] = function(data, fn) {
            return arguments.length > 0 ? this.on(name, null, data, fn) : this.trigger(name);
        };
    });
    jQuery.fn.extend({
        hover: function(fnOver, fnOut) {
            return this.mouseenter(fnOver).mouseleave(fnOut || fnOver);
        },
        bind: function(types, data, fn) {
            return this.on(types, null, data, fn);
        },
        unbind: function(types, fn) {
            return this.off(types, null, fn);
        },
        delegate: function(selector, types, data, fn) {
            return this.on(types, selector, data, fn);
        },
        undelegate: function(selector, types, fn) {
            return arguments.length === 1 ? this.off(selector, "**") : this.off(types, selector || "**", fn);
        }
    });
    var nonce = jQuery.now();
    var rquery = /\?/;
    var rvalidtokens = /(,)|(\[|{)|(}|])|"(?:[^"\\\r\n]|\\["\\\/bfnrt]|\\u[\da-fA-F]{4})*"\s*:?|true|false|null|-?(?!0\d)\d+(?:\.\d+|)(?:[eE][+-]?\d+|)/g;
    jQuery.parseJSON = function(data) {
        if (window.JSON && window.JSON.parse) {
            return window.JSON.parse(data + "");
        }
        var requireNonComma, depth = null, str = jQuery.trim(data + "");
        return str && !jQuery.trim(str.replace(rvalidtokens, function(token, comma, open, close) {
            if (requireNonComma && comma) {
                depth = 0;
            }
            if (depth === 0) {
                return token;
            }
            requireNonComma = open || comma;
            depth += !close - !open;
            return "";
        })) ? Function("return " + str)() : jQuery.error("Invalid JSON: " + data);
    };
    jQuery.parseXML = function(data) {
        var xml, tmp;
        if (!data || typeof data !== "string") {
            return null;
        }
        try {
            if (window.DOMParser) {
                tmp = new DOMParser();
                xml = tmp.parseFromString(data, "text/xml");
            } else {
                xml = new ActiveXObject("Microsoft.XMLDOM");
                xml.async = "false";
                xml.loadXML(data);
            }
        } catch (e) {
            xml = undefined;
        }
        if (!xml || !xml.documentElement || xml.getElementsByTagName("parsererror").length) {
            jQuery.error("Invalid XML: " + data);
        }
        return xml;
    };
    var ajaxLocParts, ajaxLocation, rhash = /#.*$/, rts = /([?&])_=[^&]*/, rheaders = /^(.*?):[ \t]*([^\r\n]*)\r?$/gm, rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/, rnoContent = /^(?:GET|HEAD)$/, rprotocol = /^\/\//, rurl = /^([\w.+-]+:)(?:\/\/(?:[^\/?#]*@|)([^\/?#:]*)(?::(\d+)|)|)/, prefilters = {}, transports = {}, allTypes = "*/".concat("*");
    try {
        ajaxLocation = location.href;
    } catch (e) {
        ajaxLocation = document.createElement("a");
        ajaxLocation.href = "";
        ajaxLocation = ajaxLocation.href;
    }
    ajaxLocParts = rurl.exec(ajaxLocation.toLowerCase()) || [];
    function addToPrefiltersOrTransports(structure) {
        return function(dataTypeExpression, func) {
            if (typeof dataTypeExpression !== "string") {
                func = dataTypeExpression;
                dataTypeExpression = "*";
            }
            var dataType, i = 0, dataTypes = dataTypeExpression.toLowerCase().match(rnotwhite) || [];
            if (jQuery.isFunction(func)) {
                while (dataType = dataTypes[i++]) {
                    if (dataType.charAt(0) === "+") {
                        dataType = dataType.slice(1) || "*";
                        (structure[dataType] = structure[dataType] || []).unshift(func);
                    } else {
                        (structure[dataType] = structure[dataType] || []).push(func);
                    }
                }
            }
        };
    }
    function inspectPrefiltersOrTransports(structure, options, originalOptions, jqXHR) {
        var inspected = {}, seekingTransport = structure === transports;
        function inspect(dataType) {
            var selected;
            inspected[dataType] = true;
            jQuery.each(structure[dataType] || [], function(_, prefilterOrFactory) {
                var dataTypeOrTransport = prefilterOrFactory(options, originalOptions, jqXHR);
                if (typeof dataTypeOrTransport === "string" && !seekingTransport && !inspected[dataTypeOrTransport]) {
                    options.dataTypes.unshift(dataTypeOrTransport);
                    inspect(dataTypeOrTransport);
                    return false;
                } else if (seekingTransport) {
                    return !(selected = dataTypeOrTransport);
                }
            });
            return selected;
        }
        return inspect(options.dataTypes[0]) || !inspected["*"] && inspect("*");
    }
    function ajaxExtend(target, src) {
        var deep, key, flatOptions = jQuery.ajaxSettings.flatOptions || {};
        for (key in src) {
            if (src[key] !== undefined) {
                (flatOptions[key] ? target : deep || (deep = {}))[key] = src[key];
            }
        }
        if (deep) {
            jQuery.extend(true, target, deep);
        }
        return target;
    }
    function ajaxHandleResponses(s, jqXHR, responses) {
        var firstDataType, ct, finalDataType, type, contents = s.contents, dataTypes = s.dataTypes;
        while (dataTypes[0] === "*") {
            dataTypes.shift();
            if (ct === undefined) {
                ct = s.mimeType || jqXHR.getResponseHeader("Content-Type");
            }
        }
        if (ct) {
            for (type in contents) {
                if (contents[type] && contents[type].test(ct)) {
                    dataTypes.unshift(type);
                    break;
                }
            }
        }
        if (dataTypes[0] in responses) {
            finalDataType = dataTypes[0];
        } else {
            for (type in responses) {
                if (!dataTypes[0] || s.converters[type + " " + dataTypes[0]]) {
                    finalDataType = type;
                    break;
                }
                if (!firstDataType) {
                    firstDataType = type;
                }
            }
            finalDataType = finalDataType || firstDataType;
        }
        if (finalDataType) {
            if (finalDataType !== dataTypes[0]) {
                dataTypes.unshift(finalDataType);
            }
            return responses[finalDataType];
        }
    }
    function ajaxConvert(s, response, jqXHR, isSuccess) {
        var conv2, current, conv, tmp, prev, converters = {}, dataTypes = s.dataTypes.slice();
        if (dataTypes[1]) {
            for (conv in s.converters) {
                converters[conv.toLowerCase()] = s.converters[conv];
            }
        }
        current = dataTypes.shift();
        while (current) {
            if (s.responseFields[current]) {
                jqXHR[s.responseFields[current]] = response;
            }
            if (!prev && isSuccess && s.dataFilter) {
                response = s.dataFilter(response, s.dataType);
            }
            prev = current;
            current = dataTypes.shift();
            if (current) {
                if (current === "*") {
                    current = prev;
                } else if (prev !== "*" && prev !== current) {
                    conv = converters[prev + " " + current] || converters["* " + current];
                    if (!conv) {
                        for (conv2 in converters) {
                            tmp = conv2.split(" ");
                            if (tmp[1] === current) {
                                conv = converters[prev + " " + tmp[0]] || converters["* " + tmp[0]];
                                if (conv) {
                                    if (conv === true) {
                                        conv = converters[conv2];
                                    } else if (converters[conv2] !== true) {
                                        current = tmp[0];
                                        dataTypes.unshift(tmp[1]);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                    if (conv !== true) {
                        if (conv && s["throws"]) {
                            response = conv(response);
                        } else {
                            try {
                                response = conv(response);
                            } catch (e) {
                                return {
                                    state: "parsererror",
                                    error: conv ? e : "No conversion from " + prev + " to " + current
                                };
                            }
                        }
                    }
                }
            }
        }
        return {
            state: "success",
            data: response
        };
    }
    jQuery.extend({
        active: 0,
        lastModified: {},
        etag: {},
        ajaxSettings: {
            url: ajaxLocation,
            type: "GET",
            isLocal: rlocalProtocol.test(ajaxLocParts[1]),
            global: true,
            processData: true,
            async: true,
            contentType: "application/x-www-form-urlencoded; charset=UTF-8",
            accepts: {
                "*": allTypes,
                text: "text/plain",
                html: "text/html",
                xml: "application/xml, text/xml",
                json: "application/json, text/javascript"
            },
            contents: {
                xml: /xml/,
                html: /html/,
                json: /json/
            },
            responseFields: {
                xml: "responseXML",
                text: "responseText",
                json: "responseJSON"
            },
            converters: {
                "* text": String,
                "text html": true,
                "text json": jQuery.parseJSON,
                "text xml": jQuery.parseXML
            },
            flatOptions: {
                url: true,
                context: true
            }
        },
        ajaxSetup: function(target, settings) {
            return settings ? ajaxExtend(ajaxExtend(target, jQuery.ajaxSettings), settings) : ajaxExtend(jQuery.ajaxSettings, target);
        },
        ajaxPrefilter: addToPrefiltersOrTransports(prefilters),
        ajaxTransport: addToPrefiltersOrTransports(transports),
        ajax: function(url, options) {
            if (typeof url === "object") {
                options = url;
                url = undefined;
            }
            options = options || {};
            var parts, i, cacheURL, responseHeadersString, timeoutTimer, fireGlobals, transport, responseHeaders, s = jQuery.ajaxSetup({}, options), callbackContext = s.context || s, globalEventContext = s.context && (callbackContext.nodeType || callbackContext.jquery) ? jQuery(callbackContext) : jQuery.event, deferred = jQuery.Deferred(), completeDeferred = jQuery.Callbacks("once memory"), statusCode = s.statusCode || {}, requestHeaders = {}, requestHeadersNames = {}, state = 0, strAbort = "canceled", jqXHR = {
                readyState: 0,
                getResponseHeader: function(key) {
                    var match;
                    if (state === 2) {
                        if (!responseHeaders) {
                            responseHeaders = {};
                            while (match = rheaders.exec(responseHeadersString)) {
                                responseHeaders[match[1].toLowerCase()] = match[2];
                            }
                        }
                        match = responseHeaders[key.toLowerCase()];
                    }
                    return match == null ? null : match;
                },
                getAllResponseHeaders: function() {
                    return state === 2 ? responseHeadersString : null;
                },
                setRequestHeader: function(name, value) {
                    var lname = name.toLowerCase();
                    if (!state) {
                        name = requestHeadersNames[lname] = requestHeadersNames[lname] || name;
                        requestHeaders[name] = value;
                    }
                    return this;
                },
                overrideMimeType: function(type) {
                    if (!state) {
                        s.mimeType = type;
                    }
                    return this;
                },
                statusCode: function(map) {
                    var code;
                    if (map) {
                        if (state < 2) {
                            for (code in map) {
                                statusCode[code] = [ statusCode[code], map[code] ];
                            }
                        } else {
                            jqXHR.always(map[jqXHR.status]);
                        }
                    }
                    return this;
                },
                abort: function(statusText) {
                    var finalText = statusText || strAbort;
                    if (transport) {
                        transport.abort(finalText);
                    }
                    done(0, finalText);
                    return this;
                }
            };
            deferred.promise(jqXHR).complete = completeDeferred.add;
            jqXHR.success = jqXHR.done;
            jqXHR.error = jqXHR.fail;
            s.url = ((url || s.url || ajaxLocation) + "").replace(rhash, "").replace(rprotocol, ajaxLocParts[1] + "//");
            s.type = options.method || options.type || s.method || s.type;
            s.dataTypes = jQuery.trim(s.dataType || "*").toLowerCase().match(rnotwhite) || [ "" ];
            if (s.crossDomain == null) {
                parts = rurl.exec(s.url.toLowerCase());
                s.crossDomain = !!(parts && (parts[1] !== ajaxLocParts[1] || parts[2] !== ajaxLocParts[2] || (parts[3] || (parts[1] === "http:" ? "80" : "443")) !== (ajaxLocParts[3] || (ajaxLocParts[1] === "http:" ? "80" : "443"))));
            }
            if (s.data && s.processData && typeof s.data !== "string") {
                s.data = jQuery.param(s.data, s.traditional);
            }
            inspectPrefiltersOrTransports(prefilters, s, options, jqXHR);
            if (state === 2) {
                return jqXHR;
            }
            fireGlobals = s.global;
            if (fireGlobals && jQuery.active++ === 0) {
                jQuery.event.trigger("ajaxStart");
            }
            s.type = s.type.toUpperCase();
            s.hasContent = !rnoContent.test(s.type);
            cacheURL = s.url;
            if (!s.hasContent) {
                if (s.data) {
                    cacheURL = s.url += (rquery.test(cacheURL) ? "&" : "?") + s.data;
                    delete s.data;
                }
                if (s.cache === false) {
                    s.url = rts.test(cacheURL) ? cacheURL.replace(rts, "$1_=" + nonce++) : cacheURL + (rquery.test(cacheURL) ? "&" : "?") + "_=" + nonce++;
                }
            }
            if (s.ifModified) {
                if (jQuery.lastModified[cacheURL]) {
                    jqXHR.setRequestHeader("If-Modified-Since", jQuery.lastModified[cacheURL]);
                }
                if (jQuery.etag[cacheURL]) {
                    jqXHR.setRequestHeader("If-None-Match", jQuery.etag[cacheURL]);
                }
            }
            if (s.data && s.hasContent && s.contentType !== false || options.contentType) {
                jqXHR.setRequestHeader("Content-Type", s.contentType);
            }
            jqXHR.setRequestHeader("Accept", s.dataTypes[0] && s.accepts[s.dataTypes[0]] ? s.accepts[s.dataTypes[0]] + (s.dataTypes[0] !== "*" ? ", " + allTypes + "; q=0.01" : "") : s.accepts["*"]);
            for (i in s.headers) {
                jqXHR.setRequestHeader(i, s.headers[i]);
            }
            if (s.beforeSend && (s.beforeSend.call(callbackContext, jqXHR, s) === false || state === 2)) {
                return jqXHR.abort();
            }
            strAbort = "abort";
            for (i in {
                success: 1,
                error: 1,
                complete: 1
            }) {
                jqXHR[i](s[i]);
            }
            transport = inspectPrefiltersOrTransports(transports, s, options, jqXHR);
            if (!transport) {
                done(-1, "No Transport");
            } else {
                jqXHR.readyState = 1;
                if (fireGlobals) {
                    globalEventContext.trigger("ajaxSend", [ jqXHR, s ]);
                }
                if (s.async && s.timeout > 0) {
                    timeoutTimer = setTimeout(function() {
                        jqXHR.abort("timeout");
                    }, s.timeout);
                }
                try {
                    state = 1;
                    transport.send(requestHeaders, done);
                } catch (e) {
                    if (state < 2) {
                        done(-1, e);
                    } else {
                        throw e;
                    }
                }
            }
            function done(status, nativeStatusText, responses, headers) {
                var isSuccess, success, error, response, modified, statusText = nativeStatusText;
                if (state === 2) {
                    return;
                }
                state = 2;
                if (timeoutTimer) {
                    clearTimeout(timeoutTimer);
                }
                transport = undefined;
                responseHeadersString = headers || "";
                jqXHR.readyState = status > 0 ? 4 : 0;
                isSuccess = status >= 200 && status < 300 || status === 304;
                if (responses) {
                    response = ajaxHandleResponses(s, jqXHR, responses);
                }
                response = ajaxConvert(s, response, jqXHR, isSuccess);
                if (isSuccess) {
                    if (s.ifModified) {
                        modified = jqXHR.getResponseHeader("Last-Modified");
                        if (modified) {
                            jQuery.lastModified[cacheURL] = modified;
                        }
                        modified = jqXHR.getResponseHeader("etag");
                        if (modified) {
                            jQuery.etag[cacheURL] = modified;
                        }
                    }
                    if (status === 204 || s.type === "HEAD") {
                        statusText = "nocontent";
                    } else if (status === 304) {
                        statusText = "notmodified";
                    } else {
                        statusText = response.state;
                        success = response.data;
                        error = response.error;
                        isSuccess = !error;
                    }
                } else {
                    error = statusText;
                    if (status || !statusText) {
                        statusText = "error";
                        if (status < 0) {
                            status = 0;
                        }
                    }
                }
                jqXHR.status = status;
                jqXHR.statusText = (nativeStatusText || statusText) + "";
                if (isSuccess) {
                    deferred.resolveWith(callbackContext, [ success, statusText, jqXHR ]);
                } else {
                    deferred.rejectWith(callbackContext, [ jqXHR, statusText, error ]);
                }
                jqXHR.statusCode(statusCode);
                statusCode = undefined;
                if (fireGlobals) {
                    globalEventContext.trigger(isSuccess ? "ajaxSuccess" : "ajaxError", [ jqXHR, s, isSuccess ? success : error ]);
                }
                completeDeferred.fireWith(callbackContext, [ jqXHR, statusText ]);
                if (fireGlobals) {
                    globalEventContext.trigger("ajaxComplete", [ jqXHR, s ]);
                    if (!--jQuery.active) {
                        jQuery.event.trigger("ajaxStop");
                    }
                }
            }
            return jqXHR;
        },
        getJSON: function(url, data, callback) {
            return jQuery.get(url, data, callback, "json");
        },
        getScript: function(url, callback) {
            return jQuery.get(url, undefined, callback, "script");
        }
    });
    jQuery.each([ "get", "post" ], function(i, method) {
        jQuery[method] = function(url, data, callback, type) {
            if (jQuery.isFunction(data)) {
                type = type || callback;
                callback = data;
                data = undefined;
            }
            return jQuery.ajax({
                url: url,
                type: method,
                dataType: type,
                data: data,
                success: callback
            });
        };
    });
    jQuery.each([ "ajaxStart", "ajaxStop", "ajaxComplete", "ajaxError", "ajaxSuccess", "ajaxSend" ], function(i, type) {
        jQuery.fn[type] = function(fn) {
            return this.on(type, fn);
        };
    });
    jQuery._evalUrl = function(url) {
        return jQuery.ajax({
            url: url,
            type: "GET",
            dataType: "script",
            async: false,
            global: false,
            "throws": true
        });
    };
    jQuery.fn.extend({
        wrapAll: function(html) {
            if (jQuery.isFunction(html)) {
                return this.each(function(i) {
                    jQuery(this).wrapAll(html.call(this, i));
                });
            }
            if (this[0]) {
                var wrap = jQuery(html, this[0].ownerDocument).eq(0).clone(true);
                if (this[0].parentNode) {
                    wrap.insertBefore(this[0]);
                }
                wrap.map(function() {
                    var elem = this;
                    while (elem.firstChild && elem.firstChild.nodeType === 1) {
                        elem = elem.firstChild;
                    }
                    return elem;
                }).append(this);
            }
            return this;
        },
        wrapInner: function(html) {
            if (jQuery.isFunction(html)) {
                return this.each(function(i) {
                    jQuery(this).wrapInner(html.call(this, i));
                });
            }
            return this.each(function() {
                var self = jQuery(this), contents = self.contents();
                if (contents.length) {
                    contents.wrapAll(html);
                } else {
                    self.append(html);
                }
            });
        },
        wrap: function(html) {
            var isFunction = jQuery.isFunction(html);
            return this.each(function(i) {
                jQuery(this).wrapAll(isFunction ? html.call(this, i) : html);
            });
        },
        unwrap: function() {
            return this.parent().each(function() {
                if (!jQuery.nodeName(this, "body")) {
                    jQuery(this).replaceWith(this.childNodes);
                }
            }).end();
        }
    });
    jQuery.expr.filters.hidden = function(elem) {
        return elem.offsetWidth <= 0 && elem.offsetHeight <= 0 || !support.reliableHiddenOffsets() && (elem.style && elem.style.display || jQuery.css(elem, "display")) === "none";
    };
    jQuery.expr.filters.visible = function(elem) {
        return !jQuery.expr.filters.hidden(elem);
    };
    var r20 = /%20/g, rbracket = /\[\]$/, rCRLF = /\r?\n/g, rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i, rsubmittable = /^(?:input|select|textarea|keygen)/i;
    function buildParams(prefix, obj, traditional, add) {
        var name;
        if (jQuery.isArray(obj)) {
            jQuery.each(obj, function(i, v) {
                if (traditional || rbracket.test(prefix)) {
                    add(prefix, v);
                } else {
                    buildParams(prefix + "[" + (typeof v === "object" ? i : "") + "]", v, traditional, add);
                }
            });
        } else if (!traditional && jQuery.type(obj) === "object") {
            for (name in obj) {
                buildParams(prefix + "[" + name + "]", obj[name], traditional, add);
            }
        } else {
            add(prefix, obj);
        }
    }
    jQuery.param = function(a, traditional) {
        var prefix, s = [], add = function(key, value) {
            value = jQuery.isFunction(value) ? value() : value == null ? "" : value;
            s[s.length] = encodeURIComponent(key) + "=" + encodeURIComponent(value);
        };
        if (traditional === undefined) {
            traditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;
        }
        if (jQuery.isArray(a) || a.jquery && !jQuery.isPlainObject(a)) {
            jQuery.each(a, function() {
                add(this.name, this.value);
            });
        } else {
            for (prefix in a) {
                buildParams(prefix, a[prefix], traditional, add);
            }
        }
        return s.join("&").replace(r20, "+");
    };
    jQuery.fn.extend({
        serialize: function() {
            return jQuery.param(this.serializeArray());
        },
        serializeArray: function() {
            return this.map(function() {
                var elements = jQuery.prop(this, "elements");
                return elements ? jQuery.makeArray(elements) : this;
            }).filter(function() {
                var type = this.type;
                return this.name && !jQuery(this).is(":disabled") && rsubmittable.test(this.nodeName) && !rsubmitterTypes.test(type) && (this.checked || !rcheckableType.test(type));
            }).map(function(i, elem) {
                var val = jQuery(this).val();
                return val == null ? null : jQuery.isArray(val) ? jQuery.map(val, function(val) {
                    return {
                        name: elem.name,
                        value: val.replace(rCRLF, "\r\n")
                    };
                }) : {
                    name: elem.name,
                    value: val.replace(rCRLF, "\r\n")
                };
            }).get();
        }
    });
    jQuery.ajaxSettings.xhr = window.ActiveXObject !== undefined ? function() {
        return !this.isLocal && /^(get|post|head|put|delete|options)$/i.test(this.type) && createStandardXHR() || createActiveXHR();
    } : createStandardXHR;
    var xhrId = 0, xhrCallbacks = {}, xhrSupported = jQuery.ajaxSettings.xhr();
    if (window.ActiveXObject) {
        jQuery(window).on("unload", function() {
            for (var key in xhrCallbacks) {
                xhrCallbacks[key](undefined, true);
            }
        });
    }
    support.cors = !!xhrSupported && "withCredentials" in xhrSupported;
    xhrSupported = support.ajax = !!xhrSupported;
    if (xhrSupported) {
        jQuery.ajaxTransport(function(options) {
            if (!options.crossDomain || support.cors) {
                var callback;
                return {
                    send: function(headers, complete) {
                        var i, xhr = options.xhr(), id = ++xhrId;
                        xhr.open(options.type, options.url, options.async, options.username, options.password);
                        if (options.xhrFields) {
                            for (i in options.xhrFields) {
                                xhr[i] = options.xhrFields[i];
                            }
                        }
                        if (options.mimeType && xhr.overrideMimeType) {
                            xhr.overrideMimeType(options.mimeType);
                        }
                        if (!options.crossDomain && !headers["X-Requested-With"]) {
                            headers["X-Requested-With"] = "XMLHttpRequest";
                        }
                        for (i in headers) {
                            if (headers[i] !== undefined) {
                                xhr.setRequestHeader(i, headers[i] + "");
                            }
                        }
                        xhr.send(options.hasContent && options.data || null);
                        callback = function(_, isAbort) {
                            var status, statusText, responses;
                            if (callback && (isAbort || xhr.readyState === 4)) {
                                delete xhrCallbacks[id];
                                callback = undefined;
                                xhr.onreadystatechange = jQuery.noop;
                                if (isAbort) {
                                    if (xhr.readyState !== 4) {
                                        xhr.abort();
                                    }
                                } else {
                                    responses = {};
                                    status = xhr.status;
                                    if (typeof xhr.responseText === "string") {
                                        responses.text = xhr.responseText;
                                    }
                                    try {
                                        statusText = xhr.statusText;
                                    } catch (e) {
                                        statusText = "";
                                    }
                                    if (!status && options.isLocal && !options.crossDomain) {
                                        status = responses.text ? 200 : 404;
                                    } else if (status === 1223) {
                                        status = 204;
                                    }
                                }
                            }
                            if (responses) {
                                complete(status, statusText, responses, xhr.getAllResponseHeaders());
                            }
                        };
                        if (!options.async) {
                            callback();
                        } else if (xhr.readyState === 4) {
                            setTimeout(callback);
                        } else {
                            xhr.onreadystatechange = xhrCallbacks[id] = callback;
                        }
                    },
                    abort: function() {
                        if (callback) {
                            callback(undefined, true);
                        }
                    }
                };
            }
        });
    }
    function createStandardXHR() {
        try {
            return new window.XMLHttpRequest();
        } catch (e) {}
    }
    function createActiveXHR() {
        try {
            return new window.ActiveXObject("Microsoft.XMLHTTP");
        } catch (e) {}
    }
    jQuery.ajaxSetup({
        accepts: {
            script: "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"
        },
        contents: {
            script: /(?:java|ecma)script/
        },
        converters: {
            "text script": function(text) {
                jQuery.globalEval(text);
                return text;
            }
        }
    });
    jQuery.ajaxPrefilter("script", function(s) {
        if (s.cache === undefined) {
            s.cache = false;
        }
        if (s.crossDomain) {
            s.type = "GET";
            s.global = false;
        }
    });
    jQuery.ajaxTransport("script", function(s) {
        if (s.crossDomain) {
            var script, head = document.head || jQuery("head")[0] || document.documentElement;
            return {
                send: function(_, callback) {
                    script = document.createElement("script");
                    script.async = true;
                    if (s.scriptCharset) {
                        script.charset = s.scriptCharset;
                    }
                    script.src = s.url;
                    script.onload = script.onreadystatechange = function(_, isAbort) {
                        if (isAbort || !script.readyState || /loaded|complete/.test(script.readyState)) {
                            script.onload = script.onreadystatechange = null;
                            if (script.parentNode) {
                                script.parentNode.removeChild(script);
                            }
                            script = null;
                            if (!isAbort) {
                                callback(200, "success");
                            }
                        }
                    };
                    head.insertBefore(script, head.firstChild);
                },
                abort: function() {
                    if (script) {
                        script.onload(undefined, true);
                    }
                }
            };
        }
    });
    var oldCallbacks = [], rjsonp = /(=)\?(?=&|$)|\?\?/;
    jQuery.ajaxSetup({
        jsonp: "callback",
        jsonpCallback: function() {
            var callback = oldCallbacks.pop() || jQuery.expando + "_" + nonce++;
            this[callback] = true;
            return callback;
        }
    });
    jQuery.ajaxPrefilter("json jsonp", function(s, originalSettings, jqXHR) {
        var callbackName, overwritten, responseContainer, jsonProp = s.jsonp !== false && (rjsonp.test(s.url) ? "url" : typeof s.data === "string" && !(s.contentType || "").indexOf("application/x-www-form-urlencoded") && rjsonp.test(s.data) && "data");
        if (jsonProp || s.dataTypes[0] === "jsonp") {
            callbackName = s.jsonpCallback = jQuery.isFunction(s.jsonpCallback) ? s.jsonpCallback() : s.jsonpCallback;
            if (jsonProp) {
                s[jsonProp] = s[jsonProp].replace(rjsonp, "$1" + callbackName);
            } else if (s.jsonp !== false) {
                s.url += (rquery.test(s.url) ? "&" : "?") + s.jsonp + "=" + callbackName;
            }
            s.converters["script json"] = function() {
                if (!responseContainer) {
                    jQuery.error(callbackName + " was not called");
                }
                return responseContainer[0];
            };
            s.dataTypes[0] = "json";
            overwritten = window[callbackName];
            window[callbackName] = function() {
                responseContainer = arguments;
            };
            jqXHR.always(function() {
                window[callbackName] = overwritten;
                if (s[callbackName]) {
                    s.jsonpCallback = originalSettings.jsonpCallback;
                    oldCallbacks.push(callbackName);
                }
                if (responseContainer && jQuery.isFunction(overwritten)) {
                    overwritten(responseContainer[0]);
                }
                responseContainer = overwritten = undefined;
            });
            return "script";
        }
    });
    jQuery.parseHTML = function(data, context, keepScripts) {
        if (!data || typeof data !== "string") {
            return null;
        }
        if (typeof context === "boolean") {
            keepScripts = context;
            context = false;
        }
        context = context || document;
        var parsed = rsingleTag.exec(data), scripts = !keepScripts && [];
        if (parsed) {
            return [ context.createElement(parsed[1]) ];
        }
        parsed = jQuery.buildFragment([ data ], context, scripts);
        if (scripts && scripts.length) {
            jQuery(scripts).remove();
        }
        return jQuery.merge([], parsed.childNodes);
    };
    var _load = jQuery.fn.load;
    jQuery.fn.load = function(url, params, callback) {
        if (typeof url !== "string" && _load) {
            return _load.apply(this, arguments);
        }
        var selector, response, type, self = this, off = url.indexOf(" ");
        if (off >= 0) {
            selector = url.slice(off, url.length);
            url = url.slice(0, off);
        }
        if (jQuery.isFunction(params)) {
            callback = params;
            params = undefined;
        } else if (params && typeof params === "object") {
            type = "POST";
        }
        if (self.length > 0) {
            jQuery.ajax({
                url: url,
                type: type,
                dataType: "html",
                data: params
            }).done(function(responseText) {
                response = arguments;
                self.html(selector ? jQuery("<div>").append(jQuery.parseHTML(responseText)).find(selector) : responseText);
            }).complete(callback && function(jqXHR, status) {
                self.each(callback, response || [ jqXHR.responseText, status, jqXHR ]);
            });
        }
        return this;
    };
    jQuery.expr.filters.animated = function(elem) {
        return jQuery.grep(jQuery.timers, function(fn) {
            return elem === fn.elem;
        }).length;
    };
    var docElem = window.document.documentElement;
    function getWindow(elem) {
        return jQuery.isWindow(elem) ? elem : elem.nodeType === 9 ? elem.defaultView || elem.parentWindow : false;
    }
    jQuery.offset = {
        setOffset: function(elem, options, i) {
            var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition, position = jQuery.css(elem, "position"), curElem = jQuery(elem), props = {};
            if (position === "static") {
                elem.style.position = "relative";
            }
            curOffset = curElem.offset();
            curCSSTop = jQuery.css(elem, "top");
            curCSSLeft = jQuery.css(elem, "left");
            calculatePosition = (position === "absolute" || position === "fixed") && jQuery.inArray("auto", [ curCSSTop, curCSSLeft ]) > -1;
            if (calculatePosition) {
                curPosition = curElem.position();
                curTop = curPosition.top;
                curLeft = curPosition.left;
            } else {
                curTop = parseFloat(curCSSTop) || 0;
                curLeft = parseFloat(curCSSLeft) || 0;
            }
            if (jQuery.isFunction(options)) {
                options = options.call(elem, i, curOffset);
            }
            if (options.top != null) {
                props.top = options.top - curOffset.top + curTop;
            }
            if (options.left != null) {
                props.left = options.left - curOffset.left + curLeft;
            }
            if ("using" in options) {
                options.using.call(elem, props);
            } else {
                curElem.css(props);
            }
        }
    };
    jQuery.fn.extend({
        offset: function(options) {
            if (arguments.length) {
                return options === undefined ? this : this.each(function(i) {
                    jQuery.offset.setOffset(this, options, i);
                });
            }
            var docElem, win, box = {
                top: 0,
                left: 0
            }, elem = this[0], doc = elem && elem.ownerDocument;
            if (!doc) {
                return;
            }
            docElem = doc.documentElement;
            if (!jQuery.contains(docElem, elem)) {
                return box;
            }
            if (typeof elem.getBoundingClientRect !== strundefined) {
                box = elem.getBoundingClientRect();
            }
            win = getWindow(doc);
            return {
                top: box.top + (win.pageYOffset || docElem.scrollTop) - (docElem.clientTop || 0),
                left: box.left + (win.pageXOffset || docElem.scrollLeft) - (docElem.clientLeft || 0)
            };
        },
        position: function() {
            if (!this[0]) {
                return;
            }
            var offsetParent, offset, parentOffset = {
                top: 0,
                left: 0
            }, elem = this[0];
            if (jQuery.css(elem, "position") === "fixed") {
                offset = elem.getBoundingClientRect();
            } else {
                offsetParent = this.offsetParent();
                offset = this.offset();
                if (!jQuery.nodeName(offsetParent[0], "html")) {
                    parentOffset = offsetParent.offset();
                }
                parentOffset.top += jQuery.css(offsetParent[0], "borderTopWidth", true);
                parentOffset.left += jQuery.css(offsetParent[0], "borderLeftWidth", true);
            }
            return {
                top: offset.top - parentOffset.top - jQuery.css(elem, "marginTop", true),
                left: offset.left - parentOffset.left - jQuery.css(elem, "marginLeft", true)
            };
        },
        offsetParent: function() {
            return this.map(function() {
                var offsetParent = this.offsetParent || docElem;
                while (offsetParent && (!jQuery.nodeName(offsetParent, "html") && jQuery.css(offsetParent, "position") === "static")) {
                    offsetParent = offsetParent.offsetParent;
                }
                return offsetParent || docElem;
            });
        }
    });
    jQuery.each({
        scrollLeft: "pageXOffset",
        scrollTop: "pageYOffset"
    }, function(method, prop) {
        var top = /Y/.test(prop);
        jQuery.fn[method] = function(val) {
            return access(this, function(elem, method, val) {
                var win = getWindow(elem);
                if (val === undefined) {
                    return win ? prop in win ? win[prop] : win.document.documentElement[method] : elem[method];
                }
                if (win) {
                    win.scrollTo(!top ? val : jQuery(win).scrollLeft(), top ? val : jQuery(win).scrollTop());
                } else {
                    elem[method] = val;
                }
            }, method, val, arguments.length, null);
        };
    });
    jQuery.each([ "top", "left" ], function(i, prop) {
        jQuery.cssHooks[prop] = addGetHookIf(support.pixelPosition, function(elem, computed) {
            if (computed) {
                computed = curCSS(elem, prop);
                return rnumnonpx.test(computed) ? jQuery(elem).position()[prop] + "px" : computed;
            }
        });
    });
    jQuery.each({
        Height: "height",
        Width: "width"
    }, function(name, type) {
        jQuery.each({
            padding: "inner" + name,
            content: type,
            "": "outer" + name
        }, function(defaultExtra, funcName) {
            jQuery.fn[funcName] = function(margin, value) {
                var chainable = arguments.length && (defaultExtra || typeof margin !== "boolean"), extra = defaultExtra || (margin === true || value === true ? "margin" : "border");
                return access(this, function(elem, type, value) {
                    var doc;
                    if (jQuery.isWindow(elem)) {
                        return elem.document.documentElement["client" + name];
                    }
                    if (elem.nodeType === 9) {
                        doc = elem.documentElement;
                        return Math.max(elem.body["scroll" + name], doc["scroll" + name], elem.body["offset" + name], doc["offset" + name], doc["client" + name]);
                    }
                    return value === undefined ? jQuery.css(elem, type, extra) : jQuery.style(elem, type, value, extra);
                }, type, chainable ? margin : undefined, chainable, null);
            };
        });
    });
    jQuery.fn.size = function() {
        return this.length;
    };
    jQuery.fn.andSelf = jQuery.fn.addBack;
    if (typeof define === "function" && define.amd) {
        define("jquery", [], function() {
            return jQuery;
        });
    }
    var _jQuery = window.jQuery, _$ = window.$;
    jQuery.noConflict = function(deep) {
        if (window.$ === jQuery) {
            window.$ = _$;
        }
        if (deep && window.jQuery === jQuery) {
            window.jQuery = _jQuery;
        }
        return jQuery;
    };
    if (typeof noGlobal === strundefined) {
        window.jQuery = window.$ = jQuery;
    }
    return jQuery;
});

(function() {
    var DEBUG = true;
    (function(undefined) {
        var window = this || (0, eval)("this"), document = window["document"], navigator = window["navigator"], jQuery = window["jQuery"], JSON = window["JSON"];
        (function(factory) {
            if (typeof require === "function" && typeof exports === "object" && typeof module === "object") {
                var target = module["exports"] || exports;
                factory(target);
            } else if (typeof define === "function" && define["amd"]) {
                define("knockout", [ "exports" ], factory);
            } else {
                factory(window["ko"] = {});
            }
        })(function(koExports) {
            var ko = typeof koExports !== "undefined" ? koExports : {};
            ko.exportSymbol = function(koPath, object) {
                var tokens = koPath.split(".");
                var target = ko;
                for (var i = 0; i < tokens.length - 1; i++) target = target[tokens[i]];
                target[tokens[tokens.length - 1]] = object;
            };
            ko.exportProperty = function(owner, publicName, object) {
                owner[publicName] = object;
            };
            ko.version = "3.1.0";
            ko.exportSymbol("version", ko.version);
            ko.utils = function() {
                function objectForEach(obj, action) {
                    for (var prop in obj) {
                        if (obj.hasOwnProperty(prop)) {
                            action(prop, obj[prop]);
                        }
                    }
                }
                function extend(target, source) {
                    if (source) {
                        for (var prop in source) {
                            if (source.hasOwnProperty(prop)) {
                                target[prop] = source[prop];
                            }
                        }
                    }
                    return target;
                }
                function setPrototypeOf(obj, proto) {
                    obj.__proto__ = proto;
                    return obj;
                }
                var canSetPrototype = {
                    __proto__: []
                } instanceof Array;
                var knownEvents = {}, knownEventTypesByEventName = {};
                var keyEventTypeName = navigator && /Firefox\/2/i.test(navigator.userAgent) ? "KeyboardEvent" : "UIEvents";
                knownEvents[keyEventTypeName] = [ "keyup", "keydown", "keypress" ];
                knownEvents["MouseEvents"] = [ "click", "dblclick", "mousedown", "mouseup", "mousemove", "mouseover", "mouseout", "mouseenter", "mouseleave" ];
                objectForEach(knownEvents, function(eventType, knownEventsForType) {
                    if (knownEventsForType.length) {
                        for (var i = 0, j = knownEventsForType.length; i < j; i++) knownEventTypesByEventName[knownEventsForType[i]] = eventType;
                    }
                });
                var eventsThatMustBeRegisteredUsingAttachEvent = {
                    propertychange: true
                };
                var ieVersion = document && function() {
                    var version = 3, div = document.createElement("div"), iElems = div.getElementsByTagName("i");
                    while (div.innerHTML = "<!--[if gt IE " + ++version + "]><i></i><![endif]-->", iElems[0]) {}
                    return version > 4 ? version : undefined;
                }();
                var isIe6 = ieVersion === 6, isIe7 = ieVersion === 7;
                function isClickOnCheckableElement(element, eventType) {
                    if (ko.utils.tagNameLower(element) !== "input" || !element.type) return false;
                    if (eventType.toLowerCase() != "click") return false;
                    var inputType = element.type;
                    return inputType == "checkbox" || inputType == "radio";
                }
                return {
                    fieldsIncludedWithJsonPost: [ "authenticity_token", /^__RequestVerificationToken(_.*)?$/ ],
                    arrayForEach: function(array, action) {
                        for (var i = 0, j = array.length; i < j; i++) action(array[i], i);
                    },
                    arrayIndexOf: function(array, item) {
                        if (typeof Array.prototype.indexOf == "function") return Array.prototype.indexOf.call(array, item);
                        for (var i = 0, j = array.length; i < j; i++) if (array[i] === item) return i;
                        return -1;
                    },
                    arrayFirst: function(array, predicate, predicateOwner) {
                        for (var i = 0, j = array.length; i < j; i++) if (predicate.call(predicateOwner, array[i], i)) return array[i];
                        return null;
                    },
                    arrayRemoveItem: function(array, itemToRemove) {
                        var index = ko.utils.arrayIndexOf(array, itemToRemove);
                        if (index > 0) {
                            array.splice(index, 1);
                        } else if (index === 0) {
                            array.shift();
                        }
                    },
                    arrayGetDistinctValues: function(array) {
                        array = array || [];
                        var result = [];
                        for (var i = 0, j = array.length; i < j; i++) {
                            if (ko.utils.arrayIndexOf(result, array[i]) < 0) result.push(array[i]);
                        }
                        return result;
                    },
                    arrayMap: function(array, mapping) {
                        array = array || [];
                        var result = [];
                        for (var i = 0, j = array.length; i < j; i++) result.push(mapping(array[i], i));
                        return result;
                    },
                    arrayFilter: function(array, predicate) {
                        array = array || [];
                        var result = [];
                        for (var i = 0, j = array.length; i < j; i++) if (predicate(array[i], i)) result.push(array[i]);
                        return result;
                    },
                    arrayPushAll: function(array, valuesToPush) {
                        if (valuesToPush instanceof Array) array.push.apply(array, valuesToPush); else for (var i = 0, j = valuesToPush.length; i < j; i++) array.push(valuesToPush[i]);
                        return array;
                    },
                    addOrRemoveItem: function(array, value, included) {
                        var existingEntryIndex = ko.utils.arrayIndexOf(ko.utils.peekObservable(array), value);
                        if (existingEntryIndex < 0) {
                            if (included) array.push(value);
                        } else {
                            if (!included) array.splice(existingEntryIndex, 1);
                        }
                    },
                    canSetPrototype: canSetPrototype,
                    extend: extend,
                    setPrototypeOf: setPrototypeOf,
                    setPrototypeOfOrExtend: canSetPrototype ? setPrototypeOf : extend,
                    objectForEach: objectForEach,
                    objectMap: function(source, mapping) {
                        if (!source) return source;
                        var target = {};
                        for (var prop in source) {
                            if (source.hasOwnProperty(prop)) {
                                target[prop] = mapping(source[prop], prop, source);
                            }
                        }
                        return target;
                    },
                    emptyDomNode: function(domNode) {
                        while (domNode.firstChild) {
                            ko.removeNode(domNode.firstChild);
                        }
                    },
                    moveCleanedNodesToContainerElement: function(nodes) {
                        var nodesArray = ko.utils.makeArray(nodes);
                        var container = document.createElement("div");
                        for (var i = 0, j = nodesArray.length; i < j; i++) {
                            container.appendChild(ko.cleanNode(nodesArray[i]));
                        }
                        return container;
                    },
                    cloneNodes: function(nodesArray, shouldCleanNodes) {
                        for (var i = 0, j = nodesArray.length, newNodesArray = []; i < j; i++) {
                            var clonedNode = nodesArray[i].cloneNode(true);
                            newNodesArray.push(shouldCleanNodes ? ko.cleanNode(clonedNode) : clonedNode);
                        }
                        return newNodesArray;
                    },
                    setDomNodeChildren: function(domNode, childNodes) {
                        ko.utils.emptyDomNode(domNode);
                        if (childNodes) {
                            for (var i = 0, j = childNodes.length; i < j; i++) domNode.appendChild(childNodes[i]);
                        }
                    },
                    replaceDomNodes: function(nodeToReplaceOrNodeArray, newNodesArray) {
                        var nodesToReplaceArray = nodeToReplaceOrNodeArray.nodeType ? [ nodeToReplaceOrNodeArray ] : nodeToReplaceOrNodeArray;
                        if (nodesToReplaceArray.length > 0) {
                            var insertionPoint = nodesToReplaceArray[0];
                            var parent = insertionPoint.parentNode;
                            for (var i = 0, j = newNodesArray.length; i < j; i++) parent.insertBefore(newNodesArray[i], insertionPoint);
                            for (var i = 0, j = nodesToReplaceArray.length; i < j; i++) {
                                ko.removeNode(nodesToReplaceArray[i]);
                            }
                        }
                    },
                    fixUpContinuousNodeArray: function(continuousNodeArray, parentNode) {
                        if (continuousNodeArray.length) {
                            parentNode = parentNode.nodeType === 8 && parentNode.parentNode || parentNode;
                            while (continuousNodeArray.length && continuousNodeArray[0].parentNode !== parentNode) continuousNodeArray.shift();
                            if (continuousNodeArray.length > 1) {
                                var current = continuousNodeArray[0], last = continuousNodeArray[continuousNodeArray.length - 1];
                                continuousNodeArray.length = 0;
                                while (current !== last) {
                                    continuousNodeArray.push(current);
                                    current = current.nextSibling;
                                    if (!current) return;
                                }
                                continuousNodeArray.push(last);
                            }
                        }
                        return continuousNodeArray;
                    },
                    setOptionNodeSelectionState: function(optionNode, isSelected) {
                        if (ieVersion < 7) optionNode.setAttribute("selected", isSelected); else optionNode.selected = isSelected;
                    },
                    stringTrim: function(string) {
                        return string === null || string === undefined ? "" : string.trim ? string.trim() : string.toString().replace(/^[\s\xa0]+|[\s\xa0]+$/g, "");
                    },
                    stringTokenize: function(string, delimiter) {
                        var result = [];
                        var tokens = (string || "").split(delimiter);
                        for (var i = 0, j = tokens.length; i < j; i++) {
                            var trimmed = ko.utils.stringTrim(tokens[i]);
                            if (trimmed !== "") result.push(trimmed);
                        }
                        return result;
                    },
                    stringStartsWith: function(string, startsWith) {
                        string = string || "";
                        if (startsWith.length > string.length) return false;
                        return string.substring(0, startsWith.length) === startsWith;
                    },
                    domNodeIsContainedBy: function(node, containedByNode) {
                        if (node === containedByNode) return true;
                        if (node.nodeType === 11) return false;
                        if (containedByNode.contains) return containedByNode.contains(node.nodeType === 3 ? node.parentNode : node);
                        if (containedByNode.compareDocumentPosition) return (containedByNode.compareDocumentPosition(node) & 16) == 16;
                        while (node && node != containedByNode) {
                            node = node.parentNode;
                        }
                        return !!node;
                    },
                    domNodeIsAttachedToDocument: function(node) {
                        return ko.utils.domNodeIsContainedBy(node, node.ownerDocument.documentElement);
                    },
                    anyDomNodeIsAttachedToDocument: function(nodes) {
                        return !!ko.utils.arrayFirst(nodes, ko.utils.domNodeIsAttachedToDocument);
                    },
                    tagNameLower: function(element) {
                        return element && element.tagName && element.tagName.toLowerCase();
                    },
                    registerEventHandler: function(element, eventType, handler) {
                        var mustUseAttachEvent = ieVersion && eventsThatMustBeRegisteredUsingAttachEvent[eventType];
                        if (!mustUseAttachEvent && jQuery) {
                            jQuery(element)["bind"](eventType, handler);
                        } else if (!mustUseAttachEvent && typeof element.addEventListener == "function") element.addEventListener(eventType, handler, false); else if (typeof element.attachEvent != "undefined") {
                            var attachEventHandler = function(event) {
                                handler.call(element, event);
                            }, attachEventName = "on" + eventType;
                            element.attachEvent(attachEventName, attachEventHandler);
                            ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
                                element.detachEvent(attachEventName, attachEventHandler);
                            });
                        } else throw new Error("Browser doesn't support addEventListener or attachEvent");
                    },
                    triggerEvent: function(element, eventType) {
                        if (!(element && element.nodeType)) throw new Error("element must be a DOM node when calling triggerEvent");
                        var useClickWorkaround = isClickOnCheckableElement(element, eventType);
                        if (jQuery && !useClickWorkaround) {
                            jQuery(element)["trigger"](eventType);
                        } else if (typeof document.createEvent == "function") {
                            if (typeof element.dispatchEvent == "function") {
                                var eventCategory = knownEventTypesByEventName[eventType] || "HTMLEvents";
                                var event = document.createEvent(eventCategory);
                                event.initEvent(eventType, true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, element);
                                element.dispatchEvent(event);
                            } else throw new Error("The supplied element doesn't support dispatchEvent");
                        } else if (useClickWorkaround && element.click) {
                            element.click();
                        } else if (typeof element.fireEvent != "undefined") {
                            element.fireEvent("on" + eventType);
                        } else {
                            throw new Error("Browser doesn't support triggering events");
                        }
                    },
                    unwrapObservable: function(value) {
                        return ko.isObservable(value) ? value() : value;
                    },
                    peekObservable: function(value) {
                        return ko.isObservable(value) ? value.peek() : value;
                    },
                    toggleDomNodeCssClass: function(node, classNames, shouldHaveClass) {
                        if (classNames) {
                            var cssClassNameRegex = /\S+/g, currentClassNames = node.className.match(cssClassNameRegex) || [];
                            ko.utils.arrayForEach(classNames.match(cssClassNameRegex), function(className) {
                                ko.utils.addOrRemoveItem(currentClassNames, className, shouldHaveClass);
                            });
                            node.className = currentClassNames.join(" ");
                        }
                    },
                    setTextContent: function(element, textContent) {
                        var value = ko.utils.unwrapObservable(textContent);
                        if (value === null || value === undefined) value = "";
                        var innerTextNode = ko.virtualElements.firstChild(element);
                        if (!innerTextNode || innerTextNode.nodeType != 3 || ko.virtualElements.nextSibling(innerTextNode)) {
                            ko.virtualElements.setDomNodeChildren(element, [ element.ownerDocument.createTextNode(value) ]);
                        } else {
                            innerTextNode.data = value;
                        }
                        ko.utils.forceRefresh(element);
                    },
                    setElementName: function(element, name) {
                        element.name = name;
                        if (ieVersion <= 7) {
                            try {
                                element.mergeAttributes(document.createElement("<input name='" + element.name + "'/>"), false);
                            } catch (e) {}
                        }
                    },
                    forceRefresh: function(node) {
                        if (ieVersion >= 9) {
                            var elem = node.nodeType == 1 ? node : node.parentNode;
                            if (elem.style) elem.style.zoom = elem.style.zoom;
                        }
                    },
                    ensureSelectElementIsRenderedCorrectly: function(selectElement) {
                        if (ieVersion) {
                            var originalWidth = selectElement.style.width;
                            selectElement.style.width = 0;
                            selectElement.style.width = originalWidth;
                        }
                    },
                    range: function(min, max) {
                        min = ko.utils.unwrapObservable(min);
                        max = ko.utils.unwrapObservable(max);
                        var result = [];
                        for (var i = min; i <= max; i++) result.push(i);
                        return result;
                    },
                    makeArray: function(arrayLikeObject) {
                        var result = [];
                        for (var i = 0, j = arrayLikeObject.length; i < j; i++) {
                            result.push(arrayLikeObject[i]);
                        }
                        return result;
                    },
                    isIe6: isIe6,
                    isIe7: isIe7,
                    ieVersion: ieVersion,
                    getFormFields: function(form, fieldName) {
                        var fields = ko.utils.makeArray(form.getElementsByTagName("input")).concat(ko.utils.makeArray(form.getElementsByTagName("textarea")));
                        var isMatchingField = typeof fieldName == "string" ? function(field) {
                            return field.name === fieldName;
                        } : function(field) {
                            return fieldName.test(field.name);
                        };
                        var matches = [];
                        for (var i = fields.length - 1; i >= 0; i--) {
                            if (isMatchingField(fields[i])) matches.push(fields[i]);
                        }
                        return matches;
                    },
                    parseJson: function(jsonString) {
                        if (typeof jsonString == "string") {
                            jsonString = ko.utils.stringTrim(jsonString);
                            if (jsonString) {
                                if (JSON && JSON.parse) return JSON.parse(jsonString);
                                return new Function("return " + jsonString)();
                            }
                        }
                        return null;
                    },
                    stringifyJson: function(data, replacer, space) {
                        if (!JSON || !JSON.stringify) throw new Error("Cannot find JSON.stringify(). Some browsers (e.g., IE < 8) don't support it natively, but you can overcome this by adding a script reference to json2.js, downloadable from http://www.json.org/json2.js");
                        return JSON.stringify(ko.utils.unwrapObservable(data), replacer, space);
                    },
                    postJson: function(urlOrForm, data, options) {
                        options = options || {};
                        var params = options["params"] || {};
                        var includeFields = options["includeFields"] || this.fieldsIncludedWithJsonPost;
                        var url = urlOrForm;
                        if (typeof urlOrForm == "object" && ko.utils.tagNameLower(urlOrForm) === "form") {
                            var originalForm = urlOrForm;
                            url = originalForm.action;
                            for (var i = includeFields.length - 1; i >= 0; i--) {
                                var fields = ko.utils.getFormFields(originalForm, includeFields[i]);
                                for (var j = fields.length - 1; j >= 0; j--) params[fields[j].name] = fields[j].value;
                            }
                        }
                        data = ko.utils.unwrapObservable(data);
                        var form = document.createElement("form");
                        form.style.display = "none";
                        form.action = url;
                        form.method = "post";
                        for (var key in data) {
                            var input = document.createElement("input");
                            input.name = key;
                            input.value = ko.utils.stringifyJson(ko.utils.unwrapObservable(data[key]));
                            form.appendChild(input);
                        }
                        objectForEach(params, function(key, value) {
                            var input = document.createElement("input");
                            input.name = key;
                            input.value = value;
                            form.appendChild(input);
                        });
                        document.body.appendChild(form);
                        options["submitter"] ? options["submitter"](form) : form.submit();
                        setTimeout(function() {
                            form.parentNode.removeChild(form);
                        }, 0);
                    }
                };
            }();
            ko.exportSymbol("utils", ko.utils);
            ko.exportSymbol("utils.arrayForEach", ko.utils.arrayForEach);
            ko.exportSymbol("utils.arrayFirst", ko.utils.arrayFirst);
            ko.exportSymbol("utils.arrayFilter", ko.utils.arrayFilter);
            ko.exportSymbol("utils.arrayGetDistinctValues", ko.utils.arrayGetDistinctValues);
            ko.exportSymbol("utils.arrayIndexOf", ko.utils.arrayIndexOf);
            ko.exportSymbol("utils.arrayMap", ko.utils.arrayMap);
            ko.exportSymbol("utils.arrayPushAll", ko.utils.arrayPushAll);
            ko.exportSymbol("utils.arrayRemoveItem", ko.utils.arrayRemoveItem);
            ko.exportSymbol("utils.extend", ko.utils.extend);
            ko.exportSymbol("utils.fieldsIncludedWithJsonPost", ko.utils.fieldsIncludedWithJsonPost);
            ko.exportSymbol("utils.getFormFields", ko.utils.getFormFields);
            ko.exportSymbol("utils.peekObservable", ko.utils.peekObservable);
            ko.exportSymbol("utils.postJson", ko.utils.postJson);
            ko.exportSymbol("utils.parseJson", ko.utils.parseJson);
            ko.exportSymbol("utils.registerEventHandler", ko.utils.registerEventHandler);
            ko.exportSymbol("utils.stringifyJson", ko.utils.stringifyJson);
            ko.exportSymbol("utils.range", ko.utils.range);
            ko.exportSymbol("utils.toggleDomNodeCssClass", ko.utils.toggleDomNodeCssClass);
            ko.exportSymbol("utils.triggerEvent", ko.utils.triggerEvent);
            ko.exportSymbol("utils.unwrapObservable", ko.utils.unwrapObservable);
            ko.exportSymbol("utils.objectForEach", ko.utils.objectForEach);
            ko.exportSymbol("utils.addOrRemoveItem", ko.utils.addOrRemoveItem);
            ko.exportSymbol("unwrap", ko.utils.unwrapObservable);
            if (!Function.prototype["bind"]) {
                Function.prototype["bind"] = function(object) {
                    var originalFunction = this, args = Array.prototype.slice.call(arguments), object = args.shift();
                    return function() {
                        return originalFunction.apply(object, args.concat(Array.prototype.slice.call(arguments)));
                    };
                };
            }
            ko.utils.domData = new function() {
                var uniqueId = 0;
                var dataStoreKeyExpandoPropertyName = "__ko__" + new Date().getTime();
                var dataStore = {};
                function getAll(node, createIfNotFound) {
                    var dataStoreKey = node[dataStoreKeyExpandoPropertyName];
                    var hasExistingDataStore = dataStoreKey && dataStoreKey !== "null" && dataStore[dataStoreKey];
                    if (!hasExistingDataStore) {
                        if (!createIfNotFound) return undefined;
                        dataStoreKey = node[dataStoreKeyExpandoPropertyName] = "ko" + uniqueId++;
                        dataStore[dataStoreKey] = {};
                    }
                    return dataStore[dataStoreKey];
                }
                return {
                    get: function(node, key) {
                        var allDataForNode = getAll(node, false);
                        return allDataForNode === undefined ? undefined : allDataForNode[key];
                    },
                    set: function(node, key, value) {
                        if (value === undefined) {
                            if (getAll(node, false) === undefined) return;
                        }
                        var allDataForNode = getAll(node, true);
                        allDataForNode[key] = value;
                    },
                    clear: function(node) {
                        var dataStoreKey = node[dataStoreKeyExpandoPropertyName];
                        if (dataStoreKey) {
                            delete dataStore[dataStoreKey];
                            node[dataStoreKeyExpandoPropertyName] = null;
                            return true;
                        }
                        return false;
                    },
                    nextKey: function() {
                        return uniqueId++ + dataStoreKeyExpandoPropertyName;
                    }
                };
            }();
            ko.exportSymbol("utils.domData", ko.utils.domData);
            ko.exportSymbol("utils.domData.clear", ko.utils.domData.clear);
            ko.utils.domNodeDisposal = new function() {
                var domDataKey = ko.utils.domData.nextKey();
                var cleanableNodeTypes = {
                    1: true,
                    8: true,
                    9: true
                };
                var cleanableNodeTypesWithDescendants = {
                    1: true,
                    9: true
                };
                function getDisposeCallbacksCollection(node, createIfNotFound) {
                    var allDisposeCallbacks = ko.utils.domData.get(node, domDataKey);
                    if (allDisposeCallbacks === undefined && createIfNotFound) {
                        allDisposeCallbacks = [];
                        ko.utils.domData.set(node, domDataKey, allDisposeCallbacks);
                    }
                    return allDisposeCallbacks;
                }
                function destroyCallbacksCollection(node) {
                    ko.utils.domData.set(node, domDataKey, undefined);
                }
                function cleanSingleNode(node) {
                    var callbacks = getDisposeCallbacksCollection(node, false);
                    if (callbacks) {
                        callbacks = callbacks.slice(0);
                        for (var i = 0; i < callbacks.length; i++) callbacks[i](node);
                    }
                    ko.utils.domData.clear(node);
                    ko.utils.domNodeDisposal["cleanExternalData"](node);
                    if (cleanableNodeTypesWithDescendants[node.nodeType]) cleanImmediateCommentTypeChildren(node);
                }
                function cleanImmediateCommentTypeChildren(nodeWithChildren) {
                    var child, nextChild = nodeWithChildren.firstChild;
                    while (child = nextChild) {
                        nextChild = child.nextSibling;
                        if (child.nodeType === 8) cleanSingleNode(child);
                    }
                }
                return {
                    addDisposeCallback: function(node, callback) {
                        if (typeof callback != "function") throw new Error("Callback must be a function");
                        getDisposeCallbacksCollection(node, true).push(callback);
                    },
                    removeDisposeCallback: function(node, callback) {
                        var callbacksCollection = getDisposeCallbacksCollection(node, false);
                        if (callbacksCollection) {
                            ko.utils.arrayRemoveItem(callbacksCollection, callback);
                            if (callbacksCollection.length == 0) destroyCallbacksCollection(node);
                        }
                    },
                    cleanNode: function(node) {
                        if (cleanableNodeTypes[node.nodeType]) {
                            cleanSingleNode(node);
                            if (cleanableNodeTypesWithDescendants[node.nodeType]) {
                                var descendants = [];
                                ko.utils.arrayPushAll(descendants, node.getElementsByTagName("*"));
                                for (var i = 0, j = descendants.length; i < j; i++) cleanSingleNode(descendants[i]);
                            }
                        }
                        return node;
                    },
                    removeNode: function(node) {
                        ko.cleanNode(node);
                        if (node.parentNode) node.parentNode.removeChild(node);
                    },
                    cleanExternalData: function(node) {
                        if (jQuery && typeof jQuery["cleanData"] == "function") jQuery["cleanData"]([ node ]);
                    }
                };
            }();
            ko.cleanNode = ko.utils.domNodeDisposal.cleanNode;
            ko.removeNode = ko.utils.domNodeDisposal.removeNode;
            ko.exportSymbol("cleanNode", ko.cleanNode);
            ko.exportSymbol("removeNode", ko.removeNode);
            ko.exportSymbol("utils.domNodeDisposal", ko.utils.domNodeDisposal);
            ko.exportSymbol("utils.domNodeDisposal.addDisposeCallback", ko.utils.domNodeDisposal.addDisposeCallback);
            ko.exportSymbol("utils.domNodeDisposal.removeDisposeCallback", ko.utils.domNodeDisposal.removeDisposeCallback);
            (function() {
                var leadingCommentRegex = /^(\s*)<!--(.*?)-->/;
                function simpleHtmlParse(html) {
                    var tags = ko.utils.stringTrim(html).toLowerCase(), div = document.createElement("div");
                    var wrap = tags.match(/^<(thead|tbody|tfoot)/) && [ 1, "<table>", "</table>" ] || !tags.indexOf("<tr") && [ 2, "<table><tbody>", "</tbody></table>" ] || (!tags.indexOf("<td") || !tags.indexOf("<th")) && [ 3, "<table><tbody><tr>", "</tr></tbody></table>" ] || [ 0, "", "" ];
                    var markup = "ignored<div>" + wrap[1] + html + wrap[2] + "</div>";
                    if (typeof window["innerShiv"] == "function") {
                        div.appendChild(window["innerShiv"](markup));
                    } else {
                        div.innerHTML = markup;
                    }
                    while (wrap[0]--) div = div.lastChild;
                    return ko.utils.makeArray(div.lastChild.childNodes);
                }
                function jQueryHtmlParse(html) {
                    if (jQuery["parseHTML"]) {
                        return jQuery["parseHTML"](html) || [];
                    } else {
                        var elems = jQuery["clean"]([ html ]);
                        if (elems && elems[0]) {
                            var elem = elems[0];
                            while (elem.parentNode && elem.parentNode.nodeType !== 11) elem = elem.parentNode;
                            if (elem.parentNode) elem.parentNode.removeChild(elem);
                        }
                        return elems;
                    }
                }
                ko.utils.parseHtmlFragment = function(html) {
                    return jQuery ? jQueryHtmlParse(html) : simpleHtmlParse(html);
                };
                ko.utils.setHtml = function(node, html) {
                    ko.utils.emptyDomNode(node);
                    html = ko.utils.unwrapObservable(html);
                    if (html !== null && html !== undefined) {
                        if (typeof html != "string") html = html.toString();
                        if (jQuery) {
                            jQuery(node)["html"](html);
                        } else {
                            var parsedNodes = ko.utils.parseHtmlFragment(html);
                            for (var i = 0; i < parsedNodes.length; i++) node.appendChild(parsedNodes[i]);
                        }
                    }
                };
            })();
            ko.exportSymbol("utils.parseHtmlFragment", ko.utils.parseHtmlFragment);
            ko.exportSymbol("utils.setHtml", ko.utils.setHtml);
            ko.memoization = function() {
                var memos = {};
                function randomMax8HexChars() {
                    return ((1 + Math.random()) * 4294967296 | 0).toString(16).substring(1);
                }
                function generateRandomId() {
                    return randomMax8HexChars() + randomMax8HexChars();
                }
                function findMemoNodes(rootNode, appendToArray) {
                    if (!rootNode) return;
                    if (rootNode.nodeType == 8) {
                        var memoId = ko.memoization.parseMemoText(rootNode.nodeValue);
                        if (memoId != null) appendToArray.push({
                            domNode: rootNode,
                            memoId: memoId
                        });
                    } else if (rootNode.nodeType == 1) {
                        for (var i = 0, childNodes = rootNode.childNodes, j = childNodes.length; i < j; i++) findMemoNodes(childNodes[i], appendToArray);
                    }
                }
                return {
                    memoize: function(callback) {
                        if (typeof callback != "function") throw new Error("You can only pass a function to ko.memoization.memoize()");
                        var memoId = generateRandomId();
                        memos[memoId] = callback;
                        return "<!--[ko_memo:" + memoId + "]-->";
                    },
                    unmemoize: function(memoId, callbackParams) {
                        var callback = memos[memoId];
                        if (callback === undefined) throw new Error("Couldn't find any memo with ID " + memoId + ". Perhaps it's already been unmemoized.");
                        try {
                            callback.apply(null, callbackParams || []);
                            return true;
                        } finally {
                            delete memos[memoId];
                        }
                    },
                    unmemoizeDomNodeAndDescendants: function(domNode, extraCallbackParamsArray) {
                        var memos = [];
                        findMemoNodes(domNode, memos);
                        for (var i = 0, j = memos.length; i < j; i++) {
                            var node = memos[i].domNode;
                            var combinedParams = [ node ];
                            if (extraCallbackParamsArray) ko.utils.arrayPushAll(combinedParams, extraCallbackParamsArray);
                            ko.memoization.unmemoize(memos[i].memoId, combinedParams);
                            node.nodeValue = "";
                            if (node.parentNode) node.parentNode.removeChild(node);
                        }
                    },
                    parseMemoText: function(memoText) {
                        var match = memoText.match(/^\[ko_memo\:(.*?)\]$/);
                        return match ? match[1] : null;
                    }
                };
            }();
            ko.exportSymbol("memoization", ko.memoization);
            ko.exportSymbol("memoization.memoize", ko.memoization.memoize);
            ko.exportSymbol("memoization.unmemoize", ko.memoization.unmemoize);
            ko.exportSymbol("memoization.parseMemoText", ko.memoization.parseMemoText);
            ko.exportSymbol("memoization.unmemoizeDomNodeAndDescendants", ko.memoization.unmemoizeDomNodeAndDescendants);
            ko.extenders = {
                throttle: function(target, timeout) {
                    target["throttleEvaluation"] = timeout;
                    var writeTimeoutInstance = null;
                    return ko.dependentObservable({
                        read: target,
                        write: function(value) {
                            clearTimeout(writeTimeoutInstance);
                            writeTimeoutInstance = setTimeout(function() {
                                target(value);
                            }, timeout);
                        }
                    });
                },
                rateLimit: function(target, options) {
                    var timeout, method, limitFunction;
                    if (typeof options == "number") {
                        timeout = options;
                    } else {
                        timeout = options["timeout"];
                        method = options["method"];
                    }
                    limitFunction = method == "notifyWhenChangesStop" ? debounce : throttle;
                    target.limit(function(callback) {
                        return limitFunction(callback, timeout);
                    });
                },
                notify: function(target, notifyWhen) {
                    target["equalityComparer"] = notifyWhen == "always" ? null : valuesArePrimitiveAndEqual;
                }
            };
            var primitiveTypes = {
                undefined: 1,
                "boolean": 1,
                number: 1,
                string: 1
            };
            function valuesArePrimitiveAndEqual(a, b) {
                var oldValueIsPrimitive = a === null || typeof a in primitiveTypes;
                return oldValueIsPrimitive ? a === b : false;
            }
            function throttle(callback, timeout) {
                var timeoutInstance;
                return function() {
                    if (!timeoutInstance) {
                        timeoutInstance = setTimeout(function() {
                            timeoutInstance = undefined;
                            callback();
                        }, timeout);
                    }
                };
            }
            function debounce(callback, timeout) {
                var timeoutInstance;
                return function() {
                    clearTimeout(timeoutInstance);
                    timeoutInstance = setTimeout(callback, timeout);
                };
            }
            function applyExtenders(requestedExtenders) {
                var target = this;
                if (requestedExtenders) {
                    ko.utils.objectForEach(requestedExtenders, function(key, value) {
                        var extenderHandler = ko.extenders[key];
                        if (typeof extenderHandler == "function") {
                            target = extenderHandler(target, value) || target;
                        }
                    });
                }
                return target;
            }
            ko.exportSymbol("extenders", ko.extenders);
            ko.subscription = function(target, callback, disposeCallback) {
                this.target = target;
                this.callback = callback;
                this.disposeCallback = disposeCallback;
                this.isDisposed = false;
                ko.exportProperty(this, "dispose", this.dispose);
            };
            ko.subscription.prototype.dispose = function() {
                this.isDisposed = true;
                this.disposeCallback();
            };
            ko.subscribable = function() {
                ko.utils.setPrototypeOfOrExtend(this, ko.subscribable["fn"]);
                this._subscriptions = {};
            };
            var defaultEvent = "change";
            var ko_subscribable_fn = {
                subscribe: function(callback, callbackTarget, event) {
                    var self = this;
                    event = event || defaultEvent;
                    var boundCallback = callbackTarget ? callback.bind(callbackTarget) : callback;
                    var subscription = new ko.subscription(self, boundCallback, function() {
                        ko.utils.arrayRemoveItem(self._subscriptions[event], subscription);
                    });
                    if (self.peek) {
                        self.peek();
                    }
                    if (!self._subscriptions[event]) self._subscriptions[event] = [];
                    self._subscriptions[event].push(subscription);
                    return subscription;
                },
                notifySubscribers: function(valueToNotify, event) {
                    event = event || defaultEvent;
                    if (this.hasSubscriptionsForEvent(event)) {
                        try {
                            ko.dependencyDetection.begin();
                            for (var a = this._subscriptions[event].slice(0), i = 0, subscription; subscription = a[i]; ++i) {
                                if (!subscription.isDisposed) subscription.callback(valueToNotify);
                            }
                        } finally {
                            ko.dependencyDetection.end();
                        }
                    }
                },
                limit: function(limitFunction) {
                    var self = this, selfIsObservable = ko.isObservable(self), isPending, previousValue, pendingValue, beforeChange = "beforeChange";
                    if (!self._origNotifySubscribers) {
                        self._origNotifySubscribers = self["notifySubscribers"];
                        self["notifySubscribers"] = function(value, event) {
                            if (!event || event === defaultEvent) {
                                self._rateLimitedChange(value);
                            } else if (event === beforeChange) {
                                self._rateLimitedBeforeChange(value);
                            } else {
                                self._origNotifySubscribers(value, event);
                            }
                        };
                    }
                    var finish = limitFunction(function() {
                        if (selfIsObservable && pendingValue === self) {
                            pendingValue = self();
                        }
                        isPending = false;
                        if (self.isDifferent(previousValue, pendingValue)) {
                            self._origNotifySubscribers(previousValue = pendingValue);
                        }
                    });
                    self._rateLimitedChange = function(value) {
                        isPending = true;
                        pendingValue = value;
                        finish();
                    };
                    self._rateLimitedBeforeChange = function(value) {
                        if (!isPending) {
                            previousValue = value;
                            self._origNotifySubscribers(value, beforeChange);
                        }
                    };
                },
                hasSubscriptionsForEvent: function(event) {
                    return this._subscriptions[event] && this._subscriptions[event].length;
                },
                getSubscriptionsCount: function() {
                    var total = 0;
                    ko.utils.objectForEach(this._subscriptions, function(eventName, subscriptions) {
                        total += subscriptions.length;
                    });
                    return total;
                },
                isDifferent: function(oldValue, newValue) {
                    return !this["equalityComparer"] || !this["equalityComparer"](oldValue, newValue);
                },
                extend: applyExtenders
            };
            ko.exportProperty(ko_subscribable_fn, "subscribe", ko_subscribable_fn.subscribe);
            ko.exportProperty(ko_subscribable_fn, "extend", ko_subscribable_fn.extend);
            ko.exportProperty(ko_subscribable_fn, "getSubscriptionsCount", ko_subscribable_fn.getSubscriptionsCount);
            if (ko.utils.canSetPrototype) {
                ko.utils.setPrototypeOf(ko_subscribable_fn, Function.prototype);
            }
            ko.subscribable["fn"] = ko_subscribable_fn;
            ko.isSubscribable = function(instance) {
                return instance != null && typeof instance.subscribe == "function" && typeof instance["notifySubscribers"] == "function";
            };
            ko.exportSymbol("subscribable", ko.subscribable);
            ko.exportSymbol("isSubscribable", ko.isSubscribable);
            ko.computedContext = ko.dependencyDetection = function() {
                var outerFrames = [], currentFrame, lastId = 0;
                function getId() {
                    return ++lastId;
                }
                function begin(options) {
                    outerFrames.push(currentFrame);
                    currentFrame = options;
                }
                function end() {
                    currentFrame = outerFrames.pop();
                }
                return {
                    begin: begin,
                    end: end,
                    registerDependency: function(subscribable) {
                        if (currentFrame) {
                            if (!ko.isSubscribable(subscribable)) throw new Error("Only subscribable things can act as dependencies");
                            currentFrame.callback(subscribable, subscribable._id || (subscribable._id = getId()));
                        }
                    },
                    ignore: function(callback, callbackTarget, callbackArgs) {
                        try {
                            begin();
                            return callback.apply(callbackTarget, callbackArgs || []);
                        } finally {
                            end();
                        }
                    },
                    getDependenciesCount: function() {
                        if (currentFrame) return currentFrame.computed.getDependenciesCount();
                    },
                    isInitial: function() {
                        if (currentFrame) return currentFrame.isInitial;
                    }
                };
            }();
            ko.exportSymbol("computedContext", ko.computedContext);
            ko.exportSymbol("computedContext.getDependenciesCount", ko.computedContext.getDependenciesCount);
            ko.exportSymbol("computedContext.isInitial", ko.computedContext.isInitial);
            ko.observable = function(initialValue) {
                var _latestValue = initialValue;
                function observable() {
                    if (arguments.length > 0) {
                        if (observable.isDifferent(_latestValue, arguments[0])) {
                            observable.valueWillMutate();
                            _latestValue = arguments[0];
                            if (DEBUG) observable._latestValue = _latestValue;
                            observable.valueHasMutated();
                        }
                        return this;
                    } else {
                        ko.dependencyDetection.registerDependency(observable);
                        return _latestValue;
                    }
                }
                ko.subscribable.call(observable);
                ko.utils.setPrototypeOfOrExtend(observable, ko.observable["fn"]);
                if (DEBUG) observable._latestValue = _latestValue;
                observable.peek = function() {
                    return _latestValue;
                };
                observable.valueHasMutated = function() {
                    observable["notifySubscribers"](_latestValue);
                };
                observable.valueWillMutate = function() {
                    observable["notifySubscribers"](_latestValue, "beforeChange");
                };
                ko.exportProperty(observable, "peek", observable.peek);
                ko.exportProperty(observable, "valueHasMutated", observable.valueHasMutated);
                ko.exportProperty(observable, "valueWillMutate", observable.valueWillMutate);
                return observable;
            };
            ko.observable["fn"] = {
                equalityComparer: valuesArePrimitiveAndEqual
            };
            var protoProperty = ko.observable.protoProperty = "__ko_proto__";
            ko.observable["fn"][protoProperty] = ko.observable;
            if (ko.utils.canSetPrototype) {
                ko.utils.setPrototypeOf(ko.observable["fn"], ko.subscribable["fn"]);
            }
            ko.hasPrototype = function(instance, prototype) {
                if (instance === null || instance === undefined || instance[protoProperty] === undefined) return false;
                if (instance[protoProperty] === prototype) return true;
                return ko.hasPrototype(instance[protoProperty], prototype);
            };
            ko.isObservable = function(instance) {
                return ko.hasPrototype(instance, ko.observable);
            };
            ko.isWriteableObservable = function(instance) {
                if (typeof instance == "function" && instance[protoProperty] === ko.observable) return true;
                if (typeof instance == "function" && instance[protoProperty] === ko.dependentObservable && instance.hasWriteFunction) return true;
                return false;
            };
            ko.exportSymbol("observable", ko.observable);
            ko.exportSymbol("isObservable", ko.isObservable);
            ko.exportSymbol("isWriteableObservable", ko.isWriteableObservable);
            ko.observableArray = function(initialValues) {
                initialValues = initialValues || [];
                if (typeof initialValues != "object" || !("length" in initialValues)) throw new Error("The argument passed when initializing an observable array must be an array, or null, or undefined.");
                var result = ko.observable(initialValues);
                ko.utils.setPrototypeOfOrExtend(result, ko.observableArray["fn"]);
                return result.extend({
                    trackArrayChanges: true
                });
            };
            ko.observableArray["fn"] = {
                remove: function(valueOrPredicate) {
                    var underlyingArray = this.peek();
                    var removedValues = [];
                    var predicate = typeof valueOrPredicate == "function" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function(value) {
                        return value === valueOrPredicate;
                    };
                    for (var i = 0; i < underlyingArray.length; i++) {
                        var value = underlyingArray[i];
                        if (predicate(value)) {
                            if (removedValues.length === 0) {
                                this.valueWillMutate();
                            }
                            removedValues.push(value);
                            underlyingArray.splice(i, 1);
                            i--;
                        }
                    }
                    if (removedValues.length) {
                        this.valueHasMutated();
                    }
                    return removedValues;
                },
                removeAll: function(arrayOfValues) {
                    if (arrayOfValues === undefined) {
                        var underlyingArray = this.peek();
                        var allValues = underlyingArray.slice(0);
                        this.valueWillMutate();
                        underlyingArray.splice(0, underlyingArray.length);
                        this.valueHasMutated();
                        return allValues;
                    }
                    if (!arrayOfValues) return [];
                    return this["remove"](function(value) {
                        return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;
                    });
                },
                destroy: function(valueOrPredicate) {
                    var underlyingArray = this.peek();
                    var predicate = typeof valueOrPredicate == "function" && !ko.isObservable(valueOrPredicate) ? valueOrPredicate : function(value) {
                        return value === valueOrPredicate;
                    };
                    this.valueWillMutate();
                    for (var i = underlyingArray.length - 1; i >= 0; i--) {
                        var value = underlyingArray[i];
                        if (predicate(value)) underlyingArray[i]["_destroy"] = true;
                    }
                    this.valueHasMutated();
                },
                destroyAll: function(arrayOfValues) {
                    if (arrayOfValues === undefined) return this["destroy"](function() {
                        return true;
                    });
                    if (!arrayOfValues) return [];
                    return this["destroy"](function(value) {
                        return ko.utils.arrayIndexOf(arrayOfValues, value) >= 0;
                    });
                },
                indexOf: function(item) {
                    var underlyingArray = this();
                    return ko.utils.arrayIndexOf(underlyingArray, item);
                },
                replace: function(oldItem, newItem) {
                    var index = this["indexOf"](oldItem);
                    if (index >= 0) {
                        this.valueWillMutate();
                        this.peek()[index] = newItem;
                        this.valueHasMutated();
                    }
                }
            };
            ko.utils.arrayForEach([ "pop", "push", "reverse", "shift", "sort", "splice", "unshift" ], function(methodName) {
                ko.observableArray["fn"][methodName] = function() {
                    var underlyingArray = this.peek();
                    this.valueWillMutate();
                    this.cacheDiffForKnownOperation(underlyingArray, methodName, arguments);
                    var methodCallResult = underlyingArray[methodName].apply(underlyingArray, arguments);
                    this.valueHasMutated();
                    return methodCallResult;
                };
            });
            ko.utils.arrayForEach([ "slice" ], function(methodName) {
                ko.observableArray["fn"][methodName] = function() {
                    var underlyingArray = this();
                    return underlyingArray[methodName].apply(underlyingArray, arguments);
                };
            });
            if (ko.utils.canSetPrototype) {
                ko.utils.setPrototypeOf(ko.observableArray["fn"], ko.observable["fn"]);
            }
            ko.exportSymbol("observableArray", ko.observableArray);
            var arrayChangeEventName = "arrayChange";
            ko.extenders["trackArrayChanges"] = function(target) {
                if (target.cacheDiffForKnownOperation) {
                    return;
                }
                var trackingChanges = false, cachedDiff = null, pendingNotifications = 0, underlyingSubscribeFunction = target.subscribe;
                target.subscribe = target["subscribe"] = function(callback, callbackTarget, event) {
                    if (event === arrayChangeEventName) {
                        trackChanges();
                    }
                    return underlyingSubscribeFunction.apply(this, arguments);
                };
                function trackChanges() {
                    if (trackingChanges) {
                        return;
                    }
                    trackingChanges = true;
                    var underlyingNotifySubscribersFunction = target["notifySubscribers"];
                    target["notifySubscribers"] = function(valueToNotify, event) {
                        if (!event || event === defaultEvent) {
                            ++pendingNotifications;
                        }
                        return underlyingNotifySubscribersFunction.apply(this, arguments);
                    };
                    var previousContents = [].concat(target.peek() || []);
                    cachedDiff = null;
                    target.subscribe(function(currentContents) {
                        currentContents = [].concat(currentContents || []);
                        if (target.hasSubscriptionsForEvent(arrayChangeEventName)) {
                            var changes = getChanges(previousContents, currentContents);
                            if (changes.length) {
                                target["notifySubscribers"](changes, arrayChangeEventName);
                            }
                        }
                        previousContents = currentContents;
                        cachedDiff = null;
                        pendingNotifications = 0;
                    });
                }
                function getChanges(previousContents, currentContents) {
                    if (!cachedDiff || pendingNotifications > 1) {
                        cachedDiff = ko.utils.compareArrays(previousContents, currentContents, {
                            sparse: true
                        });
                    }
                    return cachedDiff;
                }
                target.cacheDiffForKnownOperation = function(rawArray, operationName, args) {
                    if (!trackingChanges || pendingNotifications) {
                        return;
                    }
                    var diff = [], arrayLength = rawArray.length, argsLength = args.length, offset = 0;
                    function pushDiff(status, value, index) {
                        return diff[diff.length] = {
                            status: status,
                            value: value,
                            index: index
                        };
                    }
                    switch (operationName) {
                      case "push":
                        offset = arrayLength;

                      case "unshift":
                        for (var index = 0; index < argsLength; index++) {
                            pushDiff("added", args[index], offset + index);
                        }
                        break;

                      case "pop":
                        offset = arrayLength - 1;

                      case "shift":
                        if (arrayLength) {
                            pushDiff("deleted", rawArray[offset], offset);
                        }
                        break;

                      case "splice":
                        var startIndex = Math.min(Math.max(0, args[0] < 0 ? arrayLength + args[0] : args[0]), arrayLength), endDeleteIndex = argsLength === 1 ? arrayLength : Math.min(startIndex + (args[1] || 0), arrayLength), endAddIndex = startIndex + argsLength - 2, endIndex = Math.max(endDeleteIndex, endAddIndex), additions = [], deletions = [];
                        for (var index = startIndex, argsIndex = 2; index < endIndex; ++index, ++argsIndex) {
                            if (index < endDeleteIndex) deletions.push(pushDiff("deleted", rawArray[index], index));
                            if (index < endAddIndex) additions.push(pushDiff("added", args[argsIndex], index));
                        }
                        ko.utils.findMovesInArrayComparison(deletions, additions);
                        break;

                      default:
                        return;
                    }
                    cachedDiff = diff;
                };
            };
            ko.computed = ko.dependentObservable = function(evaluatorFunctionOrOptions, evaluatorFunctionTarget, options) {
                var _latestValue, _needsEvaluation = true, _isBeingEvaluated = false, _suppressDisposalUntilDisposeWhenReturnsFalse = false, _isDisposed = false, readFunction = evaluatorFunctionOrOptions;
                if (readFunction && typeof readFunction == "object") {
                    options = readFunction;
                    readFunction = options["read"];
                } else {
                    options = options || {};
                    if (!readFunction) readFunction = options["read"];
                }
                if (typeof readFunction != "function") throw new Error("Pass a function that returns the value of the ko.computed");
                function addSubscriptionToDependency(subscribable, id) {
                    if (!_subscriptionsToDependencies[id]) {
                        _subscriptionsToDependencies[id] = subscribable.subscribe(evaluatePossiblyAsync);
                        ++_dependenciesCount;
                    }
                }
                function disposeAllSubscriptionsToDependencies() {
                    _isDisposed = true;
                    ko.utils.objectForEach(_subscriptionsToDependencies, function(id, subscription) {
                        subscription.dispose();
                    });
                    _subscriptionsToDependencies = {};
                    _dependenciesCount = 0;
                    _needsEvaluation = false;
                }
                function evaluatePossiblyAsync() {
                    var throttleEvaluationTimeout = dependentObservable["throttleEvaluation"];
                    if (throttleEvaluationTimeout && throttleEvaluationTimeout >= 0) {
                        clearTimeout(evaluationTimeoutInstance);
                        evaluationTimeoutInstance = setTimeout(evaluateImmediate, throttleEvaluationTimeout);
                    } else if (dependentObservable._evalRateLimited) {
                        dependentObservable._evalRateLimited();
                    } else {
                        evaluateImmediate();
                    }
                }
                function evaluateImmediate() {
                    if (_isBeingEvaluated) {
                        return;
                    }
                    if (_isDisposed) {
                        return;
                    }
                    if (disposeWhen && disposeWhen()) {
                        if (!_suppressDisposalUntilDisposeWhenReturnsFalse) {
                            dispose();
                            return;
                        }
                    } else {
                        _suppressDisposalUntilDisposeWhenReturnsFalse = false;
                    }
                    _isBeingEvaluated = true;
                    try {
                        var disposalCandidates = _subscriptionsToDependencies, disposalCount = _dependenciesCount;
                        ko.dependencyDetection.begin({
                            callback: function(subscribable, id) {
                                if (!_isDisposed) {
                                    if (disposalCount && disposalCandidates[id]) {
                                        _subscriptionsToDependencies[id] = disposalCandidates[id];
                                        ++_dependenciesCount;
                                        delete disposalCandidates[id];
                                        --disposalCount;
                                    } else {
                                        addSubscriptionToDependency(subscribable, id);
                                    }
                                }
                            },
                            computed: dependentObservable,
                            isInitial: !_dependenciesCount
                        });
                        _subscriptionsToDependencies = {};
                        _dependenciesCount = 0;
                        try {
                            var newValue = evaluatorFunctionTarget ? readFunction.call(evaluatorFunctionTarget) : readFunction();
                        } finally {
                            ko.dependencyDetection.end();
                            if (disposalCount) {
                                ko.utils.objectForEach(disposalCandidates, function(id, toDispose) {
                                    toDispose.dispose();
                                });
                            }
                            _needsEvaluation = false;
                        }
                        if (dependentObservable.isDifferent(_latestValue, newValue)) {
                            dependentObservable["notifySubscribers"](_latestValue, "beforeChange");
                            _latestValue = newValue;
                            if (DEBUG) dependentObservable._latestValue = _latestValue;
                            if (!dependentObservable._evalRateLimited || dependentObservable["throttleEvaluation"]) {
                                dependentObservable["notifySubscribers"](_latestValue);
                            }
                        }
                    } finally {
                        _isBeingEvaluated = false;
                    }
                    if (!_dependenciesCount) dispose();
                }
                function dependentObservable() {
                    if (arguments.length > 0) {
                        if (typeof writeFunction === "function") {
                            writeFunction.apply(evaluatorFunctionTarget, arguments);
                        } else {
                            throw new Error("Cannot write a value to a ko.computed unless you specify a 'write' option. If you wish to read the current value, don't pass any parameters.");
                        }
                        return this;
                    } else {
                        if (_needsEvaluation) evaluateImmediate();
                        ko.dependencyDetection.registerDependency(dependentObservable);
                        return _latestValue;
                    }
                }
                function peek() {
                    if (_needsEvaluation && !_dependenciesCount) evaluateImmediate();
                    return _latestValue;
                }
                function isActive() {
                    return _needsEvaluation || _dependenciesCount > 0;
                }
                var writeFunction = options["write"], disposeWhenNodeIsRemoved = options["disposeWhenNodeIsRemoved"] || options.disposeWhenNodeIsRemoved || null, disposeWhenOption = options["disposeWhen"] || options.disposeWhen, disposeWhen = disposeWhenOption, dispose = disposeAllSubscriptionsToDependencies, _subscriptionsToDependencies = {}, _dependenciesCount = 0, evaluationTimeoutInstance = null;
                if (!evaluatorFunctionTarget) evaluatorFunctionTarget = options["owner"];
                ko.subscribable.call(dependentObservable);
                ko.utils.setPrototypeOfOrExtend(dependentObservable, ko.dependentObservable["fn"]);
                dependentObservable.peek = peek;
                dependentObservable.getDependenciesCount = function() {
                    return _dependenciesCount;
                };
                dependentObservable.hasWriteFunction = typeof options["write"] === "function";
                dependentObservable.dispose = function() {
                    dispose();
                };
                dependentObservable.isActive = isActive;
                var originalLimit = dependentObservable.limit;
                dependentObservable.limit = function(limitFunction) {
                    originalLimit.call(dependentObservable, limitFunction);
                    dependentObservable._evalRateLimited = function() {
                        dependentObservable._rateLimitedBeforeChange(_latestValue);
                        _needsEvaluation = true;
                        dependentObservable._rateLimitedChange(dependentObservable);
                    };
                };
                ko.exportProperty(dependentObservable, "peek", dependentObservable.peek);
                ko.exportProperty(dependentObservable, "dispose", dependentObservable.dispose);
                ko.exportProperty(dependentObservable, "isActive", dependentObservable.isActive);
                ko.exportProperty(dependentObservable, "getDependenciesCount", dependentObservable.getDependenciesCount);
                if (disposeWhenNodeIsRemoved) {
                    _suppressDisposalUntilDisposeWhenReturnsFalse = true;
                    if (disposeWhenNodeIsRemoved.nodeType) {
                        disposeWhen = function() {
                            return !ko.utils.domNodeIsAttachedToDocument(disposeWhenNodeIsRemoved) || disposeWhenOption && disposeWhenOption();
                        };
                    }
                }
                if (options["deferEvaluation"] !== true) evaluateImmediate();
                if (disposeWhenNodeIsRemoved && isActive() && disposeWhenNodeIsRemoved.nodeType) {
                    dispose = function() {
                        ko.utils.domNodeDisposal.removeDisposeCallback(disposeWhenNodeIsRemoved, dispose);
                        disposeAllSubscriptionsToDependencies();
                    };
                    ko.utils.domNodeDisposal.addDisposeCallback(disposeWhenNodeIsRemoved, dispose);
                }
                return dependentObservable;
            };
            ko.isComputed = function(instance) {
                return ko.hasPrototype(instance, ko.dependentObservable);
            };
            var protoProp = ko.observable.protoProperty;
            ko.dependentObservable[protoProp] = ko.observable;
            ko.dependentObservable["fn"] = {
                equalityComparer: valuesArePrimitiveAndEqual
            };
            ko.dependentObservable["fn"][protoProp] = ko.dependentObservable;
            if (ko.utils.canSetPrototype) {
                ko.utils.setPrototypeOf(ko.dependentObservable["fn"], ko.subscribable["fn"]);
            }
            ko.exportSymbol("dependentObservable", ko.dependentObservable);
            ko.exportSymbol("computed", ko.dependentObservable);
            ko.exportSymbol("isComputed", ko.isComputed);
            (function() {
                var maxNestedObservableDepth = 10;
                ko.toJS = function(rootObject) {
                    if (arguments.length == 0) throw new Error("When calling ko.toJS, pass the object you want to convert.");
                    return mapJsObjectGraph(rootObject, function(valueToMap) {
                        for (var i = 0; ko.isObservable(valueToMap) && i < maxNestedObservableDepth; i++) valueToMap = valueToMap();
                        return valueToMap;
                    });
                };
                ko.toJSON = function(rootObject, replacer, space) {
                    var plainJavaScriptObject = ko.toJS(rootObject);
                    return ko.utils.stringifyJson(plainJavaScriptObject, replacer, space);
                };
                function mapJsObjectGraph(rootObject, mapInputCallback, visitedObjects) {
                    visitedObjects = visitedObjects || new objectLookup();
                    rootObject = mapInputCallback(rootObject);
                    var canHaveProperties = typeof rootObject == "object" && rootObject !== null && rootObject !== undefined && !(rootObject instanceof Date) && !(rootObject instanceof String) && !(rootObject instanceof Number) && !(rootObject instanceof Boolean);
                    if (!canHaveProperties) return rootObject;
                    var outputProperties = rootObject instanceof Array ? [] : {};
                    visitedObjects.save(rootObject, outputProperties);
                    visitPropertiesOrArrayEntries(rootObject, function(indexer) {
                        var propertyValue = mapInputCallback(rootObject[indexer]);
                        switch (typeof propertyValue) {
                          case "boolean":
                          case "number":
                          case "string":
                          case "function":
                            outputProperties[indexer] = propertyValue;
                            break;

                          case "object":
                          case "undefined":
                            var previouslyMappedValue = visitedObjects.get(propertyValue);
                            outputProperties[indexer] = previouslyMappedValue !== undefined ? previouslyMappedValue : mapJsObjectGraph(propertyValue, mapInputCallback, visitedObjects);
                            break;
                        }
                    });
                    return outputProperties;
                }
                function visitPropertiesOrArrayEntries(rootObject, visitorCallback) {
                    if (rootObject instanceof Array) {
                        for (var i = 0; i < rootObject.length; i++) visitorCallback(i);
                        if (typeof rootObject["toJSON"] == "function") visitorCallback("toJSON");
                    } else {
                        for (var propertyName in rootObject) {
                            visitorCallback(propertyName);
                        }
                    }
                }
                function objectLookup() {
                    this.keys = [];
                    this.values = [];
                }
                objectLookup.prototype = {
                    constructor: objectLookup,
                    save: function(key, value) {
                        var existingIndex = ko.utils.arrayIndexOf(this.keys, key);
                        if (existingIndex >= 0) this.values[existingIndex] = value; else {
                            this.keys.push(key);
                            this.values.push(value);
                        }
                    },
                    get: function(key) {
                        var existingIndex = ko.utils.arrayIndexOf(this.keys, key);
                        return existingIndex >= 0 ? this.values[existingIndex] : undefined;
                    }
                };
            })();
            ko.exportSymbol("toJS", ko.toJS);
            ko.exportSymbol("toJSON", ko.toJSON);
            (function() {
                var hasDomDataExpandoProperty = "__ko__hasDomDataOptionValue__";
                ko.selectExtensions = {
                    readValue: function(element) {
                        switch (ko.utils.tagNameLower(element)) {
                          case "option":
                            if (element[hasDomDataExpandoProperty] === true) return ko.utils.domData.get(element, ko.bindingHandlers.options.optionValueDomDataKey);
                            return ko.utils.ieVersion <= 7 ? element.getAttributeNode("value") && element.getAttributeNode("value").specified ? element.value : element.text : element.value;

                          case "select":
                            return element.selectedIndex >= 0 ? ko.selectExtensions.readValue(element.options[element.selectedIndex]) : undefined;

                          default:
                            return element.value;
                        }
                    },
                    writeValue: function(element, value, allowUnset) {
                        switch (ko.utils.tagNameLower(element)) {
                          case "option":
                            switch (typeof value) {
                              case "string":
                                ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, undefined);
                                if (hasDomDataExpandoProperty in element) {
                                    delete element[hasDomDataExpandoProperty];
                                }
                                element.value = value;
                                break;

                              default:
                                ko.utils.domData.set(element, ko.bindingHandlers.options.optionValueDomDataKey, value);
                                element[hasDomDataExpandoProperty] = true;
                                element.value = typeof value === "number" ? value : "";
                                break;
                            }
                            break;

                          case "select":
                            if (value === "" || value === null) value = undefined;
                            var selection = -1;
                            for (var i = 0, n = element.options.length, optionValue; i < n; ++i) {
                                optionValue = ko.selectExtensions.readValue(element.options[i]);
                                if (optionValue == value || optionValue == "" && value === undefined) {
                                    selection = i;
                                    break;
                                }
                            }
                            if (allowUnset || selection >= 0 || value === undefined && element.size > 1) {
                                element.selectedIndex = selection;
                            }
                            break;

                          default:
                            if (value === null || value === undefined) value = "";
                            element.value = value;
                            break;
                        }
                    }
                };
            })();
            ko.exportSymbol("selectExtensions", ko.selectExtensions);
            ko.exportSymbol("selectExtensions.readValue", ko.selectExtensions.readValue);
            ko.exportSymbol("selectExtensions.writeValue", ko.selectExtensions.writeValue);
            ko.expressionRewriting = function() {
                var javaScriptReservedWords = [ "true", "false", "null", "undefined" ];
                var javaScriptAssignmentTarget = /^(?:[$_a-z][$\w]*|(.+)(\.\s*[$_a-z][$\w]*|\[.+\]))$/i;
                function getWriteableValue(expression) {
                    if (ko.utils.arrayIndexOf(javaScriptReservedWords, expression) >= 0) return false;
                    var match = expression.match(javaScriptAssignmentTarget);
                    return match === null ? false : match[1] ? "Object(" + match[1] + ")" + match[2] : expression;
                }
                var stringDouble = '"(?:[^"\\\\]|\\\\.)*"', stringSingle = "'(?:[^'\\\\]|\\\\.)*'", stringRegexp = "/(?:[^/\\\\]|\\\\.)*/w*", specials = ",\"'{}()/:[\\]", everyThingElse = "[^\\s:,/][^" + specials + "]*[^\\s" + specials + "]", oneNotSpace = "[^\\s]", bindingToken = RegExp(stringDouble + "|" + stringSingle + "|" + stringRegexp + "|" + everyThingElse + "|" + oneNotSpace, "g"), divisionLookBehind = /[\])"'A-Za-z0-9_$]+$/, keywordRegexLookBehind = {
                    "in": 1,
                    "return": 1,
                    "typeof": 1
                };
                function parseObjectLiteral(objectLiteralString) {
                    var str = ko.utils.stringTrim(objectLiteralString);
                    if (str.charCodeAt(0) === 123) str = str.slice(1, -1);
                    var result = [], toks = str.match(bindingToken), key, values, depth = 0;
                    if (toks) {
                        toks.push(",");
                        for (var i = 0, tok; tok = toks[i]; ++i) {
                            var c = tok.charCodeAt(0);
                            if (c === 44) {
                                if (depth <= 0) {
                                    if (key) result.push(values ? {
                                        key: key,
                                        value: values.join("")
                                    } : {
                                        unknown: key
                                    });
                                    key = values = depth = 0;
                                    continue;
                                }
                            } else if (c === 58) {
                                if (!values) continue;
                            } else if (c === 47 && i && tok.length > 1) {
                                var match = toks[i - 1].match(divisionLookBehind);
                                if (match && !keywordRegexLookBehind[match[0]]) {
                                    str = str.substr(str.indexOf(tok) + 1);
                                    toks = str.match(bindingToken);
                                    toks.push(",");
                                    i = -1;
                                    tok = "/";
                                }
                            } else if (c === 40 || c === 123 || c === 91) {
                                ++depth;
                            } else if (c === 41 || c === 125 || c === 93) {
                                --depth;
                            } else if (!key && !values) {
                                key = c === 34 || c === 39 ? tok.slice(1, -1) : tok;
                                continue;
                            }
                            if (values) values.push(tok); else values = [ tok ];
                        }
                    }
                    return result;
                }
                var twoWayBindings = {};
                function preProcessBindings(bindingsStringOrKeyValueArray, bindingOptions) {
                    bindingOptions = bindingOptions || {};
                    function processKeyValue(key, val) {
                        var writableVal;
                        function callPreprocessHook(obj) {
                            return obj && obj["preprocess"] ? val = obj["preprocess"](val, key, processKeyValue) : true;
                        }
                        if (!callPreprocessHook(ko["getBindingHandler"](key))) return;
                        if (twoWayBindings[key] && (writableVal = getWriteableValue(val))) {
                            propertyAccessorResultStrings.push("'" + key + "':function(_z){" + writableVal + "=_z}");
                        }
                        if (makeValueAccessors) {
                            val = "function(){return " + val + " }";
                        }
                        resultStrings.push("'" + key + "':" + val);
                    }
                    var resultStrings = [], propertyAccessorResultStrings = [], makeValueAccessors = bindingOptions["valueAccessors"], keyValueArray = typeof bindingsStringOrKeyValueArray === "string" ? parseObjectLiteral(bindingsStringOrKeyValueArray) : bindingsStringOrKeyValueArray;
                    ko.utils.arrayForEach(keyValueArray, function(keyValue) {
                        processKeyValue(keyValue.key || keyValue["unknown"], keyValue.value);
                    });
                    if (propertyAccessorResultStrings.length) processKeyValue("_ko_property_writers", "{" + propertyAccessorResultStrings.join(",") + " }");
                    return resultStrings.join(",");
                }
                return {
                    bindingRewriteValidators: [],
                    twoWayBindings: twoWayBindings,
                    parseObjectLiteral: parseObjectLiteral,
                    preProcessBindings: preProcessBindings,
                    keyValueArrayContainsKey: function(keyValueArray, key) {
                        for (var i = 0; i < keyValueArray.length; i++) if (keyValueArray[i]["key"] == key) return true;
                        return false;
                    },
                    writeValueToProperty: function(property, allBindings, key, value, checkIfDifferent) {
                        if (!property || !ko.isObservable(property)) {
                            var propWriters = allBindings.get("_ko_property_writers");
                            if (propWriters && propWriters[key]) propWriters[key](value);
                        } else if (ko.isWriteableObservable(property) && (!checkIfDifferent || property.peek() !== value)) {
                            property(value);
                        }
                    }
                };
            }();
            ko.exportSymbol("expressionRewriting", ko.expressionRewriting);
            ko.exportSymbol("expressionRewriting.bindingRewriteValidators", ko.expressionRewriting.bindingRewriteValidators);
            ko.exportSymbol("expressionRewriting.parseObjectLiteral", ko.expressionRewriting.parseObjectLiteral);
            ko.exportSymbol("expressionRewriting.preProcessBindings", ko.expressionRewriting.preProcessBindings);
            ko.exportSymbol("expressionRewriting._twoWayBindings", ko.expressionRewriting.twoWayBindings);
            ko.exportSymbol("jsonExpressionRewriting", ko.expressionRewriting);
            ko.exportSymbol("jsonExpressionRewriting.insertPropertyAccessorsIntoJson", ko.expressionRewriting.preProcessBindings);
            (function() {
                var commentNodesHaveTextProperty = document && document.createComment("test").text === "<!--test-->";
                var startCommentRegex = commentNodesHaveTextProperty ? /^<!--\s*ko(?:\s+([\s\S]+))?\s*-->$/ : /^\s*ko(?:\s+([\s\S]+))?\s*$/;
                var endCommentRegex = commentNodesHaveTextProperty ? /^<!--\s*\/ko\s*-->$/ : /^\s*\/ko\s*$/;
                var htmlTagsWithOptionallyClosingChildren = {
                    ul: true,
                    ol: true
                };
                function isStartComment(node) {
                    return node.nodeType == 8 && startCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);
                }
                function isEndComment(node) {
                    return node.nodeType == 8 && endCommentRegex.test(commentNodesHaveTextProperty ? node.text : node.nodeValue);
                }
                function getVirtualChildren(startComment, allowUnbalanced) {
                    var currentNode = startComment;
                    var depth = 1;
                    var children = [];
                    while (currentNode = currentNode.nextSibling) {
                        if (isEndComment(currentNode)) {
                            depth--;
                            if (depth === 0) return children;
                        }
                        children.push(currentNode);
                        if (isStartComment(currentNode)) depth++;
                    }
                    if (!allowUnbalanced) throw new Error("Cannot find closing comment tag to match: " + startComment.nodeValue);
                    return null;
                }
                function getMatchingEndComment(startComment, allowUnbalanced) {
                    var allVirtualChildren = getVirtualChildren(startComment, allowUnbalanced);
                    if (allVirtualChildren) {
                        if (allVirtualChildren.length > 0) return allVirtualChildren[allVirtualChildren.length - 1].nextSibling;
                        return startComment.nextSibling;
                    } else return null;
                }
                function getUnbalancedChildTags(node) {
                    var childNode = node.firstChild, captureRemaining = null;
                    if (childNode) {
                        do {
                            if (captureRemaining) captureRemaining.push(childNode); else if (isStartComment(childNode)) {
                                var matchingEndComment = getMatchingEndComment(childNode, true);
                                if (matchingEndComment) childNode = matchingEndComment; else captureRemaining = [ childNode ];
                            } else if (isEndComment(childNode)) {
                                captureRemaining = [ childNode ];
                            }
                        } while (childNode = childNode.nextSibling);
                    }
                    return captureRemaining;
                }
                ko.virtualElements = {
                    allowedBindings: {},
                    childNodes: function(node) {
                        return isStartComment(node) ? getVirtualChildren(node) : node.childNodes;
                    },
                    emptyNode: function(node) {
                        if (!isStartComment(node)) ko.utils.emptyDomNode(node); else {
                            var virtualChildren = ko.virtualElements.childNodes(node);
                            for (var i = 0, j = virtualChildren.length; i < j; i++) ko.removeNode(virtualChildren[i]);
                        }
                    },
                    setDomNodeChildren: function(node, childNodes) {
                        if (!isStartComment(node)) ko.utils.setDomNodeChildren(node, childNodes); else {
                            ko.virtualElements.emptyNode(node);
                            var endCommentNode = node.nextSibling;
                            for (var i = 0, j = childNodes.length; i < j; i++) endCommentNode.parentNode.insertBefore(childNodes[i], endCommentNode);
                        }
                    },
                    prepend: function(containerNode, nodeToPrepend) {
                        if (!isStartComment(containerNode)) {
                            if (containerNode.firstChild) containerNode.insertBefore(nodeToPrepend, containerNode.firstChild); else containerNode.appendChild(nodeToPrepend);
                        } else {
                            containerNode.parentNode.insertBefore(nodeToPrepend, containerNode.nextSibling);
                        }
                    },
                    insertAfter: function(containerNode, nodeToInsert, insertAfterNode) {
                        if (!insertAfterNode) {
                            ko.virtualElements.prepend(containerNode, nodeToInsert);
                        } else if (!isStartComment(containerNode)) {
                            if (insertAfterNode.nextSibling) containerNode.insertBefore(nodeToInsert, insertAfterNode.nextSibling); else containerNode.appendChild(nodeToInsert);
                        } else {
                            containerNode.parentNode.insertBefore(nodeToInsert, insertAfterNode.nextSibling);
                        }
                    },
                    firstChild: function(node) {
                        if (!isStartComment(node)) return node.firstChild;
                        if (!node.nextSibling || isEndComment(node.nextSibling)) return null;
                        return node.nextSibling;
                    },
                    nextSibling: function(node) {
                        if (isStartComment(node)) node = getMatchingEndComment(node);
                        if (node.nextSibling && isEndComment(node.nextSibling)) return null;
                        return node.nextSibling;
                    },
                    hasBindingValue: isStartComment,
                    virtualNodeBindingValue: function(node) {
                        var regexMatch = (commentNodesHaveTextProperty ? node.text : node.nodeValue).match(startCommentRegex);
                        return regexMatch ? regexMatch[1] : null;
                    },
                    normaliseVirtualElementDomStructure: function(elementVerified) {
                        if (!htmlTagsWithOptionallyClosingChildren[ko.utils.tagNameLower(elementVerified)]) return;
                        var childNode = elementVerified.firstChild;
                        if (childNode) {
                            do {
                                if (childNode.nodeType === 1) {
                                    var unbalancedTags = getUnbalancedChildTags(childNode);
                                    if (unbalancedTags) {
                                        var nodeToInsertBefore = childNode.nextSibling;
                                        for (var i = 0; i < unbalancedTags.length; i++) {
                                            if (nodeToInsertBefore) elementVerified.insertBefore(unbalancedTags[i], nodeToInsertBefore); else elementVerified.appendChild(unbalancedTags[i]);
                                        }
                                    }
                                }
                            } while (childNode = childNode.nextSibling);
                        }
                    }
                };
            })();
            ko.exportSymbol("virtualElements", ko.virtualElements);
            ko.exportSymbol("virtualElements.allowedBindings", ko.virtualElements.allowedBindings);
            ko.exportSymbol("virtualElements.emptyNode", ko.virtualElements.emptyNode);
            ko.exportSymbol("virtualElements.insertAfter", ko.virtualElements.insertAfter);
            ko.exportSymbol("virtualElements.prepend", ko.virtualElements.prepend);
            ko.exportSymbol("virtualElements.setDomNodeChildren", ko.virtualElements.setDomNodeChildren);
            (function() {
                var defaultBindingAttributeName = "data-bind";
                ko.bindingProvider = function() {
                    this.bindingCache = {};
                };
                ko.utils.extend(ko.bindingProvider.prototype, {
                    nodeHasBindings: function(node) {
                        switch (node.nodeType) {
                          case 1:
                            return node.getAttribute(defaultBindingAttributeName) != null;

                          case 8:
                            return ko.virtualElements.hasBindingValue(node);

                          default:
                            return false;
                        }
                    },
                    getBindings: function(node, bindingContext) {
                        var bindingsString = this["getBindingsString"](node, bindingContext);
                        return bindingsString ? this["parseBindingsString"](bindingsString, bindingContext, node) : null;
                    },
                    getBindingAccessors: function(node, bindingContext) {
                        var bindingsString = this["getBindingsString"](node, bindingContext);
                        return bindingsString ? this["parseBindingsString"](bindingsString, bindingContext, node, {
                            valueAccessors: true
                        }) : null;
                    },
                    getBindingsString: function(node, bindingContext) {
                        switch (node.nodeType) {
                          case 1:
                            return node.getAttribute(defaultBindingAttributeName);

                          case 8:
                            return ko.virtualElements.virtualNodeBindingValue(node);

                          default:
                            return null;
                        }
                    },
                    parseBindingsString: function(bindingsString, bindingContext, node, options) {
                        try {
                            var bindingFunction = createBindingsStringEvaluatorViaCache(bindingsString, this.bindingCache, options);
                            return bindingFunction(bindingContext, node);
                        } catch (ex) {
                            ex.message = "Unable to parse bindings.\nBindings value: " + bindingsString + "\nMessage: " + ex.message;
                            throw ex;
                        }
                    }
                });
                ko.bindingProvider["instance"] = new ko.bindingProvider();
                function createBindingsStringEvaluatorViaCache(bindingsString, cache, options) {
                    var cacheKey = bindingsString + (options && options["valueAccessors"] || "");
                    return cache[cacheKey] || (cache[cacheKey] = createBindingsStringEvaluator(bindingsString, options));
                }
                function createBindingsStringEvaluator(bindingsString, options) {
                    var rewrittenBindings = ko.expressionRewriting.preProcessBindings(bindingsString, options), functionBody = "with($context){with($data||{}){return{" + rewrittenBindings + "}}}";
                    return new Function("$context", "$element", functionBody);
                }
            })();
            ko.exportSymbol("bindingProvider", ko.bindingProvider);
            (function() {
                ko.bindingHandlers = {};
                var bindingDoesNotRecurseIntoElementTypes = {
                    script: true
                };
                ko["getBindingHandler"] = function(bindingKey) {
                    return ko.bindingHandlers[bindingKey];
                };
                ko.bindingContext = function(dataItemOrAccessor, parentContext, dataItemAlias, extendCallback) {
                    function updateContext() {
                        var dataItemOrObservable = isFunc ? dataItemOrAccessor() : dataItemOrAccessor, dataItem = ko.utils.unwrapObservable(dataItemOrObservable);
                        if (parentContext) {
                            if (parentContext._subscribable) parentContext._subscribable();
                            ko.utils.extend(self, parentContext);
                            if (subscribable) {
                                self._subscribable = subscribable;
                            }
                        } else {
                            self["$parents"] = [];
                            self["$root"] = dataItem;
                            self["ko"] = ko;
                        }
                        self["$rawData"] = dataItemOrObservable;
                        self["$data"] = dataItem;
                        if (dataItemAlias) self[dataItemAlias] = dataItem;
                        if (extendCallback) extendCallback(self, parentContext, dataItem);
                        return self["$data"];
                    }
                    function disposeWhen() {
                        return nodes && !ko.utils.anyDomNodeIsAttachedToDocument(nodes);
                    }
                    var self = this, isFunc = typeof dataItemOrAccessor == "function" && !ko.isObservable(dataItemOrAccessor), nodes, subscribable = ko.dependentObservable(updateContext, null, {
                        disposeWhen: disposeWhen,
                        disposeWhenNodeIsRemoved: true
                    });
                    if (subscribable.isActive()) {
                        self._subscribable = subscribable;
                        subscribable["equalityComparer"] = null;
                        nodes = [];
                        subscribable._addNode = function(node) {
                            nodes.push(node);
                            ko.utils.domNodeDisposal.addDisposeCallback(node, function(node) {
                                ko.utils.arrayRemoveItem(nodes, node);
                                if (!nodes.length) {
                                    subscribable.dispose();
                                    self._subscribable = subscribable = undefined;
                                }
                            });
                        };
                    }
                };
                ko.bindingContext.prototype["createChildContext"] = function(dataItemOrAccessor, dataItemAlias, extendCallback) {
                    return new ko.bindingContext(dataItemOrAccessor, this, dataItemAlias, function(self, parentContext) {
                        self["$parentContext"] = parentContext;
                        self["$parent"] = parentContext["$data"];
                        self["$parents"] = (parentContext["$parents"] || []).slice(0);
                        self["$parents"].unshift(self["$parent"]);
                        if (extendCallback) extendCallback(self);
                    });
                };
                ko.bindingContext.prototype["extend"] = function(properties) {
                    return new ko.bindingContext(this._subscribable || this["$data"], this, null, function(self, parentContext) {
                        self["$rawData"] = parentContext["$rawData"];
                        ko.utils.extend(self, typeof properties == "function" ? properties() : properties);
                    });
                };
                function makeValueAccessor(value) {
                    return function() {
                        return value;
                    };
                }
                function evaluateValueAccessor(valueAccessor) {
                    return valueAccessor();
                }
                function makeAccessorsFromFunction(callback) {
                    return ko.utils.objectMap(ko.dependencyDetection.ignore(callback), function(value, key) {
                        return function() {
                            return callback()[key];
                        };
                    });
                }
                function makeBindingAccessors(bindings, context, node) {
                    if (typeof bindings === "function") {
                        return makeAccessorsFromFunction(bindings.bind(null, context, node));
                    } else {
                        return ko.utils.objectMap(bindings, makeValueAccessor);
                    }
                }
                function getBindingsAndMakeAccessors(node, context) {
                    return makeAccessorsFromFunction(this["getBindings"].bind(this, node, context));
                }
                function validateThatBindingIsAllowedForVirtualElements(bindingName) {
                    var validator = ko.virtualElements.allowedBindings[bindingName];
                    if (!validator) throw new Error("The binding '" + bindingName + "' cannot be used with virtual elements");
                }
                function applyBindingsToDescendantsInternal(bindingContext, elementOrVirtualElement, bindingContextsMayDifferFromDomParentElement) {
                    var currentChild, nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement), provider = ko.bindingProvider["instance"], preprocessNode = provider["preprocessNode"];
                    if (preprocessNode) {
                        while (currentChild = nextInQueue) {
                            nextInQueue = ko.virtualElements.nextSibling(currentChild);
                            preprocessNode.call(provider, currentChild);
                        }
                        nextInQueue = ko.virtualElements.firstChild(elementOrVirtualElement);
                    }
                    while (currentChild = nextInQueue) {
                        nextInQueue = ko.virtualElements.nextSibling(currentChild);
                        applyBindingsToNodeAndDescendantsInternal(bindingContext, currentChild, bindingContextsMayDifferFromDomParentElement);
                    }
                }
                function applyBindingsToNodeAndDescendantsInternal(bindingContext, nodeVerified, bindingContextMayDifferFromDomParentElement) {
                    var shouldBindDescendants = true;
                    var isElement = nodeVerified.nodeType === 1;
                    if (isElement) ko.virtualElements.normaliseVirtualElementDomStructure(nodeVerified);
                    var shouldApplyBindings = isElement && bindingContextMayDifferFromDomParentElement || ko.bindingProvider["instance"]["nodeHasBindings"](nodeVerified);
                    if (shouldApplyBindings) shouldBindDescendants = applyBindingsToNodeInternal(nodeVerified, null, bindingContext, bindingContextMayDifferFromDomParentElement)["shouldBindDescendants"];
                    if (shouldBindDescendants && !bindingDoesNotRecurseIntoElementTypes[ko.utils.tagNameLower(nodeVerified)]) {
                        applyBindingsToDescendantsInternal(bindingContext, nodeVerified, !isElement);
                    }
                }
                var boundElementDomDataKey = ko.utils.domData.nextKey();
                function topologicalSortBindings(bindings) {
                    var result = [], bindingsConsidered = {}, cyclicDependencyStack = [];
                    ko.utils.objectForEach(bindings, function pushBinding(bindingKey) {
                        if (!bindingsConsidered[bindingKey]) {
                            var binding = ko["getBindingHandler"](bindingKey);
                            if (binding) {
                                if (binding["after"]) {
                                    cyclicDependencyStack.push(bindingKey);
                                    ko.utils.arrayForEach(binding["after"], function(bindingDependencyKey) {
                                        if (bindings[bindingDependencyKey]) {
                                            if (ko.utils.arrayIndexOf(cyclicDependencyStack, bindingDependencyKey) !== -1) {
                                                throw Error("Cannot combine the following bindings, because they have a cyclic dependency: " + cyclicDependencyStack.join(", "));
                                            } else {
                                                pushBinding(bindingDependencyKey);
                                            }
                                        }
                                    });
                                    cyclicDependencyStack.length--;
                                }
                                result.push({
                                    key: bindingKey,
                                    handler: binding
                                });
                            }
                            bindingsConsidered[bindingKey] = true;
                        }
                    });
                    return result;
                }
                function applyBindingsToNodeInternal(node, sourceBindings, bindingContext, bindingContextMayDifferFromDomParentElement) {
                    var alreadyBound = ko.utils.domData.get(node, boundElementDomDataKey);
                    if (!sourceBindings) {
                        if (alreadyBound) {
                            throw Error("You cannot apply bindings multiple times to the same element.");
                        }
                        ko.utils.domData.set(node, boundElementDomDataKey, true);
                    }
                    if (!alreadyBound && bindingContextMayDifferFromDomParentElement) ko.storedBindingContextForNode(node, bindingContext);
                    var bindings;
                    if (sourceBindings && typeof sourceBindings !== "function") {
                        bindings = sourceBindings;
                    } else {
                        var provider = ko.bindingProvider["instance"], getBindings = provider["getBindingAccessors"] || getBindingsAndMakeAccessors;
                        var bindingsUpdater = ko.dependentObservable(function() {
                            bindings = sourceBindings ? sourceBindings(bindingContext, node) : getBindings.call(provider, node, bindingContext);
                            if (bindings && bindingContext._subscribable) bindingContext._subscribable();
                            return bindings;
                        }, null, {
                            disposeWhenNodeIsRemoved: node
                        });
                        if (!bindings || !bindingsUpdater.isActive()) bindingsUpdater = null;
                    }
                    var bindingHandlerThatControlsDescendantBindings;
                    if (bindings) {
                        var getValueAccessor = bindingsUpdater ? function(bindingKey) {
                            return function() {
                                return evaluateValueAccessor(bindingsUpdater()[bindingKey]);
                            };
                        } : function(bindingKey) {
                            return bindings[bindingKey];
                        };
                        function allBindings() {
                            return ko.utils.objectMap(bindingsUpdater ? bindingsUpdater() : bindings, evaluateValueAccessor);
                        }
                        allBindings["get"] = function(key) {
                            return bindings[key] && evaluateValueAccessor(getValueAccessor(key));
                        };
                        allBindings["has"] = function(key) {
                            return key in bindings;
                        };
                        var orderedBindings = topologicalSortBindings(bindings);
                        ko.utils.arrayForEach(orderedBindings, function(bindingKeyAndHandler) {
                            var handlerInitFn = bindingKeyAndHandler.handler["init"], handlerUpdateFn = bindingKeyAndHandler.handler["update"], bindingKey = bindingKeyAndHandler.key;
                            if (node.nodeType === 8) {
                                validateThatBindingIsAllowedForVirtualElements(bindingKey);
                            }
                            try {
                                if (typeof handlerInitFn == "function") {
                                    ko.dependencyDetection.ignore(function() {
                                        var initResult = handlerInitFn(node, getValueAccessor(bindingKey), allBindings, bindingContext["$data"], bindingContext);
                                        if (initResult && initResult["controlsDescendantBindings"]) {
                                            if (bindingHandlerThatControlsDescendantBindings !== undefined) throw new Error("Multiple bindings (" + bindingHandlerThatControlsDescendantBindings + " and " + bindingKey + ") are trying to control descendant bindings of the same element. You cannot use these bindings together on the same element.");
                                            bindingHandlerThatControlsDescendantBindings = bindingKey;
                                        }
                                    });
                                }
                                if (typeof handlerUpdateFn == "function") {
                                    ko.dependentObservable(function() {
                                        handlerUpdateFn(node, getValueAccessor(bindingKey), allBindings, bindingContext["$data"], bindingContext);
                                    }, null, {
                                        disposeWhenNodeIsRemoved: node
                                    });
                                }
                            } catch (ex) {
                                ex.message = 'Unable to process binding "' + bindingKey + ": " + bindings[bindingKey] + '"\nMessage: ' + ex.message;
                                throw ex;
                            }
                        });
                    }
                    return {
                        shouldBindDescendants: bindingHandlerThatControlsDescendantBindings === undefined
                    };
                }
                var storedBindingContextDomDataKey = ko.utils.domData.nextKey();
                ko.storedBindingContextForNode = function(node, bindingContext) {
                    if (arguments.length == 2) {
                        ko.utils.domData.set(node, storedBindingContextDomDataKey, bindingContext);
                        if (bindingContext._subscribable) bindingContext._subscribable._addNode(node);
                    } else {
                        return ko.utils.domData.get(node, storedBindingContextDomDataKey);
                    }
                };
                function getBindingContext(viewModelOrBindingContext) {
                    return viewModelOrBindingContext && viewModelOrBindingContext instanceof ko.bindingContext ? viewModelOrBindingContext : new ko.bindingContext(viewModelOrBindingContext);
                }
                ko.applyBindingAccessorsToNode = function(node, bindings, viewModelOrBindingContext) {
                    if (node.nodeType === 1) ko.virtualElements.normaliseVirtualElementDomStructure(node);
                    return applyBindingsToNodeInternal(node, bindings, getBindingContext(viewModelOrBindingContext), true);
                };
                ko.applyBindingsToNode = function(node, bindings, viewModelOrBindingContext) {
                    var context = getBindingContext(viewModelOrBindingContext);
                    return ko.applyBindingAccessorsToNode(node, makeBindingAccessors(bindings, context, node), context);
                };
                ko.applyBindingsToDescendants = function(viewModelOrBindingContext, rootNode) {
                    if (rootNode.nodeType === 1 || rootNode.nodeType === 8) applyBindingsToDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode, true);
                };
                ko.applyBindings = function(viewModelOrBindingContext, rootNode) {
                    if (!jQuery && window["jQuery"]) {
                        jQuery = window["jQuery"];
                    }
                    if (rootNode && rootNode.nodeType !== 1 && rootNode.nodeType !== 8) throw new Error("ko.applyBindings: first parameter should be your view model; second parameter should be a DOM node");
                    rootNode = rootNode || window.document.body;
                    applyBindingsToNodeAndDescendantsInternal(getBindingContext(viewModelOrBindingContext), rootNode, true);
                };
                ko.contextFor = function(node) {
                    switch (node.nodeType) {
                      case 1:
                      case 8:
                        var context = ko.storedBindingContextForNode(node);
                        if (context) return context;
                        if (node.parentNode) return ko.contextFor(node.parentNode);
                        break;
                    }
                    return undefined;
                };
                ko.dataFor = function(node) {
                    var context = ko.contextFor(node);
                    return context ? context["$data"] : undefined;
                };
                ko.exportSymbol("bindingHandlers", ko.bindingHandlers);
                ko.exportSymbol("applyBindings", ko.applyBindings);
                ko.exportSymbol("applyBindingsToDescendants", ko.applyBindingsToDescendants);
                ko.exportSymbol("applyBindingAccessorsToNode", ko.applyBindingAccessorsToNode);
                ko.exportSymbol("applyBindingsToNode", ko.applyBindingsToNode);
                ko.exportSymbol("contextFor", ko.contextFor);
                ko.exportSymbol("dataFor", ko.dataFor);
            })();
            var attrHtmlToJavascriptMap = {
                "class": "className",
                "for": "htmlFor"
            };
            ko.bindingHandlers["attr"] = {
                update: function(element, valueAccessor, allBindings) {
                    var value = ko.utils.unwrapObservable(valueAccessor()) || {};
                    ko.utils.objectForEach(value, function(attrName, attrValue) {
                        attrValue = ko.utils.unwrapObservable(attrValue);
                        var toRemove = attrValue === false || attrValue === null || attrValue === undefined;
                        if (toRemove) element.removeAttribute(attrName);
                        if (ko.utils.ieVersion <= 8 && attrName in attrHtmlToJavascriptMap) {
                            attrName = attrHtmlToJavascriptMap[attrName];
                            if (toRemove) element.removeAttribute(attrName); else element[attrName] = attrValue;
                        } else if (!toRemove) {
                            element.setAttribute(attrName, attrValue.toString());
                        }
                        if (attrName === "name") {
                            ko.utils.setElementName(element, toRemove ? "" : attrValue.toString());
                        }
                    });
                }
            };
            (function() {
                ko.bindingHandlers["checked"] = {
                    after: [ "value", "attr" ],
                    init: function(element, valueAccessor, allBindings) {
                        function checkedValue() {
                            return allBindings["has"]("checkedValue") ? ko.utils.unwrapObservable(allBindings.get("checkedValue")) : element.value;
                        }
                        function updateModel() {
                            var isChecked = element.checked, elemValue = useCheckedValue ? checkedValue() : isChecked;
                            if (ko.computedContext.isInitial()) {
                                return;
                            }
                            if (isRadio && !isChecked) {
                                return;
                            }
                            var modelValue = ko.dependencyDetection.ignore(valueAccessor);
                            if (isValueArray) {
                                if (oldElemValue !== elemValue) {
                                    if (isChecked) {
                                        ko.utils.addOrRemoveItem(modelValue, elemValue, true);
                                        ko.utils.addOrRemoveItem(modelValue, oldElemValue, false);
                                    }
                                    oldElemValue = elemValue;
                                } else {
                                    ko.utils.addOrRemoveItem(modelValue, elemValue, isChecked);
                                }
                            } else {
                                ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, "checked", elemValue, true);
                            }
                        }
                        function updateView() {
                            var modelValue = ko.utils.unwrapObservable(valueAccessor());
                            if (isValueArray) {
                                element.checked = ko.utils.arrayIndexOf(modelValue, checkedValue()) >= 0;
                            } else if (isCheckbox) {
                                element.checked = modelValue;
                            } else {
                                element.checked = checkedValue() === modelValue;
                            }
                        }
                        var isCheckbox = element.type == "checkbox", isRadio = element.type == "radio";
                        if (!isCheckbox && !isRadio) {
                            return;
                        }
                        var isValueArray = isCheckbox && ko.utils.unwrapObservable(valueAccessor()) instanceof Array, oldElemValue = isValueArray ? checkedValue() : undefined, useCheckedValue = isRadio || isValueArray;
                        if (isRadio && !element.name) ko.bindingHandlers["uniqueName"]["init"](element, function() {
                            return true;
                        });
                        ko.computed(updateModel, null, {
                            disposeWhenNodeIsRemoved: element
                        });
                        ko.utils.registerEventHandler(element, "click", updateModel);
                        ko.computed(updateView, null, {
                            disposeWhenNodeIsRemoved: element
                        });
                    }
                };
                ko.expressionRewriting.twoWayBindings["checked"] = true;
                ko.bindingHandlers["checkedValue"] = {
                    update: function(element, valueAccessor) {
                        element.value = ko.utils.unwrapObservable(valueAccessor());
                    }
                };
            })();
            var classesWrittenByBindingKey = "__ko__cssValue";
            ko.bindingHandlers["css"] = {
                update: function(element, valueAccessor) {
                    var value = ko.utils.unwrapObservable(valueAccessor());
                    if (typeof value == "object") {
                        ko.utils.objectForEach(value, function(className, shouldHaveClass) {
                            shouldHaveClass = ko.utils.unwrapObservable(shouldHaveClass);
                            ko.utils.toggleDomNodeCssClass(element, className, shouldHaveClass);
                        });
                    } else {
                        value = String(value || "");
                        ko.utils.toggleDomNodeCssClass(element, element[classesWrittenByBindingKey], false);
                        element[classesWrittenByBindingKey] = value;
                        ko.utils.toggleDomNodeCssClass(element, value, true);
                    }
                }
            };
            ko.bindingHandlers["enable"] = {
                update: function(element, valueAccessor) {
                    var value = ko.utils.unwrapObservable(valueAccessor());
                    if (value && element.disabled) element.removeAttribute("disabled"); else if (!value && !element.disabled) element.disabled = true;
                }
            };
            ko.bindingHandlers["disable"] = {
                update: function(element, valueAccessor) {
                    ko.bindingHandlers["enable"]["update"](element, function() {
                        return !ko.utils.unwrapObservable(valueAccessor());
                    });
                }
            };
            function makeEventHandlerShortcut(eventName) {
                ko.bindingHandlers[eventName] = {
                    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
                        var newValueAccessor = function() {
                            var result = {};
                            result[eventName] = valueAccessor();
                            return result;
                        };
                        return ko.bindingHandlers["event"]["init"].call(this, element, newValueAccessor, allBindings, viewModel, bindingContext);
                    }
                };
            }
            ko.bindingHandlers["event"] = {
                init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
                    var eventsToHandle = valueAccessor() || {};
                    ko.utils.objectForEach(eventsToHandle, function(eventName) {
                        if (typeof eventName == "string") {
                            ko.utils.registerEventHandler(element, eventName, function(event) {
                                var handlerReturnValue;
                                var handlerFunction = valueAccessor()[eventName];
                                if (!handlerFunction) return;
                                try {
                                    var argsForHandler = ko.utils.makeArray(arguments);
                                    viewModel = bindingContext["$data"];
                                    argsForHandler.unshift(viewModel);
                                    handlerReturnValue = handlerFunction.apply(viewModel, argsForHandler);
                                } finally {
                                    if (handlerReturnValue !== true) {
                                        if (event.preventDefault) event.preventDefault(); else event.returnValue = false;
                                    }
                                }
                                var bubble = allBindings.get(eventName + "Bubble") !== false;
                                if (!bubble) {
                                    event.cancelBubble = true;
                                    if (event.stopPropagation) event.stopPropagation();
                                }
                            });
                        }
                    });
                }
            };
            ko.bindingHandlers["foreach"] = {
                makeTemplateValueAccessor: function(valueAccessor) {
                    return function() {
                        var modelValue = valueAccessor(), unwrappedValue = ko.utils.peekObservable(modelValue);
                        if (!unwrappedValue || typeof unwrappedValue.length == "number") return {
                            foreach: modelValue,
                            templateEngine: ko.nativeTemplateEngine.instance
                        };
                        ko.utils.unwrapObservable(modelValue);
                        return {
                            foreach: unwrappedValue["data"],
                            as: unwrappedValue["as"],
                            includeDestroyed: unwrappedValue["includeDestroyed"],
                            afterAdd: unwrappedValue["afterAdd"],
                            beforeRemove: unwrappedValue["beforeRemove"],
                            afterRender: unwrappedValue["afterRender"],
                            beforeMove: unwrappedValue["beforeMove"],
                            afterMove: unwrappedValue["afterMove"],
                            templateEngine: ko.nativeTemplateEngine.instance
                        };
                    };
                },
                init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
                    return ko.bindingHandlers["template"]["init"](element, ko.bindingHandlers["foreach"].makeTemplateValueAccessor(valueAccessor));
                },
                update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
                    return ko.bindingHandlers["template"]["update"](element, ko.bindingHandlers["foreach"].makeTemplateValueAccessor(valueAccessor), allBindings, viewModel, bindingContext);
                }
            };
            ko.expressionRewriting.bindingRewriteValidators["foreach"] = false;
            ko.virtualElements.allowedBindings["foreach"] = true;
            var hasfocusUpdatingProperty = "__ko_hasfocusUpdating";
            var hasfocusLastValue = "__ko_hasfocusLastValue";
            ko.bindingHandlers["hasfocus"] = {
                init: function(element, valueAccessor, allBindings) {
                    var handleElementFocusChange = function(isFocused) {
                        element[hasfocusUpdatingProperty] = true;
                        var ownerDoc = element.ownerDocument;
                        if ("activeElement" in ownerDoc) {
                            var active;
                            try {
                                active = ownerDoc.activeElement;
                            } catch (e) {
                                active = ownerDoc.body;
                            }
                            isFocused = active === element;
                        }
                        var modelValue = valueAccessor();
                        ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, "hasfocus", isFocused, true);
                        element[hasfocusLastValue] = isFocused;
                        element[hasfocusUpdatingProperty] = false;
                    };
                    var handleElementFocusIn = handleElementFocusChange.bind(null, true);
                    var handleElementFocusOut = handleElementFocusChange.bind(null, false);
                    ko.utils.registerEventHandler(element, "focus", handleElementFocusIn);
                    ko.utils.registerEventHandler(element, "focusin", handleElementFocusIn);
                    ko.utils.registerEventHandler(element, "blur", handleElementFocusOut);
                    ko.utils.registerEventHandler(element, "focusout", handleElementFocusOut);
                },
                update: function(element, valueAccessor) {
                    var value = !!ko.utils.unwrapObservable(valueAccessor());
                    if (!element[hasfocusUpdatingProperty] && element[hasfocusLastValue] !== value) {
                        value ? element.focus() : element.blur();
                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [ element, value ? "focusin" : "focusout" ]);
                    }
                }
            };
            ko.expressionRewriting.twoWayBindings["hasfocus"] = true;
            ko.bindingHandlers["hasFocus"] = ko.bindingHandlers["hasfocus"];
            ko.expressionRewriting.twoWayBindings["hasFocus"] = true;
            ko.bindingHandlers["html"] = {
                init: function() {
                    return {
                        controlsDescendantBindings: true
                    };
                },
                update: function(element, valueAccessor) {
                    ko.utils.setHtml(element, valueAccessor());
                }
            };
            function makeWithIfBinding(bindingKey, isWith, isNot, makeContextCallback) {
                ko.bindingHandlers[bindingKey] = {
                    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
                        var didDisplayOnLastUpdate, savedNodes;
                        ko.computed(function() {
                            var dataValue = ko.utils.unwrapObservable(valueAccessor()), shouldDisplay = !isNot !== !dataValue, isFirstRender = !savedNodes, needsRefresh = isFirstRender || isWith || shouldDisplay !== didDisplayOnLastUpdate;
                            if (needsRefresh) {
                                if (isFirstRender && ko.computedContext.getDependenciesCount()) {
                                    savedNodes = ko.utils.cloneNodes(ko.virtualElements.childNodes(element), true);
                                }
                                if (shouldDisplay) {
                                    if (!isFirstRender) {
                                        ko.virtualElements.setDomNodeChildren(element, ko.utils.cloneNodes(savedNodes));
                                    }
                                    ko.applyBindingsToDescendants(makeContextCallback ? makeContextCallback(bindingContext, dataValue) : bindingContext, element);
                                } else {
                                    ko.virtualElements.emptyNode(element);
                                }
                                didDisplayOnLastUpdate = shouldDisplay;
                            }
                        }, null, {
                            disposeWhenNodeIsRemoved: element
                        });
                        return {
                            controlsDescendantBindings: true
                        };
                    }
                };
                ko.expressionRewriting.bindingRewriteValidators[bindingKey] = false;
                ko.virtualElements.allowedBindings[bindingKey] = true;
            }
            makeWithIfBinding("if");
            makeWithIfBinding("ifnot", false, true);
            makeWithIfBinding("with", true, false, function(bindingContext, dataValue) {
                return bindingContext["createChildContext"](dataValue);
            });
            var captionPlaceholder = {};
            ko.bindingHandlers["options"] = {
                init: function(element) {
                    if (ko.utils.tagNameLower(element) !== "select") throw new Error("options binding applies only to SELECT elements");
                    while (element.length > 0) {
                        element.remove(0);
                    }
                    return {
                        controlsDescendantBindings: true
                    };
                },
                update: function(element, valueAccessor, allBindings) {
                    function selectedOptions() {
                        return ko.utils.arrayFilter(element.options, function(node) {
                            return node.selected;
                        });
                    }
                    var selectWasPreviouslyEmpty = element.length == 0;
                    var previousScrollTop = !selectWasPreviouslyEmpty && element.multiple ? element.scrollTop : null;
                    var unwrappedArray = ko.utils.unwrapObservable(valueAccessor());
                    var includeDestroyed = allBindings.get("optionsIncludeDestroyed");
                    var arrayToDomNodeChildrenOptions = {};
                    var captionValue;
                    var filteredArray;
                    var previousSelectedValues;
                    if (element.multiple) {
                        previousSelectedValues = ko.utils.arrayMap(selectedOptions(), ko.selectExtensions.readValue);
                    } else {
                        previousSelectedValues = element.selectedIndex >= 0 ? [ ko.selectExtensions.readValue(element.options[element.selectedIndex]) ] : [];
                    }
                    if (unwrappedArray) {
                        if (typeof unwrappedArray.length == "undefined") unwrappedArray = [ unwrappedArray ];
                        filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {
                            return includeDestroyed || item === undefined || item === null || !ko.utils.unwrapObservable(item["_destroy"]);
                        });
                        if (allBindings["has"]("optionsCaption")) {
                            captionValue = ko.utils.unwrapObservable(allBindings.get("optionsCaption"));
                            if (captionValue !== null && captionValue !== undefined) {
                                filteredArray.unshift(captionPlaceholder);
                            }
                        }
                    } else {}
                    function applyToObject(object, predicate, defaultValue) {
                        var predicateType = typeof predicate;
                        if (predicateType == "function") return predicate(object); else if (predicateType == "string") return object[predicate]; else return defaultValue;
                    }
                    var itemUpdate = false;
                    function optionForArrayItem(arrayEntry, index, oldOptions) {
                        if (oldOptions.length) {
                            previousSelectedValues = oldOptions[0].selected ? [ ko.selectExtensions.readValue(oldOptions[0]) ] : [];
                            itemUpdate = true;
                        }
                        var option = element.ownerDocument.createElement("option");
                        if (arrayEntry === captionPlaceholder) {
                            ko.utils.setTextContent(option, allBindings.get("optionsCaption"));
                            ko.selectExtensions.writeValue(option, undefined);
                        } else {
                            var optionValue = applyToObject(arrayEntry, allBindings.get("optionsValue"), arrayEntry);
                            ko.selectExtensions.writeValue(option, ko.utils.unwrapObservable(optionValue));
                            var optionText = applyToObject(arrayEntry, allBindings.get("optionsText"), optionValue);
                            ko.utils.setTextContent(option, optionText);
                        }
                        return [ option ];
                    }
                    arrayToDomNodeChildrenOptions["beforeRemove"] = function(option) {
                        element.removeChild(option);
                    };
                    function setSelectionCallback(arrayEntry, newOptions) {
                        if (previousSelectedValues.length) {
                            var isSelected = ko.utils.arrayIndexOf(previousSelectedValues, ko.selectExtensions.readValue(newOptions[0])) >= 0;
                            ko.utils.setOptionNodeSelectionState(newOptions[0], isSelected);
                            if (itemUpdate && !isSelected) ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [ element, "change" ]);
                        }
                    }
                    var callback = setSelectionCallback;
                    if (allBindings["has"]("optionsAfterRender")) {
                        callback = function(arrayEntry, newOptions) {
                            setSelectionCallback(arrayEntry, newOptions);
                            ko.dependencyDetection.ignore(allBindings.get("optionsAfterRender"), null, [ newOptions[0], arrayEntry !== captionPlaceholder ? arrayEntry : undefined ]);
                        };
                    }
                    ko.utils.setDomNodeChildrenFromArrayMapping(element, filteredArray, optionForArrayItem, arrayToDomNodeChildrenOptions, callback);
                    ko.dependencyDetection.ignore(function() {
                        if (allBindings.get("valueAllowUnset") && allBindings["has"]("value")) {
                            ko.selectExtensions.writeValue(element, ko.utils.unwrapObservable(allBindings.get("value")), true);
                        } else {
                            var selectionChanged;
                            if (element.multiple) {
                                selectionChanged = previousSelectedValues.length && selectedOptions().length < previousSelectedValues.length;
                            } else {
                                selectionChanged = previousSelectedValues.length && element.selectedIndex >= 0 ? ko.selectExtensions.readValue(element.options[element.selectedIndex]) !== previousSelectedValues[0] : previousSelectedValues.length || element.selectedIndex >= 0;
                            }
                            if (selectionChanged) {
                                ko.utils.triggerEvent(element, "change");
                            }
                        }
                    });
                    ko.utils.ensureSelectElementIsRenderedCorrectly(element);
                    if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20) element.scrollTop = previousScrollTop;
                }
            };
            ko.bindingHandlers["options"].optionValueDomDataKey = ko.utils.domData.nextKey();
            ko.bindingHandlers["selectedOptions"] = {
                after: [ "options", "foreach" ],
                init: function(element, valueAccessor, allBindings) {
                    ko.utils.registerEventHandler(element, "change", function() {
                        var value = valueAccessor(), valueToWrite = [];
                        ko.utils.arrayForEach(element.getElementsByTagName("option"), function(node) {
                            if (node.selected) valueToWrite.push(ko.selectExtensions.readValue(node));
                        });
                        ko.expressionRewriting.writeValueToProperty(value, allBindings, "selectedOptions", valueToWrite);
                    });
                },
                update: function(element, valueAccessor) {
                    if (ko.utils.tagNameLower(element) != "select") throw new Error("values binding applies only to SELECT elements");
                    var newValue = ko.utils.unwrapObservable(valueAccessor());
                    if (newValue && typeof newValue.length == "number") {
                        ko.utils.arrayForEach(element.getElementsByTagName("option"), function(node) {
                            var isSelected = ko.utils.arrayIndexOf(newValue, ko.selectExtensions.readValue(node)) >= 0;
                            ko.utils.setOptionNodeSelectionState(node, isSelected);
                        });
                    }
                }
            };
            ko.expressionRewriting.twoWayBindings["selectedOptions"] = true;
            ko.bindingHandlers["style"] = {
                update: function(element, valueAccessor) {
                    var value = ko.utils.unwrapObservable(valueAccessor() || {});
                    ko.utils.objectForEach(value, function(styleName, styleValue) {
                        styleValue = ko.utils.unwrapObservable(styleValue);
                        element.style[styleName] = styleValue || "";
                    });
                }
            };
            ko.bindingHandlers["submit"] = {
                init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
                    if (typeof valueAccessor() != "function") throw new Error("The value for a submit binding must be a function");
                    ko.utils.registerEventHandler(element, "submit", function(event) {
                        var handlerReturnValue;
                        var value = valueAccessor();
                        try {
                            handlerReturnValue = value.call(bindingContext["$data"], element);
                        } finally {
                            if (handlerReturnValue !== true) {
                                if (event.preventDefault) event.preventDefault(); else event.returnValue = false;
                            }
                        }
                    });
                }
            };
            ko.bindingHandlers["text"] = {
                init: function() {
                    return {
                        controlsDescendantBindings: true
                    };
                },
                update: function(element, valueAccessor) {
                    ko.utils.setTextContent(element, valueAccessor());
                }
            };
            ko.virtualElements.allowedBindings["text"] = true;
            ko.bindingHandlers["uniqueName"] = {
                init: function(element, valueAccessor) {
                    if (valueAccessor()) {
                        var name = "ko_unique_" + ++ko.bindingHandlers["uniqueName"].currentIndex;
                        ko.utils.setElementName(element, name);
                    }
                }
            };
            ko.bindingHandlers["uniqueName"].currentIndex = 0;
            ko.bindingHandlers["value"] = {
                after: [ "options", "foreach" ],
                init: function(element, valueAccessor, allBindings) {
                    var eventsToCatch = [ "change" ];
                    var requestedEventsToCatch = allBindings.get("valueUpdate");
                    var propertyChangedFired = false;
                    if (requestedEventsToCatch) {
                        if (typeof requestedEventsToCatch == "string") requestedEventsToCatch = [ requestedEventsToCatch ];
                        ko.utils.arrayPushAll(eventsToCatch, requestedEventsToCatch);
                        eventsToCatch = ko.utils.arrayGetDistinctValues(eventsToCatch);
                    }
                    var valueUpdateHandler = function() {
                        propertyChangedFired = false;
                        var modelValue = valueAccessor();
                        var elementValue = ko.selectExtensions.readValue(element);
                        ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, "value", elementValue);
                    };
                    var ieAutoCompleteHackNeeded = ko.utils.ieVersion && element.tagName.toLowerCase() == "input" && element.type == "text" && element.autocomplete != "off" && (!element.form || element.form.autocomplete != "off");
                    if (ieAutoCompleteHackNeeded && ko.utils.arrayIndexOf(eventsToCatch, "propertychange") == -1) {
                        ko.utils.registerEventHandler(element, "propertychange", function() {
                            propertyChangedFired = true;
                        });
                        ko.utils.registerEventHandler(element, "focus", function() {
                            propertyChangedFired = false;
                        });
                        ko.utils.registerEventHandler(element, "blur", function() {
                            if (propertyChangedFired) {
                                valueUpdateHandler();
                            }
                        });
                    }
                    ko.utils.arrayForEach(eventsToCatch, function(eventName) {
                        var handler = valueUpdateHandler;
                        if (ko.utils.stringStartsWith(eventName, "after")) {
                            handler = function() {
                                setTimeout(valueUpdateHandler, 0);
                            };
                            eventName = eventName.substring("after".length);
                        }
                        ko.utils.registerEventHandler(element, eventName, handler);
                    });
                },
                update: function(element, valueAccessor, allBindings) {
                    var newValue = ko.utils.unwrapObservable(valueAccessor());
                    var elementValue = ko.selectExtensions.readValue(element);
                    var valueHasChanged = newValue !== elementValue;
                    if (valueHasChanged) {
                        if (ko.utils.tagNameLower(element) === "select") {
                            var allowUnset = allBindings.get("valueAllowUnset");
                            var applyValueAction = function() {
                                ko.selectExtensions.writeValue(element, newValue, allowUnset);
                            };
                            applyValueAction();
                            if (!allowUnset && newValue !== ko.selectExtensions.readValue(element)) {
                                ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [ element, "change" ]);
                            } else {
                                setTimeout(applyValueAction, 0);
                            }
                        } else {
                            ko.selectExtensions.writeValue(element, newValue);
                        }
                    }
                }
            };
            ko.expressionRewriting.twoWayBindings["value"] = true;
            ko.bindingHandlers["visible"] = {
                update: function(element, valueAccessor) {
                    var value = ko.utils.unwrapObservable(valueAccessor());
                    var isCurrentlyVisible = !(element.style.display == "none");
                    if (value && !isCurrentlyVisible) element.style.display = ""; else if (!value && isCurrentlyVisible) element.style.display = "none";
                }
            };
            makeEventHandlerShortcut("click");
            ko.templateEngine = function() {};
            ko.templateEngine.prototype["renderTemplateSource"] = function(templateSource, bindingContext, options) {
                throw new Error("Override renderTemplateSource");
            };
            ko.templateEngine.prototype["createJavaScriptEvaluatorBlock"] = function(script) {
                throw new Error("Override createJavaScriptEvaluatorBlock");
            };
            ko.templateEngine.prototype["makeTemplateSource"] = function(template, templateDocument) {
                if (typeof template == "string") {
                    templateDocument = templateDocument || document;
                    var elem = templateDocument.getElementById(template);
                    if (!elem) throw new Error("Cannot find template with ID " + template);
                    return new ko.templateSources.domElement(elem);
                } else if (template.nodeType == 1 || template.nodeType == 8) {
                    return new ko.templateSources.anonymousTemplate(template);
                } else throw new Error("Unknown template type: " + template);
            };
            ko.templateEngine.prototype["renderTemplate"] = function(template, bindingContext, options, templateDocument) {
                var templateSource = this["makeTemplateSource"](template, templateDocument);
                return this["renderTemplateSource"](templateSource, bindingContext, options);
            };
            ko.templateEngine.prototype["isTemplateRewritten"] = function(template, templateDocument) {
                if (this["allowTemplateRewriting"] === false) return true;
                return this["makeTemplateSource"](template, templateDocument)["data"]("isRewritten");
            };
            ko.templateEngine.prototype["rewriteTemplate"] = function(template, rewriterCallback, templateDocument) {
                var templateSource = this["makeTemplateSource"](template, templateDocument);
                var rewritten = rewriterCallback(templateSource["text"]());
                templateSource["text"](rewritten);
                templateSource["data"]("isRewritten", true);
            };
            ko.exportSymbol("templateEngine", ko.templateEngine);
            ko.templateRewriting = function() {
                var memoizeDataBindingAttributeSyntaxRegex = /(<([a-z]+\d*)(?:\s+(?!data-bind\s*=\s*)[a-z0-9\-]+(?:=(?:\"[^\"]*\"|\'[^\']*\'))?)*\s+)data-bind\s*=\s*(["'])([\s\S]*?)\3/gi;
                var memoizeVirtualContainerBindingSyntaxRegex = /<!--\s*ko\b\s*([\s\S]*?)\s*-->/g;
                function validateDataBindValuesForRewriting(keyValueArray) {
                    var allValidators = ko.expressionRewriting.bindingRewriteValidators;
                    for (var i = 0; i < keyValueArray.length; i++) {
                        var key = keyValueArray[i]["key"];
                        if (allValidators.hasOwnProperty(key)) {
                            var validator = allValidators[key];
                            if (typeof validator === "function") {
                                var possibleErrorMessage = validator(keyValueArray[i]["value"]);
                                if (possibleErrorMessage) throw new Error(possibleErrorMessage);
                            } else if (!validator) {
                                throw new Error("This template engine does not support the '" + key + "' binding within its templates");
                            }
                        }
                    }
                }
                function constructMemoizedTagReplacement(dataBindAttributeValue, tagToRetain, nodeName, templateEngine) {
                    var dataBindKeyValueArray = ko.expressionRewriting.parseObjectLiteral(dataBindAttributeValue);
                    validateDataBindValuesForRewriting(dataBindKeyValueArray);
                    var rewrittenDataBindAttributeValue = ko.expressionRewriting.preProcessBindings(dataBindKeyValueArray, {
                        valueAccessors: true
                    });
                    var applyBindingsToNextSiblingScript = "ko.__tr_ambtns(function($context,$element){return(function(){return{ " + rewrittenDataBindAttributeValue + " } })()},'" + nodeName.toLowerCase() + "')";
                    return templateEngine["createJavaScriptEvaluatorBlock"](applyBindingsToNextSiblingScript) + tagToRetain;
                }
                return {
                    ensureTemplateIsRewritten: function(template, templateEngine, templateDocument) {
                        if (!templateEngine["isTemplateRewritten"](template, templateDocument)) templateEngine["rewriteTemplate"](template, function(htmlString) {
                            return ko.templateRewriting.memoizeBindingAttributeSyntax(htmlString, templateEngine);
                        }, templateDocument);
                    },
                    memoizeBindingAttributeSyntax: function(htmlString, templateEngine) {
                        return htmlString.replace(memoizeDataBindingAttributeSyntaxRegex, function() {
                            return constructMemoizedTagReplacement(arguments[4], arguments[1], arguments[2], templateEngine);
                        }).replace(memoizeVirtualContainerBindingSyntaxRegex, function() {
                            return constructMemoizedTagReplacement(arguments[1], "<!-- ko -->", "#comment", templateEngine);
                        });
                    },
                    applyMemoizedBindingsToNextSibling: function(bindings, nodeName) {
                        return ko.memoization.memoize(function(domNode, bindingContext) {
                            var nodeToBind = domNode.nextSibling;
                            if (nodeToBind && nodeToBind.nodeName.toLowerCase() === nodeName) {
                                ko.applyBindingAccessorsToNode(nodeToBind, bindings, bindingContext);
                            }
                        });
                    }
                };
            }();
            ko.exportSymbol("__tr_ambtns", ko.templateRewriting.applyMemoizedBindingsToNextSibling);
            (function() {
                ko.templateSources = {};
                ko.templateSources.domElement = function(element) {
                    this.domElement = element;
                };
                ko.templateSources.domElement.prototype["text"] = function() {
                    var tagNameLower = ko.utils.tagNameLower(this.domElement), elemContentsProperty = tagNameLower === "script" ? "text" : tagNameLower === "textarea" ? "value" : "innerHTML";
                    if (arguments.length == 0) {
                        return this.domElement[elemContentsProperty];
                    } else {
                        var valueToWrite = arguments[0];
                        if (elemContentsProperty === "innerHTML") ko.utils.setHtml(this.domElement, valueToWrite); else this.domElement[elemContentsProperty] = valueToWrite;
                    }
                };
                var dataDomDataPrefix = ko.utils.domData.nextKey() + "_";
                ko.templateSources.domElement.prototype["data"] = function(key) {
                    if (arguments.length === 1) {
                        return ko.utils.domData.get(this.domElement, dataDomDataPrefix + key);
                    } else {
                        ko.utils.domData.set(this.domElement, dataDomDataPrefix + key, arguments[1]);
                    }
                };
                var anonymousTemplatesDomDataKey = ko.utils.domData.nextKey();
                ko.templateSources.anonymousTemplate = function(element) {
                    this.domElement = element;
                };
                ko.templateSources.anonymousTemplate.prototype = new ko.templateSources.domElement();
                ko.templateSources.anonymousTemplate.prototype.constructor = ko.templateSources.anonymousTemplate;
                ko.templateSources.anonymousTemplate.prototype["text"] = function() {
                    if (arguments.length == 0) {
                        var templateData = ko.utils.domData.get(this.domElement, anonymousTemplatesDomDataKey) || {};
                        if (templateData.textData === undefined && templateData.containerData) templateData.textData = templateData.containerData.innerHTML;
                        return templateData.textData;
                    } else {
                        var valueToWrite = arguments[0];
                        ko.utils.domData.set(this.domElement, anonymousTemplatesDomDataKey, {
                            textData: valueToWrite
                        });
                    }
                };
                ko.templateSources.domElement.prototype["nodes"] = function() {
                    if (arguments.length == 0) {
                        var templateData = ko.utils.domData.get(this.domElement, anonymousTemplatesDomDataKey) || {};
                        return templateData.containerData;
                    } else {
                        var valueToWrite = arguments[0];
                        ko.utils.domData.set(this.domElement, anonymousTemplatesDomDataKey, {
                            containerData: valueToWrite
                        });
                    }
                };
                ko.exportSymbol("templateSources", ko.templateSources);
                ko.exportSymbol("templateSources.domElement", ko.templateSources.domElement);
                ko.exportSymbol("templateSources.anonymousTemplate", ko.templateSources.anonymousTemplate);
            })();
            (function() {
                var _templateEngine;
                ko.setTemplateEngine = function(templateEngine) {
                    if (templateEngine != undefined && !(templateEngine instanceof ko.templateEngine)) throw new Error("templateEngine must inherit from ko.templateEngine");
                    _templateEngine = templateEngine;
                };
                function invokeForEachNodeInContinuousRange(firstNode, lastNode, action) {
                    var node, nextInQueue = firstNode, firstOutOfRangeNode = ko.virtualElements.nextSibling(lastNode);
                    while (nextInQueue && (node = nextInQueue) !== firstOutOfRangeNode) {
                        nextInQueue = ko.virtualElements.nextSibling(node);
                        action(node, nextInQueue);
                    }
                }
                function activateBindingsOnContinuousNodeArray(continuousNodeArray, bindingContext) {
                    if (continuousNodeArray.length) {
                        var firstNode = continuousNodeArray[0], lastNode = continuousNodeArray[continuousNodeArray.length - 1], parentNode = firstNode.parentNode, provider = ko.bindingProvider["instance"], preprocessNode = provider["preprocessNode"];
                        if (preprocessNode) {
                            invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node, nextNodeInRange) {
                                var nodePreviousSibling = node.previousSibling;
                                var newNodes = preprocessNode.call(provider, node);
                                if (newNodes) {
                                    if (node === firstNode) firstNode = newNodes[0] || nextNodeInRange;
                                    if (node === lastNode) lastNode = newNodes[newNodes.length - 1] || nodePreviousSibling;
                                }
                            });
                            continuousNodeArray.length = 0;
                            if (!firstNode) {
                                return;
                            }
                            if (firstNode === lastNode) {
                                continuousNodeArray.push(firstNode);
                            } else {
                                continuousNodeArray.push(firstNode, lastNode);
                                ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);
                            }
                        }
                        invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {
                            if (node.nodeType === 1 || node.nodeType === 8) ko.applyBindings(bindingContext, node);
                        });
                        invokeForEachNodeInContinuousRange(firstNode, lastNode, function(node) {
                            if (node.nodeType === 1 || node.nodeType === 8) ko.memoization.unmemoizeDomNodeAndDescendants(node, [ bindingContext ]);
                        });
                        ko.utils.fixUpContinuousNodeArray(continuousNodeArray, parentNode);
                    }
                }
                function getFirstNodeFromPossibleArray(nodeOrNodeArray) {
                    return nodeOrNodeArray.nodeType ? nodeOrNodeArray : nodeOrNodeArray.length > 0 ? nodeOrNodeArray[0] : null;
                }
                function executeTemplate(targetNodeOrNodeArray, renderMode, template, bindingContext, options) {
                    options = options || {};
                    var firstTargetNode = targetNodeOrNodeArray && getFirstNodeFromPossibleArray(targetNodeOrNodeArray);
                    var templateDocument = firstTargetNode && firstTargetNode.ownerDocument;
                    var templateEngineToUse = options["templateEngine"] || _templateEngine;
                    ko.templateRewriting.ensureTemplateIsRewritten(template, templateEngineToUse, templateDocument);
                    var renderedNodesArray = templateEngineToUse["renderTemplate"](template, bindingContext, options, templateDocument);
                    if (typeof renderedNodesArray.length != "number" || renderedNodesArray.length > 0 && typeof renderedNodesArray[0].nodeType != "number") throw new Error("Template engine must return an array of DOM nodes");
                    var haveAddedNodesToParent = false;
                    switch (renderMode) {
                      case "replaceChildren":
                        ko.virtualElements.setDomNodeChildren(targetNodeOrNodeArray, renderedNodesArray);
                        haveAddedNodesToParent = true;
                        break;

                      case "replaceNode":
                        ko.utils.replaceDomNodes(targetNodeOrNodeArray, renderedNodesArray);
                        haveAddedNodesToParent = true;
                        break;

                      case "ignoreTargetNode":
                        break;

                      default:
                        throw new Error("Unknown renderMode: " + renderMode);
                    }
                    if (haveAddedNodesToParent) {
                        activateBindingsOnContinuousNodeArray(renderedNodesArray, bindingContext);
                        if (options["afterRender"]) ko.dependencyDetection.ignore(options["afterRender"], null, [ renderedNodesArray, bindingContext["$data"] ]);
                    }
                    return renderedNodesArray;
                }
                ko.renderTemplate = function(template, dataOrBindingContext, options, targetNodeOrNodeArray, renderMode) {
                    options = options || {};
                    if ((options["templateEngine"] || _templateEngine) == undefined) throw new Error("Set a template engine before calling renderTemplate");
                    renderMode = renderMode || "replaceChildren";
                    if (targetNodeOrNodeArray) {
                        var firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);
                        var whenToDispose = function() {
                            return !firstTargetNode || !ko.utils.domNodeIsAttachedToDocument(firstTargetNode);
                        };
                        var activelyDisposeWhenNodeIsRemoved = firstTargetNode && renderMode == "replaceNode" ? firstTargetNode.parentNode : firstTargetNode;
                        return ko.dependentObservable(function() {
                            var bindingContext = dataOrBindingContext && dataOrBindingContext instanceof ko.bindingContext ? dataOrBindingContext : new ko.bindingContext(ko.utils.unwrapObservable(dataOrBindingContext));
                            var templateName = ko.isObservable(template) ? template() : typeof template == "function" ? template(bindingContext["$data"], bindingContext) : template;
                            var renderedNodesArray = executeTemplate(targetNodeOrNodeArray, renderMode, templateName, bindingContext, options);
                            if (renderMode == "replaceNode") {
                                targetNodeOrNodeArray = renderedNodesArray;
                                firstTargetNode = getFirstNodeFromPossibleArray(targetNodeOrNodeArray);
                            }
                        }, null, {
                            disposeWhen: whenToDispose,
                            disposeWhenNodeIsRemoved: activelyDisposeWhenNodeIsRemoved
                        });
                    } else {
                        return ko.memoization.memoize(function(domNode) {
                            ko.renderTemplate(template, dataOrBindingContext, options, domNode, "replaceNode");
                        });
                    }
                };
                ko.renderTemplateForEach = function(template, arrayOrObservableArray, options, targetNode, parentBindingContext) {
                    var arrayItemContext;
                    var executeTemplateForArrayItem = function(arrayValue, index) {
                        arrayItemContext = parentBindingContext["createChildContext"](arrayValue, options["as"], function(context) {
                            context["$index"] = index;
                        });
                        var templateName = typeof template == "function" ? template(arrayValue, arrayItemContext) : template;
                        return executeTemplate(null, "ignoreTargetNode", templateName, arrayItemContext, options);
                    };
                    var activateBindingsCallback = function(arrayValue, addedNodesArray, index) {
                        activateBindingsOnContinuousNodeArray(addedNodesArray, arrayItemContext);
                        if (options["afterRender"]) options["afterRender"](addedNodesArray, arrayValue);
                    };
                    return ko.dependentObservable(function() {
                        var unwrappedArray = ko.utils.unwrapObservable(arrayOrObservableArray) || [];
                        if (typeof unwrappedArray.length == "undefined") unwrappedArray = [ unwrappedArray ];
                        var filteredArray = ko.utils.arrayFilter(unwrappedArray, function(item) {
                            return options["includeDestroyed"] || item === undefined || item === null || !ko.utils.unwrapObservable(item["_destroy"]);
                        });
                        ko.dependencyDetection.ignore(ko.utils.setDomNodeChildrenFromArrayMapping, null, [ targetNode, filteredArray, executeTemplateForArrayItem, options, activateBindingsCallback ]);
                    }, null, {
                        disposeWhenNodeIsRemoved: targetNode
                    });
                };
                var templateComputedDomDataKey = ko.utils.domData.nextKey();
                function disposeOldComputedAndStoreNewOne(element, newComputed) {
                    var oldComputed = ko.utils.domData.get(element, templateComputedDomDataKey);
                    if (oldComputed && typeof oldComputed.dispose == "function") oldComputed.dispose();
                    ko.utils.domData.set(element, templateComputedDomDataKey, newComputed && newComputed.isActive() ? newComputed : undefined);
                }
                ko.bindingHandlers["template"] = {
                    init: function(element, valueAccessor) {
                        var bindingValue = ko.utils.unwrapObservable(valueAccessor());
                        if (typeof bindingValue == "string" || bindingValue["name"]) {
                            ko.virtualElements.emptyNode(element);
                        } else {
                            var templateNodes = ko.virtualElements.childNodes(element), container = ko.utils.moveCleanedNodesToContainerElement(templateNodes);
                            new ko.templateSources.anonymousTemplate(element)["nodes"](container);
                        }
                        return {
                            controlsDescendantBindings: true
                        };
                    },
                    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
                        var value = valueAccessor(), dataValue, options = ko.utils.unwrapObservable(value), shouldDisplay = true, templateComputed = null, templateName;
                        if (typeof options == "string") {
                            templateName = value;
                            options = {};
                        } else {
                            templateName = options["name"];
                            if ("if" in options) shouldDisplay = ko.utils.unwrapObservable(options["if"]);
                            if (shouldDisplay && "ifnot" in options) shouldDisplay = !ko.utils.unwrapObservable(options["ifnot"]);
                            dataValue = ko.utils.unwrapObservable(options["data"]);
                        }
                        if ("foreach" in options) {
                            var dataArray = shouldDisplay && options["foreach"] || [];
                            templateComputed = ko.renderTemplateForEach(templateName || element, dataArray, options, element, bindingContext);
                        } else if (!shouldDisplay) {
                            ko.virtualElements.emptyNode(element);
                        } else {
                            var innerBindingContext = "data" in options ? bindingContext["createChildContext"](dataValue, options["as"]) : bindingContext;
                            templateComputed = ko.renderTemplate(templateName || element, innerBindingContext, options, element);
                        }
                        disposeOldComputedAndStoreNewOne(element, templateComputed);
                    }
                };
                ko.expressionRewriting.bindingRewriteValidators["template"] = function(bindingValue) {
                    var parsedBindingValue = ko.expressionRewriting.parseObjectLiteral(bindingValue);
                    if (parsedBindingValue.length == 1 && parsedBindingValue[0]["unknown"]) return null;
                    if (ko.expressionRewriting.keyValueArrayContainsKey(parsedBindingValue, "name")) return null;
                    return "This template engine does not support anonymous templates nested within its templates";
                };
                ko.virtualElements.allowedBindings["template"] = true;
            })();
            ko.exportSymbol("setTemplateEngine", ko.setTemplateEngine);
            ko.exportSymbol("renderTemplate", ko.renderTemplate);
            ko.utils.findMovesInArrayComparison = function(left, right, limitFailedCompares) {
                if (left.length && right.length) {
                    var failedCompares, l, r, leftItem, rightItem;
                    for (failedCompares = l = 0; (!limitFailedCompares || failedCompares < limitFailedCompares) && (leftItem = left[l]); ++l) {
                        for (r = 0; rightItem = right[r]; ++r) {
                            if (leftItem["value"] === rightItem["value"]) {
                                leftItem["moved"] = rightItem["index"];
                                rightItem["moved"] = leftItem["index"];
                                right.splice(r, 1);
                                failedCompares = r = 0;
                                break;
                            }
                        }
                        failedCompares += r;
                    }
                }
            };
            ko.utils.compareArrays = function() {
                var statusNotInOld = "added", statusNotInNew = "deleted";
                function compareArrays(oldArray, newArray, options) {
                    options = typeof options === "boolean" ? {
                        dontLimitMoves: options
                    } : options || {};
                    oldArray = oldArray || [];
                    newArray = newArray || [];
                    if (oldArray.length <= newArray.length) return compareSmallArrayToBigArray(oldArray, newArray, statusNotInOld, statusNotInNew, options); else return compareSmallArrayToBigArray(newArray, oldArray, statusNotInNew, statusNotInOld, options);
                }
                function compareSmallArrayToBigArray(smlArray, bigArray, statusNotInSml, statusNotInBig, options) {
                    var myMin = Math.min, myMax = Math.max, editDistanceMatrix = [], smlIndex, smlIndexMax = smlArray.length, bigIndex, bigIndexMax = bigArray.length, compareRange = bigIndexMax - smlIndexMax || 1, maxDistance = smlIndexMax + bigIndexMax + 1, thisRow, lastRow, bigIndexMaxForRow, bigIndexMinForRow;
                    for (smlIndex = 0; smlIndex <= smlIndexMax; smlIndex++) {
                        lastRow = thisRow;
                        editDistanceMatrix.push(thisRow = []);
                        bigIndexMaxForRow = myMin(bigIndexMax, smlIndex + compareRange);
                        bigIndexMinForRow = myMax(0, smlIndex - 1);
                        for (bigIndex = bigIndexMinForRow; bigIndex <= bigIndexMaxForRow; bigIndex++) {
                            if (!bigIndex) thisRow[bigIndex] = smlIndex + 1; else if (!smlIndex) thisRow[bigIndex] = bigIndex + 1; else if (smlArray[smlIndex - 1] === bigArray[bigIndex - 1]) thisRow[bigIndex] = lastRow[bigIndex - 1]; else {
                                var northDistance = lastRow[bigIndex] || maxDistance;
                                var westDistance = thisRow[bigIndex - 1] || maxDistance;
                                thisRow[bigIndex] = myMin(northDistance, westDistance) + 1;
                            }
                        }
                    }
                    var editScript = [], meMinusOne, notInSml = [], notInBig = [];
                    for (smlIndex = smlIndexMax, bigIndex = bigIndexMax; smlIndex || bigIndex; ) {
                        meMinusOne = editDistanceMatrix[smlIndex][bigIndex] - 1;
                        if (bigIndex && meMinusOne === editDistanceMatrix[smlIndex][bigIndex - 1]) {
                            notInSml.push(editScript[editScript.length] = {
                                status: statusNotInSml,
                                value: bigArray[--bigIndex],
                                index: bigIndex
                            });
                        } else if (smlIndex && meMinusOne === editDistanceMatrix[smlIndex - 1][bigIndex]) {
                            notInBig.push(editScript[editScript.length] = {
                                status: statusNotInBig,
                                value: smlArray[--smlIndex],
                                index: smlIndex
                            });
                        } else {
                            --bigIndex;
                            --smlIndex;
                            if (!options["sparse"]) {
                                editScript.push({
                                    status: "retained",
                                    value: bigArray[bigIndex]
                                });
                            }
                        }
                    }
                    ko.utils.findMovesInArrayComparison(notInSml, notInBig, smlIndexMax * 10);
                    return editScript.reverse();
                }
                return compareArrays;
            }();
            ko.exportSymbol("utils.compareArrays", ko.utils.compareArrays);
            (function() {
                function mapNodeAndRefreshWhenChanged(containerNode, mapping, valueToMap, callbackAfterAddingNodes, index) {
                    var mappedNodes = [];
                    var dependentObservable = ko.dependentObservable(function() {
                        var newMappedNodes = mapping(valueToMap, index, ko.utils.fixUpContinuousNodeArray(mappedNodes, containerNode)) || [];
                        if (mappedNodes.length > 0) {
                            ko.utils.replaceDomNodes(mappedNodes, newMappedNodes);
                            if (callbackAfterAddingNodes) ko.dependencyDetection.ignore(callbackAfterAddingNodes, null, [ valueToMap, newMappedNodes, index ]);
                        }
                        mappedNodes.length = 0;
                        ko.utils.arrayPushAll(mappedNodes, newMappedNodes);
                    }, null, {
                        disposeWhenNodeIsRemoved: containerNode,
                        disposeWhen: function() {
                            return !ko.utils.anyDomNodeIsAttachedToDocument(mappedNodes);
                        }
                    });
                    return {
                        mappedNodes: mappedNodes,
                        dependentObservable: dependentObservable.isActive() ? dependentObservable : undefined
                    };
                }
                var lastMappingResultDomDataKey = ko.utils.domData.nextKey();
                ko.utils.setDomNodeChildrenFromArrayMapping = function(domNode, array, mapping, options, callbackAfterAddingNodes) {
                    array = array || [];
                    options = options || {};
                    var isFirstExecution = ko.utils.domData.get(domNode, lastMappingResultDomDataKey) === undefined;
                    var lastMappingResult = ko.utils.domData.get(domNode, lastMappingResultDomDataKey) || [];
                    var lastArray = ko.utils.arrayMap(lastMappingResult, function(x) {
                        return x.arrayEntry;
                    });
                    var editScript = ko.utils.compareArrays(lastArray, array, options["dontLimitMoves"]);
                    var newMappingResult = [];
                    var lastMappingResultIndex = 0;
                    var newMappingResultIndex = 0;
                    var nodesToDelete = [];
                    var itemsToProcess = [];
                    var itemsForBeforeRemoveCallbacks = [];
                    var itemsForMoveCallbacks = [];
                    var itemsForAfterAddCallbacks = [];
                    var mapData;
                    function itemMovedOrRetained(editScriptIndex, oldPosition) {
                        mapData = lastMappingResult[oldPosition];
                        if (newMappingResultIndex !== oldPosition) itemsForMoveCallbacks[editScriptIndex] = mapData;
                        mapData.indexObservable(newMappingResultIndex++);
                        ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode);
                        newMappingResult.push(mapData);
                        itemsToProcess.push(mapData);
                    }
                    function callCallback(callback, items) {
                        if (callback) {
                            for (var i = 0, n = items.length; i < n; i++) {
                                if (items[i]) {
                                    ko.utils.arrayForEach(items[i].mappedNodes, function(node) {
                                        callback(node, i, items[i].arrayEntry);
                                    });
                                }
                            }
                        }
                    }
                    for (var i = 0, editScriptItem, movedIndex; editScriptItem = editScript[i]; i++) {
                        movedIndex = editScriptItem["moved"];
                        switch (editScriptItem["status"]) {
                          case "deleted":
                            if (movedIndex === undefined) {
                                mapData = lastMappingResult[lastMappingResultIndex];
                                if (mapData.dependentObservable) mapData.dependentObservable.dispose();
                                nodesToDelete.push.apply(nodesToDelete, ko.utils.fixUpContinuousNodeArray(mapData.mappedNodes, domNode));
                                if (options["beforeRemove"]) {
                                    itemsForBeforeRemoveCallbacks[i] = mapData;
                                    itemsToProcess.push(mapData);
                                }
                            }
                            lastMappingResultIndex++;
                            break;

                          case "retained":
                            itemMovedOrRetained(i, lastMappingResultIndex++);
                            break;

                          case "added":
                            if (movedIndex !== undefined) {
                                itemMovedOrRetained(i, movedIndex);
                            } else {
                                mapData = {
                                    arrayEntry: editScriptItem["value"],
                                    indexObservable: ko.observable(newMappingResultIndex++)
                                };
                                newMappingResult.push(mapData);
                                itemsToProcess.push(mapData);
                                if (!isFirstExecution) itemsForAfterAddCallbacks[i] = mapData;
                            }
                            break;
                        }
                    }
                    callCallback(options["beforeMove"], itemsForMoveCallbacks);
                    ko.utils.arrayForEach(nodesToDelete, options["beforeRemove"] ? ko.cleanNode : ko.removeNode);
                    for (var i = 0, nextNode = ko.virtualElements.firstChild(domNode), lastNode, node; mapData = itemsToProcess[i]; i++) {
                        if (!mapData.mappedNodes) ko.utils.extend(mapData, mapNodeAndRefreshWhenChanged(domNode, mapping, mapData.arrayEntry, callbackAfterAddingNodes, mapData.indexObservable));
                        for (var j = 0; node = mapData.mappedNodes[j]; nextNode = node.nextSibling, lastNode = node, 
                        j++) {
                            if (node !== nextNode) ko.virtualElements.insertAfter(domNode, node, lastNode);
                        }
                        if (!mapData.initialized && callbackAfterAddingNodes) {
                            callbackAfterAddingNodes(mapData.arrayEntry, mapData.mappedNodes, mapData.indexObservable);
                            mapData.initialized = true;
                        }
                    }
                    callCallback(options["beforeRemove"], itemsForBeforeRemoveCallbacks);
                    callCallback(options["afterMove"], itemsForMoveCallbacks);
                    callCallback(options["afterAdd"], itemsForAfterAddCallbacks);
                    ko.utils.domData.set(domNode, lastMappingResultDomDataKey, newMappingResult);
                };
            })();
            ko.exportSymbol("utils.setDomNodeChildrenFromArrayMapping", ko.utils.setDomNodeChildrenFromArrayMapping);
            ko.nativeTemplateEngine = function() {
                this["allowTemplateRewriting"] = false;
            };
            ko.nativeTemplateEngine.prototype = new ko.templateEngine();
            ko.nativeTemplateEngine.prototype.constructor = ko.nativeTemplateEngine;
            ko.nativeTemplateEngine.prototype["renderTemplateSource"] = function(templateSource, bindingContext, options) {
                var useNodesIfAvailable = !(ko.utils.ieVersion < 9), templateNodesFunc = useNodesIfAvailable ? templateSource["nodes"] : null, templateNodes = templateNodesFunc ? templateSource["nodes"]() : null;
                if (templateNodes) {
                    return ko.utils.makeArray(templateNodes.cloneNode(true).childNodes);
                } else {
                    var templateText = templateSource["text"]();
                    return ko.utils.parseHtmlFragment(templateText);
                }
            };
            ko.nativeTemplateEngine.instance = new ko.nativeTemplateEngine();
            ko.setTemplateEngine(ko.nativeTemplateEngine.instance);
            ko.exportSymbol("nativeTemplateEngine", ko.nativeTemplateEngine);
            (function() {
                ko.jqueryTmplTemplateEngine = function() {
                    var jQueryTmplVersion = this.jQueryTmplVersion = function() {
                        if (!jQuery || !jQuery["tmpl"]) return 0;
                        try {
                            if (jQuery["tmpl"]["tag"]["tmpl"]["open"].toString().indexOf("__") >= 0) {
                                return 2;
                            }
                        } catch (ex) {}
                        return 1;
                    }();
                    function ensureHasReferencedJQueryTemplates() {
                        if (jQueryTmplVersion < 2) throw new Error("Your version of jQuery.tmpl is too old. Please upgrade to jQuery.tmpl 1.0.0pre or later.");
                    }
                    function executeTemplate(compiledTemplate, data, jQueryTemplateOptions) {
                        return jQuery["tmpl"](compiledTemplate, data, jQueryTemplateOptions);
                    }
                    this["renderTemplateSource"] = function(templateSource, bindingContext, options) {
                        options = options || {};
                        ensureHasReferencedJQueryTemplates();
                        var precompiled = templateSource["data"]("precompiled");
                        if (!precompiled) {
                            var templateText = templateSource["text"]() || "";
                            templateText = "{{ko_with $item.koBindingContext}}" + templateText + "{{/ko_with}}";
                            precompiled = jQuery["template"](null, templateText);
                            templateSource["data"]("precompiled", precompiled);
                        }
                        var data = [ bindingContext["$data"] ];
                        var jQueryTemplateOptions = jQuery["extend"]({
                            koBindingContext: bindingContext
                        }, options["templateOptions"]);
                        var resultNodes = executeTemplate(precompiled, data, jQueryTemplateOptions);
                        resultNodes["appendTo"](document.createElement("div"));
                        jQuery["fragments"] = {};
                        return resultNodes;
                    };
                    this["createJavaScriptEvaluatorBlock"] = function(script) {
                        return "{{ko_code ((function() { return " + script + " })()) }}";
                    };
                    this["addTemplate"] = function(templateName, templateMarkup) {
                        document.write("<script type='text/html' id='" + templateName + "'>" + templateMarkup + "<" + "/script>");
                    };
                    if (jQueryTmplVersion > 0) {
                        jQuery["tmpl"]["tag"]["ko_code"] = {
                            open: "__.push($1 || '');"
                        };
                        jQuery["tmpl"]["tag"]["ko_with"] = {
                            open: "with($1) {",
                            close: "} "
                        };
                    }
                };
                ko.jqueryTmplTemplateEngine.prototype = new ko.templateEngine();
                ko.jqueryTmplTemplateEngine.prototype.constructor = ko.jqueryTmplTemplateEngine;
                var jqueryTmplTemplateEngineInstance = new ko.jqueryTmplTemplateEngine();
                if (jqueryTmplTemplateEngineInstance.jQueryTmplVersion > 0) ko.setTemplateEngine(jqueryTmplTemplateEngineInstance);
                ko.exportSymbol("jqueryTmplTemplateEngine", ko.jqueryTmplTemplateEngine);
            })();
        });
    })();
})();

define("3rdparty/queue", function() {
    queue.version = "1.0.1";
    function queue(parallelism) {
        var queue = {}, active = 0, remaining = 0, head, tail, error = null, results = [], await = noop, awaitAll;
        if (arguments.length < 1) parallelism = Infinity;
        queue.defer = function() {
            if (!error) {
                var node = arguments;
                node.index = results.push(undefined) - 1;
                if (tail) tail.next = node, tail = tail.next; else head = tail = node;
                ++remaining;
                pop();
            }
            return queue;
        };
        queue.await = function(f) {
            await = f;
            awaitAll = false;
            if (!remaining) notify();
            return queue;
        };
        queue.awaitAll = function(f) {
            await = f;
            awaitAll = true;
            if (!remaining) notify();
            return queue;
        };
        function pop() {
            if (head && active < parallelism) {
                var node = head, f = node[0], a = Array.prototype.slice.call(node, 1), i = node.index;
                if (head === tail) head = tail = null; else head = head.next;
                ++active;
                a.push(function(e, r) {
                    --active;
                    if (error != null) return;
                    if (e != null) {
                        error = e;
                        remaining = results = head = tail = null;
                        notify();
                    } else {
                        results[i] = r;
                        if (--remaining) pop(); else notify();
                    }
                });
                f.apply(null, a);
            }
        }
        function notify() {
            if (error != null) await(error); else if (awaitAll) await(null, results); else await.apply(null, [ null ].concat(results));
        }
        return queue;
    }
    function noop() {}
    return queue;
});

define("common/util", [], function() {
    var util = {};
    util.escapeRegExp = function(str) {
        return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
    };
    util.htmlEncode = function(text) {
        return text.replace(/[&<>"'`]/g, function(chr) {
            return "&#" + chr.charCodeAt(0) + ";";
        });
    };
    util.leftPad = function(str, length, padChar) {
        str = String(str);
        while (str.length < length) {
            str = (padChar || " ") + str;
        }
        return str;
    };
    util.trimArray = function(arr, trimEmptyStringsToo) {
        return arr.filter(function(item) {
            return item !== undefined && (!trimEmptyStringsToo || item !== "");
        });
    };
    util.arrayRemove = function(arr, elementsToRemove) {
        return arr.filter(function(element) {
            return elementsToRemove.indexOf(element) < 0;
        });
    };
    util.getUniqueName = function(list, name) {
        var clashes = list.map(function(item) {
            var m = 0;
            if (item === name) {
                return 0;
            } else {
                m = /(.*)(?:-(\d+))/.exec(item);
                if (m && m[1] === name) {
                    return m[2];
                } else {
                    return -1;
                }
            }
        }), num = -1;
        if (clashes.length !== 0) {
            num = Math.max.apply(null, clashes);
            if (num !== -1) {
                return name + "-" + (num + 1);
            }
        }
        return name;
    };
    util.contains = function(text, query, ignoreCase) {
        if (!text) {
            return false;
        }
        if (query && ignoreCase) {
            text = text.toLowerCase();
            query = query.toLowerCase();
        }
        return text.indexOf(query) !== -1;
    };
    util.updateApplicationCache = function(cb) {
        var callbackCalled = false;
        function reportToCb(err, updateReady) {
            if (!callbackCalled) {
                callbackCalled = true;
                setTimeout(function() {
                    cb(err, updateReady);
                }, 0);
            }
        }
        if (window.applicationCache && applicationCache.status > applicationCache.UNCACHED) {
            if (applicationCache.status === applicationCache.UPDATEREADY) {
                applicationCache.swapCache();
                reportToCb(null, true);
            } else {
                var eventNames = [ "updateready", "noupdate", "error", "obsolete", "cached" ], eventHandler = function(e) {
                    eventNames.forEach(function(eventName) {
                        applicationCache.removeEventListener(eventName, eventHandler);
                    });
                    if (e.type === "updateready") {
                        applicationCache.swapCache();
                        reportToCb(null, true);
                    } else {
                        reportToCb(null, false);
                    }
                };
                eventNames.forEach(function(eventName) {
                    applicationCache.addEventListener(eventName, eventHandler, false);
                });
                if (applicationCache.status !== applicationCache.OBSOLETE && applicationCache.status !== applicationCache.IDLE && applicationCache.status !== applicationCache.CHECKING && applicationCache.status !== applicationCache.DOWNLOADING) {
                    applicationCache.update();
                } else {
                    reportToCb(null, false);
                }
            }
        } else {
            reportToCb(null, false);
        }
    };
    util.entries = function(dictionary) {
        return Object.keys(dictionary).map(function(key) {
            return {
                key: key,
                value: dictionary[key]
            };
        });
    };
    util.unique = function(list, selector) {
        var seen = {};
        return list.filter(function(value) {
            var key = selector ? selector(value) : value;
            if (seen[key]) {
                return false;
            } else {
                seen[key] = true;
                return true;
            }
        });
    };
    util.decodePairs = function(text) {
        var entries = text.split("&");
        var result = {};
        entries.forEach(function(entry) {
            var pair = entry.split("=");
            result[decodeURIComponent(pair[0])] = decodeURIComponent(pair[1]);
        });
        return result;
    };
    util.encodePairs = function(hash) {
        return util.entries(hash).map(function(entry) {
            return encodeURIComponent(entry.key) + "=" + encodeURIComponent(entry.value);
        }).join("&");
    };
    util.createUrlQueryPart = function(hash) {
        return Object.keys(hash).length ? "?" + util.encodePairs(hash) : "";
    };
    util.getQueryParameters = function() {
        var query = window.location.search.substring(1);
        return util.decodePairs(query);
    };
    util.bySortKeyComparator = function(a, b) {
        var aSortKey = a.sortKey(), bSortKey = b.sortKey();
        return !aSortKey ? !bSortKey ? 0 : 1 : !bSortKey ? -1 : aSortKey < bSortKey ? -1 : aSortKey > bSortKey ? 1 : 0;
    };
    var CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("");
    util.uuid = function(len, radix) {
        var chars = CHARS, uuid = [], i, r;
        radix = radix || chars.length;
        if (len) {
            for (i = 0; i < len; i += 1) {
                uuid[i] = chars[0 | Math.random() * radix];
            }
        } else {
            uuid[8] = uuid[13] = uuid[18] = uuid[23] = "-";
            uuid[14] = "4";
            for (i = 0; i < 36; i += 1) {
                if (!uuid[i]) {
                    r = 0 | Math.random() * 16;
                    uuid[i] = chars[i === 19 ? r & 3 | 8 : r];
                }
            }
        }
        return uuid.join("");
    };
    util.byFileComparator = function(obj1, obj2) {
        if (obj1.justAdded !== obj2.justAdded) {
            return obj1.justAdded ? 1 : -1;
        }
        if (obj1.displayName > obj2.displayName) {
            return 1;
        }
        if (obj1.displayName < obj2.displayName) {
            return -1;
        }
        if (obj1.size > obj2.size) {
            return -1;
        }
        if (obj1.size < obj2.size) {
            return 1;
        }
        return 0;
    };
    util.attachmentDisplaySize = function(size) {
        if (size < 1024) {
            return "<1 KB";
        } else if (size < 1048576) {
            return inter.renderFileSize(size);
        } else {
            return inter.renderFileSize(size, 1);
        }
    };
    util.getMailsByUid = function(mails, uids) {
        return mails.filter(function(mail) {
            return uids.some(function(uid) {
                return mail.uid === uid;
            });
        });
    };
    return util;
});

define("3rdparty/passError", function() {
    return function passError(errorCallback, successCallback) {
        return function(err) {
            if (err) {
                errorCallback(err);
            } else if (successCallback) {
                successCallback.apply(this, [].slice.call(arguments, 1));
            }
        };
    };
});

define("mario", function() {
    var t = true;
    function mario(ua) {
        function getFirstMatch(regexp) {
            var match = ua.match(regexp);
            return match && match[1];
        }
        var chrome = /chrome/i.test(ua);
        var firefox = /firefox/i.test(ua);
        var seamonkey = /seamonkey\//i.test(ua);
        var opera = /opera/i.test(ua);
        var operaBlink = /OPR/.test(ua);
        var safari = /safari/i.test(ua);
        var ie = /msie/i.test(ua);
        var trident = /trident/i.test(ua);
        var phantom = /phantom/i.test(ua);
        var touchpad = /touchpad/i.test(ua);
        var touch = /touch/i.test(ua);
        var iphone = /\(iphone;/i.test(ua);
        var ipad = /\(ipad;/i.test(ua);
        var ipod = /\(ipod( touch)?;/i.test(ua);
        var crios = /crios\//i.test(ua);
        var android = /android/i.test(ua);
        var windowsPhone = /Windows Phone/i.test(ua);
        var gecko = /gecko\//i.test(ua);
        var likeGecko = /like gecko/i.test(ua);
        var webkit = /webkit/i.test(ua);
        var detected = {};
        if (ie) {
            detected.msie = t;
            detected.version = getFirstMatch(/msie (\d+(\.\d+)?);/i);
        } else if (operaBlink) {
            detected.opera = t;
            detected.version = getFirstMatch(/OPR\/(\d+(\.\d+)?)/i);
        } else if (chrome) {
            detected.chrome = t;
            detected.version = getFirstMatch(/chrome\/(\d+(\.\d+)?)/i);
        } else if (firefox) {
            detected.firefox = t;
            detected.version = getFirstMatch(/firefox\/(\d+(\.\d+)?)/i);
        } else if (phantom) {
            detected.phantom = t;
            detected.version = getFirstMatch(/phantomjs\/(\d+(\.\d+)+)/i);
        } else if (seamonkey) {
            detected.seamonkey = t;
            detected.version = getFirstMatch(/seamonkey\/(\d+(\.\d+)?)/i);
        } else if (opera) {
            detected.opera = t;
            detected.version = getFirstMatch(/version\/(\d+(\.\d+)?)/i);
        } else if (safari && !android) {
            detected.safari = t;
            detected.version = getFirstMatch(/version\/(\d+(\.\d+)?)/i);
        } else {
            if (ipad || iphone || ipod) {
                detected.safari = t;
                detected.webkit = t;
            } else if (android) {
                detected.webkit = t;
                detected.version = getFirstMatch(/version\/(\d+(\.\d+)?)/i);
            }
        }
        if (!detected.version) {
            delete detected.version;
        }
        if (touch) {
            detected.touch = t;
        }
        if (windowsPhone) {
            detected.touch = t;
        }
        if (ipad || iphone || ipod) {
            detected.touch = t;
            detected.ios = t;
            if (!detected.version && crios) {
                delete detected.safari;
                detected.chrome = t;
                detected.version = getFirstMatch(/crios\/(\d+(\.\d+)?)/i);
            }
            var osVersion = getFirstMatch(/os (\d+([_\s]\d+)*) like mac os x/i);
            if (osVersion) {
                detected.osversion = osVersion.replace(/[_\s]/g, ".");
            }
        }
        if (ipad) {
            detected.ipad = t;
        }
        if (iphone) {
            detected.iphone = t;
        }
        if (ipod) {
            detected.ipod = t;
        }
        if (gecko) {
            detected.mozilla = t;
            detected.gecko = t;
        }
        if (likeGecko) {
            if (trident) {
                detected.msie = t;
                detected.version = getFirstMatch(/rv:(\d+(?:\.\d+))/i);
            }
        }
        if (android) {
            detected.touch = t;
            detected.android = t;
            var androidVersion = getFirstMatch(/android[ \/](\d+(\.\d+)*)/i);
            if (androidVersion) {
                detected.osversion = androidVersion;
            }
        }
        if (operaBlink || chrome && detected.version >= 28 || android && detected.osversion >= 4.4) {
            detected.blink = t;
        }
        if (!detected.blink && webkit) {
            detected.webkit = t;
        }
        return detected;
    }
    if (typeof navigator !== "undefined" && navigator && typeof navigator.userAgent === "string") {
        var detected = mario(navigator.userAgent);
        for (var propertyName in detected) {
            if (detected.hasOwnProperty(propertyName)) {
                mario[propertyName] = detected[propertyName];
            }
        }
    }
    return mario;
});

define("common/TraceLogging", [ "knockout" ], function(ko) {
    function wrapFunction(name, target, property) {
        var original = target[property];
        return function() {
            one.crashLogger.log("calling: " + name + "." + property);
            return original.apply(this, arguments);
        };
    }
    function getName(Constructor) {
        var regex = /function\s+(.+)\s*\(/;
        return regex.exec(Constructor.toString())[1];
    }
    var TraceLogging = {
        injectTracing: function(Constructor) {
            var name = Constructor.name || getName(Constructor);
            var target = Constructor.prototype;
            if (!target._tracingInjected) {
                Object.getOwnPropertyNames(target).filter(function(property) {
                    return typeof target[property] === "function" && !ko.isObservable(target[property]);
                }).forEach(function(property) {
                    target[property] = wrapFunction(name, target, property);
                });
                target._tracingInjected = true;
            }
            return target;
        }
    };
    return TraceLogging;
});

define("common/Version", [ "knockout" ], function(ko) {
    function Version() {
        var that = this;
        that.clientVersion = ko.observable("");
        that.serverVersion = ko.observable("");
        var dataVersionAttributeValue = document.documentElement && document.documentElement.getAttribute("data-version");
        if (dataVersionAttributeValue) {
            var version = dataVersionAttributeValue.match(/(?:\d+\.?)+/);
            if (version) {
                that.clientVersion(version[0]);
            }
            that.serverVersion(that.clientVersion());
        }
        function segmentVersionNumber(version) {
            var segments = version.match(/^(\d+)\.(\d+)\.(\d+)$/);
            if (segments) {
                return {
                    major: parseInt(segments[1], 10),
                    minor: parseInt(segments[2], 10),
                    patch: parseInt(segments[3], 10)
                };
            }
        }
        that.updatePriority = ko.computed(function() {
            var client = segmentVersionNumber(that.clientVersion()), server = segmentVersionNumber(that.serverVersion());
            if (server && client) {
                if (client.major > server.major || client.major === server.major && client.minor > server.minor || client.major === server.major && client.minor === server.minor && client.patch > server.patch) {
                    return -2;
                } else if (server.major > client.major) {
                    return 3;
                } else if (server.minor > client.minor) {
                    return 2;
                } else if (server.patch > client.patch) {
                    return 1;
                } else {
                    return 0;
                }
            } else {
                return -1;
            }
        });
    }
    return new Version();
});

define("one-validation", function() {
    "use strict";
    function concatRegExps() {
        var source = "", i = 0;
        for (;i < arguments.length; i += 1) {
            if (Object.prototype.toString.call(arguments[i]) === "[object RegExp]") {
                source += arguments[i].source;
            } else {
                source += arguments[i];
            }
        }
        return source;
    }
    var ipv4DigitRegExpSource = /(?:[0-9]|1?[0-9][0-9]|2[0-4][0-9]|25[0-5])/.source, validation = {
        functions: {}
    }, fragments = {
        visibleNonAsciiChar: /[ªµºÀ-ÖØ-öø-ˁˆ-ˑˠ-ˤˬˮͰ-ʹͶͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁҊ-ԥԱ-Ֆՙա-ևא-תװ-ײء-يٮٯٱ-ۓەۥۦۮۯۺ-ۼۿܐܒ-ܯݍ-ޥޱߊ-ߪߴߵߺࠀ-ࠕࠚࠤࠨऄ-हऽॐक़-ॡॱॲॹ-ॿঅ-ঌএঐও-নপ-রলশ-হঽৎড়ঢ়য়-ৡৰৱਅ-ਊਏਐਓ-ਨਪ-ਰਲਲ਼ਵਸ਼ਸਹਖ਼-ੜਫ਼ੲ-ੴઅ-ઍએ-ઑઓ-નપ-રલળવ-હઽૐૠૡଅ-ଌଏଐଓ-ନପ-ରଲଳଵ-ହଽଡ଼ଢ଼ୟ-ୡୱஃஅ-ஊஎ-ஐஒ-கஙசஜஞடணதந-பம-ஹௐఅ-ఌఎ-ఐఒ-నప-ళవ-హఽౘౙౠౡಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽೞೠೡഅ-ഌഎ-ഐഒ-നപ-ഹഽൠൡൺ-ൿඅ-ඖක-නඳ-රලව-ෆก-ะาำเ-ๆກຂຄງຈຊຍດ-ທນ-ຟມ-ຣລວສຫອ-ະາຳຽເ-ໄໆໜໝༀཀ-ཇཉ-ཬྈ-ྋက-ဪဿၐ-ၕၚ-ၝၡၥၦၮ-ၰၵ-ႁႎႠ-Ⴥა-ჺჼᄀ-ቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚᎀ-ᎏᎠ-Ᏼᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᜀ-ᜌᜎ-ᜑᜠ-ᜱᝀ-ᝑᝠ-ᝬᝮ-ᝰក-ឳៗៜᠠ-ᡷᢀ-ᢨᢪᢰ-ᣵᤀ-ᤜᥐ-ᥭᥰ-ᥴᦀ-ᦫᧁ-ᧇᨀ-ᨖᨠ-ᩔᪧᬅ-ᬳᭅ-ᭋᮃ-ᮠᮮᮯᰀ-ᰣᱍ-ᱏᱚ-ᱽᳩ-ᳬᳮ-ᳱᴀ-ᶿḀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼⁱⁿₐ-ₔℂℇℊ-ℓℕℙ-ℝℤΩℨK-ℭℯ-ℹℼ-ℿⅅ-ⅉⅎↃↄⰀ-Ⱞⰰ-ⱞⱠ-ⳤⳫ-ⳮⴀ-ⴥⴰ-ⵥⵯⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞⸯ々〆〱-〵〻〼ぁ-ゖゝ-ゟァ-ヺー-ヿㄅ-ㄭㄱ-ㆎㆠ-ㆷㇰ-ㇿ㐀-䶵一-鿋ꀀ-ꒌꓐ-ꓽꔀ-ꘌꘐ-ꘟꘪꘫꙀ-ꙟꙢ-ꙮꙿ-ꚗꚠ-ꛥꜗ-ꜟꜢ-ꞈꞋꞌꟻ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠢꡀ-ꡳꢂ-ꢳꣲ-ꣷꣻꤊ-ꤥꤰ-ꥆꥠ-ꥼꦄ-ꦲꧏꨀ-ꨨꩀ-ꩂꩄ-ꩋꩠ-ꩶꩺꪀ-ꪯꪱꪵꪶꪹ-ꪽꫀꫂꫛ-ꫝꯀ-ꯢ가-힣ힰ-ퟆퟋ-ퟻ豈-鶴侮-舘並-龎ﬀ-ﬆﬓ-ﬗיִײַ-ﬨשׁ-זּטּ-לּמּנּסּףּפּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼＡ-Ｚａ-ｚｦ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ̀-ͯ҃-҉֑-ׇֽֿׁׂׅׄؐ-ًؚ-ٰٞۖ-ۜ۞-۪ۤۧۨ-ܑۭܰ-݊ަ-ް߫-߳ࠖ-࠙ࠛ-ࠣࠥ-ࠧࠩ-࠭ऀ-ः़ा-ॎ॑-ॕॢॣঁ-ঃ়া-ৄেৈো-্ৗৢৣਁ-ਃ਼ਾ-ੂੇੈੋ-੍ੑੰੱੵઁ-ઃ઼ા-ૅે-ૉો-્ૢૣଁ-ଃ଼ା-ୄେୈୋ-୍ୖୗୢୣஂா-ூெ-ைொ-்ௗఁ-ఃా-ౄె-ైొ-్ౕౖౢౣಂಃ಼ಾ-ೄೆ-ೈೊ-್ೕೖೢೣംഃാ-ൄെ-ൈൊ-്ൗൢൣංඃ්ා-ුූෘ-ෟෲෳัิ-ฺ็-๎ັິ-ູົຼ່-ໍ༹༘༙༵༷༾༿ཱ-྄྆྇ྐ-ྗྙ-ྼ࿆ါ-ှၖ-ၙၞ-ၠၢ-ၤၧ-ၭၱ-ၴႂ-ႍႏႚ-ႝ፟ᜒ-᜔ᜲ-᜴ᝒᝓᝲᝳា-៓៝᠋-᠍ᢩᤠ-ᤫᤰ-᤻ᦰ-ᧀᧈᧉᨗ-ᨛᩕ-ᩞ᩠-᩿᩼ᬀ-ᬄ᬴-᭄᭫-᭳ᮀ-ᮂᮡ-᮪ᰤ-᰷᳐-᳔᳒-᳨᳭ᳲ᷀-᷽ᷦ-᷿⃐-⃰⳯-⳱ⷠ-〪ⷿ-゙゚〯꙯-꙲꙼꙽꛰꛱ꠂ꠆ꠋꠣ-ꠧꢀꢁꢴ-꣄꣠-꣱ꤦ-꤭ꥇ-꥓ꦀ-ꦃ꦳-꧀ꨩ-ꨶꩃꩌꩍꩻꪰꪲ-ꪴꪷꪸꪾ꪿꫁ꯣ-ꯪ꯬꯭ﬞ︀-️︠-︦²³¹¼-¾٠-٩۰-۹߀-߉०-९০-৯৴-৹੦-੯૦-૯୦-୯௦-௲౦-౯౸-౾೦-೯൦-൵๐-๙໐-໙༠-༳၀-၉႐-႙፩-፼ᛮ-ᛰ០-៩៰-៹᠐-᠙᥆-᥏᧐-᧚᪀-᪉᪐-᪙᭐-᭙᮰-᮹᱀-᱉᱐-᱙⁰⁴-⁹₀-₉⅐-ↂↅ-↉①-⒛⓪-⓿❶-➓⳽〇〡-〩〸-〺㆒-㆕㈠-㈩㉑-㉟㊀-㊉㊱-㊿꘠-꘩ꛦ-ꛯ꠰-꠵꣐-꣙꤀-꤉꧐-꧙꩐-꩙꯰-꯹０-９¡«·»¿;·՚-՟։֊־׀׃׆׳״؉؊،؍؛؞؟٪-٭۔܀-܍߷-߹࠰-࠾।॥॰෴๏๚๛༄-༒༺-༽྅࿐-࿔၊-၏჻፡-፨᐀᙭᙮᚛᚜᛫-᛭᜵᜶។-៖៘-៚᠀-᠊᥄᥅᧞᧟᨞᨟᪠-᪦᪨-᪭᭚-᭠᰻-᰿᱾᱿᳓‐-‧‰-⁃⁅-⁑⁓-⁞⁽⁾₍₎〈〉❨-❵⟅⟆⟦-⟯⦃-⦘⧘-⧛⧼⧽⳹-⳼⳾⳿⸀-⸮⸰⸱、-〃〈-】〔-〟〰〽゠・꓾꓿꘍-꘏꙳꙾꛲-꛷꡴-꡷꣎꣏꣸-꣺꤮꤯꥟꧁-꧍꧞꧟꩜-꩟꫞꫟꯫﴾﴿︐-︙︰-﹒﹔-﹡﹣﹨﹪﹫！-＃％-＊，-／：；？＠［-］＿｛｝｟-･¢-©¬®-±´¶¸×÷˂-˅˒-˟˥-˫˭˯-˿͵΄΅϶҂؆-؈؋؎؏۩۽۾߶৲৳৺৻૱୰௳-௺౿ೱೲ൹฿༁-༃༓-༗༚-༟༴༶༸྾-࿅࿇-࿌࿎࿏࿕-࿘႞႟፠᎐-᎙៛᥀᧠-᧿᭡-᭪᭴-᭼᾽᾿-῁῍-῏῝-῟῭-`´῾⁄⁒⁺-⁼₊-₌₠-₸℀℁℃-℆℈℉℔№-℘℞-℣℥℧℩℮℺℻⅀-⅄⅊-⅍⅏←-⌨⌫-⏨␀-␦⑀-⑊⒜-ⓩ─-⛍⛏-⛡⛣⛨-⛿✁-✄✆-✉✌-✧✩-❋❍❏-❒❖-❞❡-❧➔➘-➯➱-➾⟀-⟄⟇-⟊⟌⟐-⟥⟰-⦂⦙-⧗⧜-⧻⧾-⭌⭐-⭙⳥-⳪⺀-⺙⺛-⻳⼀-⿕⿰-⿻〄〒〓〠〶〷〾〿゛゜㆐㆑㆖-㆟㇀-㇣㈀-㈞㈪-㉐㉠-㉿㊊-㊰㋀-㋾㌀-㏿䷀-䷿꒐-꓆꜀-꜖꜠꜡꞉꞊꠨-꠫꠶-꠹꩷-꩹﬩﷼﷽﹢﹤-﹦﹩＄＋＜-＞＾｀｜～￠-￦￨-￮￼�]/,
        domainPart: /[a-z0-9](?:[\-a-z0-9]*[a-z0-9])?/i,
        domainPartNonNumerical: /[a-z](?:[\-a-z]*[a-z])?/i,
        port: /\d{1,5}/,
        localpart: /[a-z0-9!#$%&'*+\/=?\^_`{|}~\-:][\.a-z0-9!#$%&'*+\/=?\^_`{|}~\-]*/i,
        user: /[^:@\/]+/i,
        uuid: /[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/i,
        lowerCaseUuid: /[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/,
        upperCaseUuid: /[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}/,
        password: /[^@\/]+?/i,
        pathname: /[\w\-\.~%!$&'\(\)*+,;=:@\/]*/,
        search: /[\w\-\.~%!$&'\(\)*+,;=:@\/?]*/,
        hash: /[\w\-\.~%!$&'\(\)*+,;=:@\/?#]*/,
        ipv4: new RegExp("(?:" + ipv4DigitRegExpSource + "\\.){3}" + ipv4DigitRegExpSource)
    }, name;
    var alphanumericalPlusVisibleNonAsciiChars = new RegExp(fragments.visibleNonAsciiChar.source.replace(/^\[/, "[a-z0-9")), alphabeticalPlusVisibleNonAsciiChars = new RegExp(fragments.visibleNonAsciiChar.source.replace(/^\[/, "[a-z"));
    fragments.domainPartIdn = new RegExp(concatRegExps(alphanumericalPlusVisibleNonAsciiChars, "(?:", new RegExp(alphanumericalPlusVisibleNonAsciiChars.source.replace(/^\[/, "[\\-") + "*"), alphanumericalPlusVisibleNonAsciiChars, ")?"));
    fragments.domainPartNonNumericalIdn = new RegExp(concatRegExps(alphabeticalPlusVisibleNonAsciiChars, "(?:", new RegExp(alphabeticalPlusVisibleNonAsciiChars.source.replace(/^\[/, "[\\-") + "*"), alphabeticalPlusVisibleNonAsciiChars, ")?"));
    fragments.domain = fragments.domainName = new RegExp("(?:" + fragments.domainPart.source + "\\.)+" + fragments.domainPartNonNumerical.source, "i");
    fragments.domainIdn = fragments.domainNameIdn = new RegExp("(?:" + fragments.domainPartIdn.source + "\\.)+" + fragments.domainPartNonNumericalIdn.source, "i");
    fragments.email = fragments.emailAddress = new RegExp(fragments.localpart.source + "@" + fragments.domain.source, "i");
    fragments.emailIdn = fragments.emailAddressIdn = new RegExp(fragments.localpart.source + "@" + fragments.domainIdn.source, "i");
    fragments.mailtoUrl = new RegExp("mailto:" + fragments.email.source, "i");
    fragments.mailtoUrlIdn = new RegExp("mailto:" + fragments.emailIdn.source, "i");
    fragments.pathnameSearchHash = new RegExp(concatRegExps("(?:/", fragments.pathname, "(?:\\?", fragments.search, ")?", "(?:#", fragments.hash, ")?", ")?"));
    function createHttpishUrlRegExp(options) {
        options = options || {};
        return new RegExp(concatRegExps(options.scheme || "https?", "://", "(?:", fragments.user, "(?::", fragments.password, ")?@", ")?", "(?:", options.localhost ? "localhost|" : "", options.idn ? fragments.domainIdn : fragments.domain, "|", fragments.ipv4, ")", "(?::", fragments.port, ")?", fragments.pathnameSearchHash), "i");
    }
    fragments.httpUrl = createHttpishUrlRegExp({
        scheme: /https?/
    });
    fragments.httpUrlIdn = createHttpishUrlRegExp({
        scheme: /https?/,
        idn: true
    });
    fragments.ftpUrl = createHttpishUrlRegExp({
        scheme: /ftp/
    });
    fragments.ftpUrlIdn = createHttpishUrlRegExp({
        scheme: /ftp/,
        idn: true
    });
    function getFlagsStringFromRegExp(regExp) {
        var flagsString = "";
        if (regExp.ignoreCase) {
            flagsString += "i";
        }
        if (regExp.global) {
            flagsString += "g";
        }
        if (regExp.multiline) {
            flagsString += "m";
        }
        return flagsString;
    }
    for (name in fragments) {
        if (fragments.hasOwnProperty(name)) {
            validation[name] = new RegExp("^" + fragments[name].source + "$", getFlagsStringFromRegExp(fragments[name]));
            validation.functions[name] = function(name) {
                return function(value) {
                    return validation[name].test(value);
                };
            }(name);
        }
    }
    validation.fragments = fragments;
    validation.createHttpishUrlRegExp = createHttpishUrlRegExp;
    return validation;
});

(function($) {
    $.cookie = function(key, value, options) {
        if (arguments.length > 1 && (!/Object/.test(Object.prototype.toString.call(value)) || value === null || value === undefined)) {
            options = $.extend({}, options);
            if (value === null || value === undefined) {
                options.expires = -1;
            }
            if (typeof options.expires === "number") {
                var days = options.expires, t = options.expires = new Date();
                t.setDate(t.getDate() + days);
            }
            value = String(value);
            return document.cookie = [ encodeURIComponent(key), "=", options.raw ? value : encodeURIComponent(value), options.expires ? "; expires=" + options.expires.toUTCString() : "", options.path ? "; path=" + options.path : "", options.domain ? "; domain=" + options.domain : "", options.secure ? "; secure" : "" ].join("");
        }
        options = value || {};
        var decode = options.raw ? function(s) {
            return s;
        } : decodeURIComponent;
        var pairs = document.cookie.split("; ");
        for (var i = 0, pair; pair = pairs[i] && pairs[i].split("="); i++) {
            if (decode(pair[0]) === key) return decode(pair[1] || "");
        }
        return null;
    };
})(jQuery);

define("3rdparty/jquery.cookie", function() {
    return $.cookie;
});

define("common/Backend", [ "jquery", "knockout", "3rdparty/queue", "common/util", "3rdparty/passError", "mario", "common/TraceLogging", "common/Version", "one-validation", "3rdparty/jquery.cookie" ], function($, ko, queue, util, passError, mario, TraceLogging, Version, validation) {
    one.version = Version;
    function createError(xhr) {
        var response = null;
        try {
            response = JSON.parse(xhr.responseText);
        } catch (e) {
            response = {};
        }
        return {
            status: xhr.status,
            statusText: xhr.statusText,
            response: response,
            responseText: xhr.responseText
        };
    }
    function Backend() {
        var that = this;
        that.queue = queue();
    }
    Backend.prototype.reload = function() {
        window.location.reload(true);
    };
    function redirectTo(url, specifySelfAsSuccessUrl) {
        if (specifySelfAsSuccessUrl) {
            var hash = util.encodePairs({
                successUrl: window.location.href
            });
            url += "#" + hash;
        }
        window.location.replace(url);
    }
    Backend.prototype.createRequest = function(url, options, callback) {
        var that = this, cb = callback;
        if (typeof options === "function") {
            cb = options;
            options = {};
        }
        var hasSideEffects = options.type && options.type !== "GET" && options.type !== "HEAD";
        if (hasSideEffects) {
            that.numPendingOperationsWithSideEffects += 1;
        }
        return function(done) {
            options.url = url;
            options.headers = options.headers || {};
            if (Version.clientVersion()) {
                options.headers["x-one-version"] = Version.clientVersion();
            }
            options.success = function(data, status, xhr) {
                if (hasSideEffects) {
                    that.numPendingOperationsWithSideEffects -= 1;
                }
                var ver = xhr.getResponseHeader("x-one-version");
                if (ver) {
                    Version.serverVersion(ver);
                }
                if (cb) {
                    cb(null, data, status, xhr);
                }
                done();
            };
            options.error = function(xhr, status, error) {
                if (hasSideEffects) {
                    that.numPendingOperationsWithSideEffects -= 1;
                }
                var ver = xhr.getResponseHeader("x-one-version");
                if (ver) {
                    Version.serverVersion(ver);
                }
                cb(createError(xhr), null, status, xhr);
                done();
            };
            $.ajax(options);
        };
    };
    function getBasicParseErrorObject(message, body) {
        return {
            status: 500,
            statusText: message,
            response: null,
            responseText: body
        };
    }
    Backend.prototype.parseVarnishError = function(errorBody) {
        var err = getBasicParseErrorObject("Failed to parse Varnish error.", errorBody), errorCodeMatch = errorBody.match(/<h1>Error\s(\d+)\s([a-zA-Z ]+)/);
        if (errorCodeMatch) {
            err.status = parseInt(errorCodeMatch[1], 10);
            err.statusText = errorCodeMatch[2];
        }
        return err;
    };
    Backend.prototype.parseNginxError = function(errorBody) {
        var err = getBasicParseErrorObject("Failed to parse nginx error.", errorBody), errorCodeMatch = errorBody.match(/<h1>(\d+)\s([a-zA-Z ]+)/);
        if (errorCodeMatch) {
            err.status = parseInt(errorCodeMatch[1], 10);
            err.statusText = errorCodeMatch[2];
        }
        return err;
    };
    Backend.prototype.handleNonJSONError = function(errorBody, callback) {
        if (/<p>Varnish\scache\sserver<\/p>/.test(errorBody)) {
            callback(this.parseVarnishError(errorBody), null);
        } else if (/>nginx\//.test(errorBody)) {
            callback(this.parseNginxError(errorBody), null);
        } else {
            callback(getBasicParseErrorObject("Parse error", util.htmlEncode(errorBody)), null);
        }
    };
    Backend.prototype.ignoreBrowserCheck = function(value) {
        if (arguments.length === 0) {
            return $.cookie("ignoreBrowserCheck") === "true";
        } else {
            $.cookie("ignoreBrowserCheck", value, {
                path: "/",
                expires: 14
            });
        }
    };
    Backend.prototype.isUnsupportedBrowser = function() {
        return !window.JSON || mario.msie && mario.version < 8;
    };
    Backend.prototype.redirectIfUnsupportedBrowser = function() {
        if (!this.ignoreBrowserCheck() && this.isUnsupportedBrowser()) {
            var unsupportedPageUrl = /^\/mail(?:\.|$)/.test(window.location.pathname) ? "https://mail.one.com/unsupported" : "/unsupported";
            redirectTo(unsupportedPageUrl, true);
            return true;
        }
        return false;
    };
    TraceLogging.injectTracing(Backend);
    return Backend;
});

define("mail/Actions", [ "jquery", "knockout", "3rdparty/passError", "common/util", "3rdparty/queue" ], function($, ko, passError, util, queue) {
    function Actions(backend, errorHandler) {
        var that = this;
        that.switchLocale = function(localeId) {
            if (localeId !== "nb") {
                var cookieDomain = "." + location.hostname.split(".").splice(-2, 2).join(".");
                $.cookie("OneLang", localeId, {
                    expires: 365 * 2,
                    path: "/",
                    domain: cookieDomain
                });
                util.updateApplicationCache(function() {
                    document.location.reload(true);
                });
            }
        };
        Object.keys(that).forEach(function(key) {
            var property = that[key];
            if (typeof property === "function") {
                property.curry = function() {
                    var args = Array.prototype.slice.call(arguments);
                    args.unshift(that);
                    return property.bind.apply(property, args);
                };
                property.withArguments = function() {
                    var args = arguments;
                    return function() {
                        property.apply(that, args);
                    };
                };
            }
        });
    }
    return Actions;
});

(function(root) {
    var freeExports = typeof exports == "object" && exports && !exports.nodeType && exports;
    var freeModule = typeof module == "object" && module && !module.nodeType && module;
    var freeGlobal = typeof global == "object" && global;
    if (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal || freeGlobal.self === freeGlobal) {
        root = freeGlobal;
    }
    var punycode, maxInt = 2147483647, base = 36, tMin = 1, tMax = 26, skew = 38, damp = 700, initialBias = 72, initialN = 128, delimiter = "-", regexPunycode = /^xn--/, regexNonASCII = /[^\x20-\x7E]/, regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, errors = {
        overflow: "Overflow: input needs wider integers to process",
        "not-basic": "Illegal input >= 0x80 (not a basic code point)",
        "invalid-input": "Invalid input"
    }, baseMinusTMin = base - tMin, floor = Math.floor, stringFromCharCode = String.fromCharCode, key;
    function error(type) {
        throw RangeError(errors[type]);
    }
    function map(array, fn) {
        var length = array.length;
        var result = [];
        while (length--) {
            result[length] = fn(array[length]);
        }
        return result;
    }
    function mapDomain(string, fn) {
        var labels = string.split(regexSeparators);
        return map(labels, function(label) {
            var parts = label.split("@");
            return map(parts, fn).join("@");
        }).join(".");
    }
    function ucs2decode(string) {
        var output = [], counter = 0, length = string.length, value, extra;
        while (counter < length) {
            value = string.charCodeAt(counter++);
            if (value >= 55296 && value <= 56319 && counter < length) {
                extra = string.charCodeAt(counter++);
                if ((extra & 64512) == 56320) {
                    output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
                } else {
                    output.push(value);
                    counter--;
                }
            } else {
                output.push(value);
            }
        }
        return output;
    }
    function ucs2encode(array) {
        return map(array, function(value) {
            var output = "";
            if (value > 65535) {
                value -= 65536;
                output += stringFromCharCode(value >>> 10 & 1023 | 55296);
                value = 56320 | value & 1023;
            }
            output += stringFromCharCode(value);
            return output;
        }).join("");
    }
    function basicToDigit(codePoint) {
        if (codePoint - 48 < 10) {
            return codePoint - 22;
        }
        if (codePoint - 65 < 26) {
            return codePoint - 65;
        }
        if (codePoint - 97 < 26) {
            return codePoint - 97;
        }
        return base;
    }
    function digitToBasic(digit, flag) {
        return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
    }
    function adapt(delta, numPoints, firstTime) {
        var k = 0;
        delta = firstTime ? floor(delta / damp) : delta >> 1;
        delta += floor(delta / numPoints);
        for (;delta > baseMinusTMin * tMax >> 1; k += base) {
            delta = floor(delta / baseMinusTMin);
        }
        return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
    }
    function decode(input) {
        var output = [], inputLength = input.length, out, i = 0, n = initialN, bias = initialBias, basic, j, index, oldi, w, k, digit, t, baseMinusT;
        basic = input.lastIndexOf(delimiter);
        if (basic < 0) {
            basic = 0;
        }
        for (j = 0; j < basic; ++j) {
            if (input.charCodeAt(j) >= 128) {
                error("not-basic");
            }
            output.push(input.charCodeAt(j));
        }
        for (index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
            for (oldi = i, w = 1, k = base; ;k += base) {
                if (index >= inputLength) {
                    error("invalid-input");
                }
                digit = basicToDigit(input.charCodeAt(index++));
                if (digit >= base || digit > floor((maxInt - i) / w)) {
                    error("overflow");
                }
                i += digit * w;
                t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                if (digit < t) {
                    break;
                }
                baseMinusT = base - t;
                if (w > floor(maxInt / baseMinusT)) {
                    error("overflow");
                }
                w *= baseMinusT;
            }
            out = output.length + 1;
            bias = adapt(i - oldi, out, oldi == 0);
            if (floor(i / out) > maxInt - n) {
                error("overflow");
            }
            n += floor(i / out);
            i %= out;
            output.splice(i++, 0, n);
        }
        return ucs2encode(output);
    }
    function encode(input) {
        var n, delta, handledCPCount, basicLength, bias, j, m, q, k, t, currentValue, output = [], inputLength, handledCPCountPlusOne, baseMinusT, qMinusT;
        input = ucs2decode(input);
        inputLength = input.length;
        n = initialN;
        delta = 0;
        bias = initialBias;
        for (j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue < 128) {
                output.push(stringFromCharCode(currentValue));
            }
        }
        handledCPCount = basicLength = output.length;
        if (basicLength) {
            output.push(delimiter);
        }
        while (handledCPCount < inputLength) {
            for (m = maxInt, j = 0; j < inputLength; ++j) {
                currentValue = input[j];
                if (currentValue >= n && currentValue < m) {
                    m = currentValue;
                }
            }
            handledCPCountPlusOne = handledCPCount + 1;
            if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
                error("overflow");
            }
            delta += (m - n) * handledCPCountPlusOne;
            n = m;
            for (j = 0; j < inputLength; ++j) {
                currentValue = input[j];
                if (currentValue < n && ++delta > maxInt) {
                    error("overflow");
                }
                if (currentValue == n) {
                    for (q = delta, k = base; ;k += base) {
                        t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                        if (q < t) {
                            break;
                        }
                        qMinusT = q - t;
                        baseMinusT = base - t;
                        output.push(stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0)));
                        q = floor(qMinusT / baseMinusT);
                    }
                    output.push(stringFromCharCode(digitToBasic(q, 0)));
                    bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
                    delta = 0;
                    ++handledCPCount;
                }
            }
            ++delta;
            ++n;
        }
        return output.join("");
    }
    function toUnicode(input) {
        return mapDomain(input, function(string) {
            return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
        });
    }
    function toASCII(input) {
        return mapDomain(input, function(string) {
            return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
        });
    }
    punycode = {
        version: "1.3.0",
        ucs2: {
            decode: ucs2decode,
            encode: ucs2encode
        },
        decode: decode,
        encode: encode,
        toASCII: toASCII,
        toUnicode: toUnicode
    };
    if (typeof define == "function" && typeof define.amd == "object" && define.amd) {
        define("punycode", function() {
            return punycode;
        });
    } else if (freeExports && freeModule) {
        if (module.exports == freeExports) {
            freeModule.exports = punycode;
        } else {
            for (key in punycode) {
                punycode.hasOwnProperty(key) && (freeExports[key] = punycode[key]);
            }
        }
    } else {
        root.punycode = punycode;
    }
})(this);

define("unicoderegexp", function(xregexp) {
    var unicodeRegExp = {};
    unicodeRegExp.letter = /[A-Za-zªµºÀ-ÖØ-öø-ˁˆ-ˑˠ-ˤˬˮͰ-ʹͶͷͺ-ͽΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁҊ-ԧԱ-Ֆՙա-ևא-תװ-ײؠ-يٮٯٱ-ۓەۥۦۮۯۺ-ۼۿܐܒ-ܯݍ-ޥޱߊ-ߪߴߵߺࠀ-ࠕࠚࠤࠨࡀ-ࡘࢠࢢ-ࢬऄ-हऽॐक़-ॡॱ-ॷॹ-ॿঅ-ঌএঐও-নপ-রলশ-হঽৎড়ঢ়য়-ৡৰৱਅ-ਊਏਐਓ-ਨਪ-ਰਲਲ਼ਵਸ਼ਸਹਖ਼-ੜਫ਼ੲ-ੴઅ-ઍએ-ઑઓ-નપ-રલળવ-હઽૐૠૡଅ-ଌଏଐଓ-ନପ-ରଲଳଵ-ହଽଡ଼ଢ଼ୟ-ୡୱஃஅ-ஊஎ-ஐஒ-கஙசஜஞடணதந-பம-ஹௐఅ-ఌఎ-ఐఒ-నప-ళవ-హఽౘౙౠౡಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽೞೠೡೱೲഅ-ഌഎ-ഐഒ-ഺഽൎൠൡൺ-ൿඅ-ඖක-නඳ-රලව-ෆก-ะาำเ-ๆກຂຄງຈຊຍດ-ທນ-ຟມ-ຣລວສຫອ-ະາຳຽເ-ໄໆໜ-ໟༀཀ-ཇཉ-ཬྈ-ྌက-ဪဿၐ-ၕၚ-ၝၡၥၦၮ-ၰၵ-ႁႎႠ-ჅჇჍა-ჺჼ-ቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚᎀ-ᎏᎠ-Ᏼᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᜀ-ᜌᜎ-ᜑᜠ-ᜱᝀ-ᝑᝠ-ᝬᝮ-ᝰក-ឳៗៜᠠ-ᡷᢀ-ᢨᢪᢰ-ᣵᤀ-ᤜᥐ-ᥭᥰ-ᥴᦀ-ᦫᧁ-ᧇᨀ-ᨖᨠ-ᩔᪧᬅ-ᬳᭅ-ᭋᮃ-ᮠᮮᮯᮺ-ᯥᰀ-ᰣᱍ-ᱏᱚ-ᱽᳩ-ᳬᳮ-ᳱᳵᳶᴀ-ᶿḀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼⁱⁿₐ-ₜℂℇℊ-ℓℕℙ-ℝℤΩℨK-ℭℯ-ℹℼ-ℿⅅ-ⅉⅎↃↄⰀ-Ⱞⰰ-ⱞⱠ-ⳤⳫ-ⳮⳲⳳⴀ-ⴥⴧⴭⴰ-ⵧⵯⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞⸯ々〆〱-〵〻〼ぁ-ゖゝ-ゟァ-ヺー-ヿㄅ-ㄭㄱ-ㆎㆠ-ㆺㇰ-ㇿ㐀-䶵一-鿌ꀀ-ꒌꓐ-ꓽꔀ-ꘌꘐ-ꘟꘪꘫꙀ-ꙮꙿ-ꚗꚠ-ꛥꜗ-ꜟꜢ-ꞈꞋ-ꞎꞐ-ꞓꞠ-Ɦꟸ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠢꡀ-ꡳꢂ-ꢳꣲ-ꣷꣻꤊ-ꤥꤰ-ꥆꥠ-ꥼꦄ-ꦲꧏꨀ-ꨨꩀ-ꩂꩄ-ꩋꩠ-ꩶꩺꪀ-ꪯꪱꪵꪶꪹ-ꪽꫀꫂꫛ-ꫝꫠ-ꫪꫲ-ꫴꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮꯀ-ꯢ가-힣ힰ-ퟆퟋ-ퟻ豈-舘並-龎ﬀ-ﬆﬓ-ﬗיִײַ-ﬨשׁ-זּטּ-לּמּנּסּףּפּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼＡ-Ｚａ-ｚｦ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ]/;
    unicodeRegExp.mark = /[\u0300-\u036F\u0483-\u0489\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711\u0730-\u074A\u07A6-\u07B0\u07EB-\u07F3\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08E4-\u08FE\u0900-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A70\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B62\u0B63\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0C01-\u0C03\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C82\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0D02\u0D03\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D82\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0EB1\u0EB4-\u0EB9\u0EBB\u0EBC\u0EC8-\u0ECD\u0F18\u0F19\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F\u109A-\u109D\u135D-\u135F\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u180B-\u180D\u18A9\u1920-\u192B\u1930-\u193B\u19B0-\u19C0\u19C8\u19C9\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F\u1B00-\u1B04\u1B34-\u1B44\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BE6-\u1BF3\u1C24-\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF2-\u1CF4\u1DC0-\u1DE6\u1DFC-\u1DFF\u20D0-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA66F-\uA672\uA674-\uA67D\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA880\uA881\uA8B4-\uA8C4\uA8E0-\uA8F1\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA7B\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uFB1E\uFE00-\uFE0F\uFE20-\uFE26]/;
    unicodeRegExp.number = /[0-9²³¹¼-¾٠-٩۰-۹߀-߉०-९০-৯৴-৹੦-੯૦-૯୦-୯୲-୷௦-௲౦-౯౸-౾೦-೯൦-൵๐-๙໐-໙༠-༳၀-၉႐-႙፩-፼ᛮ-ᛰ០-៩៰-៹᠐-᠙᥆-᥏᧐-᧚᪀-᪉᪐-᪙᭐-᭙᮰-᮹᱀-᱉᱐-᱙⁰⁴-⁹₀-₉⅐-ↂↅ-↉①-⒛⓪-⓿❶-➓⳽〇〡-〩〸-〺㆒-㆕㈠-㈩㉈-㉏㉑-㉟㊀-㊉㊱-㊿꘠-꘩ꛦ-ꛯ꠰-꠵꣐-꣙꤀-꤉꧐-꧙꩐-꩙꯰-꯹０-９]/;
    unicodeRegExp.punctuation = /[\u0021-\u0023\u0025-\u002A\u002C-\u002F\u003A\u003B\u003F\u0040\u005B-\u005D\u005F\u007B\u007D\u00A1\u00A7\u00AB\u00B6\u00B7\u00BB\u00BF\u037E\u0387\u055A-\u055F\u0589\u058A\u05BE\u05C0\u05C3\u05C6\u05F3\u05F4\u0609\u060A\u060C\u060D\u061B\u061E\u061F\u066A-\u066D\u06D4\u0700-\u070D\u07F7-\u07F9\u0830-\u083E\u085E\u0964\u0965\u0970\u0AF0\u0DF4\u0E4F\u0E5A\u0E5B\u0F04-\u0F12\u0F14\u0F3A-\u0F3D\u0F85\u0FD0-\u0FD4\u0FD9\u0FDA\u104A-\u104F\u10FB\u1360-\u1368\u1400\u166D\u166E\u169B\u169C\u16EB-\u16ED\u1735\u1736\u17D4-\u17D6\u17D8-\u17DA\u1800-\u180A\u1944\u1945\u1A1E\u1A1F\u1AA0-\u1AA6\u1AA8-\u1AAD\u1B5A-\u1B60\u1BFC-\u1BFF\u1C3B-\u1C3F\u1C7E\u1C7F\u1CC0-\u1CC7\u1CD3\u2010-\u2027\u2030-\u2043\u2045-\u2051\u2053-\u205E\u207D\u207E\u208D\u208E\u2329\u232A\u2768-\u2775\u27C5\u27C6\u27E6-\u27EF\u2983-\u2998\u29D8-\u29DB\u29FC\u29FD\u2CF9-\u2CFC\u2CFE\u2CFF\u2D70\u2E00-\u2E2E\u2E30-\u2E3B\u3001-\u3003\u3008-\u3011\u3014-\u301F\u3030\u303D\u30A0\u30FB\uA4FE\uA4FF\uA60D-\uA60F\uA673\uA67E\uA6F2-\uA6F7\uA874-\uA877\uA8CE\uA8CF\uA8F8-\uA8FA\uA92E\uA92F\uA95F\uA9C1-\uA9CD\uA9DE\uA9DF\uAA5C-\uAA5F\uAADE\uAADF\uAAF0\uAAF1\uABEB\uFD3E\uFD3F\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE61\uFE63\uFE68\uFE6A\uFE6B\uFF01-\uFF03\uFF05-\uFF0A\uFF0C-\uFF0F\uFF1A\uFF1B\uFF1F\uFF20\uFF3B-\uFF3D\uFF3F\uFF5B\uFF5D\uFF5F-\uFF65]/;
    unicodeRegExp.symbol = /[\u0024+<->\u005E`\u007C~¢-¦¨©¬®-±´¸×÷˂-˅˒-˟˥-˫˭˯-˿͵΄΅϶҂֏؆-؈؋؎؏۞۩۽۾߶৲৳৺৻૱୰௳-௺౿൹฿༁-༃༓༕-༗༚-༟༴༶༸྾-࿅࿇-࿌࿎࿏࿕-࿘႞႟᎐-᎙៛᥀᧞-᧿᭡-᭪᭴-᭼᾽᾿-῁῍-῏῝-῟῭-`´῾⁄⁒⁺-⁼₊-₌₠-₹℀℁℃-℆℈℉℔№-℘℞-℣℥℧℩℮℺℻⅀-⅄⅊-⅍⅏←-⌨⌫-⏳␀-␦⑀-⑊⒜-ⓩ─-⛿✁-❧➔-⟄⟇-⟥⟰-⦂⦙-⧗⧜-⧻⧾-⭌⭐-⭙⳥-⳪⺀-⺙⺛-⻳⼀-⿕⿰-⿻〄〒〓〠〶〷〾〿゛゜㆐㆑㆖-㆟㇀-㇣㈀-㈞㈪-㉇㉐㉠-㉿㊊-㊰㋀-㋾㌀-㏿䷀-䷿꒐-꓆꜀-꜖꜠꜡꞉꞊꠨-꠫꠶-꠹꩷-꩹﬩﮲-﯁﷼﷽﹢﹤-﹦﹩＄＋＜-＞＾｀｜～￠-￦￨-￮￼�]/;
    unicodeRegExp.separator = /[\u0020\u00A0\u1680\u180E\u2000-\u200A\u2028\u2029\u202F\u205F\u3000]/;
    unicodeRegExp.other = /[\u0000-\u001F\u007F-\u009F\u00AD\u0378\u0379\u037F-\u0383\u038B\u038D\u03A2\u0528-\u0530\u0557\u0558\u0560\u0588\u058B-\u058E\u0590\u05C8-\u05CF\u05EB-\u05EF\u05F5-\u0605\u061C\u061D\u06DD\u070E\u070F\u074B\u074C\u07B2-\u07BF\u07FB-\u07FF\u082E\u082F\u083F\u085C\u085D\u085F-\u089F\u08A1\u08AD-\u08E3\u08FF\u0978\u0980\u0984\u098D\u098E\u0991\u0992\u09A9\u09B1\u09B3-\u09B5\u09BA\u09BB\u09C5\u09C6\u09C9\u09CA\u09CF-\u09D6\u09D8-\u09DB\u09DE\u09E4\u09E5\u09FC-\u0A00\u0A04\u0A0B-\u0A0E\u0A11\u0A12\u0A29\u0A31\u0A34\u0A37\u0A3A\u0A3B\u0A3D\u0A43-\u0A46\u0A49\u0A4A\u0A4E-\u0A50\u0A52-\u0A58\u0A5D\u0A5F-\u0A65\u0A76-\u0A80\u0A84\u0A8E\u0A92\u0AA9\u0AB1\u0AB4\u0ABA\u0ABB\u0AC6\u0ACA\u0ACE\u0ACF\u0AD1-\u0ADF\u0AE4\u0AE5\u0AF2-\u0B00\u0B04\u0B0D\u0B0E\u0B11\u0B12\u0B29\u0B31\u0B34\u0B3A\u0B3B\u0B45\u0B46\u0B49\u0B4A\u0B4E-\u0B55\u0B58-\u0B5B\u0B5E\u0B64\u0B65\u0B78-\u0B81\u0B84\u0B8B-\u0B8D\u0B91\u0B96-\u0B98\u0B9B\u0B9D\u0BA0-\u0BA2\u0BA5-\u0BA7\u0BAB-\u0BAD\u0BBA-\u0BBD\u0BC3-\u0BC5\u0BC9\u0BCE\u0BCF\u0BD1-\u0BD6\u0BD8-\u0BE5\u0BFB-\u0C00\u0C04\u0C0D\u0C11\u0C29\u0C34\u0C3A-\u0C3C\u0C45\u0C49\u0C4E-\u0C54\u0C57\u0C5A-\u0C5F\u0C64\u0C65\u0C70-\u0C77\u0C80\u0C81\u0C84\u0C8D\u0C91\u0CA9\u0CB4\u0CBA\u0CBB\u0CC5\u0CC9\u0CCE-\u0CD4\u0CD7-\u0CDD\u0CDF\u0CE4\u0CE5\u0CF0\u0CF3-\u0D01\u0D04\u0D0D\u0D11\u0D3B\u0D3C\u0D45\u0D49\u0D4F-\u0D56\u0D58-\u0D5F\u0D64\u0D65\u0D76-\u0D78\u0D80\u0D81\u0D84\u0D97-\u0D99\u0DB2\u0DBC\u0DBE\u0DBF\u0DC7-\u0DC9\u0DCB-\u0DCE\u0DD5\u0DD7\u0DE0-\u0DF1\u0DF5-\u0E00\u0E3B-\u0E3E\u0E5C-\u0E80\u0E83\u0E85\u0E86\u0E89\u0E8B\u0E8C\u0E8E-\u0E93\u0E98\u0EA0\u0EA4\u0EA6\u0EA8\u0EA9\u0EAC\u0EBA\u0EBE\u0EBF\u0EC5\u0EC7\u0ECE\u0ECF\u0EDA\u0EDB\u0EE0-\u0EFF\u0F48\u0F6D-\u0F70\u0F98\u0FBD\u0FCD\u0FDB-\u0FFF\u10C6\u10C8-\u10CC\u10CE\u10CF\u1249\u124E\u124F\u1257\u1259\u125E\u125F\u1289\u128E\u128F\u12B1\u12B6\u12B7\u12BF\u12C1\u12C6\u12C7\u12D7\u1311\u1316\u1317\u135B\u135C\u137D-\u137F\u139A-\u139F\u13F5-\u13FF\u169D-\u169F\u16F1-\u16FF\u170D\u1715-\u171F\u1737-\u173F\u1754-\u175F\u176D\u1771\u1774-\u177F\u17DE\u17DF\u17EA-\u17EF\u17FA-\u17FF\u180F\u181A-\u181F\u1878-\u187F\u18AB-\u18AF\u18F6-\u18FF\u191D-\u191F\u192C-\u192F\u193C-\u193F\u1941-\u1943\u196E\u196F\u1975-\u197F\u19AC-\u19AF\u19CA-\u19CF\u19DB-\u19DD\u1A1C\u1A1D\u1A5F\u1A7D\u1A7E\u1A8A-\u1A8F\u1A9A-\u1A9F\u1AAE-\u1AFF\u1B4C-\u1B4F\u1B7D-\u1B7F\u1BF4-\u1BFB\u1C38-\u1C3A\u1C4A-\u1C4C\u1C80-\u1CBF\u1CC8-\u1CCF\u1CF7-\u1CFF\u1DE7-\u1DFB\u1F16\u1F17\u1F1E\u1F1F\u1F46\u1F47\u1F4E\u1F4F\u1F58\u1F5A\u1F5C\u1F5E\u1F7E\u1F7F\u1FB5\u1FC5\u1FD4\u1FD5\u1FDC\u1FF0\u1FF1\u1FF5\u1FFF\u200B-\u200F\u202A-\u202E\u2060-\u206F\u2072\u2073\u208F\u209D-\u209F\u20BA-\u20CF\u20F1-\u20FF\u218A-\u218F\u23F4-\u23FF\u2427-\u243F\u244B-\u245F\u2700\u2B4D-\u2B4F\u2B5A-\u2BFF\u2C2F\u2C5F\u2CF4-\u2CF8\u2D26\u2D28-\u2D2C\u2D2E\u2D2F\u2D68-\u2D6E\u2D71-\u2D7E\u2D97-\u2D9F\u2DA7\u2DAF\u2DB7\u2DBF\u2DC7\u2DCF\u2DD7\u2DDF\u2E3C-\u2E7F\u2E9A\u2EF4-\u2EFF\u2FD6-\u2FEF\u2FFC-\u2FFF\u3040\u3097\u3098\u3100-\u3104\u312E-\u3130\u318F\u31BB-\u31BF\u31E4-\u31EF\u321F\u32FF\u4DB6-\u4DBF\u9FCD-\u9FFF\uA48D-\uA48F\uA4C7-\uA4CF\uA62C-\uA63F\uA698-\uA69E\uA6F8-\uA6FF\uA78F\uA794-\uA79F\uA7AB-\uA7F7\uA82C-\uA82F\uA83A-\uA83F\uA878-\uA87F\uA8C5-\uA8CD\uA8DA-\uA8DF\uA8FC-\uA8FF\uA954-\uA95E\uA97D-\uA97F\uA9CE\uA9DA-\uA9DD\uA9E0-\uA9FF\uAA37-\uAA3F\uAA4E\uAA4F\uAA5A\uAA5B\uAA7C-\uAA7F\uAAC3-\uAADA\uAAF7-\uAB00\uAB07\uAB08\uAB0F\uAB10\uAB17-\uAB1F\uAB27\uAB2F-\uABBF\uABEE\uABEF\uABFA-\uABFF\uD7A4-\uD7AF\uD7C7-\uD7CA\uD7FC-\uF8FF\uFA6E\uFA6F\uFADA-\uFAFF\uFB07-\uFB12\uFB18-\uFB1C\uFB37\uFB3D\uFB3F\uFB42\uFB45\uFBC2-\uFBD2\uFD40-\uFD4F\uFD90\uFD91\uFDC8-\uFDEF\uFDFE\uFDFF\uFE1A-\uFE1F\uFE27-\uFE2F\uFE53\uFE67\uFE6C-\uFE6F\uFE75\uFEFD-\uFF00\uFFBF-\uFFC1\uFFC8\uFFC9\uFFD0\uFFD1\uFFD8\uFFD9\uFFDD-\uFFDF\uFFE7\uFFEF-\uFFFB\uFFFE\uFFFF]/;
    unicodeRegExp.spliceCharacterClassRegExps = function() {
        var args = Array.prototype.slice.call(arguments);
        return new RegExp("[" + args.map(function(regExp) {
            return regExp.source.replace(/^\[|\]$/g, "");
        }).join("") + "]");
    };
    unicodeRegExp.visible = unicodeRegExp.spliceCharacterClassRegExps(unicodeRegExp.letter, unicodeRegExp.mark, unicodeRegExp.number, unicodeRegExp.punctuation, unicodeRegExp.symbol);
    unicodeRegExp.printable = unicodeRegExp.spliceCharacterClassRegExps(unicodeRegExp.visible, unicodeRegExp.separator);
    function parseCharCode(u4, x2, literal) {
        if (u4 || x2) {
            return parseInt(u4 || x2, 16);
        } else {
            return literal.charCodeAt(0);
        }
    }
    function charCodeToRegExpToken(charCode) {
        if (charCode >= 32 && charCode < 127) {
            return String.fromCharCode(charCode);
        } else {
            var hexStr = charCode.toString(16);
            return "\\u" + "0000".slice(hexStr.length) + hexStr;
        }
    }
    var characterClassToken = /(?:\\u([0-9a-f]{4})|\\x([0-9a-f]{2})|([^\-]))(?:-(?:\\u([0-9a-f]{4})|\\x([0-9a-f]{2})|([^\-])))?/gi;
    unicodeRegExp.removeCharacterFromCharacterClassRegExp = function(regExp, ch) {
        var charCode = ch.charCodeAt(0);
        return new RegExp("[" + regExp.source.replace(/^\[|\]$/g, "").replace(characterClassToken, function($0, fromU4, fromX2, fromLiteral, toU4, toX2, toLiteral) {
            var fromCharCode = parseCharCode(fromU4, fromX2, fromLiteral);
            if (toU4 || toX2 || toLiteral) {
                var toCharCode = parseCharCode(toU4, toX2, toLiteral);
                if (charCode === fromCharCode) {
                    if (charCode + 1 < toCharCode) {
                        return charCodeToRegExpToken(charCode + 1) + "-" + charCodeToRegExpToken(toCharCode);
                    } else {
                        return charCodeToRegExpToken(toCharCode);
                    }
                } else if (charCode === toCharCode) {
                    if (fromCharCode < charCode - 1) {
                        return charCodeToRegExpToken(fromCharCode) + "-" + charCodeToRegExpToken(charCode - 1);
                    } else {
                        return charCodeToRegExpToken(fromCharCode);
                    }
                } else if (charCode > fromCharCode && charCode < toCharCode) {
                    return charCodeToRegExpToken(fromCharCode) + (charCode > fromCharCode + 1 ? "-" + charCodeToRegExpToken(charCode - 1) : "") + (charCode + 1 < toCharCode ? charCodeToRegExpToken(charCode + 1) + "-" : "") + charCodeToRegExpToken(toCharCode);
                } else {
                    return $0;
                }
            } else {
                if (charCode === fromCharCode) {
                    return "";
                } else {
                    return charCodeToRegExpToken(fromCharCode);
                }
            }
        }) + "]");
    };
    return unicodeRegExp;
});

define("3rdparty/purify", [ "one-validation", "punycode", "unicoderegexp" ], function(oneValidation, punycode, unicodeRegExp) {
    var purify = {};
    purify.boolean = function(rawValue, defaultValue) {
        if (typeof rawValue === "boolean") {
            return rawValue;
        } else if (typeof rawValue === "string") {
            var isTrue = /^(?:1|on|true|yes)$/i.test(rawValue), isFalse = /^(?:0|off|false|no)$/i.test(rawValue);
            return isTrue ? true : isFalse ? false : defaultValue;
        }
        return defaultValue;
    };
    purify.email = purify.emailAddress = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && oneValidation.emailIdn.test(rawValue)) {
            var fragments = rawValue.toLowerCase().split("@"), encodedDomain = fragments.length === 2 && punycode.toASCII(fragments[1]), encodedEmail = encodedDomain && fragments[0] + "@" + encodedDomain;
            if (typeof encodedEmail === "string" && oneValidation.email.test(encodedEmail)) {
                return encodedEmail;
            }
        }
        return defaultValue;
    };
    purify.emailIdn = purify.emailAddressIdn = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && oneValidation.emailIdn.test(rawValue)) {
            var fragments = rawValue.toLowerCase().split("@"), decodedDomain = fragments.length === 2 && punycode.toUnicode(fragments[1]), decodedEmail = decodedDomain && fragments[0] + "@" + decodedDomain;
            if (typeof decodedEmail === "string" && oneValidation.emailIdn.test(decodedEmail)) {
                return decodedEmail;
            }
        }
        return defaultValue;
    };
    purify.domain = purify.domainName = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && oneValidation.domainIdn.test(rawValue)) {
            var encoded = punycode.toASCII(rawValue.toLowerCase());
            if (typeof encoded === "string" && oneValidation.domain.test(encoded)) {
                return encoded;
            }
        }
        return defaultValue;
    };
    purify.domainIdn = purify.domainNameIdn = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && oneValidation.domainIdn.test(rawValue)) {
            var decoded = punycode.toUnicode(rawValue.toLowerCase());
            if (typeof decoded === "string" && oneValidation.domainIdn.test(decoded)) {
                return decoded;
            }
        }
        return defaultValue;
    };
    purify.url = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && oneValidation.httpUrl.test(rawValue)) {
            return rawValue;
        }
        return defaultValue;
    };
    var urlWithLocalhostRegExp = new RegExp("^(?:" + oneValidation.createHttpishUrlRegExp({
        scheme: /https?/,
        localhost: true
    }).source + ")$");
    purify.urlWithLocalhost = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && urlWithLocalhostRegExp.test(rawValue)) {
            return rawValue;
        }
        return defaultValue;
    };
    purify.integer = function(rawValue, defaultValue) {
        var integer;
        if (typeof rawValue === "string") {
            integer = parseInt(rawValue, 10);
        } else if (typeof rawValue === "number") {
            integer = Math.floor(rawValue);
        }
        if (typeof integer === "number" && isFinite(integer) && !isNaN(integer)) {
            return integer;
        } else {
            return defaultValue;
        }
    };
    purify.integerInRange = function(rawValue, lower, upper, defaultValue) {
        var integer = purify.integer(rawValue);
        if (typeof integer === "number" && !isNaN(integer) && isFinite(integer) && (typeof lower === "undefined" || integer >= lower) && (typeof upper === "undefined" || integer <= upper)) {
            return integer;
        }
        return defaultValue;
    };
    purify.positiveInteger = function(rawValue, defaultValue) {
        var integer = purify.integer(rawValue);
        if (typeof integer !== "undefined" && !isNaN(integer) && isFinite(integer) && integer >= 1) {
            return integer;
        }
        return defaultValue;
    };
    purify.positiveIntegerOrZero = function(rawValue, defaultValue) {
        var integer = purify.integer(rawValue);
        if (typeof integer !== "undefined" && !isNaN(integer) && isFinite(integer) && integer >= 0) {
            return integer;
        }
        return defaultValue;
    };
    purify.float = function(rawValue, defaultValue) {
        var number;
        if (typeof rawValue === "string") {
            if (/^[\-+]?[0-9]*\.?[0-9]+$/.test(rawValue)) {
                number = parseFloat(rawValue);
            }
        } else if (typeof rawValue === "number") {
            number = rawValue;
        }
        if (typeof number !== "undefined" && !isNaN(number) && isFinite(number)) {
            return number;
        }
        return defaultValue;
    };
    purify.positiveFloat = function(rawValue, defaultValue) {
        var number;
        if (typeof rawValue === "string") {
            if (/^\+?[0-9]*\.?[0-9]+$/.test(rawValue)) {
                number = parseFloat(rawValue);
            }
        } else if (typeof rawValue === "number") {
            number = rawValue;
        }
        if (typeof number !== "undefined" && !isNaN(number) && isFinite(number) && number > 0) {
            return number;
        }
        return defaultValue;
    };
    purify.positiveFloatOrZero = function(rawValue, defaultValue) {
        var number;
        if (typeof rawValue === "string") {
            if (/^\+?[0-9]*\.?[0-9]+$/.test(rawValue)) {
                number = parseFloat(rawValue);
            }
        } else if (typeof rawValue === "number") {
            number = rawValue;
        }
        if (typeof number !== "undefined" && !isNaN(number) && isFinite(number) && number >= 0) {
            return number;
        }
        return defaultValue;
    };
    var nonEmptyVisibleUnicodeRegExp = new RegExp("^" + unicodeRegExp.visible.source + "+$");
    purify.nonEmptyVisibleUnicode = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && nonEmptyVisibleUnicodeRegExp.test(rawValue)) {
            return rawValue;
        }
        return defaultValue;
    };
    var visibleUnicodeRegExp = new RegExp("^" + unicodeRegExp.visible.source + "*$");
    purify.visibleUnicode = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && visibleUnicodeRegExp.test(rawValue)) {
            return rawValue;
        }
        return defaultValue;
    };
    var nonEmptyPrintableUnicodeRegExp = new RegExp("^" + unicodeRegExp.printable.source + "+$");
    purify.nonEmptyPrintableUnicode = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && nonEmptyPrintableUnicodeRegExp.test(rawValue)) {
            return rawValue;
        }
        return defaultValue;
    };
    var printableUnicodeRegExp = new RegExp("^" + unicodeRegExp.printable.source + "*$");
    purify.printableUnicode = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && printableUnicodeRegExp.test(rawValue)) {
            return rawValue;
        }
        return defaultValue;
    };
    purify.nonEmptyVisibleAscii = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && /^[\x21-\x7e]+$/.test(rawValue)) {
            return rawValue;
        }
        return defaultValue;
    };
    purify.visibleAscii = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && /^[\x21-\x7e]*$/.test(rawValue)) {
            return rawValue;
        }
        return defaultValue;
    };
    purify.nonEmptyPrintableAscii = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && /^[\x20-\x7e]+$/.test(rawValue)) {
            return rawValue;
        }
        return defaultValue;
    };
    purify.printableAscii = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && /^[\x20-\x7e]*$/.test(rawValue)) {
            return rawValue;
        }
        return defaultValue;
    };
    purify.alphaNumeric = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && /^[a-z0-9]*$/i.test(rawValue)) {
            return rawValue;
        } else if (typeof rawValue === "number" && isFinite(rawValue) && !isNaN(rawValue) && rawValue === Math.floor(rawValue)) {
            return String(rawValue);
        }
        return defaultValue;
    };
    purify.nonEmptyAlphaNumeric = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && /^[a-z0-9]+$/i.test(rawValue)) {
            return rawValue;
        } else if (typeof rawValue === "number" && isFinite(rawValue) && !isNaN(rawValue) && rawValue === Math.floor(rawValue)) {
            return String(rawValue);
        }
        return defaultValue;
    };
    purify.alphaNumericWithDot = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && /^[a-z0-9\.]*$/i.test(rawValue)) {
            return rawValue;
        } else if (typeof rawValue === "number" && isFinite(rawValue) && !isNaN(rawValue)) {
            return String(rawValue);
        }
        return defaultValue;
    };
    purify.nonEmptyAlphaNumericWithDot = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && /^[a-z0-9\.]+$/i.test(rawValue)) {
            return rawValue;
        } else if (typeof rawValue === "number" && isFinite(rawValue) && !isNaN(rawValue)) {
            return String(rawValue);
        }
        return defaultValue;
    };
    purify.uuid = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && oneValidation.uuid.test(rawValue)) {
            return rawValue;
        }
        return defaultValue;
    };
    purify.upperCaseUuid = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && oneValidation.upperCaseUuid.test(rawValue)) {
            return rawValue;
        }
        return defaultValue;
    };
    purify.lowerCaseUuid = function(rawValue, defaultValue) {
        if (typeof rawValue === "string" && oneValidation.lowerCaseUuid.test(rawValue)) {
            return rawValue;
        }
        return defaultValue;
    };
    purify.json = function(rawValue, defaultValue) {
        if (typeof rawValue === "string") {
            try {
                return JSON.parse(rawValue);
            } catch (e) {}
        }
        return defaultValue;
    };
    return purify;
});

define("3rdparty/knockout.validation", [ "knockout", "one-validation" ], function(ko, validation) {
    var validations = {
        present: function(value) {
            if (value) {
                return /\S+/.test(value);
            } else {
                return false;
            }
        },
        domainName: function(value) {
            return validation.functions.domainIdn(value);
        },
        email: function(value) {
            return validation.functions.emailIdn(value);
        },
        password: function(value) {
            return /^[!-~]+$/.test(value);
        },
        directoryEntryDisplayName: function(value) {
            return value !== "." && value !== ".." && /^[^\\\/]+$/.test(value) && encodeURIComponent(value).replace(/%../g, "%").length < 256;
        }
    };
    function capitalize(value) {
        return value.charAt(0).toUpperCase() + value.substr(1);
    }
    function createValidator(name) {
        return function(target) {
            function validate(value) {
                return validations[name](value);
            }
            target["is" + capitalize(name)] = ko.observable(validate(target()));
            target["isNot" + capitalize(name)] = ko.computed(function() {
                return !target["is" + capitalize(name)]();
            });
            target.subscribe(function(newValue) {
                target["is" + capitalize(name)](validate(newValue));
            });
            if (!target.hasOwnProperty("isValid") && !target.hasOwnProperty("isNotValid")) {
                target.isValid = ko.computed(function() {
                    var valid = true;
                    for (var k in validations) {
                        if (target.hasOwnProperty("is" + capitalize(k))) {
                            valid = target["is" + capitalize(k)]();
                        }
                    }
                    return valid;
                });
                target.isNotValid = ko.computed(function() {
                    return !target.isValid();
                });
            }
            return target;
        };
    }
    for (var v in validations) {
        ko.extenders[v] = createValidator(v);
    }
});

define("common/model/LoginForm", [ "jquery", "knockout", "3rdparty/purify", "3rdparty/knockout.validation" ], function($, ko, purify) {
    function LoginForm() {
        var that = this;
        that.displayUsername = ko.observable().extend({
            present: true,
            email: true,
            domainName: true
        });
        that.username = ko.computed(function() {
            var displayUsername = that.displayUsername();
            if (that.displayUsername.isEmail()) {
                return purify.email(displayUsername);
            } else if (that.displayUsername.isDomainName()) {
                return purify.domain(displayUsername);
            }
            return displayUsername;
        });
        that.displayTargetDomain = ko.observable().extend({
            domainName: true
        });
        that.targetDomain = ko.computed(function() {
            var displayTargetDomain = that.displayTargetDomain();
            return purify.domain(displayTargetDomain);
        });
        that.password = ko.observable().extend({
            present: true,
            password: true
        });
        that.driveType = ko.observable("cloud");
        that.loginTarget = ko.observable();
        that.isLoginValid = ko.observable(true);
        that.isLoginObsolete = ko.observable(false);
    }
    LoginForm.prototype.loadAutofill = function() {
        var username = $(".login input.username").val(), domain = $(".login input.domain").val(), password = $(".login input.password").val(), loginTarget = $(".login input.loginTarget").val();
        if (!this.displayUsername() || this.displayUsername() === username) {
            this.displayUsername(username);
        }
        if (!this.displayTargetDomain() || this.displayTargetDomain() === domain) {
            this.displayTargetDomain(domain);
        }
        if (!this.loginTarget() || this.loginTarget() === loginTarget) {
            this.loginTarget(loginTarget);
        }
        if (!this.password() || this.password() === password) {
            this.password(password);
        }
    };
    LoginForm.prototype.setFormAction = function(actionUrl) {
        $(".login").attr("action", actionUrl);
    };
    LoginForm.prototype.devEmailAndDomainLoginForm = function() {
        var $domain = $(".login input.domain");
        if ($domain.length > 0) {
            $(".login input.username").attr("placeholder", "Username");
            $(".login input.password").attr("name", "password");
        }
    };
    return LoginForm;
});

define("common/isApprovedUrl", function() {
    return function isApprovedUrl(url) {
        return /^https?:\/\/(?:localhost|(?:[a-z0-9\-]+\.)*(bix|(one(?:-test)?))\.com)(?::\d+)?\//.test(url);
    };
});

define("common/ErrorHandler", [], function() {
    var noConnectionMessage = "Ingen forbindelse med serveren, prøv igjen senere.";
    var defaultHandlers = {
        0: noConnectionMessage,
        400: "Det oppstod et problem med tilkoblingen til serveren. Prøv på nytt.",
        409: "Elementet du arbeidet på, er oppdatert. Oppdater nettleservinduet ditt.",
        500: noConnectionMessage,
        502: noConnectionMessage,
        503: "Serverne våre er utilgjengelige på grunn av midlertidig overbelastning eller vedlikehold. Vennligst prøv igjen senere."
    };
    function sanitiseMessageString(data, clean) {
        if (typeof data !== "string") {
            return "";
        }
        if (clean) {
            try {
                JSON.parse(data);
                return "";
            } catch (e) {}
        }
        return data;
    }
    function ErrorHandler(handlers) {
        this.defaultHandlers = $.extend(defaultHandlers, handlers);
        this.defaultMapping = {
            12002: 503,
            12029: 503,
            12030: 503,
            12031: 503,
            12152: 500
        };
    }
    ErrorHandler.prototype.showError = function(err, message) {
        console.log(message);
    };
    ErrorHandler.prototype.createErrorMessage = function(err, message, clean) {
        var tmp;
        message = !!message ? message + " " : "Application error.";
        message = message + "[" + err.status + ":";
        message = message + " " + (!!err.statusText ? err.statusText : "application error");
        tmp = sanitiseMessageString(err.responseText, clean);
        message = !!tmp ? message + " - " + tmp : message;
        message = message + "]";
        return message;
    };
    ErrorHandler.prototype.handleError = function(err, handlers) {
        var that = this;
        handlers = $.extend({}, this.defaultHandlers, handlers);
        var mappedStatus;
        if ((mappedStatus = this.defaultMapping[err.status]) && !handlers[err.status]) {
            err.status = mappedStatus;
        }
        var handler = null;
        if (err.response && err.response.error) {
            handler = handlers[err.status + " " + err.response.error];
        }
        if (!handler) {
            handler = handlers[err.status];
        }
        var callback = null;
        var disableShowError = false;
        var message = null;
        if (handler) {
            if (typeof handler === "string") {
                message = handler;
            } else if (typeof handler === "function") {
                callback = handler;
                disableShowError = true;
            } else {
                message = handler.message;
                callback = handler.callback;
            }
        } else {
            message = "Missing handler for error.";
        }
        if (err.status !== 0) {
            setTimeout(function() {
                one.sendCrashReport(err, {
                    message: that.createErrorMessage(err, message)
                });
            }, 0);
        }
        if (callback) {
            callback.call(this, err);
        }
        if (!disableShowError) {
            this.showError(err, this.createErrorMessage(err, message, true));
        }
    };
    return ErrorHandler;
});

define("common/EvilExtensionDetector", [], function() {
    function EvilExtensionDetector() {}
    EvilExtensionDetector.prototype.detectFlvRunner = function() {
        return $("body .main-iframe-wrapper").length > 0;
    };
    EvilExtensionDetector.prototype.searchForProblems = function() {
        var detected = [];
        if (this.detectFlvRunner()) {
            detected.push('<strong>FLV Runner oppdaget</strong>\n<br>\nVi beklager, men du kan ikke logge på med denne utvidelsen.\n<br>\nHvis du har noen spørsmål, nøl ikke med å ta kontakt med vår <a href="http://www.one.com/chat">kundestøtte</a>.');
        }
        return detected;
    };
    return EvilExtensionDetector;
});

define("mail/Application", [ "jquery", "knockout", "common/Backend", "mail/Actions", "common/model/LoginForm", "common/isApprovedUrl", "common/ErrorHandler", "common/EvilExtensionDetector", "common/TraceLogging", "common/util", "one-validation", "3rdparty/purify", "mario", "common/Version" ], function($, ko, Backend, Actions, LoginForm, isApprovedUrl, ErrorHandler, EvilExtensionDetector, TraceLogging, util, oneValidation, purify, mario, Version) {
    function Application() {
        var that = this;
        that.backend = new Backend();
        that.loginForm = new LoginForm();
        that.errorHandler = new ErrorHandler();
        that.errorHandler.showError = that.showError.bind(that);
        that.actions = new Actions(that.backend, that.errorHandler);
        that.enterUsernameAndPassword = ko.observable(false);
        that.invalidEmail = ko.observable(false);
        that.invalidUsername = ko.observable(false);
        that.invalidPassword = ko.observable(false);
        that.validateInput = ko.observable(true);
        that.mailFunction = ko.observable();
        that.mailFunction.subscribe(function(newValue) {
            that.goToApp(newValue);
        });
        that.filemanFunction = ko.observable();
        that.filemanFunction.subscribe(function(newValue) {
            if (newValue === "fm/") {
                that.loginForm.driveType("webspace");
            } else if (newValue === "fm/cd") {
                that.loginForm.driveType("cloud");
            }
            that.goToApp(newValue);
        });
        that.loginForm.username.subscribe(function(newValue) {
            that.enterUsernameAndPassword(false);
            that.invalidEmail(false);
            that.invalidUsername(false);
        });
        that.loginForm.password.subscribe(function(newValue) {
            that.invalidPassword(false);
            that.enterUsernameAndPassword(false);
        });
        that.showControlsMenuOverlay = ko.observable(false);
        that.controlsMenuFadeIn = ko.observable(false);
        that.toggleControlsMenuOverlay = function() {
            var isActive = that.showControlsMenuOverlay();
            if (isActive) {
                that.controlsMenuFadeIn(false);
                window.setTimeout(function() {
                    that.showControlsMenuOverlay(false);
                }, 200);
            } else {
                that.showControlsMenuOverlay(true);
                window.setTimeout(function() {
                    that.controlsMenuFadeIn(true);
                }, 1);
            }
        };
        that.notification = ko.observable(null);
        that.errormsg = ko.observable(null);
        that.loginUrl = ko.observable();
        var emailInFragmentIdentifierRegExp = new RegExp("/#/?(" + oneValidation.fragments.email.source + ")"), loginTargetHostnameInFragmentIdentifierRegExp = new RegExp("https?://(" + oneValidation.fragments.domain.source + "|localhost)");
        function oneComOrLocalhostUrl(rawValue, defaultValue) {
            var hostname = typeof rawValue === "string" ? rawValue.match(loginTargetHostnameInFragmentIdentifierRegExp)[1] : "";
            if (typeof rawValue === "string" && (/^https?:\/\/localhost(?::\d+)?(?:\/|$)/.test(rawValue) || oneValidation.httpUrl.test(rawValue) && /(?:^|\.)(bix|(one(?:-test)?))\.com$/.test(hostname))) {
                return rawValue;
            }
            return defaultValue;
        }
        that.webmailSuccessUrl = ko.observable();
        that.webmailTestedSuccessUrl = ko.computed(function() {
            var successUrl = that.webmailSuccessUrl(), username = that.loginForm.username(), matchEmailInFragmentIdentifier = successUrl && successUrl.match(emailInFragmentIdentifierRegExp), isRightUser = matchEmailInFragmentIdentifier && matchEmailInFragmentIdentifier[1] === username;
            if (!oneComOrLocalhostUrl(successUrl)) {
                return "https://mail.one.com/";
            } else if (!isRightUser) {
                return successUrl.split("#")[0];
            } else {
                return successUrl;
            }
        });
        that.cdfmSuccessUrl = ko.observable();
        that.cdfmTestedSuccessUrl = ko.computed(function() {
            var successUrl = that.cdfmSuccessUrl(), username = that.loginForm.username(), matchEmailInFragmentIdentifier = successUrl && successUrl.match(emailInFragmentIdentifierRegExp), isRightUser = matchEmailInFragmentIdentifier && matchEmailInFragmentIdentifier[1] === username;
            if (!oneComOrLocalhostUrl(successUrl)) {
                return "https://filemanager.bix.com/";
            } else if (!isRightUser) {
                return successUrl.split("#")[0];
            } else {
                return successUrl;
            }
        });
        that.wfmSuccessUrl = ko.observable();
        that.wfmTestedSuccessUrl = ko.computed(function() {
            var successUrl = that.wfmSuccessUrl(), username = that.loginForm.username(), matchEmailInFragmentIdentifier = successUrl && successUrl.match(emailInFragmentIdentifierRegExp), isRightUser = matchEmailInFragmentIdentifier && matchEmailInFragmentIdentifier[1] === username;
            if (!oneComOrLocalhostUrl(successUrl)) {
                return "https://filemanager.one.com/";
            } else if (!isRightUser) {
                return successUrl.split("#")[0];
            } else {
                return successUrl;
            }
        });
        that.webEditorSuccessUrl = ko.observable();
        that.webEditorTestedSuccessUrl = ko.computed(function() {
            var successUrl = that.webEditorSuccessUrl(), username = that.loginForm.username(), matchEmailInFragmentIdentifier = successUrl && successUrl.match(emailInFragmentIdentifierRegExp), isRightUser = matchEmailInFragmentIdentifier && matchEmailInFragmentIdentifier[1] === username;
            if (!oneComOrLocalhostUrl(successUrl)) {
                return "https://webeditor.one.com/";
            } else if (!isRightUser) {
                return successUrl.split("#")[0];
            } else {
                return successUrl;
            }
        });
        that.notifyNewVersion = ko.computed(function() {
            var priority = Version.updatePriority();
            if (priority > 0) {
                that.backend.reload();
            }
        });
        that.errorUrl = (location.origin || location.protocol + "//" + location.host) + location.pathname;
    }
    Application.prototype.showLogin = function() {
        $(".application .loginErrors").show();
        if (!mario.msie) {
            $("input.username").focus();
        }
    };
    Application.prototype.inputIsValid = function() {
        var that = this, username = that.loginForm.displayUsername, password = that.loginForm.password, usernameValue = username(), sanitizedUsernameValue = usernameValue.trim().toLowerCase();
        if (username.isEmail()) {
            sanitizedUsernameValue = purify.emailIdn(sanitizedUsernameValue);
        } else {
            sanitizedUsernameValue = purify.domainIdn(sanitizedUsernameValue);
        }
        if (usernameValue !== sanitizedUsernameValue) {
            username(sanitizedUsernameValue);
        }
        if (username.isNotPresent() || password.isNotPresent()) {
            that.enterUsernameAndPassword(true);
            return false;
        }
        if (username.isEmail()) {
            that.invalidEmail(false);
            that.invalidUsername(false);
        } else if (username.isDomainName()) {
            that.invalidEmail(true);
            that.invalidUsername(false);
        } else {
            that.invalidEmail(true);
            that.invalidUsername(true);
            return false;
        }
        if (password.isNotValid()) {
            that.invalidPassword(true);
            return false;
        }
        return true;
    };
    Application.prototype.userLogin = function() {
        var that = this;
        if (that.validateInput() && !that.inputIsValid()) {
            return;
        }
        that.notification("Laster inn...");
        if (window.trackLoginViaGoogleTagManager) {
            window.trackLoginViaGoogleTagManager();
        }
        return true;
    };
    Application.prototype.unauthorized = function() {
        var that = this;
        that.loginForm.isLoginValid(false);
        window.setTimeout(function() {
            that.loginForm.password("");
        }, 100);
    };
    Application.prototype.handleLoginUrlOrLoginTarget = function(loginUrl) {
        var that = this;
        that.loginForm.isLoginObsolete(false);
        that.validateInput(true);
        if (!loginUrl) {
            return;
        }
        var matchLoginUrl = loginUrl.match(/^https?:\/\/(?:[^@\/:]@)?([^\/:]+)(?::\d+)?(\/|$)/), loginTargetByHostname = {
            "filemanager-staging.one.com": "wfm-staging",
            "filemanager-next.one.com": "wfm-next",
            "webeditor-staging.one.com": "webeditor-staging",
            "webeditor-next.one.com": "webeditor-next"
        };
        if (!matchLoginUrl) {
            return;
        }
        var hostname = matchLoginUrl[1], useOneComApi = that.loginForm.loginTarget();
        if (hostname in loginTargetByHostname) {
            if (useOneComApi) {
                that.loginForm.loginTarget(loginTargetByHostname[hostname]);
            } else {
                that.loginUrl(loginUrl);
                that.loginForm.setFormAction(loginUrl);
            }
        } else if (isApprovedUrl(loginUrl)) {
            that.loginUrl(loginUrl);
            that.loginForm.setFormAction(loginUrl);
            that.loginForm.devEmailAndDomainLoginForm();
            that.validateInput(false);
        }
    };
    Application.prototype.readUrlParamsFromHash = function(hash) {
        var that = this, params = util.decodePairs(hash), loginUrlOrLoginTarget = params.loginUrl, successUrl = params.redirectUrl || params.successUrl;
        if (successUrl && isApprovedUrl(successUrl)) {
            that.webmailSuccessUrl(successUrl);
            that.cdfmSuccessUrl(successUrl);
            that.wfmSuccessUrl(successUrl);
            that.webEditorSuccessUrl(successUrl);
        } else {
            that.webmailSuccessUrl("https://mail.one.com/");
            that.cdfmSuccessUrl("https://filemanager.bix.com/");
            that.wfmSuccessUrl("https://filemanager.one.com/");
            that.webEditorSuccessUrl("https://webeditor.one.com/");
        }
        that.handleLoginUrlOrLoginTarget(loginUrlOrLoginTarget);
        if (params.targetDomain) {
            that.loginForm.displayTargetDomain(params.targetDomain);
        }
        if (params.username) {
            var displayTargetDomain = purify.domainIdn(params.username), displayUsername = purify.emailIdn(params.username);
            if (displayTargetDomain) {
                that.loginForm.displayTargetDomain(displayTargetDomain);
            } else if (displayUsername) {
                that.loginForm.displayUsername(displayUsername);
            }
        }
        if (params["error-login-invalid-credentials"]) {
            that.unauthorized();
        }
        if (params["error-too-many-attempts"]) {
            that.errorHandler.showError(null, "Du har prøvd å logge på 5 ganger etter hverandre med feil opplysninger. Prøv igjen om 5 minutter.");
        }
        if (params["error-fatal-contact-support"]) {
            that.errorHandler.showError(null, "Det oppstod en ukjent feil. Kontakt vår support.");
        }
        if (params["error-login-imap-account-not-ready-yet"]) {
            that.errorHandler.showError(null, "Din e-postkonto er ikke klar ennå. Prøv igjen om 5 minutter.");
        }
        if (params["error-obsolete-login-method"]) {
            that.loginForm.isLoginObsolete(true);
        }
    };
    Application.prototype.searchForProblems = function() {
        var evilExtensionDetector = new EvilExtensionDetector();
        var problems = evilExtensionDetector.searchForProblems();
        if (problems.length > 0) {
            var message = problems.join("\n");
            this.showError(null, message);
        }
    };
    Application.prototype.load = function() {
        var that = this;
        that.searchForProblems();
        that.readUrlParamsFromHash(window.location.hash && window.location.hash.substring(1));
        that.showLogin();
    };
    Application.prototype.redirectIfUnsupportedBrowser = function() {
        return this.backend.redirectIfUnsupportedBrowser();
    };
    Application.prototype.handleError = function(err, handlers) {
        this.errorHandler.handleError(err, handlers);
    };
    Application.prototype.showError = function(err, message) {
        this.errormsg(util.htmlEncode(message));
    };
    Application.prototype.goToApp = function(appname) {
        var pathname = location.pathname;
        if ("/" + appname !== pathname) {
            document.location.pathname = "/" + appname;
        }
    };
    Application.prototype.localeInfos = [ {
        id: "da",
        displayName: "Dansk"
    }, {
        id: "de",
        displayName: "Deutsch"
    }, {
        id: "en_gb",
        displayName: "English (UK)"
    }, {
        id: "en_us",
        displayName: "English (US)"
    }, {
        id: "es",
        displayName: "Español"
    }, {
        id: "fr",
        displayName: "Français"
    }, {
        id: "it",
        displayName: "Italiano"
    }, {
        id: "nl",
        displayName: "Nederlands"
    }, {
        id: "nb",
        displayName: "Norsk"
    }, {
        id: "pt",
        displayName: "Português"
    }, {
        id: "sv",
        displayName: "Svenska"
    } ];
    TraceLogging.injectTracing(Application);
    return Application;
});

define("theme/autofill", [ "jquery" ], function($) {
    $(function() {
        $("form.autofill").each(function(index, form) {
            var inputs = $("input, textarea", form);
            inputs.blur(function() {
                inputs.not(this).trigger("change");
            });
            $(form).submit(function() {
                $("input, textarea", form).each(function(index, input) {
                    $(input).trigger("change");
                });
            });
        });
    });
});

define("common/binding/knockout.checkedWithInit", [ "knockout" ], function(ko) {
    ko.bindingHandlers.checkedWithInit = {
        init: function(element, valueAccessor, allBindingsAccessor, data) {
            var propertyValue = valueAccessor(), valueToWrite;
            if (element.type === "checkbox") {
                valueToWrite = element.checked;
            } else if (element.type === "radio" && element.checked) {
                valueToWrite = element.value;
            } else {
                valueToWrite = null;
            }
            if (valueToWrite && !propertyValue()) {
                propertyValue(valueToWrite);
            }
            ko.applyBindingsToNode(element, {
                checked: propertyValue
            });
        }
    };
});

define("3rdparty/knockout.tap", [ "knockout", "jquery" ], function(ko, $) {
    function getDistance(fromTouches, toTouches) {
        var from = fromTouches[0];
        var to = ko.utils.arrayFirst(toTouches, function(touch) {
            return touch.identifier === from.identifier;
        });
        return {
            x: to.clientX - from.clientX,
            y: to.clientY - from.clientY
        };
    }
    function copy(touches) {
        return ko.utils.arrayMap(touches, function(touch) {
            return {
                clientX: touch.clientX,
                clientY: touch.clientY,
                identifier: touch.identifier
            };
        });
    }
    ko.bindingHandlers.tap = {
        init: function(element, valueAccessor, allBindingsAccessor, viewModel) {
            var $element = $(element);
            var startTouches, distance;
            var touchSupport = "ontouchstart" in document.documentElement;
            if (!touchSupport) {
                $element.on("click", function() {
                    var value = valueAccessor();
                    var handler = ko.utils.unwrapObservable(value);
                    var argsForHandler = ko.utils.makeArray(arguments);
                    argsForHandler.unshift(viewModel);
                    handler.apply(viewModel, argsForHandler);
                    $element.trigger("tap");
                });
            } else {
                var $highlightedElements;
                $element.on("touchstart", function(e) {
                    var $target = $(e.target);
                    var touches = e.originalEvent.touches;
                    distance = {
                        x: 0,
                        y: 0
                    };
                    startTouches = copy(touches);
                    $highlightedElements = $target.closest(".touch-highlight");
                    $highlightedElements.addClass("touching");
                    e.stopPropagation();
                    e.preventDefault();
                    return false;
                });
                $element.on("touchmove", function(e) {
                    distance = getDistance(startTouches, e.originalEvent.touches);
                    e.stopPropagation();
                    e.preventDefault();
                    return false;
                });
                $element.on("touchend", function(e) {
                    var touches = e.originalEvent.changedTouches;
                    var moved = Math.sqrt(Math.pow(distance.x, 2), Math.pow(distance.y, 2));
                    if (moved < 10) {
                        var value = valueAccessor();
                        var handler = ko.utils.unwrapObservable(value);
                        var argsForHandler = ko.utils.makeArray(arguments);
                        argsForHandler.unshift(viewModel);
                        handler.apply(viewModel, argsForHandler);
                        setTimeout(function() {
                            if ($highlightedElements) {
                                $highlightedElements.removeClass("touching");
                                $highlightedElements = null;
                            }
                        }, 300);
                        $element.trigger("tap");
                    } else {
                        if ($highlightedElements) {
                            $highlightedElements.removeClass("touching");
                            $highlightedElements = null;
                        }
                    }
                    e.stopPropagation();
                    e.preventDefault();
                    return false;
                });
            }
        }
    };
});

define("3rdparty/knockout.placeholderPolyfill", [ "jquery", "knockout" ], function($, ko) {
    if ("placeholder" in $("<input>")[0] && "placeholder" in $("<textarea>")[0]) {
        return;
    }
    function attributes(elem) {
        var newAttrs = {};
        var frameworkIdentifiers = /^(jQuery|__ko__)\d+$/;
        var dataAttribute = /^data-.*/;
        var disallowedAttributes = /^(id|name)$/;
        $.each(elem.attributes, function(i, attr) {
            if (attr.specified && !frameworkIdentifiers.test(attr.name) && !dataAttribute.test(attr.name) && !disallowedAttributes.test(attr.name)) {
                newAttrs[attr.name] = attr.value;
            }
        });
        if (newAttrs.type === "password") {
            newAttrs.type = "text";
        }
        return newAttrs;
    }
    ko.bindingHandlers.placeholderPolyfill = {
        init: function(element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
            var $placeholder;
            var $input = $(element);
            $placeholder = $input.is("textarea") ? $("<textarea>") : $("<input>");
            $placeholder.attr(attributes(element)).addClass("placeholder").val($input.attr("placeholder"));
            $input.before($placeholder);
            function placeholderToggle(visible) {
                return $placeholder.toggle(visible).next().toggle(!visible);
            }
            function showPlaceholderIfValueIsEmpty() {
                var value = ko.utils.unwrapObservable(valueAccessor()) || "";
                placeholderToggle(value === "");
            }
            $placeholder.focus(function() {
                placeholderToggle(false).focus();
            });
            $input.blur(function() {
                showPlaceholderIfValueIsEmpty();
            });
            if (ko.isObservable(valueAccessor())) {
                var subscription = valueAccessor().subscribe(function(newValue) {
                    if (!$input.is(":focus")) {
                        showPlaceholderIfValueIsEmpty();
                    }
                });
                ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
                    subscription.dispose();
                });
            }
            showPlaceholderIfValueIsEmpty();
        }
    };
    var defaultBindingProvider = ko.bindingProvider.instance || new ko.bindingProvider();
    var ELEMENT_NODE = 1;
    ko.bindingProvider.instance = {
        nodeHasBindings: function(node) {
            return defaultBindingProvider.nodeHasBindings(node) || node.nodeType === ELEMENT_NODE && node.hasAttribute && node.hasAttribute("placeholder");
        },
        getBindings: function(node, bindingContext) {
            var bindings = defaultBindingProvider.getBindings(node, bindingContext);
            if (node.nodeType === ELEMENT_NODE && node.hasAttribute && node.hasAttribute("placeholder")) {
                bindings = bindings || {};
                if (!bindings.value) {
                    bindings.value = ko.observable();
                }
                bindings.placeholderPolyfill = bindings.value;
            }
            return bindings;
        }
    };
});

!function($) {
    "use strict";
    var dismiss = '[data-dismiss="alert"]', Alert = function(el) {
        $(el).on("click", dismiss, this.close);
    };
    Alert.prototype.close = function(e) {
        var $this = $(this), selector = $this.attr("data-target"), $parent;
        if (!selector) {
            selector = $this.attr("href");
            selector = selector && selector.replace(/.*(?=#[^\s]*$)/, "");
        }
        $parent = $(selector);
        e && e.preventDefault();
        $parent.length || ($parent = $this.hasClass("alert") ? $this : $this.parent());
        $parent.trigger(e = $.Event("close"));
        if (e.isDefaultPrevented()) return;
        $parent.removeClass("in");
        function removeElement() {
            $parent.trigger("closed").remove();
        }
        $.support.transition && $parent.hasClass("fade") ? $parent.on($.support.transition.end, removeElement) : removeElement();
    };
    $.fn.alert = function(option) {
        return this.each(function() {
            var $this = $(this), data = $this.data("alert");
            if (!data) $this.data("alert", data = new Alert(this));
            if (typeof option == "string") data[option].call($this);
        });
    };
    $.fn.alert.Constructor = Alert;
    $(function() {
        $("body").on("click.alert.data-api", dismiss, Alert.prototype.close);
    });
}(window.jQuery);

define("3rdparty/one-theme/3rdparty/bootstrap/js/bootstrap-alert", function() {
    return $.fn.alert;
});

!function($) {
    "use strict";
    var Button = function(element, options) {
        this.$element = $(element);
        this.options = $.extend({}, $.fn.button.defaults, options);
    };
    Button.prototype.setState = function(state) {
        var d = "disabled", $el = this.$element, data = $el.data(), val = $el.is("input") ? "val" : "html";
        state = state + "Text";
        data.resetText || $el.data("resetText", $el[val]());
        $el[val](data[state] || this.options[state]);
        setTimeout(function() {
            state == "loadingText" ? $el.addClass(d).attr(d, d) : $el.removeClass(d).removeAttr(d);
        }, 0);
    };
    Button.prototype.toggle = function() {
        var $parent = this.$element.closest('[data-toggle="buttons-radio"]');
        $parent && $parent.find(".active").removeClass("active");
        this.$element.toggleClass("active");
    };
    $.fn.button = function(option) {
        return this.each(function() {
            var $this = $(this), data = $this.data("button"), options = typeof option == "object" && option;
            if (!data) $this.data("button", data = new Button(this, options));
            if (option == "toggle") data.toggle(); else if (option) data.setState(option);
        });
    };
    $.fn.button.defaults = {
        loadingText: "loading..."
    };
    $.fn.button.Constructor = Button;
    $(function() {
        $("body").on("click.button.data-api", "[data-toggle^=button]", function(e) {
            var $btn = $(e.target);
            if (!$btn.hasClass("btn")) $btn = $btn.closest(".btn");
            $btn.button("toggle");
        });
    });
}(window.jQuery);

define("3rdparty/one-theme/3rdparty/bootstrap/js/bootstrap-button", function() {
    return $.fn.button;
});

!function($) {
    "use strict";
    var Tooltip = function(element, options) {
        this.init("tooltip", element, options);
    };
    Tooltip.prototype = {
        constructor: Tooltip,
        init: function(type, element, options) {
            var eventIn, eventOut;
            this.type = type;
            this.$element = $(element);
            this.options = this.getOptions(options);
            this.enabled = true;
            if (this.options.trigger != "manual") {
                eventIn = this.options.trigger == "hover" ? "mouseenter" : "focus";
                eventOut = this.options.trigger == "hover" ? "mouseleave" : "blur";
                this.$element.on(eventIn, this.options.selector, $.proxy(this.enter, this));
                this.$element.on(eventOut, this.options.selector, $.proxy(this.leave, this));
            }
            var that = this;
            $.event.special.tooltipdestroy = {
                teardown: function() {
                    that.hide();
                }
            };
            this.$element.on("tooltipdestroy", function() {});
            this.options.selector ? this._options = $.extend({}, this.options, {
                trigger: "manual",
                selector: ""
            }) : this.fixTitle();
        },
        getOptions: function(options) {
            var toolTipData = this.$element.data();
            var elementOptions = {};
            Object.keys(toolTipData).forEach(function(key) {
                var match;
                if (match = /^tooltip([A-Z])(.+)/.exec(key)) {
                    elementOptions[match[1].toLowerCase() + match[2]] = toolTipData[key];
                }
            });
            options = $.extend({}, $.fn[this.type].defaults, options, elementOptions);
            if (options.delay && typeof options.delay == "number") {
                options.delay = {
                    show: options.delay,
                    hide: options.delay
                };
            }
            return options;
        },
        enter: function(e) {
            var self = $(e.currentTarget)[this.type](this._options).data(this.type);
            if (!self.options.delay || !self.options.delay.show) {
                self.show();
            } else {
                self.hoverState = "in";
                setTimeout(function() {
                    if (self.hoverState == "in" && $(e.currentTarget).closest("body").length > 0) {
                        self.show();
                    }
                }, self.options.delay.show);
            }
        },
        leave: function(e) {
            var self = $(e.currentTarget)[this.type](this._options).data(this.type);
            if (!self.options.delay || !self.options.delay.hide) {
                self.hide();
            } else {
                self.hoverState = "out";
                setTimeout(function() {
                    if (self.hoverState == "out") {
                        self.hide();
                    }
                }, self.options.delay.hide);
            }
        },
        show: function() {
            var that, $tip, inside, pos, actualWidth, actualHeight, placement, tp;
            if (this.hasContent() && this.enabled) {
                that = this;
                $tip = this.tip();
                this.setContent();
                if (this.options.animation) {
                    $tip.addClass("fade");
                }
                placement = typeof this.options.placement == "function" ? this.options.placement.call(this, $tip[0], this.$element[0]) : this.options.placement;
                inside = /in/.test(placement);
                $tip.remove().css({
                    top: 0,
                    left: 0,
                    display: "block"
                }).appendTo(inside ? this.$element : document.body);
                pos = this.getPosition(inside);
                actualWidth = $tip[0].offsetWidth;
                actualHeight = $tip[0].offsetHeight;
                switch (inside ? placement.split(" ")[1] : placement) {
                  case "bottom":
                    tp = {
                        top: pos.top + pos.height,
                        left: pos.left + pos.width / 2 - actualWidth / 2
                    };
                    break;

                  case "top":
                    tp = {
                        top: pos.top - actualHeight,
                        left: pos.left + pos.width / 2 - actualWidth / 2
                    };
                    break;

                  case "left":
                    tp = {
                        top: pos.top + pos.height / 2 - actualHeight / 2,
                        left: pos.left - actualWidth
                    };
                    break;

                  case "right":
                    tp = {
                        top: pos.top + pos.height / 2 - actualHeight / 2,
                        left: pos.left + pos.width
                    };
                    break;
                }
                clearInterval(this.interval);
                this.interval = setInterval(function() {
                    if (!that.$element.is(":visible")) {
                        that.hide();
                    }
                }, 500);
                $tip.css(tp).addClass(placement).addClass("in");
            }
        },
        setContent: function() {
            var $tip = this.tip();
            $tip.find(".tooltip-inner").html(this.getTitle());
            $tip.removeClass("fade in top bottom left right");
        },
        hide: function() {
            var that = this, $tip = this.tip();
            clearInterval(this.interval);
            $tip.removeClass("in");
            function removeWithAnimation() {
                var timeout = setTimeout(function() {
                    $tip.off($.support.transition.end).remove();
                }, 500);
                $tip.one($.support.transition.end, function() {
                    clearTimeout(timeout);
                    $tip.remove();
                });
            }
            $.support.transition && this.$tip.hasClass("fade") ? removeWithAnimation() : $tip.remove();
        },
        fixTitle: function() {
            var $e = this.$element;
            if ($e.attr("title") || typeof $e.attr("data-title") != "string") {
                $e.attr("data-title", $e.attr("title") || "").removeAttr("title");
            }
        },
        hasContent: function() {
            return this.getTitle();
        },
        getPosition: function(inside) {
            return $.extend({}, inside ? {
                top: 0,
                left: 0
            } : this.$element.offset(), {
                width: this.$element[0].offsetWidth,
                height: this.$element[0].offsetHeight
            });
        },
        getTitle: function() {
            var title, $e = this.$element, o = this.options;
            title = $e.attr("data-title") || (typeof o.title == "function" ? o.title.call($e[0]) : o.title);
            title = title.toString().replace(/(^\s*|\s*$)/, "");
            return title;
        },
        tip: function() {
            return this.$tip = this.$tip || $(this.options.template);
        },
        validate: function() {
            if (!this.$element[0].parentNode) {
                this.hide();
                this.$element = null;
                this.options = null;
            }
        },
        enable: function() {
            this.enabled = true;
        },
        disable: function() {
            this.enabled = false;
        },
        toggleEnabled: function() {
            this.enabled = !this.enabled;
        },
        toggle: function() {
            this[this.tip().hasClass("in") ? "hide" : "show"]();
        }
    };
    $.fn.tooltip = function(option) {
        return this.each(function() {
            var $this = $(this), data = $this.data("tooltip"), options = typeof option == "object" && option;
            if (!data) $this.data("tooltip", data = new Tooltip(this, options));
            if (typeof option == "string") data[option]();
        });
    };
    $.fn.tooltip.Constructor = Tooltip;
    $.fn.tooltip.defaults = {
        animation: true,
        delay: 0,
        selector: false,
        placement: "top",
        trigger: "hover",
        title: "",
        template: '<div class="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>'
    };
}(window.jQuery);

define("3rdparty/one-theme/3rdparty/bootstrap/js/bootstrap-tooltip", function() {
    return $.fn.tooltip;
});

define("theme/tooltip", [ "jquery", "knockout", "3rdparty/one-theme/3rdparty/bootstrap/js/bootstrap-tooltip" ], function($, ko) {
    $("body").tooltip({
        animation: true,
        delay: {
            show: 750,
            hide: 100
        },
        selector: "[data-title]"
    });
    $("body").on("mouseenter", "[data-title]", function(e) {
        var element = e.target;
        ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
            $(element).tooltip("hide");
            ko.utils.domNodeDisposal.removeDisposeCallback(element, this);
        });
    });
});

define("theme/binding/errormsg", [ "jquery", "knockout" ], function($, ko) {
    ko.bindingHandlers.errormsg = {
        init: function(element, valueAccessor) {
            $(element).hide();
        },
        update: function(element, valueAccessor) {
            var content = ko.utils.unwrapObservable(valueAccessor()), msgBox = $(element), dismissable = true;
            if (content !== null) {
                if (typeof content !== "string") {
                    dismissable = !!content.dismissable;
                    content = content.message;
                }
                msgBox.stop().hide().empty();
                if (dismissable) {
                    content = '<a class="close" data-dismiss="alert">×</a> ' + content;
                }
                msgBox.append('<div class="alert alert-error">' + content + "</div>");
                var closeButtons = $(".close", msgBox);
                if (closeButtons.length) {
                    closeButtons.click(function(e) {
                        closeButtons.off("click");
                        valueAccessor()(null);
                    });
                }
                var bodyOuterWidth = $("body").outerWidth(), height = msgBox.outerHeight() + 2, width = msgBox.outerWidth() + 2;
                var left = Math.floor((bodyOuterWidth - width) / 2);
                msgBox.css({
                    top: -1 * height + "px",
                    left: left + "px"
                });
                msgBox.show().animate({
                    top: "50px"
                }, 200);
            } else {
                msgBox.stop().animate({
                    top: -1 * (msgBox.outerHeight() + 2) + "px"
                }, 400, function() {
                    msgBox.hide().empty();
                });
            }
        }
    };
});

define("theme/binding/notification", [ "jquery", "knockout" ], function($, ko) {
    ko.bindingHandlers.notification = {
        init: function(element, valueAccessor) {
            var notifyBox = $(element);
            notifyBox.hide();
            notifyBox.data("counter", 0);
        },
        update: function(element, valueAccessor) {
            var value = ko.utils.unwrapObservable(valueAccessor()), notifyBox = $(element), content = value, timeout = 1e3;
            if (value !== null && typeof value !== "string") {
                content = value.message;
                timeout = value.timeout || timeout;
            }
            if (content !== null) {
                notifyBox.data("timed-out", false);
                notifyBox.data("hide-after-timeout", false);
                clearTimeout(notifyBox.data("timer"));
                notifyBox.stop().hide().empty();
                notifyBox.append('<div class="alert alert-block">' + content + "</div>");
                var closeButtons = $(".close", notifyBox);
                if (closeButtons.length) {
                    closeButtons.click(function(e) {
                        closeButtons.off("click");
                        valueAccessor()(null);
                    });
                }
                var bodyOuterWidth = $("body").outerWidth(), height = notifyBox.outerHeight() + 2, width = notifyBox.outerWidth() + 2, left = Math.floor((bodyOuterWidth - width) / 2);
                notifyBox.css({
                    top: -height + "px",
                    left: left + "px"
                });
                notifyBox.show().animate({
                    top: "-5px"
                }, 200);
                var timer = setTimeout(function() {
                    notifyBox.data("timed-out", true);
                    if (notifyBox.data("hide-after-timeout")) {
                        notifyBox.stop().animate({
                            top: -1 * (notifyBox.outerHeight() + 2) + "px"
                        }, 400, function() {
                            notifyBox.hide().empty();
                        });
                    }
                }, timeout);
                notifyBox.data("timer", timer);
            } else {
                if (notifyBox.data("timed-out")) {
                    notifyBox.stop().animate({
                        top: -1 * (notifyBox.outerHeight() + 2) + "px"
                    }, 400, function() {
                        notifyBox.hide().empty();
                    });
                } else {
                    notifyBox.data("hide-after-timeout", true);
                }
            }
        }
    };
});

window.one = window.one || {};

require([ "jquery", "knockout", "mail/Application", "common/util", "theme/autofill", "common/binding/knockout.checkedWithInit", "3rdparty/knockout.tap", "3rdparty/knockout.placeholderPolyfill", "3rdparty/one-theme/3rdparty/bootstrap/js/bootstrap-alert", "3rdparty/one-theme/3rdparty/bootstrap/js/bootstrap-button", "theme/tooltip", "theme/binding/errormsg", "theme/binding/notification" ], function($, ko, Application, util) {
    var application = one.application = new Application();
    if (application.redirectIfUnsupportedBrowser()) {
        return;
    }
    $(function() {
        var $body = $("body");
        function updateBodyClasses() {
            $body.toggleClass("very-small-width", $body.width() < 800);
            $body.toggleClass("small-width", $body.width() < 1366);
        }
        function resizeApp() {
            updateBodyClasses();
        }
        util.updateApplicationCache(function(err, updateReady) {
            if (err) {
                throw err;
            }
            if (updateReady) {
                document.location.reload();
            } else {
                application.loginForm.loadAutofill();
                ko.applyBindings(application, $body[0]);
                $(window).resize(resizeApp);
                resizeApp();
                application.load();
                $body.tooltip({
                    animation: true,
                    delay: {
                        show: 1500,
                        hide: 100
                    },
                    selector: "[rel=tooltip]"
                });
            }
        });
    });
});

define("mail/mail", function() {});